/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.utils;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqAppCenterConstant;
import ysq.rpac.rpamc.common.constant.YsqAppMineConstant;
import ysq.rpac.rpamc.common.model.AppCenterVO;
import ysq.rpac.rpamc.common.model.LicenseVO;

public class LicenseUtils {
    private static Log log = LogFactory.getLog(LicenseUtils.class);
    public static final String LICENSE_ROBOT = "RPAC_YSQ_UTR";
    public static final String LICENSE_ASSISTANTS = "RPAC_YSQ_ASR";
    public static final String LICENSE_COMMONROBOT = "RPAC_YSQ_CSR";
    public static final String LICENSE_STUDIO = "RPAC_YSQ_RPADS";
    public static final String LICENSE_STD_APP = "RPAC_YSQ_STD_APP";
    public static final int LICENSE_ROBOT_ID = 513;
    public static final int LICENSE_ASSISTANTS_ID = 512;
    public static final int LICENSE_STUDIO_ID = 511;
    public static final int LICENSE_STD_APP_ID = -1;
    public static final int LICENSE_COMMONROBOT_ID = -1;

    public static LicenseVO licenseNums() {
        LicenseVO licenseVO = new LicenseVO();
        licenseVO.setAssistants(0);
        licenseVO.setRobots(0);
        licenseVO.setStudios(0);
        licenseVO.setCsRobot(0);
        Boolean robotLicenseCheck = LicenseServiceHelper.checkPerformGroup((String)LICENSE_ROBOT).getHasLicense();
        log.info("\u65e0\u4eba\u503c\u5b88\u673a\u5668\u4eba\u8bb8\u53ef\u6821\u9a8c\uff1a" + robotLicenseCheck);
        if (robotLicenseCheck.booleanValue()) {
            int robotNumber = LicenseServiceHelper.getTotalNumber((Object)513);
            log.info("\u65e0\u4eba\u503c\u5b88\u673a\u5668\u4eba\u8bb8\u53ef\u6570\u91cf\uff1a" + robotNumber);
            licenseVO.setRobots(robotNumber);
        }
        Boolean assLicense = LicenseServiceHelper.checkPerformGroup((String)LICENSE_ASSISTANTS).getHasLicense();
        log.info("\u6709\u4eba\u503c\u5b88\u673a\u5668\u4eba\u8bb8\u53ef\u6821\u9a8c\uff1a" + assLicense);
        if (assLicense.booleanValue()) {
            int assNumber = LicenseServiceHelper.getTotalNumber((Object)512);
            log.info("\u6709\u4eba\u503c\u5b88\u673a\u5668\u4eba\u8bb8\u53ef\u6570\u91cf\uff1a" + assNumber);
            licenseVO.setAssistants(assNumber);
        }
        Boolean stuLicense = LicenseServiceHelper.checkPerformGroup((String)LICENSE_STUDIO).getHasLicense();
        log.info("\u8bbe\u8ba1\u5668\u8bb8\u53ef\u6821\u9a8c\uff1a" + stuLicense);
        if (stuLicense.booleanValue()) {
            int studioNumber = LicenseServiceHelper.getTotalNumber((Object)511);
            log.info("\u8bbe\u8ba1\u5668\u8bb8\u53ef\u6570\u91cf\uff1a" + studioNumber);
            licenseVO.setStudios(studioNumber);
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_app_center", (String)"ysq_app_permit_code", (QFilter[])new QFilter[0]);
        HashSet licSet = new HashSet();
        int csInt = 0;
        if (query.size() > 0) {
            query.stream().forEach(e -> licSet.add(e.getString("ysq_app_permit_code")));
        }
        if (licSet.size() > 0) {
            for (String lic : licSet) {
                if (!LicenseServiceHelper.checkPerformGroup((String)lic).getHasLicense().booleanValue()) continue;
                ++csInt;
            }
        }
        licenseVO.setCsRobot(csInt);
        return licenseVO;
    }

    public static boolean licneseCheck(String lic) {
        return LicenseServiceHelper.checkPerformGroup((String)lic).getHasLicense();
    }

    public static boolean remainingLicCheck(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return false;
        }
        LicenseVO licenseVO = LicenseUtils.licenseNums();
        Integer assistantLics = licenseVO.getAssistants();
        Integer robotLics = licenseVO.getRobots();
        Integer studiosLics = licenseVO.getStudios();
        Integer crobotLics = licenseVO.getCsRobot();
        int robotSizeLic = 0;
        if ("robot".equals(type)) {
            robotSizeLic = robotLics;
        } else if ("assistant".equals(type)) {
            robotSizeLic = assistantLics;
        } else if ("studio".equals(type)) {
            robotSizeLic = studiosLics;
        } else if ("standardRobot".equals(type)) {
            robotSizeLic = crobotLics;
        } else {
            return false;
        }
        QFilter qFilter = new QFilter("ysq_agent_type", "=", (Object)type);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_agent", (String)"id", (QFilter[])new QFilter[]{qFilter});
        int robotSize = 0;
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            robotSize = query.size();
        }
        return robotSize < robotSizeLic;
    }

    public static boolean remainingCsLicCheck() {
        LicenseVO licenseVO = LicenseUtils.licenseNums();
        Integer crobotLics = licenseVO.getCsRobot();
        return crobotLics > 0;
    }

    public static Boolean checkStdAppLicense(String procCode) {
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObject centerProc = BusinessDataServiceHelper.loadSingle((String)"ysq_app_center", (String)YsqAppCenterConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeFilter});
        if (null == centerProc) {
            return false;
        }
        String licCode = centerProc.getString("ysq_app_permit_code");
        boolean hasLic = LicenseServiceHelper.checkPerformGroup((String)licCode).getHasLicense();
        if (!hasLic) {
            QFilter procCodeMineFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            DynamicObject mineApp = BusinessDataServiceHelper.loadSingle((String)"ysq_app_mine", (String)YsqAppMineConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeMineFilter});
            if (null != mineApp && !"0".equals(mineApp.getString("ysq_lic_status"))) {
                mineApp.set("ysq_lic_status", (Object)"0");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mineApp});
            }
        } else {
            QFilter procCodeMineFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            DynamicObject mineApp = BusinessDataServiceHelper.loadSingle((String)"ysq_app_mine", (String)YsqAppMineConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeMineFilter});
            if (null != mineApp && !"1".equals(mineApp.getString("ysq_lic_status"))) {
                mineApp.set("ysq_lic_status", (Object)"1");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mineApp});
            }
        }
        return hasLic;
    }

    public static Integer getUsedLicNums(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new KDException("\u673a\u5668\u4eba\u7c7b\u578b\u4e3a\u7a7a");
        }
        Integer robotSize = 0;
        if (!("robot".equals(type) || "assistant".equals(type) || "studio".equals(type) || "standardRobot".equals(type))) {
            throw new KDException("\u673a\u5668\u4eba\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        QFilter qFilter = new QFilter("ysq_agent_type", "=", (Object)type);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_agent", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            robotSize = query.size();
        }
        return robotSize;
    }

    public static List<AppCenterVO> getAppCenterData() {
        List appCenterVOS = null;
        try {
            String json = "[{\n\t\t\"ysqAppName\": \"\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u673a\u5668\u4eba(Win10+IE\u7248)\",\n\t\t\"ysqDevComCode\": \"ysq\",\n\t\t\"ysqDevComName\": \"\u4e0a\u6d77\u827a\u8d5b\u65d7\u8f6f\u4ef6\u80a1\u4efd\u6709\u9650\u516c\u53f8\",\n\t\t\"ysqLaunchDate\": \"2022-09-16 17:42:13\",\n\t\t\"ysqUpdateDate\": \"2022-09-16 17:42:13\",\n\t\t\"ysqLastVersion\": \"1.0.0.0\",\n\t\t\"ysqAppPrice\": 0.00,\n\t\t\"ysqAppOpenSource\": \"no\",\n\t\t\"ysqAppSpecial\": \"no\",\n\t\t\"ysqAppExplain\": \"\u672c\u6b3e\u673a\u5668\u4eba\u4e3a\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u7684\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u6d41\u7a0b\u673a\u5668\u4eba\uff0c\u9002\u7528\u4e8e\u672a\u5f00\u901a\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u94f6\u4f01\u76f4\u8054\u4f46\u5f00\u901a\u4e86\u4f01\u4e1a\u7f51\u94f6\u7684\u4f01\u4e1a\u7528\u6237\u3002\",\n\t\t\"ysqAppLabel\": \"\u661f\u7a7a\u65d7\u8230\u7248\",\n\t\t\"ysqAppInvolveSys\": \"IE\u6d4f\u89c8\u5668,WINDOWS10\u64cd\u4f5c\u7cfb\u7edf\",\n\t\t\"ysqAppUseHelper\": \"{}\",\n\t\t\"ysqProcCode\": \"ysq_bank_download_receipt_ccb\",\n\t\t\"ysqAppProductType\": \"3\",\n\t\t\"ysqAppPermitCode\": \"\",\n\t\t\"ysqAppReserve\": \"\",\n\t\t\"ysqAppGroupNumber\": \"\",\n\t\t\"ysqAppCenterVerList\": [{\n\t\t\t\"ysqAppVerCode\": \"1.0.0.0001\",\n\t\t\t\"ysqAppUpdateDate\": \"2022-09-18 17:24:59\",\n\t\t\t\"ysqAppUpdateContent\": \"\u7b2c2\u6b21\",\n\t\t\t\"ysqAppLink\": \"\"\n\t\t}, {\n\t\t\t\"ysqAppVerCode\": \"1.0.0.0000\",\n\t\t\t\"ysqAppUpdateDate\": \"2022-09-17 17:24:59\",\n\t\t\t\"ysqAppUpdateContent\": \"\u7b2c1\u6b21\",\n\t\t\t\"ysqAppLink\": \"\"\n\t\t}]\n\t},\n\t{\n\t\t\"ysqAppName\": \"\u62db\u5546\u94f6\u884c\u94f6\u884c\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u673a\u5668\u4eba(Win10+IE\u7248)\",\n\t\t\"ysqDevComCode\": \"ysq\",\n\t\t\"ysqDevComName\": \"\u4e0a\u6d77\u827a\u8d5b\u65d7\u8f6f\u4ef6\u80a1\u4efd\u6709\u9650\u516c\u53f8\",\n\t\t\"ysqLaunchDate\": \"2022-09-16 17:42:13\",\n\t\t\"ysqUpdateDate\": \"2022-09-16 17:42:13\",\n\t\t\"ysqLastVersion\": \"1.0.0.0\",\n\t\t\"ysqAppPrice\": 0.00,\n\t\t\"ysqAppOpenSource\": \"no\",\n\t\t\"ysqAppSpecial\": \"no\",\n\t\t\"ysqAppExplain\": \"\u672c\u6b3e\u673a\u5668\u4eba\u4e3a\u62db\u5546\u94f6\u884c\u7684\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u6d41\u7a0b\u673a\u5668\u4eba\uff0c\u9002\u7528\u4e8e\u672a\u5f00\u901a\u62db\u5546\u94f6\u884c\u94f6\u4f01\u76f4\u8054\u4f46\u5f00\u901a\u4e86\u4f01\u4e1a\u7f51\u94f6\u7684\u4f01\u4e1a\u7528\u6237\u3002\",\n\t\t\"ysqAppLabel\": \"\u661f\u7a7a\u65d7\u8230\u7248\",\n\t\t\"ysqAppInvolveSys\": \"IE\u6d4f\u89c8\u5668,WINDOWS10\u64cd\u4f5c\u7cfb\u7edf\",\n\t\t\"ysqAppUseHelper\": \"{\n\t\t\"appCharacter\": {\n\t\t\t\"main\": [\n\t\t\t\t\"\u2022 \u652f\u6301\u591a\u8d26\u53f7\u7535\u5b50\u56de\u5355\u4e0b\u8f7d*\",\n\t\t\t\t\"\u2022 \u652f\u6301\u81ea\u5b9a\u4e49\u67e5\u8be2\u65e5\u671f\u6a21\u5f0f\",\n\t\t\t\t\"\u2022 \u81ea\u52a8\u89e3\u6790\u7528\u6237\u4f20\u5165\u7684\u7f51\u94f6\u767b\u5f55\u914d\u7f6e\u4fe1\u606f\",\n\t\t\t\t\"\u2022 \u4e0b\u8f7d\u7684\u7535\u5b50\u56de\u5355\u8fdb\u884c\u62c6\u5206\u6210\u72ec\u7acb\u7684\u6587\u4ef6\uff0c\u5e76\u8bc6\u522b\u5f62\u6210EXCEL\u5173\u8054\u6587\u4ef6\uff0c\u65b9\u4fbf\u8fdb\u884c\u540e\u7eed\u7684\u51ed\u8bc1\u9644\u4ef6\u5173\u8054\"\n\t\t\t],\n\t\t\t\"note\": [\n\t\t\t\t\"\u82e5\u9700\u8981\u591a\u94f6\u884c\u591a\u8d26\u53f7\u7f51\u94f6\u6d41\u6c34\u4e0b\u8f7d\uff0c\u8bf7\u8054\u7cfb\u9500\u552e\u3002\u652f\u6301USB-HUB\u914d\u7f6e,\u9002\u7528\u4e8e\u591aU-KEY\u60c5\u5f62\u3002\u82e5\u9700\u8981USB-HUB\uff0c\u8bf7\u8054\u7cfb\u9500\u552e\u3002\"\n\t\t\t]\n\t\t},\n\t\t\"appScope\": [\n\t\t\t\"\u2022 \u5f00\u901a\u4e86\u94f6\u884c\u4f01\u4e1a\u7f51\u94f6\u7684\u5ba2\u6237\",\n\t\t\t\"\u2022 \u9700\u8981\u8fd0\u884c\u5728Win10 \uff0b IE\u6d4f\u89c8\u5668\u7684\u73af\u5883\u4e2d\",\n\t\t\t\"\u2022 \u4e0a\u8ff0\u73af\u5883\u5df2\u5b89\u88c5\u4e86\u5bf9\u5e94\u7684\u94f6\u884c\u5b89\u5168\u63d2\u4ef6\u548c\u76f8\u5173\u7684\u7f51\u94f6U-KEY\u9a71\u52a8\",\n\t\t\t\"\u2022 \u6700\u540e\u6210\u679c\u7269:1)\u7535\u5b50\u56de\u5355\u6587\u4ef6 2\uff09EXCEL\u5173\u8054\u6587\u4ef6\",\n\t\t\t\"\t\u2022 \u7535\u5b50\u56de\u5355\u6587\u4ef6\u53ef\u4f9b\u7528\u6237\u6253\u5370\u4f5c\u4e3a\u51ed\u8bc1\u9644\u4ef6\uff0c\u4e5f\u53ef\u7ed3\u5408\u540e\u7eed\u7684\u673a\u5668\u4eba\u5c06\u9644\u4ef6\u4f20\u5165\u7535\u5b50\u7cfb\u7edf\u4e2d\u3002\",\n\t\t\t\"\t\u2022 EXCEL\u5173\u8054\u6587\u4ef6\u7ed3\u5408\u540e\u7eed\u7684\u56de\u5355\u5173\u8054\u673a\u5668\u4eba\u8f85\u52a9\u7528\u6237\u6574\u7406\u8bb0\u8d26\u51ed\u8bc1\u548c\u539f\u59cb\u51ed\u8bc1\u3002\"\n\t\t],\n\t\t\"appMore\": {\n\t\t\t\"name\": \"\u62db\u5546\u94f6\u884c\u94f6\u884c\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u673a\u5668\u4eba(Win10+IE\u7248)\",\n\t\t\t\"href\": \"http://www.baidu.com\"\n\t\t}\n\t}\n\t\",\n\t\"ysqProcCode\": \"ysq_bank_download_receipt_cmb\",\n\t\"ysqAppProductType\": \"3\",\n\t\"ysqAppPermitCode\": \"\",\n\t\"ysqAppReserve\": \"\",\n\t\"ysqAppGroupNumber\": \"\",\n\t\"ysqAppCenterVerList\": [{\n\t\t\"ysqAppVerCode\": \"1.0.0.0001\",\n\t\t\"ysqAppUpdateDate\": \"2022-09-18 17:24:59\",\n\t\t\"ysqAppUpdateContent\": \"\u7b2c2\u6b21\",\n\t\t\"ysqAppLink\": \"\"\n\t}, {\n\t\t\"ysqAppVerCode\": \"1.0.0.0000\",\n\t\t\"ysqAppUpdateDate\": \"2022-09-17 17:24:59\",\n\t\t\"ysqAppUpdateContent\": \"\u7b2c1\u6b21\",\n\t\t\"ysqAppLink\": \"\"\n\t}]\n}]";
            appCenterVOS = JSON.parseArray((String)json, AppCenterVO.class);
        }
        catch (Exception exception) {
            log.debug("\u83b7\u53d6\u6700\u65b0\u5e94\u7528\u4fe1\u606f\u5931\u8d25", (Object)exception.getMessage());
        }
        return appCenterVOS;
    }
}

