/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.utils;

import java.math.BigDecimal;
import java.util.Comparator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class ProcVerComparator
implements Comparator<DynamicObject> {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String FLG_V_MIN = "v";
    private static final String FLG_V_MAX = "V";
    private static final String FLG_POINT = "\\.";

    @Override
    public int compare(DynamicObject verOne, DynamicObject verTwo) {
        if (null == verOne) {
            if (null == verTwo) {
                return 0;
            }
            return 1;
        }
        if (null == verTwo) {
            return -1;
        }
        String verCodeOne = verOne.getString("ysq_proc_ver");
        String verCodeTwo = verTwo.getString("ysq_proc_ver");
        if (StringUtils.isBlank((CharSequence)verCodeOne)) {
            if (StringUtils.isBlank((CharSequence)verCodeTwo)) {
                return 0;
            }
            return 1;
        }
        if (StringUtils.isBlank((CharSequence)verCodeTwo)) {
            return -1;
        }
        if (verCodeOne.startsWith(FLG_V_MIN) || verCodeOne.startsWith(FLG_V_MAX)) {
            verCodeOne = verCodeOne.substring(1);
        }
        if (verCodeTwo.startsWith(FLG_V_MIN) || verCodeTwo.startsWith(FLG_V_MAX)) {
            verCodeTwo = verCodeTwo.substring(1);
        }
        String[] verOneArr = verCodeOne.split(FLG_POINT);
        String[] verTwoArr = verCodeTwo.split(FLG_POINT);
        Integer size = verOneArr.length;
        if (size > verTwoArr.length) {
            size = verTwoArr.length;
        }
        for (int index = 0; index < size; ++index) {
            String oneVer = verOneArr[index];
            String twoVer = verTwoArr[index];
            int result = this.compareVer(oneVer, twoVer);
            if (result == 0) continue;
            return result;
        }
        if (verOneArr.length == verTwoArr.length) {
            return 0;
        }
        if (verOneArr.length > verTwoArr.length) {
            return -1;
        }
        return 1;
    }

    private int compareVer(String oneVer, String twoVer) {
        BigDecimal one = null;
        try {
            one = oneVer.startsWith("0") ? new BigDecimal("0." + oneVer) : new BigDecimal(oneVer);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            one = null;
        }
        BigDecimal two = null;
        try {
            two = twoVer.startsWith("0") ? new BigDecimal("0." + twoVer) : new BigDecimal(twoVer);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            two = null;
        }
        if (null == one) {
            if (null == two) {
                return 0;
            }
            return 1;
        }
        if (null == two) {
            return -1;
        }
        return two.compareTo(one);
    }
}

