/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.service.ServiceFactory;
import org.apache.commons.lang3.RandomUtils;

public class ScheduleUtils {
    public static boolean delTaskJob(String jobId, String planId) {
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob(jobId);
        scheduleManager.disableSchedule(planId);
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        boolean result = proxy.deleteJob(jobId);
        if (result) {
            result = proxy.deletePlan(planId);
        }
        return result;
    }

    public static String[] addTaskJob(Long schId, Date startTime, Date endTime, String cronExpression, String schName) {
        String[] jobPlanIds = new String[2];
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        JobInfo jobInfo = ScheduleUtils.getJobInfo(schId, schName);
        String jobId = proxy.createJob(jobInfo);
        PlanInfo planInfo = ScheduleUtils.getPlanInfo(jobInfo, schId, startTime, endTime, cronExpression, schName);
        String planId = proxy.createPlan(planInfo);
        jobPlanIds[0] = jobId;
        jobPlanIds[1] = planId;
        return jobPlanIds;
    }

    public static PlanInfo getPlanInfo(JobInfo jobInfo, Long schId, Date startTime, Date endTime, String cronExpression, String schName) {
        Calendar endCalendar;
        Calendar startCalendar;
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(jobInfo.getId());
        planInfo.setName(schName);
        planInfo.setNumber("rpaSchedule_" + schId);
        if (null != startTime) {
            startCalendar = Calendar.getInstance();
            startCalendar.setTime(startTime);
            planInfo.setStartTime(startCalendar);
        } else {
            startCalendar = Calendar.getInstance();
            startCalendar.setTime(new Date());
            planInfo.setStartTime(startCalendar);
        }
        if (null != endTime) {
            endCalendar = Calendar.getInstance();
            endCalendar.setTime(endTime);
            planInfo.setEndTime(endCalendar);
        } else {
            endCalendar = Calendar.getInstance();
            endCalendar.setTime(new Date());
            endCalendar.add(1, 200);
            planInfo.setEndTime(endCalendar);
        }
        planInfo.setCronExpression(cronExpression);
        return planInfo;
    }

    public static JobInfo getJobInfo(Long schId, String schName) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("ysq_rpamc");
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setName(schName);
        jobInfo.setNumber("rpaJobTask_" + schId + RandomUtils.nextInt());
        jobInfo.setTaskClassname("ysq.rpac.rpamc.plugin.task.RpaJobTask");
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("schId", schId);
        jobInfo.setParams(params);
        return jobInfo;
    }
}

