/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.TriggerBuilder;
import ysq.rpac.rpamc.common.utils.DateUtils;

public class TriggerTimeUtils {
    private static Log log = LogFactory.getLog(TriggerTimeUtils.class);
    public static final String TRIGGER_GROUP_CRON_COUNTER = "cron_counter";

    public static Boolean checkCronStr(String cronStr) {
        if (StringUtils.isBlank((CharSequence)cronStr)) {
            return false;
        }
        return CronExpression.isValidExpression((String)cronStr);
    }

    public static List<Date> findNextTimes(String cron, Date lastTime) {
        return TriggerTimeUtils.findNextTimes(cron, null, lastTime);
    }

    public static List<Date> findNextTimes(String cron, Integer nextNum, Date lastTime) {
        List<Date> dateList = new ArrayList<Date>();
        if (!CronExpression.isValidExpression((String)cron)) {
            return dateList;
        }
        try {
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            triggerBuilder.withIdentity(TRIGGER_GROUP_CRON_COUNTER);
            triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron));
            CronTrigger trigger = (CronTrigger)triggerBuilder.build();
            dateList = TriggerTimeUtils.findNextTimes(trigger, nextNum, lastTime);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return dateList;
    }

    public static List<Date> findNextTimes(CronTrigger trigger) {
        return TriggerTimeUtils.findNextTimes(trigger, null, null);
    }

    public static List<Date> findNextTimes(CronTrigger trigger, Integer nextNum, Date lastTime) {
        ArrayList<Date> dateList = new ArrayList<Date>();
        try {
            if (null == nextNum) {
                nextNum = 5;
            }
            if (null == lastTime) {
                lastTime = trigger.getStartTime();
            }
            for (int i = 0; i < nextNum; ++i) {
                if ((lastTime = trigger.getFireTimeAfter(lastTime)) == null) continue;
                dateList.add(lastTime);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return dateList;
    }

    public static List<String> findNextTimesStr(String cron) {
        return TriggerTimeUtils.findNextTimesStr(cron, null);
    }

    public static List<String> findNextTimesStr(String cron, Integer nextNum) {
        List<String> dateList = new ArrayList<String>();
        if (!CronExpression.isValidExpression((String)cron)) {
            return dateList;
        }
        try {
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            triggerBuilder.withIdentity(TRIGGER_GROUP_CRON_COUNTER);
            triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron));
            Calendar c = Calendar.getInstance();
            c.add(2, 1);
            String monTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(c.getTime());
            Date triggerEndTime = DateUtils.parseDate(monTime);
            triggerBuilder.endAt(triggerEndTime);
            CronTrigger trigger = (CronTrigger)triggerBuilder.build();
            dateList = TriggerTimeUtils.findNextTimesStr(trigger, nextNum);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return dateList;
    }

    public static List<String> findNextTimesStr(CronTrigger trigger) {
        return TriggerTimeUtils.findNextTimesStr(trigger, null);
    }

    public static List<String> findNextTimesStr(CronTrigger trigger, Integer nextNum) {
        ArrayList<String> dateList = new ArrayList<String>();
        try {
            if (null == nextNum) {
                nextNum = 5;
            }
            Date lastTime = trigger.getStartTime();
            for (int i = 0; i < nextNum; ++i) {
                lastTime = trigger.getFireTimeAfter(lastTime);
                dateList.add(DateUtils.formatDate(lastTime));
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return dateList;
    }

    private TriggerTimeUtils() {
    }
}

