/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.opplugin.confirm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.adm.opplugin.validator.AdmSampleNotifyValidator;
import org.apache.commons.collections.CollectionUtils;

public class AdmSampleConfirmOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("cfmstatus");
        fieldKeys.add("cfm");
        fieldKeys.add("cfmdate");
        fieldKeys.add("supplier");
        fieldKeys.add("aptitudeno");
        fieldKeys.add("entryentity.senddate");
        fieldKeys.add("entryentity.arrivaldate");
        fieldKeys.add("entryentity.testdate");
        e.getFieldKeys().add("entryentity.material");
        e.getFieldKeys().add("entryentity.arrivaldate");
        e.getFieldKeys().add("entryentity.sendqty");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"confirm")) {
            DynamicObject[] Objs;
            for (DynamicObject obj : Objs = e.getDataEntities()) {
                String cfmStatus = this.getCfmStatus(obj);
                if (cfmStatus == null) continue;
                obj.set("cfmstatus", (Object)cfmStatus);
                obj.set("cfm", (Object)RequestContext.get().getUserId());
                obj.set("cfmdate", (Object)TimeServiceHelper.now());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
            this.updateAptitudeExam(e.getDataEntities(), null);
        }
    }

    private String getCfmStatus(DynamicObject obj) {
        DynamicObjectCollection rows = obj.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return null;
        }
        boolean part = false;
        boolean whole = true;
        for (DynamicObject row : rows) {
            BigDecimal qty = row.getBigDecimal("qty");
            BigDecimal sendQty = row.getBigDecimal("sendqty");
            if (!part && sendQty.compareTo(BigDecimal.ZERO) > 0) {
                part = true;
            }
            if (!whole || sendQty.compareTo(qty) >= 0) continue;
            whole = false;
        }
        if (whole) {
            return "E";
        }
        if (part) {
            return "D";
        }
        return null;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AdmSampleNotifyValidator());
    }

    private void updateAptitudeExam(DynamicObject[] objects, String billType) {
        ArrayList<Long> aptitudeIds = new ArrayList<Long>(objects.length);
        HashMap mapAptitudeOfCategory = new HashMap((int)((double)objects.length / 0.75));
        for (DynamicObject dynamicObject : objects) {
            DynamicObject dynamicObject2 = dynamicObject.getDynamicObject("aptitudeno");
            if (Objects.isNull(dynamicObject2)) continue;
            Long aptitudeId = dynamicObject2.getLong("id");
            aptitudeIds.add(dynamicObject2.getLong("id"));
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            HashMap<Long, DynamicObject> mapMaterialOfEntry = new HashMap<Long, DynamicObject>();
            for (DynamicObject row2 : entryentity) {
                Long material = row2.getLong("material_id");
                mapMaterialOfEntry.put(material, row2);
            }
            mapAptitudeOfCategory.put(aptitudeId, mapMaterialOfEntry);
        }
        if (CollectionUtils.isEmpty(aptitudeIds)) {
            return;
        }
        QFilter qFilter = new QFilter("aptitudeno", "in", aptitudeIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"srm_aptitudeexam", (String)"id,issample,hassample", (QFilter[])new QFilter[]{new QFilter("id", "in", aptitudeIds)}, (String)"id");){
            dataSet.forEach(row -> {
                boolean hasSample = row.getBoolean("hassample");
                boolean isSample = row.getBoolean("issample");
                if (!isSample || hasSample) {
                    aptitudeIds.remove(row.getLong("id"));
                }
            });
        }
        ArrayList samplePkIds = new ArrayList();
        Throwable throwable = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"srm_sampleexam", (String)"id", (QFilter[])new QFilter[]{qFilter.and(new QFilter("billstatus", "=", (Object)"A"))}, (String)"id");){
            dataSet.forEach(row -> samplePkIds.add(row.getLong("id")));
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        DynamicObject[] sampleExam = BusinessDataServiceHelper.load((Object[])samplePkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"srm_sampleexam"));
        Date date = TimeServiceHelper.now();
        for (DynamicObject sample : sampleExam) {
            DynamicObject aptitudeynamicObject = sample.getDynamicObject("aptitudeno");
            if (Objects.isNull(aptitudeynamicObject)) continue;
            Long aptitudeId = aptitudeynamicObject.getLong("id");
            DynamicObjectCollection entryentity = sample.getDynamicObjectCollection("entryentity");
            Map mapAptitudeOfMaterial = (Map)mapAptitudeOfCategory.get(aptitudeId);
            for (DynamicObject row3 : entryentity) {
                Long material = row3.getLong("material_id");
                DynamicObject data = (DynamicObject)mapAptitudeOfMaterial.get(material);
                if (Objects.isNull(data)) continue;
                row3.set("sendqty", (Object)data.getBigDecimal("sendqty"));
                row3.set("arrivaldate", (Object)data.getDate("arrivaldate"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])sampleExam);
    }
}

