/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.opplugin.submit;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.adm.common.AdmPrintToAttachmentUtil;

public class AdmSupQuestionSubmitOp
extends AbstractOperationServicePlugIn {
    public static final String SUBMIT_STATUS = "B";
    public static final String UNSUBMIT_STATUS = "A";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("srcsupquestionid");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("attachmentpanel");
        e.getFieldKeys().add("lockstatus");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        List selectedRows = e.getSelectedRows();
        this.updateSrmQuestionEntryStatus(selectedRows, SUBMIT_STATUS);
    }

    protected void updateSrmQuestionEntryStatus(List<ExtendedDataEntity> selectedRows, String status) {
        DynamicObject[] srm_supquestions;
        List srcsupquestionids = selectedRows.stream().map(x -> Long.parseLong(x.getValue("srcsupquestionid").toString())).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", srcsupquestionids);
        for (DynamicObject srm_supquestion : srm_supquestions = BusinessDataServiceHelper.load((String)"srm_supquestion", (String)"id,allsupissub,entryentity.supplier,entryentity.supdealstatus,entryentity.supuser,entryentity.supdatetime,entryentity.supattachment", (QFilter[])new QFilter[]{qFilter})) {
            DynamicObjectCollection entryentity = srm_supquestion.getDynamicObjectCollection("entryentity");
            String supquestionId = srm_supquestion.getPkValue().toString();
            for (ExtendedDataEntity selectedRow : selectedRows) {
                DynamicObject supplier;
                String srcsupquestionid = selectedRow.getDataEntity().getString("srcsupquestionid");
                if (StringUtils.isEmpty((Object)srcsupquestionid) || !srcsupquestionid.equals(supquestionId) || Objects.isNull(supplier = selectedRow.getDataEntity().getDynamicObject("supplier"))) continue;
                List attachmentpanel = AttachmentServiceHelper.getAttachments((String)selectedRow.getDataEntity().getDataEntityType().getName(), (Object)selectedRow.getBillPkId(), (String)"attachmentpanel");
                for (DynamicObject entry : entryentity) {
                    DynamicObject supplier1 = entry.getDynamicObject("supplier");
                    if (!supplier1.getPkValue().equals(supplier.getPkValue())) continue;
                    entry.set("supdealstatus", (Object)status);
                    entry.set("supuser", (Object)RequestContext.get().getCurrUserId());
                    entry.set("supdatetime", (Object)TimeServiceHelper.now());
                    DynamicObjectCollection supattachment = entry.getDynamicObjectCollection("supattachment");
                    if (SUBMIT_STATUS.equals(status)) {
                        AdmPrintToAttachmentUtil.attToAttachmentFile((List)attachmentpanel, (DynamicObjectCollection)supattachment);
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)supattachment)) continue;
                    supattachment.clear();
                }
            }
            if (this.isAllSubmit(entryentity)) {
                srm_supquestion.set("allsupissub", (Object)Boolean.TRUE);
                continue;
            }
            srm_supquestion.set("allsupissub", (Object)Boolean.FALSE);
        }
        if (srm_supquestions.length > 0) {
            SaveServiceHelper.save((DynamicObject[])srm_supquestions);
        }
    }

    private boolean isAllSubmit(DynamicObjectCollection entryentity) {
        List supdealstatus = entryentity.stream().filter(x -> UNSUBMIT_STATUS.equals(x.getString("supdealstatus"))).collect(Collectors.toList());
        if (supdealstatus.size() > 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

