/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.opplugin.submit;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.adm.common.AdmCommonUtils;
import kd.scm.adm.opplugin.validator.AdmSupplierRegValidator;
import kd.scm.common.enums.IssuerfiHaveConfirmEnum;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.SupplierUtil;

public class AdmSupplierRegSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("biztype");
        fieldKeys.add("org");
        fieldKeys.add("auditopinion");
        fieldKeys.add("auditstatus");
        fieldKeys.add("supplier");
        fieldKeys.add("societycreditcode");
        fieldKeys.add("phone");
        fieldKeys.add("email");
        fieldKeys.add("linkman");
        fieldKeys.add("ctrlstrategy");
        fieldKeys.add("enterprise");
        fieldKeys.add("certifiapply");
        fieldKeys.add("entry_aptitude.aptitudename");
        fieldKeys.add("entry_aptitude.issuedate");
        fieldKeys.add("entry_aptitude.dateto");
        fieldKeys.add("entry_aptitude.checkdate");
        fieldKeys.add("entry_link.name1");
        fieldKeys.add("entry_link.email1");
        fieldKeys.add("entry_link.mobile1");
        fieldKeys.add("entry_link.isdefault_link");
        fieldKeys.add("entry_bank.account");
        fieldKeys.add("entry_bank.accountname");
        fieldKeys.add("entry_bank.bank");
        fieldKeys.add("entry_bank.acccurr");
        fieldKeys.add("entry_bank.isdefault");
        fieldKeys.add("scopeentity");
        fieldKeys.add("scopeentity.province");
        fieldKeys.add("listeddate");
        fieldKeys.add("regdate");
        fieldKeys.add("regstockentry");
        fieldKeys.add("regstockentry.stockratio");
        fieldKeys.add("issuerfiid");
        fieldKeys.add("executeresult");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        String defaultCtrlStrgy = "5";
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject obj = extendedDataEntity.getDataEntity();
            obj.set("executeresult", null);
            obj.set("auditstatus", (Object)SrmSupplierStatusEnum.SUBMIT);
            Long org = obj.getLong("org.id");
            if (org != null) {
                String bdCtrlStrgy = BaseDataServiceHelper.getBdCtrlStrgy((String)"bd_supplier", (String)String.valueOf(org));
                if (bdCtrlStrgy != null && !bdCtrlStrgy.isEmpty()) {
                    obj.set("ctrlstrategy", (Object)bdCtrlStrgy);
                    continue;
                }
                obj.set("ctrlstrategy", (Object)defaultCtrlStrgy);
                continue;
            }
            obj.set("ctrlstrategy", (Object)defaultCtrlStrgy);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        AdmCommonUtils.updateEnterpriseNames((DynamicObject[])dataEntities);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        String initiator = this.getOption().getVariableValue("initiator", "-1");
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"submitdata")) {
            DynamicObject[] Objs;
            for (DynamicObject obj : Objs = e.getDataEntities()) {
                SrmCommonUtil.recordAuditInfo((DynamicObject)obj);
                Object id = obj.get("id");
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("_initiator_", initiator);
                WorkflowServiceHelper.tryTriggerProcess((String)id.toString(), (String)"submit", (String)"srm_supplierreg", map);
            }
            SupplierUtil.setIssuerfiHaveconfirm((DynamicObject[])Objs, (String)IssuerfiHaveConfirmEnum.Y.getNumber());
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AdmSupplierRegValidator(true));
    }

    public void updateUserCreditno(String phone, String code) {
        String selects = "id,creditno,number";
        DynamicObject userDy = BusinessDataServiceHelper.loadSingle((String)"srm_user", (String)selects, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)phone)});
        if (Objects.nonNull(userDy)) {
            userDy.set("creditno", (Object)code);
            SaveServiceHelper.update((DynamicObject)userDy);
        }
    }
}

