/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin;

import java.net.URLDecoder;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.container.GridContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.util.AESUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DateUtil;

public class AdmAdmittancePlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(AdmAdmittancePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"return"});
        this.addClickListeners(new String[]{"refresh"});
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirmActionId".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"srm_portal", null, null, (ShowType)ShowType.Modal));
            this.getView().close();
        } else if ("mailValidityConfirm".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Cancel) == 0) {
            this.getView().close();
        }
    }

    public void ifDelete(Long id) {
        DynamicObject regsupObj;
        if (id != null && !id.toString().trim().equals("") && (regsupObj = QueryServiceHelper.queryOne((String)"srm_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)})) == null) {
            this.getView().close();
            return;
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map param = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        Object numberParam = param.get("number");
        if (Objects.isNull(numberParam)) {
            return;
        }
        String number = this.decrypt(numberParam.toString());
        if (Objects.isNull(number)) {
            return;
        }
        DynamicObject issuerfiObj = QueryServiceHelper.queryOne((String)"srm_issuerfi", (String)"id", (QFilter[])new QFilter[]{new QFilter("email", "=", (Object)number)});
        Object reglogin = param.get("reglogin");
        if (Objects.nonNull(issuerfiObj) && reglogin == null) {
            Object mailvalidity = param.get("mailvalidity");
            if (Objects.nonNull(mailvalidity)) {
                String urlmailvalidity = this.decrypt(mailvalidity.toString());
                if (TimeServiceHelper.now().before(DateUtil.string2date((String)urlmailvalidity, (String)"yyyy-MM-dd HH:mm:ss"))) {
                    this.setValue();
                } else {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u90ae\u4ef6\u94fe\u63a5\u5df2\u5931\u6548\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u6700\u65b0\u90ae\u4ef6\uff0c\u6216\u8054\u7cfb\u91c7\u8d2d\u65b9\u8fdb\u884cRFI\u90ae\u4ef6\u91cd\u53d1\u3002", (String)"AdmAdmittancePlugin_0", (String)"scm-adm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("mailValidityConfirm", (IFormPlugin)this));
                }
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u90ae\u4ef6\u94fe\u63a5\u5df2\u5931\u6548\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u6700\u65b0\u90ae\u4ef6\uff0c\u6216\u8054\u7cfb\u91c7\u8d2d\u65b9\u8fdb\u884cRFI\u90ae\u4ef6\u91cd\u53d1\u3002", (String)"AdmAdmittancePlugin_0", (String)"scm-adm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("mailValidityConfirm", (IFormPlugin)this));
            }
        } else {
            this.setValue();
        }
    }

    private void openDealPage(String pageKey, ShowType showType) {
        HashMap paramMap = new HashMap();
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ""), (ShowType)showType));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().close();
    }

    public void setValue() {
        Label label;
        long id = 0L;
        String number = null;
        String name = null;
        String enterprise = null;
        Map param = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        Object idParam = param.get("id");
        if (Objects.isNull(idParam)) {
            return;
        }
        Object nameParam = param.get("name");
        if (Objects.isNull(nameParam)) {
            return;
        }
        Object enterpriseParam = param.get("enterprise");
        if (Objects.isNull(enterpriseParam)) {
            return;
        }
        Object numberParam = param.get("number");
        if (Objects.isNull(numberParam)) {
            return;
        }
        id = Long.parseLong(idParam.toString());
        name = this.decrypt(nameParam.toString());
        log.info("name" + name);
        enterprise = this.decrypt(enterpriseParam.toString());
        log.info("enterprise" + enterprise);
        number = this.decrypt(numberParam.toString());
        log.info("number" + number);
        if (number != null) {
            this.getModel().setValue("number", (Object)number);
        }
        this.ifDelete(id);
        if (id != 0L) {
            this.getModel().setValue("id", (Object)id);
        }
        if (name != null) {
            label = (Label)this.getControl("name");
            label.setText(name);
        }
        if (enterprise != null) {
            label = (Label)this.getControl("enterprise");
            label.setText(enterprise);
        }
    }

    public String decrypt(String value) {
        String decryptValue = null;
        try {
            decryptValue = AESUtil.decryptToStringNew((String)value);
        }
        catch (Exception e1) {
            log.error("decrypt value is fail value :" + value + " next to decode" + e1.getMessage());
            try {
                String decode = URLDecoder.decode(value, "UTF-8");
                decryptValue = AESUtil.decryptToStringNew((String)decode);
            }
            catch (Exception e2) {
                log.error("decode value is fail value :" + value + e2.getMessage());
            }
        }
        return decryptValue;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "return": {
                String tenanId = RequestContext.get().getTenantId();
                String accountId = RequestContext.get().getAccountId();
                String url = UrlService.getDomainContextUrlByTenantCode((String)tenanId) + "/index.html?accountId=" + accountId + "&appNumber=srm&formId=srm_portal#/dform?accountId=" + accountId + "&appNumber=srm&formId=srm_portal";
                this.getView().openUrl(url);
                this.getView().close();
                break;
            }
            case "refresh": {
                String enterprise;
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"srm_user", (String)"id,number,enterprise", (QFilter[])new QFilter[]{new QFilter("number", "=", this.getModel().getValue("number"))});
                if (dynamicObject != null && (enterprise = dynamicObject.getString("enterprise")) != null) {
                    Label label = (Label)this.getControl("enterprise");
                    label.setText(enterprise);
                }
                GridContainer gc = (GridContainer)this.getControl("gridcontainerap");
                gc.trigger();
                break;
            }
        }
    }
}

