/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.StyleUtil;

public class AdmProcessPlugin
extends AbstractFormPlugin {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String KEY_PROCESS = "process";
    private static final String KEY_IMAGE = "image";
    private static final String KEY_APPLYDATE = "applydate";
    private static final String KEY_AUDITDATE = "auditdate";
    private static final String COLOR_NOSTART = "#999999";
    private static final String COLOR_PROGRESS = "#5E80EB";
    private static final String COLOR_SUCCESS = "#18BC71";
    private static final String COLOR_REJECT = "#FD6C6A";
    private static final String IMAGE_PATH = "icons/pc/state/";
    private static final String IMAGE_NOSTART = "notdelay_notstart.png";
    private static final String IMAGE_PROGRESS = "notdelay_progressed.png";
    private static final String IMAGE_REJECT = "refuse_13_13.png";
    private static final String IMAGE_SUCCESS = "success_28_28.png";
    private static final String[] ADM_KEYS = new String[]{"id", "supplier", "supplier", "supplier", "supplier", "supplier", "supplier", "supplier"};
    private static final String[] ADM_FORMS = new String[]{"adm_supplierreg", "adm_aptitude", "adm_scene", "adm_sample", "adm_material", "adm_approve", "srm_categorychg", "srm_supquit", "srm_blackenterprise", "srm_blackperson"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Container panel1 = (Container)this.getView().getControl("panel1");
        panel1.addClickListener((ClickListener)this);
        Container panel2 = (Container)this.getView().getControl("panel2");
        panel2.addClickListener((ClickListener)this);
        Container panel3 = (Container)this.getView().getControl("panel3");
        panel3.addClickListener((ClickListener)this);
        Container panel4 = (Container)this.getView().getControl("panel4");
        panel4.addClickListener((ClickListener)this);
        Container panel5 = (Container)this.getView().getControl("panel5");
        panel5.addClickListener((ClickListener)this);
        Container panel6 = (Container)this.getView().getControl("panel6");
        panel6.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "panel1": 
            case "panel2": 
            case "panel3": 
            case "panel4": 
            case "panel5": 
            case "panel6": {
                int i = Integer.parseInt(key.substring(5));
                long billId = this.getModel().getDataEntity().getLong("id" + i);
                if (billId == 0L) break;
                this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)ADM_FORMS[i - 1], (ShowType)ShowType.NewWindow, (OperationStatus)OperationStatus.VIEW, (long)billId, new HashMap(), null));
            }
        }
    }

    public void afterBindData(EventObject e) {
        block15: {
            super.afterBindData(e);
            try {
                String number = this.getView().getParentView().getModel().getDataEntity().getString("number");
                if (!StringUtils.isNotBlank((CharSequence)number)) break block15;
                DynamicObject objs = null;
                HashMap enableData = new HashMap();
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"srm_user", (String)"id,enterprise,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number).and(new QFilter("status", "=", (Object)"C")).and(new QFilter("enable", "=", (Object)"1"))}, (String)"id");){
                    dataSet.forEach(row -> {
                        if (row.getBoolean("enable").booleanValue()) {
                            enableData.put("enterprise", row.getString("enterprise"));
                        }
                    });
                }
                objs = QueryRecordUtil.queryRecordSet((String)"srm_supplierreg", (String)"id", (String)"phone", (Object)number, (String)"name", enableData.get("enterprise"), null, null, null, null, null, (String)"queryOne", null);
                if (objs != null) {
                    long supplierId = objs.getLong("id");
                    Map<String, Map<String, Object>> processData = this.getProcessData(supplierId);
                    this.setProcessView(processData);
                }
            }
            catch (ORMDesignException ex) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6682\u4e0d\u652f\u6301\u6dfb\u52a0\u8be5\u5361\u7247\u529f\u80fd\uff1a", (String)"AdmProcessPlugin_3", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                this.log.error("\u5f53\u524d\u9875\u9762\u6682\u4e0d\u652f\u6301\u6dfb\u52a0\u8be5\u5361\u7247\u529f\u80fd\uff1a" + ex.getMessage());
            }
        }
    }

    private Map<String, Map<String, Object>> getProcessData(long supplierId) {
        HashMap<String, Map<String, Object>> processData = new HashMap<String, Map<String, Object>>();
        for (int index = 0; index < 6; ++index) {
            QFilter filter = new QFilter(ADM_KEYS[index], "=", (Object)supplierId).and("auditstatus", ">", (Object)SrmSupplierStatusEnum.INITIAL.getValue());
            QFilter[] filters = new QFilter[]{filter};
            DynamicObjectCollection objs = QueryServiceHelper.query((String)ADM_FORMS[index], (String)"id,createtime,auditdate,auditstatus", (QFilter[])filters, (String)"createtime desc, auditstatus desc");
            if (objs == null || objs.size() == 0) continue;
            HashMap<String, Object> tempData = new HashMap<String, Object>();
            long billId = 0L;
            Date createTime = null;
            Date auditDate = null;
            String auditStatus = null;
            if (objs != null) {
                billId = ((DynamicObject)objs.get(0)).getLong("id");
                createTime = ((DynamicObject)objs.get(0)).getDate("createtime");
                auditDate = ((DynamicObject)objs.get(0)).getDate(KEY_AUDITDATE);
                auditStatus = ((DynamicObject)objs.get(0)).getString("auditstatus");
            }
            tempData.put("id", billId);
            tempData.put("createtime", createTime);
            tempData.put(KEY_AUDITDATE, auditDate);
            tempData.put("auditstatus", auditStatus);
            processData.put(String.valueOf(index + 1), tempData);
        }
        return processData;
    }

    private void setProcessView(Map<String, Map<String, Object>> processData) {
        for (int index = 0; index < 6; ++index) {
            Image image = (Image)this.getView().getControl(KEY_IMAGE + String.valueOf(index + 1));
            image.setUrl("icons/pc/state/notdelay_notstart.png");
        }
        processData.entrySet().stream().forEach(entry -> {
            String processName = (String)entry.getKey();
            Map proData = (Map)entry.getValue();
            long billId = 0L;
            Date applyDate = null;
            Date auditDate = null;
            String auditStatus = null;
            if (proData != null) {
                billId = (Long)proData.get("id");
                applyDate = (Date)proData.get("createtime");
                auditDate = (Date)proData.get(KEY_AUDITDATE);
                auditStatus = (String)proData.get("auditstatus");
                this.renderView(billId, processName, applyDate, auditDate, auditStatus);
            }
        });
    }

    private void renderView(long billId, String processName, Date requestTime, Date auditTime, String auditStatus) {
        Label process = (Label)this.getView().getControl(KEY_PROCESS + processName);
        Image image = (Image)this.getView().getControl(KEY_IMAGE + processName);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Label label4RT = (Label)this.getView().getControl(KEY_APPLYDATE + processName);
        Label label4AT = (Label)this.getView().getControl(KEY_AUDITDATE + processName);
        if (billId != 0L) {
            this.getModel().setValue("id" + processName, (Object)billId);
        }
        if (requestTime != null) {
            label4RT.setText(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\uff1a%1", (String)"AdmProcessPlugin_0", (String)"scm-adm-formplugin", (Object[])new Object[0]), (String)"AdmProcessPlugin_0", (String)"scm-adm-formplugin", (Object[])new Object[]{format.format(requestTime)}));
        }
        if (auditTime != null) {
            label4AT.setText(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5ba1\u6279\u65e5\u671f\uff1a%1", (String)"AdmProcessPlugin_1", (String)"scm-adm-formplugin", (Object[])new Object[0]), (String)"AdmProcessPlugin_1", (String)"scm-adm-formplugin", (Object[])new Object[]{format.format(auditTime)}));
        }
        ArrayList<String> statusList = new ArrayList<String>(10);
        statusList.add(SrmSupplierStatusEnum.AUDIT.getValue());
        statusList.add(SrmSupplierStatusEnum.APTITUDE.getValue());
        statusList.add(SrmSupplierStatusEnum.SCENE.getValue());
        statusList.add(SrmSupplierStatusEnum.SAMPLE.getValue());
        statusList.add(SrmSupplierStatusEnum.MATERIAL.getValue());
        statusList.add(SrmSupplierStatusEnum.SUCCESS.getValue());
        if (statusList.contains(auditStatus)) {
            image.setUrl("icons/pc/state/success_28_28.png");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)process.getKey(), (String)COLOR_SUCCESS, (String)"");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)label4RT.getKey(), (String)COLOR_SUCCESS, (String)"");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)label4AT.getKey(), (String)COLOR_SUCCESS, (String)"");
        } else if (auditStatus.equals("D")) {
            image.setUrl("icons/pc/state/refuse_13_13.png");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)process.getKey(), (String)COLOR_REJECT, (String)"");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)label4RT.getKey(), (String)COLOR_REJECT, (String)"");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)label4AT.getKey(), (String)COLOR_REJECT, (String)"");
        } else if (auditStatus.equals("B")) {
            image.setUrl("icons/pc/state/notdelay_progressed.png");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)process.getKey(), (String)COLOR_PROGRESS, (String)"");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)label4RT.getKey(), (String)COLOR_PROGRESS, (String)"");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)label4AT.getKey(), (String)COLOR_PROGRESS, (String)"");
        } else {
            image.setUrl("icons/pc/state/notdelay_notstart.png");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)process.getKey(), (String)COLOR_NOSTART, (String)"");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)label4RT.getKey(), (String)COLOR_NOSTART, (String)"");
            StyleUtil.setControlerColor((IFormView)this.getView(), (String)label4AT.getKey(), (String)COLOR_NOSTART, (String)"");
        }
    }
}

