/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.OpenFormUtil;

public class AdmBasedataConfigEdit
extends AbstractBillPlugIn
implements RowClickEventListener,
HyperLinkClickListener {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String GUESTBASEDATA_NO = "guestbasedatano";
    private static final String SOURCEBASEDATA_NO = "sourcebasedatano";
    private static final String IS_ENTRYFIELD = "isentryfield";
    private static final String ENTRY_NO = "entryno";
    private static final String SELECTS = "selects";
    private static final String CUSTOMDATASOURCE = "customdatasource";
    private static final String MAIN_ENTITY = "mainentity";
    private static Set<String> ignoreField = new HashSet<String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        TextEdit selects = (TextEdit)this.getView().getControl(SELECTS);
        selects.addButtonClickListener((ClickListener)this);
        TextEdit sourcebasedatano = (TextEdit)this.getView().getControl(GUESTBASEDATA_NO);
        sourcebasedatano.addButtonClickListener((ClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(SELECTS)) {
            StringBuilder selects = new StringBuilder("id");
            Object returnData = closedCallBackEvent.getReturnData();
            String hasselects = this.getPageCache().get("hasselects");
            if (returnData != null && StringUtils.isNotBlank((CharSequence)returnData.toString())) {
                if (StringUtils.isBlank((CharSequence)hasselects)) {
                    selects.append(",");
                    if ("id,".equals(selects.toString())) {
                        selects.append(returnData);
                    }
                } else {
                    selects.delete(0, selects.length());
                    selects.append(returnData);
                    this.getPageCache().remove("hasselects");
                }
            }
            String indexStr = this.getView().getPageCache().get("index");
            int rowIndex = Integer.parseInt(indexStr);
            String changeName = "";
            Object guestbasedatano = this.getModel().getValue(GUESTBASEDATA_NO, rowIndex);
            if (guestbasedatano != null) {
                changeName = guestbasedatano.toString();
            }
            this.getModel().setValue(SELECTS, (Object)selects, rowIndex);
            this.initEntryConfig(changeName, rowIndex);
        } else if (actionId.equals(GUESTBASEDATA_NO)) {
            Object returnData = closedCallBackEvent.getReturnData();
            String indexStr = this.getView().getPageCache().get("index");
            int rowIndex = Integer.parseInt(indexStr);
            if (returnData != null) {
                String changeName = returnData.toString();
                this.getModel().setValue(GUESTBASEDATA_NO, returnData, rowIndex);
                this.initEntryConfig(changeName, rowIndex);
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String fieldKey = ((TextEdit)evt.getSource()).getFieldKey();
        IPageCache pageCache = this.getView().getPageCache();
        if (fieldKey.equals(SELECTS)) {
            String selects;
            String indexStr = this.getView().getPageCache().get("index");
            int index = Integer.parseInt(indexStr);
            HashMap<String, String> paramMap = new HashMap<String, String>(1);
            String sourcebasedatano = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, index).getString(SOURCEBASEDATA_NO);
            String guestbasedatano = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, index).getString(GUESTBASEDATA_NO);
            if (StringUtils.isBlank((CharSequence)sourcebasedatano) || StringUtils.isBlank((CharSequence)guestbasedatano)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u5148\u914d\u7f6e\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"AdmBasedataConfigEdit_1", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject mainentity = this.getModel().getDataEntity().getDynamicObject(MAIN_ENTITY);
            String number = mainentity.getString("number");
            if (pageCache.get("init") == null) {
                this.initBaseDataMap(number);
            }
            if (StringUtils.isNotBlank((CharSequence)(selects = ((DynamicObject)this.getModel().getEntryEntity(KEY_ENTRYENTITY).get(index)).get(SELECTS).toString()))) {
                this.getPageCache().put("hasselects", "true");
            } else {
                this.getPageCache().remove("hasselects");
            }
            paramMap.put(SELECTS, selects);
            paramMap.put(SOURCEBASEDATA_NO, sourcebasedatano);
            paramMap.put(GUESTBASEDATA_NO, guestbasedatano);
            String selectBaseDataFieldsForm = "adm_selectbasedatafields";
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)selectBaseDataFieldsForm, (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, fieldKey));
        } else if (fieldKey.equals(GUESTBASEDATA_NO)) {
            HashMap<String, String> paramMap = new HashMap<String, String>(1);
            DynamicObject mainentity = this.getModel().getDataEntity().getDynamicObject(MAIN_ENTITY);
            if (mainentity == null || StringUtils.isBlank((CharSequence)mainentity.getString("number"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u5148\u914d\u7f6e\u5355\u636e\u5b9e\u4f53\u3002", (String)"AdmBasedataConfigEdit_2", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String number = mainentity.getString("number");
            if (pageCache.get("init") == null) {
                this.initBaseDataMap(number);
            }
            paramMap.put(MAIN_ENTITY, number);
            String selectBaseDataFieldsForm = "adm_selectbasedatano";
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)selectBaseDataFieldsForm, (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, fieldKey));
        }
    }

    private void initBaseDataMap(String number) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("init", "true");
        DynamicObject billObj = BusinessDataServiceHelper.newDynamicObject((String)number);
        DataEntityPropertyCollection properties = billObj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (property instanceof BasedataProp && !ignoreField.contains(name)) {
                pageCache.put(name, null);
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            DynamicObjectCollection dyoc = billObj.getDynamicObjectCollection(name);
            DataEntityPropertyCollection dyocProperties = dyoc.getDynamicObjectType().getProperties();
            for (IDataEntityProperty dyocProperty : dyocProperties) {
                String dyocName = dyocProperty.getName();
                if (!(dyocProperty instanceof BasedataProp) || ignoreField.contains(dyocName)) continue;
                pageCache.put(dyocName, name);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        this.getView().getPageCache().put("index", rowIndex + "");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeField = e.getProperty().getName();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        String changeName = this.getModel().getValue(changeField, rowIndex).toString();
        if (!changeField.equals(SELECTS) && !changeField.equals(CUSTOMDATASOURCE) && StringUtils.isBlank((CharSequence)changeName)) {
            this.getModel().setValue(SOURCEBASEDATA_NO, null, rowIndex);
            this.getModel().setValue(IS_ENTRYFIELD, (Object)false, rowIndex);
            this.getModel().setValue(ENTRY_NO, null, rowIndex);
            this.getModel().setValue(SELECTS, null, rowIndex);
            this.getModel().setValue(CUSTOMDATASOURCE, null, rowIndex);
            this.getView().updateView();
        } else if (changeField.equals(MAIN_ENTITY)) {
            this.getView().getPageCache().put("init", null);
        } else if (this.getView().getPageCache().get(changeName) != null) {
            this.initEntryConfig(changeName, rowIndex);
        }
    }

    private void initEntryConfig(String changeName, int rowIndex) {
        if (StringUtils.isBlank((CharSequence)changeName)) {
            return;
        }
        String baseDataName = "";
        String entryName = this.getView().getPageCache().get(changeName);
        DynamicObject mainentity = this.getModel().getDataEntity().getDynamicObject(MAIN_ENTITY);
        if (mainentity == null || StringUtils.isBlank((CharSequence)mainentity.getString("number"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u5148\u914d\u7f6e\u5355\u636e\u5b9e\u4f53\u3002", (String)"AdmBasedataConfigEdit_2", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            return;
        }
        String number = mainentity.getString("number");
        DynamicObject billObj = BusinessDataServiceHelper.newDynamicObject((String)number);
        if (entryName == null) {
            this.getModel().setValue(ENTRY_NO, (Object)"", rowIndex);
            this.getModel().setValue(IS_ENTRYFIELD, (Object)false);
            DynamicProperty property = billObj.getDynamicObjectType().getProperty(changeName);
            baseDataName = ((BasedataProp)property).getBaseEntityId();
            this.getModel().beginInit();
            this.getModel().setValue(SOURCEBASEDATA_NO, (Object)baseDataName, rowIndex);
            this.getModel().endInit();
        } else {
            this.getModel().setValue(ENTRY_NO, (Object)entryName, rowIndex);
            this.getModel().setValue(IS_ENTRYFIELD, (Object)true);
            DynamicProperty property = billObj.getDynamicObjectCollection(entryName).getDynamicObjectType().getProperty(changeName);
            baseDataName = ((BasedataProp)property).getBaseEntityId();
            this.getModel().setValue(SOURCEBASEDATA_NO, (Object)baseDataName, rowIndex);
        }
        this.getView().updateView();
    }

    static {
        ignoreField.add("creator");
        ignoreField.add("modifier");
        ignoreField.add("lastupdateuser");
        ignoreField.add("auditor");
        ignoreField.add("cfm");
        ignoreField.add("certifiapply");
        ignoreField.add("useorg");
        ignoreField.add("country");
        ignoreField.add("createorg");
        ignoreField.add("bizpartner");
        ignoreField.add("group");
        ignoreField.add("examer");
    }
}

