/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.StepsOption;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.LoginMCServiceUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.OpenFormUtil;

public class AdmLoginStatusPlugin
extends AbstractBasePlugIn {
    private static final Log LOG = LogFactory.getLog(AdmLoginStatusPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label detaillabel = (Label)this.getView().getControl("detaillabel");
        detaillabel.addClickListener((ClickListener)this);
        Label modifylabel = (Label)this.getView().getControl("modifylabel");
        modifylabel.addClickListener((ClickListener)this);
        Label loginlabel = (Label)this.getView().getControl("loginlabel");
        loginlabel.addClickListener((ClickListener)this);
        Label showall = (Label)this.getView().getControl("showall");
        showall.addClickListener((ClickListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("supplierreg")) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void setFormData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            return;
        }
        Object pkid = customParams.get("id");
        Object number = customParams.get("number");
        if (number != null && ("null".equals(pkid) || "NULL".equals(pkid) || "".equals(pkid))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"id\u4e3a\u7a7a\u7684\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"AdmLoginStatusPlugin_0", (String)"scm-adm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("idNullConfirm", (IFormPlugin)this));
            return;
        }
        if (pkid == null) {
            pkid = this.getModel().getDataEntity().getPkValue();
        }
        this.getModel().getDataEntity().set("id", pkid);
        DynamicObject regbill = BusinessDataServiceHelper.loadSingle(pkid, (String)"adm_supplierreg");
        DynamicObject bill = ORM.create().newDynamicObject("adm_registerstatus");
        HashSet<String> fieldNameSet = new HashSet<String>(16);
        fieldNameSet.add("submittime");
        fieldNameSet.add("rejecttime");
        fieldNameSet.add("returntime");
        DataEntityPropertyCollection properties = bill.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (fieldNameSet.contains(name)) continue;
            this.getModel().setValue(name, regbill.get(name));
        }
        this.setSubmitTime();
    }

    private void setFormTools() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            return;
        }
        String auditstatus = this.getModel().getDataEntity(true).getString("auditstatus");
        Label detaillabel = (Label)this.getView().getControl("detaillabel");
        if (auditstatus != null) {
            switch (auditstatus) {
                case "A": {
                    if (this.isReturnModify()) {
                        detaillabel.setText(ResManager.loadKDString((String)"\u8be6\u60c5 >", (String)"AdmLoginStatusPlugin_5", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                        this.setLabelName(ResManager.loadKDString((String)"\u5ba1\u6279\u4e0d\u901a\u8fc7\uff0c\u9000\u56de\u4fee\u6539\u3002", (String)"AdmLoginStatusPlugin_9", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                        this.setReturnTime();
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"submittime", "detaillabel", "auditopinion", "modifylabel", "returntime", "auditstatusnextlabel"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"waitlabel", "logintipslabel", "uncompletelabel", "logintipsextlabel", "loginlabel", "auditstatuslabel", "auditstatusextlabel"});
                        String auditopinion = this.getModel().getDataEntity(true).getString("auditopinion");
                        if (StringUtils.isNotBlank((CharSequence)auditopinion) && auditopinion.length() > 15) {
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{"showall"});
                        } else {
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"showall"});
                        }
                        this.createTabStatusPage(2, "error");
                        break;
                    }
                    detaillabel.setText(ResManager.loadKDString((String)"\u586b\u5199\u8d44\u6599 >", (String)"AdmLoginStatusPlugin_4", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    this.setLabelName(ResManager.loadKDString((String)"\u8d44\u6599\u672a\u63d0\u4ea4", (String)"AdmLoginStatusPlugin_6", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"uncompletelabel", "detaillabel", "logintipslabel", "auditstatusnextlabel"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"waitlabel", "submittime", "loginlabel", "logintipsextlabel", "auditopinion", "auditdate", "modifylabel", "showall", "returntime", "auditstatuslabel", "auditstatusextlabel"});
                    this.createTabStatusPage(0, "process");
                    break;
                }
                case "B": {
                    detaillabel.setText(ResManager.loadKDString((String)"\u8be6\u60c5 >", (String)"AdmLoginStatusPlugin_5", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    this.setLabelName(ResManager.loadKDString((String)"\u8d44\u6599\u5ba1\u6279\u4e2d", (String)"AdmLoginStatusPlugin_2", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"waitlabel", "submittime", "logintipslabel", "detaillabel", "auditstatusnextlabel"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"uncompletelabel", "loginlabel", "logintipsextlabel", "auditopinion", "auditdate", "modifylabel", "showall", "returntime", "auditstatuslabel", "auditstatusextlabel"});
                    this.createTabStatusPage(1, "process");
                    break;
                }
                case "C": {
                    detaillabel.setText(ResManager.loadKDString((String)"\u8be6\u60c5 >", (String)"AdmLoginStatusPlugin_5", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    this.setLabelName(ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7", (String)"AdmLoginStatusPlugin_7", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"submittime", "auditdate", "detaillabel", "loginlabel", "logintipsextlabel", "auditstatuslabel"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"waitlabel", "logintipslabel", "uncompletelabel", "auditopinion", "modifylabel", "showall", "returntime", "auditstatusnextlabel", "auditstatusextlabel"});
                    this.createTabStatusPage(2, "finish");
                    break;
                }
                case "D": {
                    detaillabel.setText(ResManager.loadKDString((String)"\u8be6\u60c5 >", (String)"AdmLoginStatusPlugin_5", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    this.setLabelName(ResManager.loadKDString((String)"\u5ba1\u6279\u4e0d\u901a\u8fc7\uff0c\u9a73\u56de\u7ec8\u6b62\u3002", (String)"AdmLoginStatusPlugin_8", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"submittime", "auditdate", "detaillabel", "auditopinion", "submittime", "auditdate", "auditstatusextlabel"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"waitlabel", "logintipslabel", "uncompletelabel", "logintipsextlabel", "loginlabel", "modifylabel", "returntime", "auditstatuslabel", "auditstatusnextlabel"});
                    this.setRejectTime();
                    this.createTabStatusPage(2, "error");
                    String auditopinion = this.getModel().getDataEntity(true).getString("auditopinion");
                    if (StringUtils.isNotBlank((CharSequence)auditopinion) && auditopinion.length() > 15) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"showall"});
                        break;
                    }
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"showall"});
                    break;
                }
                case "E": 
                case "F": 
                case "G": 
                case "H": 
                case "I": 
                case "J": 
                case "K": 
                case "L": 
                case "Z": 
                case "M": {
                    detaillabel.setText(ResManager.loadKDString((String)"\u8be6\u60c5 >", (String)"AdmLoginStatusPlugin_5", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    this.setLabelName(ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7", (String)"AdmLoginStatusPlugin_7", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"submittime", "auditdate", "detaillabel", "loginlabel", "auditstatuslabel"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"waitlabel", "logintipslabel", "uncompletelabel", "auditopinion", "modifylabel", "showall", "returntime", "auditstatusnextlabel", "auditstatusextlabel"});
                    this.createTabStatusPage(2, "finish");
                }
            }
            this.getView().updateView("flexpanelap11");
            this.getView().updateView("auditstatusnextlabel");
            if (Objects.isNull(customParams.get("id"))) {
                OperationServiceHelper.executeOperate((String)"save", (String)"adm_registerstatus", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, (OperateOption)OperateOption.create());
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setFormData();
        this.setFormTools();
        this.setLogo();
    }

    private void setLogo() {
        try {
            String value = LoginMCServiceUtil.getMcData((String)"_tenant_login_config_values_");
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                HashMap resultMap = (HashMap)SerializationUtils.fromJsonString((String)value, HashMap.class);
                if (resultMap == null) {
                    return;
                }
                FileService imageFileService = FileServiceFactory.getImageFileService();
                String realPath = imageFileService.getRealPath((String)resultMap.get("lefttoplogoimg"));
                if (StringUtils.isNotBlank((CharSequence)realPath)) {
                    realPath = UrlService.getImageFullUrl((String)String.valueOf(realPath));
                    Image imageap = (Image)this.getControl("imageap");
                    if (imageap != null) {
                        imageap.setUrl(realPath);
                    }
                }
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u7528\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u5931\u8d25\uff0c\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"AdmLoginStatusPlugin_10", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            LOG.error("\u8c03\u7528\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u5931\u8d25\uff0c\u65e0\u6709\u6548\u6570\u636e" + e.getMessage());
        }
    }

    private void createTabStatusPage(int currentStep, String currentStatus) {
        Wizard wizard = (Wizard)this.getControl("status_wizardap");
        List stepsOptions = wizard.getStepsOptions();
        stepsOptions.clear();
        StepsOption submitOption = new StepsOption();
        submitOption.setTitle(new LocaleString(ResManager.loadKDString((String)"\u8d44\u6599\u63d0\u4ea4", (String)"AdmLoginStatusPlugin_1", (String)"scm-adm-formplugin", (Object[])new Object[0])));
        submitOption.setDescription(new LocaleString(""));
        submitOption.setStatus("finish");
        stepsOptions.add(submitOption);
        StepsOption processOption = new StepsOption();
        processOption.setTitle(new LocaleString(ResManager.loadKDString((String)"\u8d44\u6599\u5ba1\u6279\u4e2d", (String)"AdmLoginStatusPlugin_2", (String)"scm-adm-formplugin", (Object[])new Object[0])));
        processOption.setDescription(new LocaleString(""));
        processOption.setStatus("finish");
        stepsOptions.add(processOption);
        StepsOption resultOption = new StepsOption();
        resultOption.setTitle(new LocaleString(ResManager.loadKDString((String)"\u5ba1\u6279\u7ed3\u679c", (String)"AdmLoginStatusPlugin_3", (String)"scm-adm-formplugin", (Object[])new Object[0])));
        resultOption.setDescription(new LocaleString(""));
        resultOption.setStatus("finish");
        stepsOptions.add(resultOption);
        wizard.setWizardStepsOptions(stepsOptions);
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>(2);
        currentStepMap.put("currentStep", currentStep);
        currentStepMap.put("currentStatus", currentStatus);
        wizard.setWizardCurrentStep(currentStepMap);
    }

    private boolean isReturnModify() {
        DynamicObject newRow;
        String examstatus;
        String billid = this.getModel().getDataEntity().getPkValue().toString();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"adm_supplierreg", (String)"entry_exam.examstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(billid))});
        boolean returnModifyStatus = false;
        if (!query.isEmpty() && "E".equals(examstatus = (newRow = (DynamicObject)query.get(query.size() - 1)).getString("entry_exam.examstatus"))) {
            returnModifyStatus = true;
        }
        return returnModifyStatus;
    }

    private void setSubmitTime() {
        String billid = this.getModel().getDataEntity().getPkValue().toString();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"adm_supplierreg", (String)"entry_exam.examstatus,entry_exam.examtime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(billid))});
        for (int i = query.size() - 1; i >= 0; --i) {
            DynamicObject row = (DynamicObject)query.get(i);
            String examStatus = row.getString("entry_exam.examstatus");
            String examTime = row.getString("entry_exam.examtime");
            if (!StringUtils.isNotBlank((CharSequence)examStatus) || !examStatus.equals("B")) continue;
            this.getModel().setValue("submittime", (Object)examTime);
            break;
        }
    }

    private void setReturnTime() {
        String billid = this.getModel().getDataEntity().getPkValue().toString();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"adm_supplierreg", (String)"entry_exam.examtime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(billid))});
        if (!query.isEmpty()) {
            DynamicObject lastRow = (DynamicObject)query.get(query.size() - 1);
            String returnTime = lastRow.getString("entry_exam.examtime");
            this.getModel().setValue("returntime", (Object)returnTime);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"returntime"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"auditdate"});
        }
    }

    private void setRejectTime() {
        String billid = this.getModel().getDataEntity().getPkValue().toString();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"adm_supplierreg", (String)"entry_exam.examstatus,entry_exam.examtime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(billid))});
        if (query.size() > 1) {
            DynamicObject rejectInfo = (DynamicObject)query.get(query.size() - 1);
            DynamicObject submitInfo = (DynamicObject)query.get(query.size() - 2);
            String rejectExamStatus = rejectInfo.getString("entry_exam.examstatus");
            String submitExamStatus = submitInfo.getString("entry_exam.examstatus");
            if ("B".equals(submitExamStatus) && "D".equals(rejectExamStatus)) {
                String rejectExamTime = rejectInfo.getString("entry_exam.examtime");
                this.getModel().setValue("rejecttime", (Object)rejectExamTime);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"rejecttime"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"auditdate"});
            }
        }
    }

    private void setLabelName(String status) {
        Label labelap = (Label)this.getControl("auditstatusnextlabel");
        labelap.setText(status);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        try {
            this.getModel().getDataEntity();
        }
        catch (KDException e) {
            evt.setCancel(true);
            LOG.error(e.getMessage());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        try {
            if (key.equals("detaillabel") || key.equals("modifylabel")) {
                String billid = this.getModel().getDataEntity().getPkValue().toString();
                String groupId = MutexHelper.getMutexGroupId((String)"adm_supplierreg", (String)"modify");
                if (groupId != null) {
                    Map lockInfo = DataMutex.create().getLockInfo(billid, groupId, "adm_supplierreg");
                    if (lockInfo != null && !lockInfo.isEmpty()) {
                        this.getPageCache().put(lockInfo);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u53ef\u80fd\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u8d44\u6599\uff0c\u786e\u5b9a\u8e22\u9664\u5df2\u767b\u5f55\u7684\u7528\u6237\u5417\uff1f", (String)"AdmLoginStatusPlugin_11", (String)"scm-adm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("netctrlActionId", (IFormPlugin)this));
                    } else {
                        String formId = this.getView().getFormShowParameter().getFormId();
                        BaseShowParameter bsp = new BaseShowParameter();
                        if (StringUtils.equals((CharSequence)formId, (CharSequence)"adm_registerstatus_layout")) {
                            bsp.setFormId("adm_companyinfo_register");
                        } else {
                            bsp.setFormId("adm_supplierreg");
                        }
                        bsp.setPkId((Object)billid);
                        HashMap<String, String> mp = new HashMap<String, String>();
                        mp.put("registerstatusform", "1");
                        bsp.setCustomParams(mp);
                        bsp.setBillStatus(BillOperationStatus.EDIT);
                        bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "supplierreg"));
                        this.getView().showForm((FormShowParameter)bsp);
                    }
                }
            } else if (key.equals("loginlabel")) {
                String url = CommonUtil.getDomainUrlWidthouSlash() + "/login.html";
                this.getView().openUrl(url);
            } else if (key.equals("showall")) {
                Object auditopinion = this.getModel().getValue("auditopinion");
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("auditopinion", auditopinion);
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"adm_showauditopinion", (ShowType)ShowType.Modal, paramMap, null);
            }
        }
        catch (KDException e) {
            LOG.info("\u60a8\u8981\u8bfb\u53d6\u7684\u586b\u5199\u6ce8\u518c\u8d44\u6599\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff1a" + e.getMessage());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals("mailValidityConfirm") || callBackId.equals("idNullConfirm")) {
            this.getView().close();
        } else if ("netctrlActionId".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            String billid = this.getModel().getDataEntity().getString("id");
            MutexHelper.release((String)"adm_supplierreg", (String)"modify", (String)billid);
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId("adm_supplierreg");
            bsp.setPkId((Object)billid);
            HashMap<String, String> mp = new HashMap<String, String>();
            mp.put("registerstatusform", "1");
            bsp.setCustomParams(mp);
            bsp.setBillStatus(BillOperationStatus.EDIT);
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }
}

