/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;

public class AdmSelectBaseDataNoPlugin
extends AbstractFormPlugin {
    private static final String SELECT_FIELD = "selects";
    private static final String BT_OK = "btnok";
    private static final String MAIN_ENTITY = "mainentity";
    private static final String SOURCEBILL_KEY = "sourcebillkey";
    private static final String SOURCEBILL_NAME = "sourcebillname";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button bt = (Button)this.getControl(BT_OK);
        bt.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ComboEdit comboEdit = (ComboEdit)this.getControl(SELECT_FIELD);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object guestbillid = customParams.get(MAIN_ENTITY);
        this.getModel().setValue(SOURCEBILL_KEY, guestbillid);
        if (Objects.isNull(guestbillid)) {
            return;
        }
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        DynamicObject sourceBillEntity = ORM.create().newDynamicObject(guestbillid.toString());
        this.getModel().setValue(SOURCEBILL_NAME, (Object)sourceBillEntity.getDynamicObjectType().getDisplayName());
        DataEntityPropertyCollection baseDataProperties = sourceBillEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty baseDataProperty : baseDataProperties) {
            if (baseDataProperty instanceof BasedataProp) {
                data.add(new ComboItem(new LocaleString(baseDataProperty.getName()), baseDataProperty.getName()));
                continue;
            }
            if (!(baseDataProperty instanceof EntryProp)) continue;
            DynamicObjectCollection billEntryEntity = sourceBillEntity.getDynamicObjectCollection(baseDataProperty.getName());
            DataEntityPropertyCollection billEntryEntityProperties = billEntryEntity.getDynamicObjectType().getProperties();
            for (IDataEntityProperty billEntryEntityProperty : billEntryEntityProperties) {
                if (!(billEntryEntityProperty instanceof BasedataProp)) continue;
                data.add(new ComboItem(new LocaleString(billEntryEntityProperty.getName()), billEntryEntityProperty.getName()));
            }
        }
        comboEdit.setComboItems(data);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control bt = (Control)evt.getSource();
        String key = bt.getKey();
        if (key.equals(BT_OK)) {
            Object selectsobj = this.getModel().getValue(SELECT_FIELD);
            if (!Objects.isNull(selectsobj)) {
                String selects = selectsobj.toString();
                this.getView().returnDataToParent((Object)selects);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5b57\u6bb5\u3002", (String)"AdmSelectBaseDataNoPlugin_0", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

