/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin.edit;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.plugin.AbstractAdmBillPlugIn;
import kd.scm.common.task.SupChgFilterDefService;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.sdk.scm.common.extpoint.ISupChgFilterService;

public class AdmSupplierEdit
extends AbstractAdmBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.resetStatus();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (operateKey.equals("change")) {
            if (this.getModel().getDataEntity().getString("auditstatus").equals(SrmSupplierStatusEnum.UNAUDIT.getValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ce8\u518c\u9a73\u56de\u72b6\u6001\u7684\u4f9b\u5e94\u5546\u4e0d\u80fd\u8fdb\u884c\u8d44\u6599\u53d8\u66f4\u3002", (String)"AdmSupplierEdit_3", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Map result = null;
            Long supId = Long.parseLong(this.getModel().getDataEntity().getPkValue().toString());
            SupChgFilterDefService defPlugin = new SupChgFilterDefService();
            PluginProxy pluginProxy = PluginProxy.create((Object)defPlugin, ISupChgFilterService.class, (String)"SCM_SRM_SRMSUPCHGFILTERSERVICE_EXT", null);
            List plugins = pluginProxy.getPlugins();
            if (plugins != null && !plugins.isEmpty()) {
                for (ISupChgFilterService srmSupChgFilterService : plugins) {
                    result = srmSupChgFilterService.supplierChgFilter(supId);
                }
            }
            if (result != null && !((Boolean)result.get("success")).booleanValue()) {
                this.getView().showTipNotification(result.get("message").toString());
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String key = afterDoOperationEventArgs.getOperateKey();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess() && key.equals("change")) {
            OpenFormUtil.openBasePage((IFormView)this.getView(), (String)"adm_supplierchg", (Object)this.getModel().getDataEntity().getLong("id"), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
        }
    }

    private void resetStatus() {
        this.getModel().setDataChanged(false);
        DynamicObject tempObj = this.getModel().getDataEntity();
        if (tempObj == null) {
            return;
        }
        String bizStatus = tempObj.getString("auditstatus");
        if (bizStatus == null) {
            return;
        }
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(bizStatus.toLowerCase() + "tab"));
    }
}

