/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin.list;

import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmImproveConfirmStatusEnum;
import kd.scm.common.plugin.AbstractAdmListPlugin;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmCommonUtil;

public class AdmImproveList
extends AbstractAdmListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        qFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.CANCELED.getVal())).and(new QFilter("supplier", "in", (Object)supIdList)));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        long billId;
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"tblconfirm", (CharSequence)key)) {
            QFilter confirmStatusFilter;
            billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            if (billId == 0L) {
                evt.setCancel(true);
                return;
            }
            QFilter idFilter = new QFilter("id", "=", (Object)billId);
            QFilter[] filters = new QFilter[]{idFilter, confirmStatusFilter = new QFilter("confirmstatus", "=", (Object)SrmImproveConfirmStatusEnum.TODO.getVal())};
            DynamicObject obj = QueryServiceHelper.queryOne((String)"adm_improve", (String)"id", (QFilter[])filters);
            if (obj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u53cd\u9988\uff0c\u4e0d\u80fd\u518d\u6b21\u53cd\u9988\u3002", (String)"AdmImproveList_0", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)"tblfinish", (CharSequence)key) && (billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")))) == 0L) {
            evt.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            switch (operateKey) {
                case "myconfirm": {
                    MutexHelper.require((String)"adm_improve", (Object)billId, (String)"myconfirm", (boolean)true, (StringBuilder)new StringBuilder(16));
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"adm_improvecfm", (Object)SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap"))), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
                    break;
                }
                case "finish": {
                    QFilter idFilter = new QFilter("id", "=", (Object)SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap"))));
                    QFilter confirmStatusFilter = new QFilter("confirmstatus", "=", (Object)SrmImproveConfirmStatusEnum.IMPROVING.getVal()).or(new QFilter("confirmstatus", "=", (Object)SrmImproveConfirmStatusEnum.IMPROVE_REJECT.getVal()));
                    QFilter[] filters = new QFilter[]{idFilter, confirmStatusFilter};
                    DynamicObject obj = QueryServiceHelper.queryOne((String)"adm_improve", (String)"id,confirmstatus", (QFilter[])filters);
                    if (null == obj || obj.getString("confirmstatus") == null || !obj.getString("confirmstatus").equals(SrmImproveConfirmStatusEnum.IMPROVING.getVal()) && !obj.getString("confirmstatus").equals(SrmImproveConfirmStatusEnum.IMPROVE_REJECT.getVal())) break;
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"adm_improveresult", (Object)SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap"))), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("callbackid")) {
            long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            MutexHelper.release((String)"adm_improve", (String)"myconfirm", (String)String.valueOf(billId));
            this.getView().invokeOperation("refresh");
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bd_supplier".equals(args.getRefEntityId())) {
            List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
            args.addCustomQFilter(new QFilter("id", "in", (Object)supIdList));
        }
    }
}

