/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin.list;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.adm.common.utils.AdmBizPartnerUtil;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.plugin.AbstractAdmListPlugin;
import kd.scm.common.task.SupChgFilterDefService;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.SupplierChangeValidator;
import kd.sdk.scm.common.extpoint.ISupChgFilterService;

public class AdmSupChangeList
extends AbstractAdmListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        qFilterList.add(AdmBizPartnerUtil.assembleQFilterBizPartner());
        qFilterList.add(new QFilter("origin", "=", (Object)"1").or(new QFilter("origin", "=", (Object)"2").and(new QFilter("cfmstatus", "=", (Object)"B"))));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (operateKey.equals("change")) {
            QFilter qFilter = new QFilter("status", "=", (Object)SrmSupplierStatusEnum.AUDIT.getValue()).and(new QFilter("supplier", "=", (Object)BizPartnerUtil.getCurSupplierId()));
            DynamicObject supplier = QueryServiceHelper.queryOne((String)"srm_supplier", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (supplier != null) {
                this.getPageCache().put("billid", supplier.getString("id"));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546\uff0c\u4e0d\u80fd\u8fdb\u884c\u53d8\u66f4\u3002", (String)"AdmSupChangeList_0", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (supplier != null) {
                Long supId = supplier.getLong("id");
                Map result = null;
                SupChgFilterDefService defPlugin = new SupChgFilterDefService();
                PluginProxy pluginProxy = PluginProxy.create((Object)defPlugin, ISupChgFilterService.class, (String)"SCM_SRM_SRMSUPCHGFILTERSERVICE_EXT", null);
                List plugins = pluginProxy.getPlugins();
                if (plugins != null && !plugins.isEmpty()) {
                    for (ISupChgFilterService srmSupChgFilterService : plugins) {
                        result = srmSupChgFilterService.supplierChgFilter(supId);
                    }
                }
                if (result != null && !((Boolean)result.get("success")).booleanValue()) {
                    this.getView().showTipNotification(result.get("message").toString());
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "change": {
                    long billId = Long.parseLong(this.getPageCache().get("billid"));
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"adm_supplierchg", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
                    break;
                }
                case "quickchange": {
                    long bill = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
                    if (bill == 0L) {
                        return;
                    }
                    SupplierChangeValidator.Message message = SupplierChangeValidator.validQuickChange((IFormView)this.getView(), (Object)bill, (String)"adm_supchange");
                    if (!message.getResult().booleanValue()) {
                        return;
                    }
                    long supplierId = message.getSupplierId();
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("supchange_id", bill);
                    DynamicObject query = QueryServiceHelper.queryOne((String)"adm_supchange", (String)"billstatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bill)});
                    String billstatus = query.getString("billstatus");
                    if ("A".equals(billstatus)) {
                        paramMap.put("supchange_billno", query.get("billno"));
                    }
                    OpenFormUtil.openBasePage((IFormView)this.getView(), (String)"adm_supplierchg", (Object)supplierId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, paramMap, null);
                    break;
                }
            }
        }
    }
}

