/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.common;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.FeatureCheckUtil;
import kd.scm.common.util.SrmCommonUtil;

public class AdmCommonList
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        LicenseCheckResult checkResult;
        super.preOpenForm(e);
        String formId = ((ListShowParameter)e.getSource()).getBillFormId();
        if ((StringUtils.equals((CharSequence)formId, (CharSequence)"adm_samplenotify_in") || StringUtils.equals((CharSequence)formId, (CharSequence)"adm_aptitude_in")) && !(checkResult = FeatureCheckUtil.checkNewFeature((String)"PRO_ADM")).getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(checkResult.getMsg());
            e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        boolean enableNewAccessFlow = SrmCommonUtil.enableNewAccessFlow();
        if (enableNewAccessFlow) {
            List columns = args.getListColumns();
            List<String> deleteColumns = this.getColumnList();
            ArrayList<IListColumn> listColumns = new ArrayList<IListColumn>(columns.size());
            for (IListColumn column : columns) {
                String fieldKey = column.getListFieldKey();
                if (deleteColumns.contains(fieldKey)) continue;
                listColumns.add(column);
            }
            columns.clear();
            columns.addAll(listColumns);
        }
    }

    private List<String> getColumnList() {
        ArrayList<String> columnList = new ArrayList<String>(4);
        columnList.add("aptitudeno.hasscene");
        columnList.add("aptitudeno.hassample");
        columnList.add("aptitudeno.hasmaterial");
        columnList.add("aptitudeno.hasapprove");
        columnList.add("hasscene");
        columnList.add("hassample");
        columnList.add("hasmaterial");
        columnList.add("hasapprove");
        return columnList;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        qFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
    }
}

