/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.common;

import java.net.URLDecoder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class AdmPrintToAttachmentUtil {
    public static Log log = LogFactory.getLog((String)"AdmPrintToAttachmentUtil");

    public static void attToAttachmentFile(List<Map<String, Object>> attachments, DynamicObjectCollection attCol) {
        for (Map<String, Object> map : attachments) {
            DynamicObject attObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
            attObj.set("name", map.get("name"));
            attObj.set("size", map.get("size"));
            attObj.set("uid", (Object)("rc-upload-" + UUID.randomUUID().toString()));
            Object url = map.get("url");
            if (Objects.nonNull(url)) {
                try {
                    String path = StringUtils.substringAfter((String)url.toString(), (String)"path=");
                    String uri = StringUtils.substringBefore((String)url.toString(), (String)"path=");
                    if (path.contains("&kdedcba")) {
                        path = StringUtils.substringBefore((String)path, (String)"&kdedcba");
                    }
                    path = URLDecoder.decode(path, "UTF-8");
                    attObj.set("url", (Object)(uri + "path=" + path));
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            attObj.set("type", map.get("type"));
            attObj.set("tempfile", (Object)1);
            attObj.set("pageid", (Object)"");
            attObj.set("number", (Object)UUID.randomUUID().toString());
            attObj.set("status", (Object)"B");
            Date now = new Date();
            attObj.set("modifytime", (Object)now.getTime());
            attObj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attObj});
            attCol.addNew().set("fbasedataid", (Object)attObj);
        }
    }
}

