/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.filter.FilterServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.BizPartnerUtil;

public final class AdmInquiryService {
    private Log logger = LogFactory.getLog(AdmInquiryService.class);

    public Map<String, Set<Long>> getSampleNotifyTodoInfos() {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        List<QFilter> qFilters = this.getCommonFilter("adm_samplenotify_in");
        qFilters.add(this.getSampleNotifyFilter());
        QFilter[] qFilterArray = qFilters.toArray(new QFilter[0]);
        HashSet queryIdList = new HashSet(8);
        this.logger.info("AdmInquiryService.getSampleNotifyTodoInfos={}", (Object)SerializationUtils.toJsonString((Object)qFilterArray));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AdmInquiryService.getSampleNotifyTodoInfos", (String)"adm_samplenotify", (String)"id", (QFilter[])qFilterArray, null);){
            ds.forEach(row -> queryIdList.add(row.getLong("id")));
        }
        map.put("unConfirm", queryIdList);
        return map;
    }

    public Map<String, Set<Long>> getQuestionTodoInfos() {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        List<QFilter> qFilters = this.getCommonFilter("adm_questioncomp");
        qFilters.add(this.getQuestionFilter());
        QFilter[] qFilterArray = qFilters.toArray(new QFilter[0]);
        HashSet queryIdList = new HashSet(8);
        this.logger.info("AdmInquiryService.getQuestionTodoInfos={}", (Object)SerializationUtils.toJsonString((Object)qFilterArray));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AdmInquiryService.getQuestionTodoInfos", (String)"adm_questioncomp", (String)"id", (QFilter[])qFilterArray, null);){
            ds.forEach(row -> queryIdList.add(row.getLong("id")));
        }
        map.put("unLock", queryIdList);
        return map;
    }

    public Map<String, Set<Long>> getExamineTodoInfos() {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        List<QFilter> qFilters = this.getCommonFilter("adm_examine");
        qFilters.add(this.getExamineFilter());
        QFilter[] qFilterArray = qFilters.toArray(new QFilter[0]);
        HashSet queryIdList = new HashSet(8);
        this.logger.info("AdmInquiryService.getExamineTodoInfos={}", (Object)SerializationUtils.toJsonString((Object)qFilterArray));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AdmInquiryService.getExamineTodoInfos", (String)"adm_examine", (String)"id", (QFilter[])qFilterArray, null);){
            ds.forEach(row -> queryIdList.add(row.getLong("id")));
        }
        map.put("unConfirm", queryIdList);
        return map;
    }

    public Map<String, Set<Long>> getImproveTodoInfos() {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        List<QFilter> qFilters = this.getCommonFilter("adm_improve");
        qFilters.add(this.getImproveFilter());
        QFilter[] qFilterArray = qFilters.toArray(new QFilter[0]);
        HashSet queryIdList = new HashSet(8);
        this.logger.info("AdmInquiryService.getImproveTodoInfos={}", (Object)SerializationUtils.toJsonString((Object)qFilterArray));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AdmInquiryService.getImproveTodoInfos", (String)"adm_improve", (String)"id", (QFilter[])qFilterArray, null);){
            ds.forEach(row -> queryIdList.add(row.getLong("id")));
        }
        map.put("unConfirm", queryIdList);
        return map;
    }

    public QFilter getSampleNotifyFilter() {
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        qFilter.and(new QFilter("cfmstatus", "=", (Object)ConfirmStatusEnum.UNCONFIRM.getVal()));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        return qFilter;
    }

    public QFilter getQuestionFilter() {
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        qFilter.and(new QFilter("lockstatus", "=", (Object)"A"));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getVal()));
        return qFilter;
    }

    public QFilter getExamineFilter() {
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        qFilter.and(new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.UNCONFIRM.getVal()));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        return qFilter;
    }

    public QFilter getImproveFilter() {
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        qFilter.and(new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.UNCONFIRM.getVal()).or("confirmstatus", "=", (Object)ConfirmStatusEnum.REJECT.getVal()));
        return qFilter;
    }

    public List<QFilter> getCommonFilter(String metadata) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        qFilter.and(this.getBizPartnerFilter());
        qFilter.and(this.getSchemeQfilter(metadata));
        qFilter.and(this.getPermissionFilter(metadata, "02"));
        qFilters.add(qFilter);
        return qFilters;
    }

    private QFilter getBizPartnerFilter() {
        QFilter qFilter = BizPartnerUtil.assembleQFilterBizPartner();
        return qFilter;
    }

    private QFilter getSchemeQfilter(String metadata) {
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        List schemeList = FilterServiceHelper.getSchemeList((String)metadata);
        FilterScheme defaultScheme = null;
        if (schemeList != null && schemeList.size() > 0) {
            for (int i = schemeList.size() - 1; i >= 0; --i) {
                if (!((FilterScheme)schemeList.get(i)).isDefault()) continue;
                defaultScheme = (FilterScheme)schemeList.get(i);
                break;
            }
        }
        if (defaultScheme != null) {
            qFilter = FilterServiceHelper.getQFilterByFilterScheme(defaultScheme, (String)metadata, (QFilter)qFilter);
        }
        return qFilter;
    }

    private QFilter getPermissionFilter(String metaDataCode, String orgVievType) {
        HasPermOrgResult permOrgsResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgVievType, null, (String)metaDataCode, (String)"47150e89000000ac");
        List orgIdList = permOrgsResult.getHasPermOrgs();
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Collection)orgIdList)) {
            qFilter.and(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        } else {
            qFilter.and(new QFilter("org.id", "in", (Object)orgIdList));
        }
        return qFilter;
    }
}

