/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.service.opp;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.license.api.ILicenseService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.util.PhoneValidator;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.cloudkingdee.CloudDataUtils;
import kd.scm.common.cloudkingdee.CompanyInfo;
import kd.scm.common.constant.SupplierLifeCycleConstant;
import kd.scm.common.sdk.SupplierRegSetDefValueService;
import kd.scm.common.util.CodeRuleUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.SupplierLifeCycleManagerUtil;
import kd.sdk.scm.srm.extpoint.ISupplierRegSetDefValueService;

public class AdmRegistUserSubmitService {
    public Map<String, Object> submit(HashMap<String, String> param) {
        String number;
        Map<String, Object> resultMap = new HashMap<String, Object>();
        String enterprise = param.get("enterprise");
        String creditno = param.get("creditno");
        String name = param.get("name");
        Date date = TimeServiceHelper.now();
        String billno = CodeRuleUtil.getCodeRule((String)"adm_supplierreg");
        if (billno == null) {
            billno = creditno;
        }
        if ((number = param.get("number")).contains("+86") && number.length() == 14) {
            number = number.substring(3, 14);
        }
        if (!number.trim().equals("") || null != number) {
            QFilter qfilter;
            DynamicObject userObj = ORMUtil.newDynamicObject((String)"adm_userquery");
            userObj.set("number", (Object)number);
            userObj.set("name", (Object)name);
            userObj.set("enterprise", (Object)enterprise);
            userObj.set("creditno", (Object)creditno);
            userObj.set("creator", (Object)RequestContext.get().getUserId());
            userObj.set("createtime", (Object)date);
            userObj.set("auditor", (Object)RequestContext.get().getUserId());
            userObj.set("auditdate", (Object)date);
            userObj.set("status", (Object)"C");
            userObj.set("enable", (Object)"1");
            resultMap = SrmCommonUtil.saveDynamicObject((String)"adm_userquery", (DynamicObject)userObj);
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                return resultMap;
            }
            DynamicObject supplierObj = BusinessDataServiceHelper.newDynamicObject((String)"adm_supplier");
            boolean supplierlifecycle = SupplierLifeCycleManagerUtil.isEnableSupplierLifeCycleManager();
            Set quitOrgSet = SupplierLifeCycleManagerUtil.getQuitOrInvalidOrgVaildRegistrationSet((String)enterprise, (String)creditno);
            boolean isquitregister = !quitOrgSet.isEmpty() && supplierlifecycle;
            supplierObj.set("isquitregister", (Object)isquitregister);
            supplierObj.set("supplier_status", (Object)SupplierLifeCycleConstant.SUPSTATUS_REGISTER);
            supplierObj.set("number", (Object)billno);
            supplierObj.set("name", (Object)enterprise);
            supplierObj.set("simplename", (Object)enterprise);
            supplierObj.set("linkman", (Object)name);
            supplierObj.set("phone", (Object)number);
            supplierObj.set("societycreditcode", (Object)creditno);
            supplierObj.set("creator", (Object)RequestContext.get().getUserId());
            supplierObj.set("createtime", (Object)date);
            supplierObj.set("status", (Object)"A");
            supplierObj.set("enable", (Object)"1");
            supplierObj.set("auditstatus", (Object)"A");
            supplierObj.set("origin", (Object)"1");
            supplierObj.set("biztype", (Object)"1");
            ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
            if (Objects.nonNull(service) && 1 == service.getModeType()) {
                supplierObj.set("org", (Object)OrgUnitServiceHelper.getRootOrgId());
                supplierObj.set("createorg", (Object)OrgUnitServiceHelper.getRootOrgId());
            }
            this.setSuplierDefaltValue(supplierObj, enterprise);
            EntryProp entryProp = (EntryProp)supplierObj.getDataEntityType().getProperties().get((Object)"entry_link");
            EntryType entryType = (EntryType)entryProp.getItemType();
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set("seq", (Object)1);
            row.set("name1", (Object)name);
            boolean valid = true;
            String resMsg = "";
            if (StringUtils.isEmail((String)number)) {
                row.set("email1", (Object)number);
            } else if (StringUtils.isPhoneNumberValid((String)number) || ((Boolean)this.isPhone(number).get("succed")).booleanValue()) {
                row.set("mobile1", (Object)number);
            } else {
                valid = false;
                resMsg = this.isPhone(number).get("message").toString();
            }
            row.set("isdefault_link", (Object)Boolean.TRUE);
            DynamicObjectCollection rows = supplierObj.getDynamicObjectCollection("entry_link");
            rows.add((Object)row);
            SupplierRegSetDefValueService defPlugin = new SupplierRegSetDefValueService();
            PluginProxy pluginProxy = PluginProxy.create((Object)defPlugin, ISupplierRegSetDefValueService.class, (String)"SCM_SRM_SUPPLIERREGSETDEFVALUE_EXT", null);
            pluginProxy.callAfter(p -> {
                p.setFieldsDefValue(supplierObj);
                return null;
            });
            try {
                resultMap = SrmCommonUtil.saveDynamicObject((String)"adm_supplier", (DynamicObject)supplierObj);
                String supplierRegId = supplierObj.getString("id");
                userObj.set("supplierregid", (Object)supplierRegId);
                SrmCommonUtil.saveDynamicObject((String)"adm_userquery", (DynamicObject)userObj);
            }
            catch (KDBizException e) {
                resultMap.put("succed", false);
                resultMap.put("message", e.getMessage());
            }
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                qfilter = new QFilter("enterprise", "=", (Object)enterprise);
                DeleteServiceHelper.delete((String)"srm_user", (QFilter[])new QFilter[]{qfilter});
            }
            if (!valid) {
                resultMap.put("succed", valid);
                resultMap.put("message", resMsg);
                qfilter = new QFilter("enterprise", "=", (Object)enterprise);
                DeleteServiceHelper.delete((String)"srm_user", (QFilter[])new QFilter[]{qfilter});
            }
        }
        return resultMap;
    }

    private void setSuplierDefaltValue(DynamicObject supplierObj, String enterprise) {
        CompanyInfo companyInfo = CloudDataUtils.getCompanyInfo((String)enterprise);
        if (companyInfo == null) {
            return;
        }
        supplierObj.set("artificialperson", (Object)companyInfo.getLegalPerson());
        supplierObj.set("regcapital", (Object)companyInfo.getRegistedMoney());
        supplierObj.set("regaddress", (Object)companyInfo.getAddress());
        supplierObj.set("regdate", (Object)companyInfo.getEstablisDate());
        supplierObj.set("staffnum", (Object)companyInfo.getInsuredPersons());
        supplierObj.set("summary", (Object)companyInfo.getProfile());
        supplierObj.set("bizscope", (Object)companyInfo.getBusinessScope());
        supplierObj.set("email", (Object)companyInfo.getEmail());
        supplierObj.set("complaintel", (Object)companyInfo.getPhone());
    }

    private Map<String, Object> isPhone(String number) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        try {
            PhoneValidator phoneValidator = new PhoneValidator(number, true);
            phoneValidator.check();
        }
        catch (KDBizException e) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", e.getMessage());
        }
        return resultMap;
    }
}

