/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.service.valid;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.MessageUtils;
import kd.bos.message.api.EmailInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.util.PhoneValidator;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.scm.common.cloudkingdee.CloudDataUtils;
import kd.scm.common.cloudkingdee.CompanyInfo;
import kd.scm.common.skyeye.QiChaChaApiUtil;
import kd.scm.common.skyeye.SkyEyeApiUtil;
import kd.scm.common.skyeye.config.QiChaChaConfig;
import kd.scm.common.skyeye.config.SkyEyeConfig;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.SupplierLifeCycleManagerUtil;

public class AdmRegistValid {
    private Log log = LogFactory.getLog(this.getClass());

    public Boolean validateInfo(HashMap<String, String> param, StringBuilder result) {
        String enterprise = param.get("enterprise");
        String creditno = param.get("creditno");
        String name = param.get("name");
        String number = null;
        Boolean isSucced = true;
        if (!param.get("number").trim().isEmpty() && (number = param.get("number")).contains("+86") && number.length() == 14) {
            number = number.substring(3, 14);
        }
        if (name == null || name.trim().equals("")) {
            result.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u59d3\u540d\u3002", (String)"AdmRegisterPlugin_12", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            result.append("\n");
            isSucced = false;
        }
        if (StringUtils.equals((CharSequence)"administrator", (CharSequence)name)) {
            result.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u6ce8\u518c\u7528\u6237\u540d\u4e3a\u201cadministrator\u201d\u7684\u7528\u6237\u3002", (String)"AdmRegisterPlugin_033", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            isSucced = false;
        }
        isSucced = this.validNumber(number, result, isSucced);
        boolean supplierlifecycle = SupplierLifeCycleManagerUtil.isEnableSupplierLifeCycleManager();
        boolean validEnterprise = true;
        boolean validCreditno = true;
        boolean validSkyeye = true;
        boolean isBlackEnterpirse = false;
        boolean isBlackCreditno = false;
        if (StringUtils.isNotBlank((CharSequence)enterprise) && SrmCommonUtil.isBlackEnterpirse((long)0L, null, (String)enterprise)) {
            isBlackEnterpirse = true;
        }
        if (StringUtils.isNotBlank((CharSequence)creditno) && SrmCommonUtil.isBlackEnterpirse((long)0L, (String)creditno, null)) {
            isBlackCreditno = true;
        }
        if (isBlackEnterpirse && isBlackCreditno) {
            result.append(ResManager.loadResFormat((String)"\u4f01\u4e1a\u540d\u79f0(%1)\u3001\u4fe1\u7528\u4ee3\u7801(%2) \u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u3002", (String)"AdmRegisterPlugin_13", (String)"scm-adm-formplugin", (Object[])new Object[]{enterprise, creditno}));
        } else if (isBlackEnterpirse) {
            result.append(ResManager.loadResFormat((String)"\u4f01\u4e1a\u540d\u79f0(%1) \u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u3002", (String)"AdmRegisterPlugin_4", (String)"scm-adm-formplugin", (Object[])new Object[]{enterprise}));
        } else if (isBlackCreditno) {
            result.append(ResManager.loadResFormat((String)"\u4fe1\u7528\u4ee3\u7801(%1) \u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u3002", (String)"AdmRegisterPlugin_8", (String)"scm-adm-formplugin", (Object[])new Object[]{creditno}));
        } else if (supplierlifecycle) {
            validEnterprise = this.validEnterprise(enterprise, creditno, result, number, isSucced);
            validCreditno = this.validCreditno(enterprise, creditno, result, isSucced);
        } else {
            validEnterprise = this.validEnterprise(enterprise, result, number, isSucced);
            validCreditno = this.validCreditno(creditno, result, isSucced);
        }
        validSkyeye = this.validSkyEye(enterprise, creditno, result, isSucced);
        return validEnterprise && validCreditno && validSkyeye && !isBlackEnterpirse && !isBlackCreditno;
    }

    public HashMap<String, Object> getCodeAndSendMsg(String account, String fun) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        String randomStr = AdmRegistValid.createRandNum();
        String msg = ResManager.loadResFormat((String)"\u9a8c\u8bc1\u7801\uff1a%1\u3002\u60a8\u6b63\u5728\u4f7f\u7528\u77ed\u4fe1\u9a8c\u8bc1\u7801%2\u529f\u80fd\uff0c\u8be5\u9a8c\u8bc1\u7801\u4ec5\u7528\u4e8e\u8eab\u4efd\u9a8c\u8bc1\uff0c\u8bf7\u52ff\u6cc4\u9732\u7ed9\u4ed6\u4eba\u4f7f\u7528\u3002", (String)"AdmCommonUtils_0", (String)"scm-adm-common", (Object[])new Object[]{randomStr, fun});
        String emailmsg = ResManager.loadResFormat((String)"\u9a8c\u8bc1\u7801\uff1a%1\u3002\u60a8\u6b63\u5728\u4f7f\u7528\u90ae\u7bb1\u9a8c\u8bc1\u7801%2\u529f\u80fd\uff0c\u8be5\u9a8c\u8bc1\u7801\u4ec5\u7528\u4e8e\u8eab\u4efd\u9a8c\u8bc1\uff0c\u8bf7\u52ff\u6cc4\u9732\u7ed9\u4ed6\u4eba\u4f7f\u7528\u3002", (String)"AdmCommonUtils_1", (String)"scm-adm-common", (Object[])new Object[]{randomStr, fun});
        if (StringUtils.isNotBlank((CharSequence)account) && account.contains("+86") && account.length() == 14) {
            account = account.substring(3, 14);
        }
        if (StringUtils.isPhoneNumberValid((String)account) || ((Boolean)this.isPhone(account).get("succed")).booleanValue()) {
            MessageUtils.sendMessage((String)account, (String)msg);
            result.put("code", randomStr);
        } else if (StringUtils.isEmail((String)account)) {
            EmailInfo emailInfo = new EmailInfo();
            emailInfo.setContentMimeType("TEXT");
            ArrayList<String> receivers = new ArrayList<String>();
            receivers.add(account);
            emailInfo.setReceiver(receivers);
            emailInfo.setTitle(ResManager.loadResFormat((String)"\u90ae\u7bb1%1\u9a8c\u8bc1\u7801", (String)"AdmCommonUtils_7", (String)"scm-adm-common", (Object[])new Object[]{fun}));
            emailInfo.setContent(emailmsg);
            MessageServiceHelper.sendEmail((EmailInfo)emailInfo);
            result.put("code", randomStr);
        }
        return result;
    }

    public Boolean validSkyEye(String enterprise, String creditno, StringBuilder result, Boolean isSucced) {
        DynamicObject skyEyeDyo = SkyEyeConfig.getSkyEyeConfig();
        if (null != skyEyeDyo) {
            if (!SkyEyeApiUtil.verifySupplier((String)enterprise, (String)creditno)) {
                result.append(ResManager.loadKDString((String)"\u201c\u4f01\u4e1a\u540d\u79f0-\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201d\u5929\u773c\u67e5\u6821\u9a8c\u6ca1\u6709\u901a\u8fc7\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u6709\u6548\u7684\u4fe1\u606f\u3002", (String)"AdmRegisterPlugin_21", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                isSucced = false;
            }
        } else {
            DynamicObject qiChaChaDyo = QiChaChaConfig.getQiChaChaConfig();
            if (null != qiChaChaDyo && !QiChaChaApiUtil.verifySupplier((String)enterprise, (String)creditno)) {
                result.append(ResManager.loadKDString((String)"\u201c\u4f01\u4e1a\u540d\u79f0-\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201d\u5929\u773c\u67e5\u6821\u9a8c\u6ca1\u6709\u901a\u8fc7\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u6709\u6548\u7684\u4fe1\u606f\u3002", (String)"AdmRegisterPlugin_21", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                isSucced = false;
            }
        }
        return isSucced;
    }

    public Boolean validNumber(String number, StringBuilder result, Boolean isSucced) {
        if (number == null || number.trim().equals("")) {
            result.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u624b\u673a\u53f7/\u90ae\u7bb1\u3002", (String)"AdmRegisterPlugin_9", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<String> bosUser = new ArrayList<String>();
        QFilter bosUserQf = new QFilter("phone", "=", (Object)number).or("email", "=", (Object)number).and(new QFilter("enable", "=", (Object)"1"));
        this.getRegisterNumberRepeatData(bosUser, bosUserQf, "bos_user", "id,phone", "phone");
        ArrayList<String> srmUser = new ArrayList<String>();
        QFilter srmUserQf = new QFilter("enable", "=", (Object)"1").and("number", "=", (Object)number);
        this.getRegisterNumberRepeatData(srmUser, srmUserQf, "srm_user", "id,number", "number");
        ArrayList<String> srmSupplierReg = new ArrayList<String>();
        QFilter srmSupplierRegQf = new QFilter("phone", "=", (Object)number);
        this.getRegisterNumberRepeatData(srmSupplierReg, srmSupplierRegQf, "srm_supplierreg", "id,number", "number");
        ArrayList<String> purSupUser = new ArrayList<String>();
        QFilter purSupUserQf = new QFilter("user.phone", "=", (Object)number).or("user.email", "=", (Object)number).and(new QFilter("enable", "=", (Object)"1"));
        this.getRegisterNumberRepeatData(purSupUser, purSupUserQf, "pur_supuser", "id,number", "number");
        ArrayList<String> srcRegexpert = new ArrayList<String>();
        QFilter srcRegexpertQf = new QFilter("telephone", "=", (Object)number).or("email", "=", (Object)number);
        this.getRegisterNumberRepeatData(srcRegexpert, srcRegexpertQf, "src_regexpert", "id,number", "number");
        if (bosUser.isEmpty() && purSupUser.isEmpty() && srmSupplierReg.isEmpty() && srmUser.isEmpty()) {
            return isSucced;
        }
        if (!bosUser.isEmpty() && !purSupUser.isEmpty()) {
            result.append(ResManager.loadResFormat((String)"\u6b64\u8d26\u53f7\u201c%1\u201d\u5df2\u5ba1\u6279\u901a\u8fc7\uff0c\u8bf7\u70b9\u51fb\u201c\u767b\u5f55\u201d\u6309\u94ae\u8fdb\u5165\u7cfb\u7edf\u3002", (String)"AdmRegisterPlugin_11", (String)"scm-adm-formplugin", (Object[])new Object[]{number == null ? "" : number}));
        } else if (!srmSupplierReg.isEmpty()) {
            String supplierRegAuditstatus = this.getSupplierRegAuditstatus(number);
            result.append(this.getRegisterMsgByAuditstatus(supplierRegAuditstatus, number, !bosUser.isEmpty()));
        } else if (!srcRegexpert.isEmpty()) {
            result.append(ResManager.loadResFormat((String)"\u6b64\u8d26\u53f7\uff08%1\uff09\u5df2\u5728\u5bfb\u6e90\u4e13\u5bb6\u8d44\u6599\u4e2d\u5b58\u5728\uff0c\u65e0\u6cd5\u6ce8\u518c\u6210\u4e3a\u4f9b\u5e94\u5546\u7528\u6237\u3002", (String)"AdmRegisterPlugin_37", (String)"scm-adm-formplugin", (Object[])new Object[]{number == null ? "" : number}));
        } else {
            result.append(ResManager.loadResFormat((String)"\u624b\u673a\u53f7/\u90ae\u7bb1(%1) \u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmRegisterPlugin_3", (String)"scm-adm-formplugin", (Object[])new Object[]{number == null ? "" : number}));
        }
        return false;
    }

    private String getRegisterMsgByAuditstatus(String supplierRegAuditstatus, String phone, boolean hasUser) {
        if (StringUtils.isNotBlank((CharSequence)supplierRegAuditstatus) && supplierRegAuditstatus.compareTo("C") >= 0 && !supplierRegAuditstatus.equals("D")) {
            return ResManager.loadResFormat((String)"\u624b\u673a\u53f7/\u90ae\u7bb1(%1) \u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u5f00\u901a\u4f9b\u5e94\u5546\u7528\u6237\u3002", (String)"AdmRegisterPlugin_30", (String)"scm-adm-formplugin", (Object[])new Object[]{phone == null ? "" : phone});
        }
        if (StringUtils.isNotBlank((CharSequence)supplierRegAuditstatus) && supplierRegAuditstatus.equals("D")) {
            return ResManager.loadResFormat((String)"\u624b\u673a\u53f7/\u90ae\u7bb1(%1) \u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002\u60a8\u7684\u6ce8\u518c\u5df2\u88ab\u9a73\u56de\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u3002", (String)"AdmRegisterPlugin_29", (String)"scm-adm-formplugin", (Object[])new Object[]{phone == null ? "" : phone});
        }
        if (StringUtils.isBlank((CharSequence)supplierRegAuditstatus) || hasUser) {
            return ResManager.loadResFormat((String)"\u624b\u673a\u53f7/\u90ae\u7bb1(%1) \u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmRegisterPlugin_3", (String)"scm-adm-formplugin", (Object[])new Object[]{phone == null ? "" : phone});
        }
        boolean exists = QueryServiceHelper.exists((String)"srm_supplierreg", (QFilter[])new QFilter[]{new QFilter("phone", "=", (Object)phone).and("origin", "=", (Object)"2")});
        if (exists) {
            return ResManager.loadResFormat((String)"\u624b\u673a\u53f7/\u90ae\u7bb1(%1) \u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmRegisterPlugin_3", (String)"scm-adm-formplugin", (Object[])new Object[]{phone == null ? "" : phone});
        }
        return ResManager.loadResFormat((String)"\u624b\u673a\u53f7/\u90ae\u7bb1(%1) \u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\uff0c\u53ef\u4ee5\u901a\u8fc7\u201c\u6ce8\u518c\u8fdb\u5ea6\u67e5\u8be2\u201d\u67e5\u770b\u6ce8\u518c\u8fdb\u5ea6\u3002", (String)"AdmRegisterPlugin_10", (String)"scm-adm-formplugin", (Object[])new Object[]{phone == null ? "" : phone});
    }

    private void getRegisterNumberRepeatData(List<String> phoneRepeatList, QFilter qf, String eneityName, String selects, String entityPhone) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdmRegisterPlugin", (String)eneityName, (String)selects, (QFilter[])new QFilter[]{qf}, (String)"id");){
            dataSet.forEach(row -> phoneRepeatList.add(row.getString(entityPhone)));
        }
    }

    private String getSupplierRegAuditstatus(String phone) {
        DynamicObject supplierreg = QueryServiceHelper.queryOne((String)"srm_supplierreg", (String)"id,auditstatus", (QFilter[])new QFilter[]{new QFilter("phone", "=", (Object)phone)});
        return supplierreg.getString("auditstatus");
    }

    public Boolean validCreditno(String creditno, StringBuilder result, Boolean isSucced) {
        if (creditno == null || creditno.trim().equals("")) {
            result.append(ResManager.loadKDString((String)"\u4fe1\u7528\u4ee3\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AdmRegisterPlugin_5", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            isSucced = false;
        } else {
            boolean isexist = false;
            if (QueryRecordUtil.queryRecordSet((String)"srm_user", (String)"id", (String)"creditno", (Object)creditno, null, null, null, null, null, null, null, (String)"queryOne", null) != null) {
                result.append(ResManager.loadResFormat((String)"\u4fe1\u7528\u4ee3\u7801(%1) \u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmRegisterPlugin_7", (String)"scm-adm-formplugin", (Object[])new Object[]{creditno == null ? "" : creditno}));
                isSucced = false;
                isexist = true;
            }
            if (!isexist && QueryRecordUtil.queryRecordSet((String)"srm_supplierreg", (String)"id", (String)"societycreditcode", (Object)creditno, null, null, null, null, null, null, null, (String)"queryOne", null) != null) {
                result.append(ResManager.loadResFormat((String)"\u4fe1\u7528\u4ee3\u7801(%1) \u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmRegisterPlugin_7", (String)"scm-adm-formplugin", (Object[])new Object[]{creditno == null ? "" : creditno}));
                isSucced = false;
                isexist = true;
            }
            QFilter socialCodeFilter = new QFilter("societycreditcode", "=", (Object)creditno);
            if (!isexist && QueryServiceHelper.exists((String)"bd_bizpartner", (QFilter[])new QFilter[]{socialCodeFilter})) {
                if (!SrmCommonUtil.isSupplier((String)"societycreditcode", (String)creditno, (String)"bd_supplier")) {
                    isSucced = true;
                } else {
                    result.append(ResManager.loadResFormat((String)"\u4fe1\u7528\u4ee3\u7801(%1) \u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmRegisterPlugin_7", (String)"scm-adm-formplugin", (Object[])new Object[]{creditno == null ? "" : creditno}));
                    isSucced = false;
                }
            }
        }
        return isSucced;
    }

    public Boolean validCreditno(String enterprise, String creditno, StringBuilder result, Boolean isSucced) {
        if (creditno == null || creditno.trim().equals("")) {
            result.append(ResManager.loadKDString((String)"\u4fe1\u7528\u4ee3\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AdmRegisterPlugin_5", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            isSucced = false;
        } else {
            Set quitOrgSet = SupplierLifeCycleManagerUtil.getQuitOrInvalidOrgVaildRegistrationSet((String)enterprise, (String)creditno);
            boolean isexist = false;
            if (quitOrgSet == null || quitOrgSet.isEmpty()) {
                if (QueryRecordUtil.queryRecordSet((String)"srm_user", (String)"id", (String)"creditno", (Object)creditno, null, null, null, null, null, null, null, (String)"queryOne", null) != null) {
                    result.append(ResManager.loadResFormat((String)"\u4fe1\u7528\u4ee3\u7801(%1) \u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmRegisterPlugin_7", (String)"scm-adm-formplugin", (Object[])new Object[]{creditno == null ? "" : creditno}));
                    isSucced = false;
                    isexist = true;
                }
                if (!isexist && QueryRecordUtil.queryRecordSet((String)"srm_supplierreg", (String)"id", (String)"societycreditcode", (Object)creditno, null, null, null, null, null, null, null, (String)"queryOne", null) != null) {
                    result.append(ResManager.loadResFormat((String)"\u4fe1\u7528\u4ee3\u7801(%1) \u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmRegisterPlugin_7", (String)"scm-adm-formplugin", (Object[])new Object[]{creditno == null ? "" : creditno}));
                    isSucced = false;
                    isexist = true;
                }
            }
        }
        return isSucced;
    }

    public Boolean validEnterprise(String enterprise, StringBuilder result, String number, Boolean isSucced) {
        boolean isexist = false;
        if (enterprise == null || enterprise.trim().equals("")) {
            result.append(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AdmRegisterPlugin_2", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            isSucced = false;
        } else {
            isexist = false;
            if (QueryRecordUtil.queryRecordSet((String)"srm_user", (String)"id", (String)"enterprise", (Object)enterprise, null, null, null, null, null, null, null, (String)"queryOne", null) != null || QueryServiceHelper.exists((String)"srm_supplierreg", (QFilter[])new QFilter[]{new QFilter("phone", "=", (Object)number).and(new QFilter("name", "=", (Object)enterprise))})) {
                result.append(ResManager.loadResFormat((String)"\u4f01\u4e1a\u540d\u79f0(%1)\u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmRegisterPlugin_6", (String)"scm-adm-formplugin", (Object[])new Object[]{enterprise == null ? "" : enterprise}));
                isexist = true;
                isSucced = false;
            }
            if (!isexist && QueryRecordUtil.queryRecordSet((String)"srm_supplierreg", (String)"id", (String)"name", (Object)enterprise, null, null, null, null, null, null, null, (String)"queryOne", null) != null) {
                result.append(ResManager.loadResFormat((String)"\u4f01\u4e1a\u540d\u79f0(%1)\u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmRegisterPlugin_6", (String)"scm-adm-formplugin", (Object[])new Object[]{enterprise == null ? "" : enterprise}));
                isexist = true;
                isSucced = false;
            }
            if (!isexist && QueryRecordUtil.queryRecordSet((String)"bd_supplier", (String)"id", (String)"name", (Object)enterprise, null, null, null, null, null, null, null, (String)"queryOne", null) != null) {
                if (!SrmCommonUtil.isSupplier((String)"name", (String)enterprise, (String)"bd_supplier")) {
                    isSucced = true;
                } else {
                    result.append(ResManager.loadResFormat((String)"\u4f01\u4e1a\u540d\u79f0(%1)\u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmRegisterPlugin_6", (String)"scm-adm-formplugin", (Object[])new Object[]{enterprise == null ? "" : enterprise}));
                    isSucced = false;
                }
            }
        }
        return isSucced;
    }

    public Boolean validEnterprise(String enterprise, String creditno, StringBuilder result, String number, Boolean isSucced) {
        boolean isexist = false;
        if (enterprise == null || enterprise.trim().equals("")) {
            result.append(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AdmRegisterPlugin_2", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            isSucced = false;
        } else {
            Set quitOrgSet = SupplierLifeCycleManagerUtil.getQuitOrInvalidOrgVaildRegistrationSet((String)enterprise, (String)creditno);
            this.log.info("\u5f53\u524d\u4f01\u4e1a@" + enterprise + creditno + "\u5b58\u5728\u9000\u51fa\u7ec4\u7ec7@quitOrgSet" + quitOrgSet);
            isexist = false;
            if (quitOrgSet == null || quitOrgSet.isEmpty()) {
                if (QueryRecordUtil.queryRecordSet((String)"srm_user", (String)"id", (String)"enterprise", (Object)enterprise, null, null, null, null, null, null, null, (String)"queryOne", null) != null || QueryServiceHelper.exists((String)"srm_supplierreg", (QFilter[])new QFilter[]{new QFilter("phone", "=", (Object)number).and(new QFilter("name", "=", (Object)enterprise))})) {
                    result.append(ResManager.loadResFormat((String)"\u4f01\u4e1a\u540d\u79f0(%1)\u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmRegisterPlugin_6", (String)"scm-adm-formplugin", (Object[])new Object[]{enterprise == null ? "" : enterprise}));
                    isexist = true;
                    isSucced = false;
                }
                if (!isexist && QueryRecordUtil.queryRecordSet((String)"srm_supplierreg", (String)"id", (String)"name", (Object)enterprise, null, null, null, null, null, null, null, (String)"queryOne", null) != null) {
                    result.append(ResManager.loadResFormat((String)"\u4f01\u4e1a\u540d\u79f0(%1)\u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmRegisterPlugin_6", (String)"scm-adm-formplugin", (Object[])new Object[]{enterprise == null ? "" : enterprise}));
                    isexist = true;
                    isSucced = false;
                }
            }
        }
        return isSucced;
    }

    public static String createRandNum() {
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= 5; ++i) {
            String s = random.nextInt(10) + "";
            sb.append(s);
        }
        return sb.toString();
    }

    public String getCreditno(String companyName) {
        String creditno = null;
        CompanyInfo companyInfo = CloudDataUtils.getCompanyInfo((String)companyName);
        if (companyInfo != null) {
            creditno = companyInfo.getSocialCreditCode();
        }
        return creditno;
    }

    private Map<String, Object> isPhone(String number) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        try {
            PhoneValidator phoneValidator = new PhoneValidator(number, true);
            phoneValidator.check();
        }
        catch (KDBizException e) {
            this.log.error("\u201c\u8d26\u53f7\u201d\u683c\u5f0f\u4e0d\u6b63\u786e" + e.getMessage());
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u201c\u8d26\u53f7\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AdmRegisterPlugin_27", (String)"scm-adm-formplugin", (Object[])new Object[0]));
        }
        return resultMap;
    }
}

