/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.basedata;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.scm.bid.common.enums.EvaluationBasePriceEnum;

public class QuotationScoreSchSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("evaluationbaseprice");
        e.getFieldKeys().add("range");
        e.getFieldKeys().add("scoringruleentry");
        e.getFieldKeys().add("pricediffratiostart");
        e.getFieldKeys().add("pricediffratioend");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SaveValidator());
    }

    protected boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isPositiveInteger(String str) {
        try {
            int i = Integer.parseInt(str);
            return i > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected class SaveValidator
    extends AbstractValidator {
        protected SaveValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities;
            for (ExtendedDataEntity billData : dataEntities = this.getDataEntities()) {
                this.checkRange(this, billData);
                this.checkPriceDiff(this, billData);
            }
        }

        protected void checkPriceDiff(SaveValidator saveValidator, ExtendedDataEntity data) {
            HashMap<Integer, String> rangeMap = new HashMap<Integer, String>(16);
            DynamicObject info = data.getDataEntity();
            DynamicObjectCollection scoringRule_DOC = info.getDynamicObjectCollection("scoringruleentry");
            for (int i = 0; i < scoringRule_DOC.size(); ++i) {
                String msg;
                DynamicObject scoringRule_DO = (DynamicObject)scoringRule_DOC.get(i);
                BigDecimal priceDifStart = scoringRule_DO.getBigDecimal("pricediffratiostart");
                BigDecimal priceDifEnd = scoringRule_DO.getBigDecimal("pricediffratioend");
                BigDecimal range = priceDifEnd.subtract(priceDifStart);
                if (priceDifStart.compareTo(priceDifEnd) > 0) {
                    msg = String.format(ResManager.loadKDString((String)"\u8bc4\u5206\u89c4\u5219\u5206\u5f55\u7b2c%s\u884c\u4ef7\u5dee\u6bd4\u4ece\uff08=>\uff09 \u6bd4\u4ef7\u5dee\u6bd4\u81f3\uff08<\uff09  \u5927\uff01", (String)"QuotationScoreSchSaveOpPlugin_0", (String)"scm-bid-opplugin", (Object[])new Object[0]), i + 1);
                    saveValidator.addErrorMessage(data, msg);
                    return;
                }
                if (priceDifStart.compareTo(priceDifEnd) == 0) {
                    msg = String.format(ResManager.loadKDString((String)"\u8bc4\u5206\u89c4\u5219\u5206\u5f55\u7b2c%s\u884c\u4ef7\u5dee\u6bd4\u4ece\uff08=>\uff09 \u548c\u4ef7\u5dee\u6bd4\u81f3\uff08<\uff09 \u76f8\u7b49\uff01", (String)"QuotationScoreSchSaveOpPlugin_1", (String)"scm-bid-opplugin", (Object[])new Object[0]), i + 1);
                    saveValidator.addErrorMessage(data, msg);
                    return;
                }
                String value = priceDifStart + "+" + priceDifEnd;
                rangeMap.put(i + 1, value);
            }
            for (Map.Entry i1 : rangeMap.entrySet()) {
                String value1 = (String)i1.getValue();
                BigDecimal priceDifStart1 = new BigDecimal(StringUtils.substringBefore((String)value1, (String)"+"));
                BigDecimal priceDifEnd1 = new BigDecimal(StringUtils.substringAfter((String)value1, (String)"+"));
                for (Map.Entry i2 : rangeMap.entrySet()) {
                    String value2 = (String)i2.getValue();
                    BigDecimal priceDifStart2 = new BigDecimal(StringUtils.substringBefore((String)value2, (String)"+"));
                    BigDecimal priceDifEnd2 = new BigDecimal(StringUtils.substringAfter((String)value2, (String)"+"));
                    if (((Integer)i1.getKey()).equals(i2.getKey())) continue;
                    if (priceDifStart2.compareTo(priceDifStart1) >= 0 && priceDifStart2.compareTo(priceDifEnd1) < 0) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bc4\u5206\u89c4\u5219\u5206\u5f55\u7b2c%1$s\u884c\u548c\u7b2c%2$s\u884c\u4ef7\u5dee\u6bd4\u533a\u95f4\u5b58\u5728\u91cd\u53e0", (String)"QuotationScoreSchSaveOpPlugin_2", (String)"scm-bid-opplugin", (Object[])new Object[0]), i1.getKey(), i2.getKey()));
                    }
                    if (priceDifEnd2.compareTo(priceDifStart1) <= 0 || priceDifEnd2.compareTo(priceDifEnd1) >= 0) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bc4\u5206\u89c4\u5219\u5206\u5f55\u7b2c%1$s\u884c\u548c\u7b2c%2$s\u884c\u4ef7\u5dee\u6bd4\u533a\u95f4\u5b58\u5728\u91cd\u53e0", (String)"QuotationScoreSchSaveOpPlugin_2", (String)"scm-bid-opplugin", (Object[])new Object[0]), i1.getKey(), i2.getKey()));
                }
            }
        }

        protected void checkRange(SaveValidator saveValidator, ExtendedDataEntity data) {
            DynamicObject info = data.getDataEntity();
            String evaluationbaseprice = info.getString("evaluationbaseprice");
            if (EvaluationBasePriceEnum.RANGEAVG.getValue().equals(evaluationbaseprice)) {
                String str;
                String range = info.getString("range");
                if ((range = range.replaceAll(" ", "")).indexOf(44) <= 0 || range.indexOf(44) != range.lastIndexOf(44)) {
                    saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", (String)"QuotationScoreSchSaveOpPlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (!range.startsWith("[") || !range.endsWith("]")) {
                    saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", (String)"QuotationScoreSchSaveOpPlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                range = range.replaceFirst("\\[", "");
                String[] strs = (range = range.substring(0, range.length() - 1)).split(",");
                if (strs.length != 2) {
                    saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", (String)"QuotationScoreSchSaveOpPlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                String start = strs[0];
                String end = strs[1];
                if (kd.bos.util.StringUtils.isEmpty((String)start) || kd.bos.util.StringUtils.isEmpty((String)end)) {
                    saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", (String)"QuotationScoreSchSaveOpPlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                boolean isCheckPassed = true;
                if (start.contains("n")) {
                    if (start.indexOf(110) != start.lastIndexOf(110)) {
                        isCheckPassed = false;
                        saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5f00\u59cb\u533a\u95f4\u4e0d\u5141\u8bb8\u5f55\u5165\u591a\u4e2a'n'\uff01", (String)"QuotationScoreSchSaveOpPlugin_4", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    } else if (!"n".equals(start)) {
                        if (!start.startsWith("n-")) {
                            isCheckPassed = false;
                            saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,\u5f00\u59cb\u533a\u95f4\u4e0d\u662f'n-\u6574\u6570'\uff01", (String)"QuotationScoreSchSaveOpPlugin_5", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        } else {
                            str = start.replaceFirst("n", "");
                            if (!QuotationScoreSchSaveOpPlugin.this.isInteger(str)) {
                                isCheckPassed = false;
                                saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,\u5f00\u59cb\u533a\u95f4\u4e0d\u662f'n-\u6574\u6570'\uff01", (String)"QuotationScoreSchSaveOpPlugin_5", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                        }
                    }
                } else if (!QuotationScoreSchSaveOpPlugin.this.isInteger(start)) {
                    isCheckPassed = false;
                    saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,\u5f00\u59cb\u533a\u95f4\u975e\u6574\u6570\uff01", (String)"QuotationScoreSchSaveOpPlugin_6", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                } else if (!QuotationScoreSchSaveOpPlugin.this.isPositiveInteger(start)) {
                    isCheckPassed = false;
                    saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,\u5f00\u59cb\u533a\u95f4\u975e\u6b63\u6574\u6570\uff01", (String)"QuotationScoreSchSaveOpPlugin_7", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
                if (end.contains("n")) {
                    if (end.indexOf(110) != end.lastIndexOf(110)) {
                        isCheckPassed = false;
                        saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u7ed3\u675f\u533a\u95f4\u4e0d\u5141\u8bb8\u5f55\u5165\u591a\u4e2a'n'\uff01", (String)"QuotationScoreSchSaveOpPlugin_8", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    } else if (!"n".equals(end)) {
                        if (!end.startsWith("n-")) {
                            isCheckPassed = false;
                            saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,\u5f00\u59cb\u533a\u95f4\u4e0d\u662f'n-\u6574\u6570'\uff01", (String)"QuotationScoreSchSaveOpPlugin_5", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        } else {
                            str = end.replaceFirst("n", "");
                            if (!QuotationScoreSchSaveOpPlugin.this.isInteger(str)) {
                                isCheckPassed = false;
                                saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,\u7ed3\u675f\u533a\u95f4\u4e0d\u662f'n-\u6574\u6570'\uff01", (String)"QuotationScoreSchSaveOpPlugin_9", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                        }
                    }
                } else if (!QuotationScoreSchSaveOpPlugin.this.isInteger(end)) {
                    isCheckPassed = false;
                    saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,\u7ed3\u675f\u533a\u95f4\u975e\u6574\u6570\uff01", (String)"QuotationScoreSchSaveOpPlugin_10", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                } else if (!QuotationScoreSchSaveOpPlugin.this.isPositiveInteger(end)) {
                    isCheckPassed = false;
                    saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,\u7ed3\u675f\u533a\u95f4\u975e\u6b63\u6574\u6570\uff01", (String)"QuotationScoreSchSaveOpPlugin_11", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
                if (isCheckPassed) {
                    int start_int;
                    int end_int;
                    if (start.contains("n") && end.contains("n")) {
                        int start_int2 = "n".equals(start) ? 0 : Integer.parseInt(start.replace("n", ""));
                        int n = end_int = "n".equals(end) ? 0 : Integer.parseInt(end.replace("n", ""));
                        if (start_int2 > end_int) {
                            saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,\u5f00\u59cb\u533a\u95f4\u4e0d\u5141\u8bb8\u5927\u4e8e\u7ed3\u675f\u533a\u95f4\uff01", (String)"QuotationScoreSchSaveOpPlugin_12", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                    }
                    if (!start.contains("n") && !end.contains("n") && (start_int = Integer.parseInt(start)) > (end_int = Integer.parseInt(end))) {
                        saveValidator.addErrorMessage(data, ResManager.loadKDString((String)"\u8303\u56f4\u533a\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,\u5f00\u59cb\u533a\u95f4\u4e0d\u5141\u8bb8\u5927\u4e8e\u7ed3\u675f\u533a\u95f4\uff01", (String)"QuotationScoreSchSaveOpPlugin_12", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
    }
}

