/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidAnswerQuestionService;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidAnswerQuestionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;

public class AnswerQuestionOperationServicePlugin
extends AbstractOperationServicePlugIn {
    private static final String OPERATION_COMPLETE = "complete";
    private IBidProjectService projectService = new BidProjectServiceImpl();
    private IBidAnswerQuestionService service = new BidAnswerQuestionServiceImpl();
    private IBidOpenService bidOpenService = new BidOpenServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("realanswertime");
        e.getFieldKeys().add("answerquestiondeadline");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("bidproject.id");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        String key = e.getOperationKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)OPERATION_COMPLETE)) {
            for (DynamicObject data : datas) {
                RequestContext request = RequestContext.get();
                Long projectId = data.getLong("bidproject.id");
                Date date = new Date();
                data.set("realanswertime", (Object)date);
                data.set("billstatus", (Object)BillStatusEnum.COMPLETE.getVal());
                data.set("modifytime", (Object)new Date());
                data.set("modifier", (Object)request.getUserId());
                data.set("auditor", (Object)request.getUserId());
                data.set("auditdate", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
                DynamicObject project = this.projectService.getBidProjectAllById(projectId);
                DynamicObject bidmode = (DynamicObject)project.get("bidmode");
                Boolean isBidOpen = bidmode.getBoolean("bidopen");
                DynamicObject bidOpen = this.bidOpenService.getBidOpenByProjectId(projectId);
                if (isBidOpen.booleanValue() && bidOpen == null) {
                    this.service.createNextStep(project, BidStepEnum.BidAnswerQuestion);
                }
                if (isBidOpen.booleanValue() && bidOpen != null) {
                    project.set("currentstep", (Object)"BidOpen");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
                }
                if (isBidOpen.booleanValue()) continue;
                this.service.createNextStep(project, BidStepEnum.BidAnswerQuestion);
            }
        }
    }
}

