/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.bill.IBidAnswerQuestionService;
import kd.scm.bid.business.bill.serviceImpl.BidAnswerQuestionServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;

public class AnswerQuestionRecoOperationServicePlugin
extends AbstractOperationServicePlugIn {
    protected IBidAnswerQuestionService service = new BidAnswerQuestionServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("bidanswerquestiontheme");
        e.getFieldKeys().add("answerquestiontime");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ValidatorForAnswerQuestion());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("answerquestiontime", (Object)dataEntity.getDate("auditdate"));
            }
        } else if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("answerquestiontime", null);
            }
        }
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)key)) {
            for (DynamicObject dataEntity : dataEntities) {
                this.service.updateAnswerCount(dataEntity.getDynamicObject("bidproject"), "delone", false);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            for (DynamicObject dataEntity : dataEntities) {
                boolean isOld = dataEntity.getDataEntityState().getFromDatabase();
                this.service.updateAnswerCount(dataEntity.getDynamicObject("bidproject"), "addone", isOld);
            }
        }
    }

    private static class ValidatorForAnswerQuestion
    extends AbstractValidator {
        private ValidatorForAnswerQuestion() {
        }

        public void validate() {
            Object billStatus;
            DynamicObject answerQuestion;
            DynamicObject answer;
            MainEntityType type;
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || "submit".equals(key)) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObjectCollection bidAnswerquestionsList;
                    QFilter qFilter = new QFilter("bidanswerquestiontheme", "=", (Object)((ILocaleString)dataEntity.getValue("bidanswerquestiontheme")).toString());
                    type = (MainEntityType)dataEntity.getDataEntity().getDataEntityType();
                    DynamicObject data = dataEntity.getDataEntity();
                    DynamicObject bidProject = data.getDynamicObject("bidproject");
                    qFilter.and(new QFilter("entitytypeid", "=", (Object)type.getName()));
                    qFilter.and(new QFilter("id", "!=", dataEntity.getBillPkId()));
                    qFilter.and(new QFilter("bidproject.id", "=", bidProject.getPkValue()));
                    boolean privatizationReplyFlag = bidProject.getBoolean("privatizationreplyflag");
                    DynamicObjectCollection colls = QueryServiceHelper.query((String)type.getName(), (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (colls.size() > 0) {
                        ILocaleString nameLocal = (ILocaleString)dataEntity.getValue("bidanswerquestiontheme");
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u5408\u5b57\u6bb5\u552f\u4e00\u6027\u6821\u9a8c\uff1a\u201c\u62db\u6807\u7b54\u7591\u4e3b\u9898\u201d\u5b57\u6bb5\u503c\u201c%s\u201d\u91cd\u590d\u3002", (String)"AnswerQuestionRecoOperationServicePlugin_7", (String)"scm-bid-opplugin", (Object[])new Object[0]), nameLocal.toString()));
                    }
                    if (!"submit".equals(key) || privatizationReplyFlag || (bidAnswerquestionsList = (DynamicObjectCollection)dataEntity.getValue("bid_answerquestions_list")) != null && bidAnswerquestionsList.size() != 0) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u63d0\u7591\u5217\u8868\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AnswerQuestionRecoOperationServicePlugin_8", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            }
            if (StringUtils.equals((CharSequence)"delete", (CharSequence)key)) {
                block1: for (ExtendedDataEntity dataEntity : dataEntities) {
                    answer = dataEntity.getDataEntity();
                    type = EntityMetadataCache.getDataEntityType((String)"bid_answerquestion_reco");
                    answerQuestion = BusinessDataServiceHelper.loadSingle((Object)answer.getPkValue(), (DynamicObjectType)type);
                    billStatus = answerQuestion.get("billstatus");
                    if (!billStatus.equals("A")) continue;
                    DynamicObjectCollection answerQuestionsList = answerQuestion.getDynamicObjectCollection("bid_answerquestions_list");
                    for (int j = 0; j < answerQuestionsList.size(); ++j) {
                        Boolean isFormTen = ((DynamicObject)answerQuestionsList.get(j)).getBoolean("isfromten");
                        if (!isFormTen.booleanValue()) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4f9b\u5e94\u5546\u5728\u7ebf\u7b54\u7591\u4fe1\u606f\u3002", (String)"AnswerQuestionRecoOperationServicePlugin_9", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue block1;
                    }
                }
            }
            if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    answer = dataEntity.getDataEntity();
                    type = EntityMetadataCache.getDataEntityType((String)"bid_answerquestion");
                    answerQuestion = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"answerquestion", ((Object)((Object)this)).getClass()), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", (Object)Long.parseLong(answer.getString("bidproject.id")))});
                    billStatus = answerQuestion.get("billstatus");
                    if (!billStatus.equals(BillStatusEnum.COMPLETE.getVal())) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u7b54\u7591\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"AnswerQuestionRecoOperationServicePlugin_10", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
        }
    }
}

