/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BaseDataOperation
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new Validator4REBMBaseData());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("name");
    }

    private static class Validator4REBMBaseData
    extends AbstractValidator {
        private Validator4REBMBaseData() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            String key = this.getOperateKey();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"save")) {
                for (ExtendedDataEntity data : dataEntities) {
                    Object id = data.getBillPkId();
                    ILocaleString nameLocale = (ILocaleString)data.getValue("name");
                    String name = nameLocale.getLocaleValue();
                    String billName = this.entityKey;
                    LocaleString chName = ((MuliLangTextProp)data.getDataEntity().getDataEntityType().getProperties().get((Object)"name")).getDisplayName();
                    if (!this.queryDataIsUnique(name, id, billName)) {
                        this.addFatalErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7ec4\u5408\u5b57\u6bb5\u552f\u4e00\u6027\u6821\u9a8c\uff1a\u201c%1$s\u201d\u5b57\u6bb5\u503c\u201c%2$s\u201d\u91cd\u590d\u3002", (String)"BaseDataOperation_5", (String)"scm-bid-opplugin", (Object[])new Object[0]), chName.getLocaleValue(), name));
                    }
                    LocaleString numberName = ((IDataEntityProperty)data.getDataEntity().getDataEntityType().getProperties().get((Object)"number")).getDisplayName();
                    String number = data.getBillNo();
                    if (!this.validateNumberUnique(number, billName, id)) continue;
                    this.addFatalErrorMessage(data, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b57\u6bb5\u503c\u201c%2$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BaseDataOperation_4", (String)"scm-bid-opplugin", (Object[])new Object[0]), numberName.getLocaleValue(), number));
                }
            }
        }

        protected boolean validateNumberUnique(String number, String billName, Object id) {
            QFilter qFilter = new QFilter("number", "=", (Object)number);
            qFilter.and(new QFilter("id", "!=", id));
            return QueryServiceHelper.exists((String)billName, (QFilter[])qFilter.toArray());
        }

        public boolean queryDataIsUnique(String name, Object id, String billName) {
            QFilter qFilter = new QFilter("name", "=", (Object)name);
            qFilter.and(new QFilter("id", "!=", id));
            qFilter.and(new QFilter("entitytypeid", "=", (Object)billName));
            DynamicObjectCollection colls = QueryServiceHelper.query((String)billName, (String)"id", (QFilter[])new QFilter[]{qFilter});
            return colls.size() <= 0;
        }
    }
}

