/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidBottomMakeService;
import kd.scm.bid.business.bill.serviceImpl.BidBottomMakeServiceImpl;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidBottomMakeOperationPlugin
extends AbstractOperationServicePlugIn {
    protected IBidBottomMakeService bottomMakeService = new BidBottomMakeServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("billstatus");
        keys.add("comment");
        keys.add("bidbottomamount");
        keys.add("bidproject");
        keys.add("bidsection");
        keys.add("projectentry");
        keys.add("declareamount");
        keys.add("projectentry.finalauditamount");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataList = e.getDataEntities();
        if ("save".equals(key) || "submit".equals(key)) {
            for (DynamicObject data : dataList) {
                this.saveEntity(key, data);
            }
        }
        if ("delete".equals(key)) {
            for (DynamicObject data : dataList) {
                DynamicObject bidProject = data.getDynamicObject("bidproject");
                String appId = this.getAppId(bidProject);
                String entityName = appId + "_bottom_make";
                DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter("id", "=", data.getPkValue())});
                this.bottomMakeService.createBottomMakeByBidProject(Long.valueOf(bidProject.getLong("id")), appId);
            }
        }
        if ("audit".equals(key)) {
            for (DynamicObject data : dataList) {
                data.set("billstatus", (Object)BillStatusEnum.AUDITED.getVal());
                SaveServiceHelper.update((DynamicObject)data);
            }
        }
        if ("unaudit".equals(key)) {
            for (DynamicObject data : dataList) {
                data.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                SaveServiceHelper.update((DynamicObject)data);
            }
        }
        if ("auditing_save".equals(key)) {
            for (DynamicObject data : dataList) {
                this.saveEntity(key, data);
            }
        }
    }

    private void saveEntity(String key, DynamicObject data) {
        Object pkValue = data.getPkValue();
        DynamicObject bidProject = data.getDynamicObject("bidproject");
        String entityName = this.getAppId(bidProject) + "_bottom_make";
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)entityName);
        DynamicObjectCollection bidSectionEntryTmp = data.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection bidSectionEntry = object.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidSectionEntry.size(); ++i) {
            DynamicObjectCollection proEntryTmp = ((DynamicObject)bidSectionEntryTmp.get(i)).getDynamicObjectCollection("projectentry");
            DynamicObjectCollection proEntry = ((DynamicObject)bidSectionEntry.get(i)).getDynamicObjectCollection("projectentry");
            for (int j = 0; j < proEntry.size(); ++j) {
                ((DynamicObject)proEntry.get(j)).set("declareamount", (Object)((DynamicObject)proEntryTmp.get(j)).getBigDecimal("declareamount"));
                ((DynamicObject)proEntry.get(j)).set("finalauditamount", (Object)((DynamicObject)proEntryTmp.get(j)).getBigDecimal("finalauditamount"));
            }
            ((DynamicObject)bidSectionEntry.get(i)).set("projectentry", (Object)proEntry);
        }
        object.set("bidbottomamount", data.get("bidbottomamount"));
        object.set("comment", data.get("comment"));
        String billStatus = "";
        if ("save".equals(key)) {
            billStatus = BillStatusEnum.SAVE.getVal();
        } else if ("submit".equals(key)) {
            billStatus = BillStatusEnum.SUBMIT.getVal();
        } else if ("auditing_save".equals(key)) {
            billStatus = BillStatusEnum.AUDITING.getVal();
        }
        object.set("billstatus", (Object)billStatus);
        object.set("bidsection", (Object)bidSectionEntry);
        SaveServiceHelper.update((DynamicObject)object);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String key = this.getOperateKey();
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    DynamicObject data = dataEntity.getDataEntity();
                    if (!"unaudit".equals(key)) continue;
                    DynamicObject bidProject = data.getDynamicObject("bidproject");
                    String appId = BidBottomMakeOperationPlugin.this.getAppId(bidProject);
                    DynamicObject[] bidOpenList = BusinessDataServiceHelper.load((String)(appId + "_bidopen"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue())});
                    if (bidOpenList != null && bidOpenList.length > 0) {
                        for (DynamicObject bidOpen : bidOpenList) {
                            String billStatus = bidOpen.getString("billstatus");
                            if (BillStatusEnum.DISBEGIN.getVal().equals(billStatus) || BillStatusEnum.SAVE.getVal().equals(billStatus) || BillStatusEnum.INVALID.getVal().equals(billStatus) || BillStatusEnum.INVALIDXX.getVal().equals(billStatus)) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u5df2\u53d1\u751f\u5f00\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838", (String)"BidBottomMakeOperationPlugin_0", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                        continue;
                    }
                    DynamicObject[] bidDecisionList = BusinessDataServiceHelper.load((String)(appId + "_decision"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue())});
                    if (bidDecisionList == null || bidDecisionList.length <= 0) continue;
                    for (DynamicObject bidDecision : bidDecisionList) {
                        String billStatus = bidDecision.getString("billstatus");
                        if (BillStatusEnum.DISBEGIN.getVal().equals(billStatus) || BillStatusEnum.SAVE.getVal().equals(billStatus) || BillStatusEnum.INVALID.getVal().equals(billStatus) || BillStatusEnum.INVALIDXX.getVal().equals(billStatus)) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u5df2\u53d1\u751f\u5b9a\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838", (String)"BidBottomMakeOperationPlugin_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public String getAppId(DynamicObject bidProject) {
        String typeId;
        String appId = "bid";
        if (!bidProject.getDataEntityType().getProperties().containsKey((Object)"entitytypeid")) {
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
        }
        if ((typeId = bidProject.getString("entitytypeid")) != null && typeId.indexOf(95) != -1) {
            appId = typeId.substring(0, typeId.indexOf(95));
        }
        return appId;
    }
}

