/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.helper.BidStepInteractiveHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.SupplierServiceOrgUtil;
import kd.scm.bid.formplugin.bill.util.BidBustalkUtil;

public class BidBustalkOperationServicePlugIn
extends AbstractOperationServicePlugIn {
    private BidBustalkUtil bidBustalkUtil = new BidBustalkUtil();
    private static IBidProjectService projectService = new BidProjectServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("bidsection");
        e.getFieldKeys().add("supplierentry");
        e.getFieldKeys().add("supplierdetail");
        e.getFieldKeys().add("supplierentry.taxrate");
        e.getFieldKeys().add("supplierentry.newrate");
        e.getFieldKeys().add("supplierentry.uprate");
        e.getFieldKeys().add("supplierentry.supplier");
        e.getFieldKeys().add("supplierdetail.staxrate");
        e.getFieldKeys().add("supplierdetail.costrate");
        e.getFieldKeys().add("entitytypeid");
        e.getFieldKeys().add("bidsection.sectionname");
        e.getFieldKeys().add("is_again_bidding");
        e.getFieldKeys().add("openonlinesynergy");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new Validator4BidProject());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key) || StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
            dataEntities = e.getDataEntities();
            if (dataEntities == null) {
                return;
            }
            QFilter judgeNum = new QFilter("judge_num", "=", (Object)"0");
            for (DynamicObject dataEntity : dataEntities) {
                boolean inProcess;
                if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                    DynamicObject answer;
                    dataEntity.set("is_again_bidding", (Object)"0");
                    DynamicObject project = dataEntity.getDynamicObject("bidproject");
                    long projectId = project.getLong("id");
                    QFilter projectfilter = new QFilter("bidproject.id", "=", (Object)projectId);
                    DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{projectfilter.and(judgeNum)});
                    QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                    Date date = new Date();
                    BidStepEnum[] nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)project, (BidStepEnum)BidStepEnum.BidAnswerQuestion);
                    if (null != nextStep && BidStepEnum.BidBustalk == nextStep[0] && null != bustalk && (answer = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"answerquestion", ((Object)((Object)this)).getClass()), (String)"billstatus,realanswertime,modifytime,modifier,auditor,auditdate", (QFilter[])new QFilter[]{qFilter})) != null) {
                        answer.set("realanswertime", (Object)date);
                        answer.set("billstatus", (Object)BillStatusEnum.COMPLETE.getVal());
                        answer.set("modifytime", (Object)new Date());
                        answer.set("modifier", (Object)RequestContext.get().getUserId());
                        answer.set("auditor", (Object)RequestContext.get().getUserId());
                        answer.set("auditdate", (Object)new Date());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{answer});
                        projectService.saveCurrentBidStep((Object)projectId, nextStep);
                    }
                }
                if (!(inProcess = WorkflowServiceHelper.inProcess((String)dataEntity.getPkValue().toString()))) {
                    String isFromList = this.getOption().getVariableValue("form");
                    if (!"List".equals(isFromList)) {
                        this.updateEntityRateData(dataEntity);
                    }
                } else {
                    String isFromEdit;
                    Map variables = this.getOption().getVariables();
                    if (variables.get("form") != null && "edit".equals(isFromEdit = this.getOption().getVariableValue("form"))) {
                        this.updateEntityRateData(dataEntity);
                    }
                }
                if (!StringUtils.equals((CharSequence)"audit", (CharSequence)key)) continue;
                DynamicObjectCollection bidSectionCol = dataEntity.getDynamicObjectCollection("bidsection");
                String appId = this.billEntityType.getAppId();
                if ("bid".equals(appId)) continue;
                for (DynamicObject bidSection : bidSectionCol) {
                    DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier == null) continue;
                        SupplierServiceOrgUtil.updateServiceOrg((Object)dataEntity.getDynamicObject("org").getPkValue(), (Object)supplier.getPkValue(), (String)"resm_official_supplier");
                    }
                }
            }
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"unsubmit")) {
            dataEntities = e.getDataEntities();
            this.changeAnswerQuesData(dataEntities);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
            dataEntities = e.getDataEntities();
            this.changeAnswerQuesData(dataEntities);
        }
    }

    protected void updateEntityRateData(DynamicObject dataEntity) {
        DynamicObjectCollection bidSectionColl = dataEntity.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidSectionColl.size(); ++i) {
            DynamicObjectCollection supplierentry = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
            DynamicObjectCollection supplierDetail = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
            String entitytypeid = dataEntity.getString("entitytypeid");
            if (supplierentry != null && supplierentry.size() > 0) {
                for (int j = 0; j < supplierentry.size(); ++j) {
                    ((DynamicObject)supplierentry.get(j)).set("taxrate", (Object)((DynamicObject)supplierentry.get(j)).getBigDecimal("taxrate").divide(new BigDecimal("100")));
                    ((DynamicObject)supplierentry.get(j)).set("newrate", (Object)((DynamicObject)supplierentry.get(j)).getBigDecimal("newrate").divide(new BigDecimal("100")));
                    ((DynamicObject)supplierentry.get(j)).set("uprate", (Object)((DynamicObject)supplierentry.get(j)).getBigDecimal("uprate").divide(new BigDecimal("100")));
                }
            }
            if (supplierDetail == null || supplierDetail.size() <= 0) continue;
            for (int m = 0; m < supplierDetail.size(); ++m) {
                ((DynamicObject)supplierDetail.get(m)).set("staxrate", (Object)((DynamicObject)supplierDetail.get(m)).getBigDecimal("staxrate").divide(new BigDecimal("100")));
                ((DynamicObject)supplierDetail.get(m)).set("costrate", (Object)((DynamicObject)supplierDetail.get(m)).getBigDecimal("costrate").divide(new BigDecimal("100")));
                ((DynamicObject)supplierDetail.get(m)).set("bd_taxrate", ((DynamicObject)supplierDetail.get(m)).get("bd_taxrate"));
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block4: {
            DynamicObject[] dataEntities;
            String key;
            block3: {
                super.endOperationTransaction(e);
                key = e.getOperationKey();
                dataEntities = e.getDataEntities();
                if (!StringUtils.equals((CharSequence)key, (CharSequence)"audit")) break block3;
                RequestContext context = RequestContext.get();
                String userId = context.getUserId();
                for (int i = 0; i < dataEntities.length; ++i) {
                    DynamicObject dataEntitie = dataEntities[i];
                    Long pk = (Long)dataEntitie.getPkValue();
                    String entitytypeid = dataEntities[i].getString("entitytypeid");
                    String appId = "";
                    appId = "bid_bustalk".equals(entitytypeid) ? "bid" : "rebm";
                    boolean openonlinesynergy = dataEntitie.getBoolean("openonlinesynergy");
                    if (!openonlinesynergy) {
                        this.bidBustalkUtil.auditSupplierToDecision(pk, appId);
                        this.bidBustalkUtil.auditPriceToDecision(pk, appId);
                        this.addToDesicionShow(pk, appId);
                    }
                    this.bidBustalkUtil.setBustalkAuditor(pk.longValue(), userId, new Date());
                }
                break block4;
            }
            if (!StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) break block4;
            for (int i = 0; i < dataEntities.length; ++i) {
                DynamicObject dataEntitie = dataEntities[i];
                Long pk = (Long)dataEntitie.getPkValue();
                String entitytypeid = dataEntities[i].getString("entitytypeid");
                String appId = "";
                appId = "bid_bustalk".equals(entitytypeid) ? "bid" : "rebm";
                boolean openonlinesynergy = dataEntitie.getBoolean("openonlinesynergy");
                if (openonlinesynergy) continue;
                this.delToDesicionShow(pk, appId);
            }
        }
    }

    public void addToDesicionShow(Long id, String appId) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(appId + "_decipurdetailshow"));
        ArrayList<DynamicObject> saveBukShowList = new ArrayList<DynamicObject>();
        DynamicObject bustalkDynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)(appId + "_bustalk"));
        DynamicObject bidproject = bustalkDynamicObject.getDynamicObject("bidproject");
        DynamicObjectCollection bidsectionCol = bustalkDynamicObject.getDynamicObjectCollection("bidsection");
        QFilter projectqfilter = new QFilter("bidproject", "=", bidproject.getPkValue());
        DynamicObject[] lastdetailshows = BusinessDataServiceHelper.load((String)(appId + "_decipurdetailshow"), (String)"inclutaxamount,datetimefield,sectionname,supplier", (QFilter[])new QFilter[]{projectqfilter}, (String)"datetimefield desc");
        for (DynamicObject bidsection : bidsectionCol) {
            String bidsectionName = bidsection.getString("sectionname");
            DynamicObjectCollection supplierentryCol = bidsection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierentry : supplierentryCol) {
                DynamicObject supplier = supplierentry.getDynamicObject("supplier");
                DynamicObject decipurdetailshow = new DynamicObject((DynamicObjectType)mainType);
                decipurdetailshow.set("currency", bustalkDynamicObject.get("currency"));
                decipurdetailshow.set("inclutaxamount", supplierentry.get("new_price"));
                decipurdetailshow.set("taxrate", (Object)supplierentry.getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                decipurdetailshow.set("taxamount", supplierentry.get("pricevat"));
                decipurdetailshow.set("excepttaxamount", supplierentry.get("bus_exceptvat"));
                decipurdetailshow.set("quotesource", (Object)"bustalk");
                decipurdetailshow.set("decline_dec", (Object)"0.00%");
                decipurdetailshow.set("datetimefield", (Object)new Date());
                decipurdetailshow.set("supplier", (Object)supplier);
                decipurdetailshow.set("sectionname", (Object)bidsectionName);
                decipurdetailshow.set("bidproject", (Object)bidproject);
                decipurdetailshow.set("sourceid", (Object)id.toString());
                decipurdetailshow.set("entitytype", (Object)appId);
                saveBukShowList.add(decipurdetailshow);
            }
        }
        int amtPrecision = 0;
        DynamicObject currency = bustalkDynamicObject.getDynamicObject("currency");
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        block2: for (DynamicObject saveBukShow : saveBukShowList) {
            String secName = saveBukShow.getString("sectionname");
            Long idSupplier = saveBukShow.getDynamicObject("supplier").getLong("id");
            for (DynamicObject lastdetailshow : lastdetailshows) {
                String showSecName = lastdetailshow.getString("sectionname");
                Long showSupplier = lastdetailshow.getDynamicObject("supplier").getLong("id");
                if (!showSecName.equals(secName) || !showSupplier.equals(idSupplier)) continue;
                BigDecimal inclutaxamount = lastdetailshow.getBigDecimal("inclutaxamount");
                if (inclutaxamount.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal decline = saveBukShow.getBigDecimal("inclutaxamount").subtract(inclutaxamount).divide(inclutaxamount, amtPrecision, 4);
                    DecimalFormat df = new DecimalFormat("0.00");
                    String declineStr = df.format(decline.multiply(new BigDecimal("100")));
                    declineStr = declineStr.replaceAll("-", "");
                    if (decline.compareTo(BigDecimal.ZERO) > 0) {
                        saveBukShow.set("decline_dec", (Object)(declineStr + "% \u2191"));
                        continue block2;
                    }
                    if (decline.compareTo(BigDecimal.ZERO) < 0) {
                        saveBukShow.set("decline_dec", (Object)(declineStr + "% \u2193"));
                        continue block2;
                    }
                    saveBukShow.set("decline_dec", (Object)"0.00%");
                    continue block2;
                }
                saveBukShow.set("decline_dec", (Object)"0.00%");
                continue block2;
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveBukShowList.toArray(new DynamicObject[0]));
    }

    public void delToDesicionShow(Long id, String appId) {
        DeleteServiceHelper.delete((String)(appId + "_decipurdetailshow"), (QFilter[])new QFilter[]{new QFilter("sourceid", "=", (Object)id.toString())});
    }

    private void changeAnswerQuesData(DynamicObject[] dataEntities) {
        for (DynamicObject data : dataEntities) {
            DynamicObject project = data.getDynamicObject("bidproject");
            Long projectId = project.getLong("id");
            QFilter projectfilter = new QFilter("bidproject.id", "=", (Object)projectId);
            QFilter judgeNum = new QFilter("judge_num", "=", (Object)"0");
            DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{projectfilter.and(judgeNum)});
            DynamicObject tempProject = projectService.getBidProjectById(projectId, "answerquestiontime");
            BidStepEnum[] nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)project, (BidStepEnum)BidStepEnum.BidAnswerQuestion);
            if (null == nextStep || BidStepEnum.BidBustalk != nextStep[0] || null == bustalk) continue;
            QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
            Date date = new Date();
            Date answerQuestionTime = tempProject.getDate("answerquestiontime");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            DynamicObject answer = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"answerquestion", ((Object)((Object)this)).getClass()), (String)"billstatus,realanswertime,modifytime,modifier,auditor,auditdate", (QFilter[])new QFilter[]{qFilter});
            if (answer == null) continue;
            if (answerQuestionTime == null || formatter.format(date).compareTo(formatter.format(answerQuestionTime)) < 0) {
                answer.set("billstatus", (Object)BillStatusEnum.QUESTIONING.getVal());
            } else if (answerQuestionTime != null && formatter.format(date).compareTo(formatter.format(answerQuestionTime)) >= 0) {
                answer.set("billstatus", (Object)BillStatusEnum.ENDED.getVal());
            }
            answer.set("realanswertime", null);
            answer.set("modifytime", null);
            answer.set("modifier", null);
            answer.set("auditor", null);
            answer.set("auditdate", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{answer});
            projectService.saveCurrentBidStep((Object)projectId, new BidStepEnum[]{BidStepEnum.BidAnswerQuestion});
        }
    }

    public String getAppId() {
        return "bid";
    }

    private static class Validator4BidProject
    extends AbstractValidator {
        private Validator4BidProject() {
        }

        public void validate() {
            Long projectId;
            DynamicObject project;
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"submit")) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject bidPublish;
                    DynamicObject data = dataEntity.getDataEntity();
                    project = data.getDynamicObject("bidproject");
                    projectId = project.getLong("id");
                    DynamicObject tempProject = projectService.getBidProjectAllById(projectId);
                    BidStepEnum[] nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)project, (BidStepEnum)BidStepEnum.BidAnswerQuestion);
                    if (null != nextStep && BidStepEnum.BidBustalk == nextStep[0]) {
                        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                        DynamicObject[] AnswerQuestionReco = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter});
                        boolean flag = true;
                        for (DynamicObject question : AnswerQuestionReco) {
                            if (question.get("billstatus").equals("C")) continue;
                            flag = false;
                            break;
                        }
                        Date date = new Date();
                        Date answerQuestionTime = tempProject.getDate("answerquestiontime");
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        if (answerQuestionTime != null && formatter.format(date).compareTo(formatter.format(answerQuestionTime)) < 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7b54\u7591\u622a\u6b62\u65f6\u95f4\u201d\u5c1a\u672a\u622a\u6b62\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidBustalkOperationServicePlugIn_2", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                        if (!flag) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6279\u7684\u7b54\u7591\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidBustalkOperationServicePlugIn_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                    }
                    if ((bidPublish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("billstatus", "not in", (Object)new String[]{BillStatusEnum.ADJUSTING.getVal(), BillStatusEnum.INVALID.getVal()}), new QFilter("bidproject", "=", project.getPkValue())})) != null) {
                        String billStatus = bidPublish.getString("billstatus");
                        if (BillStatusEnum.PUBLISHED.getVal().equals(billStatus)) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u5904\u7406\u53d1\u6807\u4e1a\u52a1\u518d\u63d0\u4ea4\u3002", (String)"BidBustalkOperationServicePlugIn_4", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    boolean openOnlineSynErgy = data.getBoolean("openonlinesynergy");
                    if (!openOnlineSynErgy) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53d1\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u7ebf\u4e0a\u534f\u540c\u3002", (String)"BidBustalkOperationServicePlugIn_9", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)key, (CharSequence)"audit")) {
                DynamicObject project2 = null;
                HashMap dmaps = null;
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject data = dataEntity.getDataEntity();
                    project2 = data.getDynamicObject("bidproject");
                    Long projectId2 = project2.getLong("id");
                    dmaps = new HashMap();
                    QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId2);
                    qFilter.and(new QFilter("billstatus", "=", (Object)"O"));
                    DynamicObjectCollection bidopencoll = QueryServiceHelper.query((String)"bid_bidopen", (String)"id,entitytypeid", (QFilter[])qFilter.toArray());
                    for (DynamicObject bidopen : bidopencoll) {
                        String EntityTypeId = bidopen.getString("entitytypeid");
                        DynamicObject load = BusinessDataServiceHelper.loadSingle((Object)bidopen.getLong("id"), (String)EntityTypeId);
                        DynamicObjectCollection bidsectioncoll = load.getDynamicObjectCollection("bidsection");
                        int section = 0;
                        for (DynamicObject bidsection : bidsectioncoll) {
                            DynamicObjectCollection supplierentrycoll = bidsection.getDynamicObjectCollection("supplierentry");
                            HashMap<Long, DynamicObject> dmap = new HashMap<Long, DynamicObject>();
                            for (DynamicObject supplierentry : supplierentrycoll) {
                                boolean isinvalid = supplierentry.getBoolean("supplier_isinvalid");
                                if (!isinvalid) continue;
                                DynamicObject supplier = supplierentry.getDynamicObject("supplier");
                                dmap.put(supplier.getLong("id"), supplier);
                            }
                            if (dmap.size() > 0) {
                                dmaps.put(section, dmap);
                            }
                            ++section;
                        }
                    }
                    if (dmaps.size() == 0) continue;
                    DynamicObjectCollection bidsectioncoll = data.getDynamicObjectCollection("bidsection");
                    String entitytypeid = data.getString("entitytypeid");
                    int section = -1;
                    for (DynamicObject bidsection : bidsectioncoll) {
                        Map map;
                        String bidsectionname = bidsection.getString("sectionname");
                        if ((map = (Map)dmaps.get(++section)) == null || map.size() <= 0) continue;
                        DynamicObjectCollection supplierentrycoll = bidsection.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierentry : supplierentrycoll) {
                            DynamicObject suppliers = supplierentry.getDynamicObject("supplier");
                            if (null == map.get(suppliers.getLong("id"))) continue;
                            String name = null;
                            if ("bid_bustalk".equals(entitytypeid)) {
                                DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)suppliers.getPkValue(), (String)"bd_supplier");
                                name = supplier.getString("name");
                            } else {
                                DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)suppliers.getPkValue(), (String)"resm_official_supplier");
                                name = supplier.getString("name");
                            }
                            if (bidsectioncoll.size() == 1) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5df2\u5728\u5f00\u6807\u51c6\u5907\u65f6\u88ab\u6dd8\u6c70\uff0c\u8bf7\u64a4\u9500\u6d41\u7a0b\u3002", (String)"BidBustalkOperationServicePlugIn_5", (String)"scm-bid-opplugin", (Object[])new Object[0]), name));
                                return;
                            }
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u7684\u3010%2$s\u3011\u5df2\u5728\u5f00\u6807\u51c6\u5907\u65f6\u88ab\u6dd8\u6c70\uff0c\u8bf7\u64a4\u9500\u6d41\u7a0b\u3002", (String)"BidBustalkOperationServicePlugIn_6", (String)"scm-bid-opplugin", (Object[])new Object[0]), bidsectionname, name));
                            return;
                        }
                    }
                }
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)key, (CharSequence)"audit")) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject[] loadInvitation;
                    DynamicObject data = dataEntity.getDataEntity();
                    project = data.getDynamicObject("bidproject");
                    projectId = project.getLong("id");
                    String entitytypeid = data.getString("entitytypeid");
                    String appid = "bid";
                    if (!"bid_bustalk".equals(entitytypeid)) {
                        appid = "rebm";
                    }
                    if ((loadInvitation = BusinessDataServiceHelper.load((String)(appid + "_supplierinvitation"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX"})})).length == 2) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u589e\u8865\u5165\u56f4\u5355\uff0c\u4e0d\u5141\u8bb8\u5904\u7406\u5546\u52a1\u8c08\u5224\u4e1a\u52a1\u3002", (String)"BidBustalkOperationServicePlugIn_7", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject[] loadBidpublish = BusinessDataServiceHelper.load((String)(appid + "_bidpublish"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "not in", (Object)new String[]{"X"})});
                    if (loadBidpublish.length != 2) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4fee\u8ba2\u4e2d\u72b6\u6001\u7684\u53d1\u6807\u5355\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u540e\u7eed\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"BidBustalkOperationServicePlugIn_8", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }
}

