/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidClarificaitonService;
import kd.scm.bid.business.bill.serviceImpl.BidClarificaitonServiceImpl;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidClarificaitonOperationPlugin
extends AbstractOperationServicePlugIn {
    private static final String UN_RELEASE = "unrelease";
    private static final String RELEASE = "release";
    private IBidClarificaitonService bidClarificaitonService = new BidClarificaitonServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("entryvideo");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("clarificaitonstatus");
        e.getFieldKeys().add("entryvideo.operatetime");
        e.getFieldKeys().add("releasetime");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void onAddValidators(final AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                DynamicObject[] dataList = e.getDataEntities();
                if (dataList != null && dataList.length > 1) {
                    this.addErrorMessage(this.getDataEntities()[0], ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bf9\u591a\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c", (String)"BidClarificaitonOperationPlugin_0", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
                String key = this.getOperateKey();
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    DynamicObject[] bidOpenList;
                    DynamicObject data = dataEntity.getDataEntity();
                    DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)data.getDynamicObject("bidproject").getPkValue(), (String)"bid_project", (String)"entitytypeid");
                    if (!(!"modify".equals(key) || "B".equals(data.getString(BillStatusEnum.SAVE.getVal())) && "D".equals(data.getString(BillStatusEnum.SAVE.getVal())))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5bf9\u672a\u5f00\u59cb\u6216\u6682\u5b58\u7684\u6570\u636e\u8fdb\u884c\u62db\u6807\u4ea4\u5e95", (String)"BidClarificaitonOperationPlugin_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                    if (!"unaudit".equals(key) && !BidClarificaitonOperationPlugin.UN_RELEASE.equals(key)) continue;
                    String typeId = bidProject.getString("entitytypeid");
                    String appId = "";
                    if (!StringUtils.isEmpty((CharSequence)typeId) && typeId.indexOf(95) != -1) {
                        appId = typeId.substring(0, typeId.indexOf(95));
                    }
                    if ((bidOpenList = BusinessDataServiceHelper.load((String)(appId + "_bidopen"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())}, (String)"createtime desc")) == null || bidOpenList.length <= 0) continue;
                    DynamicObject bidOpen = bidOpenList[0];
                    String billStatus = bidOpen.getString("billstatus");
                    if (BillStatusEnum.DISBEGIN.getVal().equals(billStatus) || BillStatusEnum.SAVE.getVal().equals(billStatus)) continue;
                    if ("unaudit".equals(key)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u5df2\u53d1\u751f\u5f00\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838", (String)"BidClarificaitonOperationPlugin_2", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u5df2\u53d1\u751f\u5f00\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u53d1\u5e03", (String)"BidClarificaitonOperationPlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataList = e.getDataEntities();
        if ("save".equals(key)) {
            for (DynamicObject data : dataList) {
                data.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            }
        }
        if (RELEASE.equals(key)) {
            for (DynamicObject data : dataList) {
                data.set("releasetime", (Object)new Date());
                data.set("billstatus", (Object)BillStatusEnum.COMPLETE.getVal());
                SaveServiceHelper.update((DynamicObject)data);
            }
        }
        if (UN_RELEASE.equals(key)) {
            for (DynamicObject data : dataList) {
                data.set("releasetime", null);
                data.set("billstatus", (Object)BillStatusEnum.AUDITED.getVal());
                SaveServiceHelper.update((DynamicObject)data);
            }
        }
        if ("delete".equals(key)) {
            for (DynamicObject data : dataList) {
                DynamicObject bidProject = data.getDynamicObject("bidproject");
                DeleteServiceHelper.delete((String)(this.billEntityType.getAppId() + "_clarificaiton"), (QFilter[])new QFilter[]{new QFilter("id", "=", data.getPkValue())});
                this.bidClarificaitonService.createByLastStep(bidProject, BidStepEnum.Clarificaiton);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        block5: {
            DynamicObject[] dataList;
            String key;
            block4: {
                super.afterExecuteOperationTransaction(e);
                key = e.getOperationKey();
                dataList = e.getDataEntities();
                if (!RELEASE.equals(key)) break block4;
                for (DynamicObject data : dataList) {
                    DynamicObject bidProject = data.getDynamicObject("bidproject");
                    String currentStep = bidProject.getString("currentstep");
                    if (StringUtils.isNotEmpty((CharSequence)currentStep)) {
                        currentStep = currentStep.replace("Clarificaiton,", "");
                        currentStep = currentStep.replace("Clarificaiton", "");
                    }
                    bidProject.set("currentstep", (Object)currentStep);
                    SaveServiceHelper.update((DynamicObject)bidProject);
                    this.bidClarificaitonService.sendMessage(bidProject, data.getPkValue());
                }
                break block5;
            }
            if (!UN_RELEASE.equals(key)) break block5;
            for (DynamicObject data : dataList) {
                DynamicObject bidProject = data.getDynamicObject("bidproject");
                String currentStep = bidProject.getString("currentstep");
                if (StringUtils.isNotEmpty((CharSequence)currentStep) && !currentStep.contains("Clarificaiton")) {
                    currentStep = currentStep.lastIndexOf(44) > 0 ? currentStep + "Clarificaiton" : currentStep + ",Clarificaiton";
                }
                bidProject.set("currentstep", (Object)currentStep);
                SaveServiceHelper.update((DynamicObject)bidProject);
            }
        }
    }
}

