/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.EvalItemType;
import kd.scm.bid.common.enums.ScoreMode;
import kd.scm.bid.common.enums.ScoreType;

public class BidEvalTemplateOperationServicePlugIn
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("item");
        e.getFieldKeys().add("score");
        e.getFieldKeys().add("weight");
        e.getFieldKeys().add("evaltype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new Validator4BidEvalTemplate());
    }

    private boolean queryDataIsUnique(String name, Object id, String billName) {
        QFilter qFilter = new QFilter("name", "=", (Object)name);
        qFilter.and(new QFilter("id", "!=", id));
        qFilter.and(new QFilter("entitytypeid", "=", (Object)billName));
        DynamicObjectCollection colls = QueryServiceHelper.query((String)billName, (String)"id", (QFilter[])new QFilter[]{qFilter});
        return colls.size() <= 0;
    }

    private static class Validator4BidEvalTemplate
    extends AbstractValidator {
        private Validator4BidEvalTemplate() {
        }

        public void validate() {
            String key = this.getOperateKey();
            if (!StringUtils.equals((CharSequence)"save", (CharSequence)key) && StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject data = dataEntity.getDataEntity();
                    String evalType = (String)dataEntity.getValue("evaltype");
                    DynamicObjectCollection entityColls = data.getDynamicObjectCollection("entryentity");
                    String scoremode = data.get("scoremode").toString();
                    BigDecimal technicalSum = new BigDecimal(0);
                    BigDecimal commercialSum = new BigDecimal(0);
                    boolean iscorrect = true;
                    String scoretype = (String)dataEntity.getValue("scoretype");
                    for (int j = 0; j < entityColls.size(); ++j) {
                        DynamicObjectCollection colls;
                        DynamicObject entityData = (DynamicObject)entityColls.get(j);
                        String entryType = EvalItemType.DEFAULT.getVal();
                        if (ScoreType.PART.getVal().equals(scoretype)) {
                            entryType = j == 0 ? EvalItemType.TECHNICAL.getVal() : EvalItemType.COMMERCIAL.getVal();
                        }
                        if ((colls = entityData.getDynamicObjectCollection("subentryentity")).size() == 0) {
                            String msg = "";
                            if (entryType != null && ScoreType.PART.getVal().equals(scoretype)) {
                                msg = EvalItemType.TECHNICAL.getVal().equals(entryType) ? EvalItemType.TECHNICAL.getAlias() : EvalItemType.COMMERCIAL.getAlias();
                            }
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u8bc4\u6807\u9879\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidEvalTemplateOperationServicePlugIn_19", (String)"scm-bid-opplugin", (Object[])new Object[0]), msg));
                            iscorrect = false;
                            break;
                        }
                        for (int i = 0; i < colls.size(); ++i) {
                            String type;
                            BigDecimal obj;
                            DynamicObject coll = (DynamicObject)colls.get(i);
                            if (StringUtils.isBlank((CharSequence)coll.getString("type"))) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u6807\u9879\u533a\u57df\u7684\u7b2c%s\u884c\u201c\u7c7b\u522b\u201d\u5b57\u6bb5\u3002", (String)"BidEvalTemplateOperationServicePlugIn_20", (String)"scm-bid-opplugin", (Object[])new Object[0]), i + 1));
                                iscorrect = false;
                            }
                            if (StringUtils.isBlank((CharSequence)coll.getString("item"))) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u6807\u9879\u533a\u57df\u7684\u7b2c%s\u884c\u201c\u8bc4\u5206\u9879\u201d\u5b57\u6bb5\u3002", (String)"BidEvalTemplateOperationServicePlugIn_21", (String)"scm-bid-opplugin", (Object[])new Object[0]), i + 1));
                                iscorrect = false;
                            }
                            if (ScoreMode.STANDARD.getVal().equals(scoremode)) {
                                obj = coll.getBigDecimal("score");
                                if (obj.doubleValue() <= 0.0) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u6807\u9879\u533a\u57df\u7684\u7b2c%s\u884c\u201c\u6807\u51c6\u5206\u201d\u5b57\u6bb5\u3002", (String)"BidEvalTemplateOperationServicePlugIn_22", (String)"scm-bid-opplugin", (Object[])new Object[0]), i + 1));
                                    iscorrect = false;
                                }
                                type = coll.getString("type");
                                if (EvalItemType.TECHNICAL.getVal().equals(type)) {
                                    technicalSum = technicalSum.add(obj);
                                    continue;
                                }
                                if (!EvalItemType.COMMERCIAL.getVal().equals(type)) continue;
                                commercialSum = commercialSum.add(obj);
                                continue;
                            }
                            if (!ScoreMode.WEIGHT.getVal().equals(scoremode)) continue;
                            obj = coll.getBigDecimal("weight");
                            if (obj.doubleValue() <= 0.0) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u6807\u9879\u533a\u57df\u7684\u7b2c%s\u884c\u201c\u6240\u5360\u6743\u91cd\u201d\u5b57\u6bb5\u3002", (String)"BidEvalTemplateOperationServicePlugIn_23", (String)"scm-bid-opplugin", (Object[])new Object[0]), i + 1));
                                iscorrect = false;
                            }
                            type = coll.getString("type");
                            if (EvalItemType.TECHNICAL.getVal().equals(type)) {
                                technicalSum = technicalSum.add(obj);
                                continue;
                            }
                            if (!EvalItemType.COMMERCIAL.getVal().equals(type)) continue;
                            commercialSum = commercialSum.add(obj);
                        }
                    }
                    if (!iscorrect) continue;
                    if (ScoreType.SUM.getVal().equals(scoretype)) {
                        if (ScoreMode.STANDARD.getVal().equals(scoremode)) {
                            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u8bc4\u6807\u6a21\u7248\u63d0\u4ea4\u5206\u6570\u6821\u9a8c:%s", (String)"BidEvalTemplateOperationServicePlugIn_24", (String)"scm-bid-opplugin", (Object[])new Object[0]), technicalSum.add(commercialSum).doubleValue()));
                            if (technicalSum.add(commercialSum).compareTo(new BigDecimal(100)) != 0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6807\u51c6\u5206\u201d\u5408\u8ba1\u884c\u503c\u5fc5\u987b\u7b49\u4e8e100\u3002", (String)"BidEvalTemplateOperationServicePlugIn_25", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            if (BidOpenTypeEnum.MULTI.getValue().equals(evalType) && technicalSum.compareTo(BigDecimal.ZERO) == 0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5fc5\u987b\u5b58\u5728\u6280\u672f\u6807\u90e8\u5206\u3002", (String)"BidEvalTemplateOperationServicePlugIn_26", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                            if (commercialSum.compareTo(BigDecimal.ZERO) != 0) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5fc5\u987b\u5b58\u5728\u5546\u52a1\u6807\u90e8\u5206\u3002", (String)"BidEvalTemplateOperationServicePlugIn_27", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (technicalSum.add(commercialSum).compareTo(BigDecimal.ONE) != 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6240\u5360\u6743\u91cd\u201d\u5408\u8ba1\u884c\u503c\u5fc5\u987b\u7b49\u4e8e100%\u3002", (String)"BidEvalTemplateOperationServicePlugIn_28", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (BidOpenTypeEnum.MULTI.getValue().equals(evalType) && technicalSum.compareTo(BigDecimal.ZERO) == 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5fc5\u987b\u5b58\u5728\u6280\u672f\u6807\u90e8\u5206\u3002", (String)"BidEvalTemplateOperationServicePlugIn_26", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                        if (commercialSum.compareTo(BigDecimal.ZERO) != 0) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5fc5\u987b\u5b58\u5728\u5546\u52a1\u6807\u90e8\u5206\u3002", (String)"BidEvalTemplateOperationServicePlugIn_27", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!ScoreType.PART.getVal().equals(scoretype)) continue;
                    if (ScoreMode.STANDARD.getVal().equals(scoremode)) {
                        if (BidOpenTypeEnum.MULTI.getValue().equals(evalType) && technicalSum.compareTo(new BigDecimal(100)) != 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6280\u672f\u6807\u90e8\u5206\u201c\u6807\u51c6\u5206\u201d\u5408\u8ba1\u884c\u503c\u5fc5\u987b\u7b49\u4e8e100\u3002", (String)"BidEvalTemplateOperationServicePlugIn_29", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                        if (commercialSum.compareTo(new BigDecimal(100)) == 0) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5546\u52a1\u6807\u90e8\u5206\u201c\u6807\u51c6\u5206\u201d\u5408\u8ba1\u884c\u503c\u5fc5\u987b\u7b49\u4e8e100\u3002", (String)"BidEvalTemplateOperationServicePlugIn_30", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (BidOpenTypeEnum.MULTI.getValue().equals(evalType) && technicalSum.compareTo(BigDecimal.ONE) != 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6280\u672f\u6807\u90e8\u5206\u201c\u6240\u5360\u6743\u91cd\u201d\u5408\u8ba1\u884c\u503c\u5fc5\u987b\u7b49\u4e8e100%\u3002", (String)"BidEvalTemplateOperationServicePlugIn_31", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                    if (commercialSum.compareTo(BigDecimal.ONE) == 0) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5546\u52a1\u6807\u90e8\u5206\u201c\u6240\u5360\u6743\u91cd\u201d\u5408\u8ba1\u884c\u503c\u5fc5\u987b\u7b49\u4e8e100%\u3002", (String)"BidEvalTemplateOperationServicePlugIn_32", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

