/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidEvaluationService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidEvalMethodEnum;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.formplugin.bill.util.SupplierInvitationUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;
import kd.scm.bid.opplugin.bill.util.NextStepSendMessage;
import kd.sdk.annotation.SdkDeprecated;

public class BidEvaluationOperationServicePlugIn
extends AbstractOperationServicePlugIn {
    private static IBidEvaluationService bidEvaluationService = new BidEvaluationServiceImpl();
    private static IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();
    private static IBidProjectService bidProjectService = new BidProjectServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("techweight");
        e.getFieldKeys().add("commweight");
        e.getFieldKeys().add("bidproject.bidopentype");
        e.getFieldKeys().add("bidproject.entitytypeid");
        e.getFieldKeys().add("evaltype");
        e.getFieldKeys().add("supplierinvitationid");
        e.getFieldKeys().add("evaluatedmethod");
        e.getFieldKeys().add("bidopenid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new Validator4BidEvaluation());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block3: {
            String key;
            block2: {
                super.beginOperationTransaction(e);
                key = e.getOperationKey();
                if (!"save".equals(key)) break block2;
                DynamicObject[] dataEntities = e.getDataEntities();
                for (int i = 0; i < dataEntities.length; ++i) {
                    DynamicObject dataEntitie = dataEntities[i];
                    dataEntitie.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                }
                break block3;
            }
            if (!"delete".equals(key)) break block3;
            DynamicObject[] dataEntities = e.getDataEntities();
            for (int i = 0; i < dataEntities.length; ++i) {
                DynamicObject dataEntity = dataEntities[i];
                Long bidevaluationId = dataEntity.getLong("id");
                bidEvaluationService.deleteBidEvaluationEntry(bidevaluationId);
                bidEvaluationService.deleteBidEvalScoreDetail(bidevaluationId);
                DynamicObject bidevaluation = bidEvaluationService.getBidEvaluation(bidevaluationId);
                DynamicObject bidproject = bidevaluation.getDynamicObject("bidproject");
                bidEvaluationService.createByLastStep(bidproject, BidStepEnum.BidEvaluation);
            }
        }
    }

    protected static boolean isInvalid(DynamicObject bidProject, DynamicObject clarifySupplier) {
        Object supplierID = clarifySupplier.get("id");
        DynamicObject[] bidOpenArray = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"id,bidsection,supplierentry,supplierentry.supplier,supplierentry.supplier_isinvalid", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"A", "X"})}, (String)"createtime desc");
        if (bidOpenArray != null && bidOpenArray.length > 0) {
            DynamicObject currentBidOpen = bidOpenArray[0];
            for (DynamicObject bidSection : currentBidOpen.getDynamicObjectCollection("bidsection")) {
                for (DynamicObject supplierEntry : bidSection.getDynamicObjectCollection("supplierentry")) {
                    DynamicObject entrySupplier = supplierEntry.getDynamicObject("supplier");
                    if (entrySupplier == null || !supplierID.equals(entrySupplier.get("id"))) continue;
                    return entrySupplier.getBoolean("supplier_isinvalid");
                }
            }
        }
        return false;
    }

    @SdkDeprecated
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if ("audit".equals(key)) {
            NextStepSendMessage nextStepSendMessage = null;
            for (DynamicObject proObj : datas) {
                DynamicObject bidProject = proObj.getDynamicObject("bidproject");
                bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
                nextStepSendMessage = new NextStepSendMessage();
                nextStepSendMessage.nextStepSendMessage(bidProject, BidStepEnum.BidEvaluation);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block9: {
            DynamicObject[] dataEntities;
            String key;
            block10: {
                String appId;
                block8: {
                    super.endOperationTransaction(e);
                    key = e.getOperationKey();
                    dataEntities = e.getDataEntities();
                    appId = "bid";
                    if (!"audit".equals(key)) break block8;
                    for (DynamicObject dataEntity : dataEntities) {
                        DynamicObject bidOpen;
                        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
                        String typeId = bidProject.getString("entitytypeid");
                        appId = typeId.substring(0, typeId.indexOf(95));
                        this.auditUpdateBidOpenSupplierInvalidStatus(dataEntity, appId);
                        bidEvaluationService.createNextStep(bidProject, BidStepEnum.BidEvaluation);
                        questionClarifyService.clarifyWriteBackBidDesicion(appId, bidProject);
                        String bidOpenSelectType = bidProject.getString("bidopentype");
                        String evalType = dataEntity.getString("evaltype");
                        if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenSelectType)) {
                            if (!StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)evalType) || "O".equals((bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue())})).getString("billstatus"))) continue;
                            this.sendMessage(bidProject, evalType);
                            continue;
                        }
                        if (!StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenSelectType) || !StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)evalType) || "O".equals((bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue())})).getString("billstatus"))) continue;
                        this.sendMessage(bidProject, evalType);
                    }
                    break block9;
                }
                if (!"unaudit".equals(key)) break block10;
                for (DynamicObject dataEntity : dataEntities) {
                    DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
                    bidEvaluationService.deleteNextStepUnStarted(bidProject, BidStepEnum.BidEvaluation);
                    String bidOpenSelectType = bidProject.getString("bidopentype");
                    String evalType = dataEntity.getString("evaltype");
                    if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenSelectType)) {
                        if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)evalType)) {
                            bidProjectService.saveCurrentBidStep(bidProject.getPkValue(), new BidStepEnum[]{BidStepEnum.BidEvaluation});
                        }
                    } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenSelectType) && StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)evalType)) {
                        bidProjectService.saveCurrentBidStep(bidProject.getPkValue(), new BidStepEnum[]{BidStepEnum.BidEvaluation});
                    }
                    String typeId = bidProject.getString("entitytypeid");
                    appId = typeId.substring(0, typeId.indexOf(95));
                    this.unAuditUpdateBidOpenSupplierInvalidStatus(dataEntity, appId);
                }
                break block9;
            }
            if (!"delete".equals(key)) break block9;
            for (DynamicObject dataEntity : dataEntities) {
                bidEvaluationService.updateEvalScoreDataByOnlineBidEvel(dataEntity);
            }
        }
    }

    private void sendMessage(DynamicObject bidproject, String openType) {
        String notifyType;
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidproject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        DynamicObject bidOpen = new DynamicObject();
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        String name = bidProject.getString("name");
        if (openType.equals(BidOpenTypeEnum.TECHNICAL.getValue())) {
            bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()), new QFilter("billstatus", "!=", (Object)"XX")});
            msgParam.put("tplScene", "createbidbuopen");
        }
        if (openType.equals(BidOpenTypeEnum.BUSSINESS.getValue())) {
            bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue())});
            msgParam.put("tplScene", "createbidteopen");
        }
        if (bidOpen == null) {
            return;
        }
        String title = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u6761<%s>\u4e1a\u52a1\u5f85\u529e\u6d88\u606f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidEvaluationOperationServicePlugIn_26", (String)"scm-bid-opplugin", (Object[])new Object[0]), name);
        msgParam.put("msgentity", "bid_bidopen");
        if ("bid".equals(this.billEntityType.getAppId())) {
            msgParam.put("formId", "bid_bidopen");
        } else {
            msgParam.put("formId", "rebm_bidopen");
        }
        msgParam.put("appId", this.billEntityType.getAppId());
        msgParam.put("id", bidOpen.getPkValue());
        msgParam.put("pkId", bidOpen.getPkValue());
        msgParam.put("title", null);
        msgParam.put("operation", "save");
        msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
        DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
        HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        for (DynamicObject member : memberColl) {
            String[] values = member.getString("respbusiness").split(",");
            if (values != null && values.length > 0) {
                for (int m = 0; m < values.length; ++m) {
                    if ("12".equals(values[m]) && openType.equals(BidOpenTypeEnum.TECHNICAL.getValue())) {
                        memberSet.add(member.getDynamicObject("user"));
                    }
                    if (!"11".equals(values[m]) || !openType.equals(BidOpenTypeEnum.BUSSINESS.getValue())) continue;
                    memberSet.add(member.getDynamicObject("user"));
                }
            }
            if (!member.getBoolean("isdirector")) continue;
            memberSet.add(member.getDynamicObject("user"));
        }
        if (!memberSet.isEmpty()) {
            for (DynamicObject set : memberSet) {
                receiveUserIds.add(set.getLong("id"));
            }
        }
        msgParam.put("content", null);
        if (openType.equals(BidOpenTypeEnum.TECHNICAL.getValue())) {
            notifyType = MessageChannelUtil.getNotifyType((String)"createbidbuopen", (String)"bid_bidopen");
            MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyType);
        }
        if (openType.equals(BidOpenTypeEnum.BUSSINESS.getValue())) {
            notifyType = MessageChannelUtil.getNotifyType((String)"createbidteopen", (String)"bid_bidopen");
            MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyType);
        }
    }

    public void auditUpdateBidOpenSupplierInvalidStatus(DynamicObject dataEntity, String appId) {
        String evaluatedMethod = dataEntity.getString("evaluatedmethod");
        String evalType = dataEntity.getString("evaltype");
        if (BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod) || BidEvalMethodEnum.DX.getCode().equals(evaluatedMethod)) {
            DynamicObject[] tenderGradingDetailLoadArray;
            long bidOpenId = dataEntity.getLong("bidopenid");
            HashMap<String, DynamicObject> tenderGradingDetailMap = new HashMap<String, DynamicObject>(50);
            for (DynamicObject tenderGradingDetailLoad : tenderGradingDetailLoadArray = BusinessDataServiceHelper.load((String)"bid_tendergradingdetail", (String)"evaluationid,opensectionid,sectionname,supplierid,techevalresult,busevalresult", (QFilter[])new QFilter[]{new QFilter("evaluationid", "=", dataEntity.getPkValue())})) {
                String key = tenderGradingDetailLoad.getString("sectionname") + "_" + tenderGradingDetailLoad.get("supplierid");
                tenderGradingDetailMap.put(key, tenderGradingDetailLoad);
            }
            DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(appId + "_supplierinvalid"));
            DynamicObject supplierInvalid = new DynamicObject((DynamicObjectType)mainType);
            supplierInvalid.set("billstatus", (Object)"C");
            supplierInvalid.set("bidproject", bidProject.getPkValue());
            supplierInvalid.set("bidopenid", (Object)bidOpenId);
            supplierInvalid.set("evaluationid", dataEntity.getPkValue());
            supplierInvalid.set("creator", (Object)RequestContext.get().getUserId());
            supplierInvalid.set("createtime", (Object)new Date());
            supplierInvalid.set("modifier", (Object)RequestContext.get().getUserId());
            supplierInvalid.set("modifytime", (Object)new Date());
            supplierInvalid.set("auditor", (Object)RequestContext.get().getUserId());
            supplierInvalid.set("auditdate", (Object)new Date());
            DynamicObjectCollection supplierInvalidSectionCol = supplierInvalid.getDynamicObjectCollection("bidsection");
            DynamicObject bidOpen = this.getBidOpen(bidProject, appId);
            DynamicObjectCollection bidSectionCol = bidOpen.getDynamicObjectCollection("bidsection");
            boolean existInvalid = false;
            for (DynamicObject bidSection : bidSectionCol) {
                String sectionName = bidSection.getString("sectionname");
                DynamicObject supplierInvalidSection = supplierInvalidSectionCol.addNew();
                supplierInvalidSection.set("sectionname", (Object)bidSection.getString("sectionname"));
                DynamicObjectCollection supplierInvalidEntryCol = supplierInvalidSection.getDynamicObjectCollection("supplierentry");
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    Boolean techResult;
                    String supplierId = supplierEntry.getDynamicObject("supplier").getString("id");
                    String key = sectionName + "_" + supplierId;
                    DynamicObject tenderGradingDetail = (DynamicObject)tenderGradingDetailMap.get(key);
                    if (tenderGradingDetail == null) continue;
                    boolean existSupplierInvalid = false;
                    if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)evalType)) {
                        techResult = tenderGradingDetail.getBoolean("techevalresult");
                        if (!techResult.booleanValue()) {
                            existSupplierInvalid = true;
                            supplierEntry.set("supplier_isinvalid", (Object)Boolean.TRUE);
                            supplierEntry.set("supplier_invalidreason", (Object)ResManager.loadKDString((String)"\u6280\u672f\u6807\u8bc4\u6807\u4e0d\u5408\u683c", (String)"BidEvaluationOperationServicePlugIn_27", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            supplierEntry.set("evalsupplierinvalid", (Object)Boolean.TRUE);
                        }
                    } else if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)evalType)) {
                        Boolean busEvalResult = tenderGradingDetail.getBoolean("busevalresult");
                        if (!busEvalResult.booleanValue()) {
                            existSupplierInvalid = true;
                            supplierEntry.set("supplier_isinvalid", (Object)Boolean.TRUE);
                            supplierEntry.set("supplier_invalidreason", (Object)ResManager.loadKDString((String)"\u5546\u52a1\u6807\u8bc4\u6807\u4e0d\u5408\u683c", (String)"BidEvaluationOperationServicePlugIn_28", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            supplierEntry.set("evalsupplierinvalid", (Object)Boolean.TRUE);
                        }
                    } else if (StringUtils.equals((CharSequence)BidOpenTypeEnum.MULTI.getValue(), (CharSequence)evalType)) {
                        techResult = tenderGradingDetail.getBoolean("techevalresult");
                        Boolean busEvalResult = tenderGradingDetail.getBoolean("busevalresult");
                        if (!techResult.booleanValue() || !busEvalResult.booleanValue()) {
                            existSupplierInvalid = true;
                            supplierEntry.set("supplier_isinvalid", (Object)Boolean.TRUE);
                            String supplierInvalidreason = techResult != false && busEvalResult == false ? ResManager.loadKDString((String)"\u5546\u52a1\u6807\u8bc4\u6807\u4e0d\u5408\u683c", (String)"BidEvaluationOperationServicePlugIn_28", (String)"scm-bid-opplugin", (Object[])new Object[0]) : (techResult == false && busEvalResult != false ? ResManager.loadKDString((String)"\u6280\u672f\u6807\u8bc4\u6807\u4e0d\u5408\u683c", (String)"BidEvaluationOperationServicePlugIn_27", (String)"scm-bid-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6280\u672f\u6807\u548c\u5546\u52a1\u6807\u8bc4\u6807\u4e0d\u5408\u683c", (String)"BidEvaluationOperationServicePlugIn_29", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            supplierEntry.set("supplier_invalidreason", (Object)supplierInvalidreason);
                            supplierEntry.set("evalsupplierinvalid", (Object)Boolean.TRUE);
                        }
                    }
                    if (!existSupplierInvalid) continue;
                    existInvalid = true;
                    DynamicObject supplierInvalidEntry = supplierInvalidEntryCol.addNew();
                    supplierInvalidEntry.set("supplier", supplierEntry.get("supplier"));
                    supplierInvalidEntry.set("suppliercontact", supplierEntry.get("contactphone"));
                    supplierInvalidEntry.set("supplier_deposittype", supplierEntry.get("supplier_deposittype"));
                    supplierInvalidEntry.set("supplier_deposit", supplierEntry.get("supplier_deposit"));
                    supplierInvalidEntry.set("supplier_istender", supplierEntry.get("supplier_istender"));
                    supplierInvalidEntry.set("supplier_tenderdate", supplierEntry.get("supplier_tenderdate"));
                    supplierInvalidEntry.set("supplier_manager", supplierEntry.get("supplier_manager"));
                    supplierInvalidEntry.set("supplier_workday", supplierEntry.get("supplier_workday"));
                    supplierInvalidEntry.set("supplier_isinvalid", (Object)Boolean.TRUE);
                    supplierInvalidEntry.set("supplier_techfile", (Object)supplierEntry.getInt("supplier_techfile"));
                    supplierInvalidEntry.set("supplier_comfile", (Object)supplierEntry.getInt("supplier_comfile"));
                    supplierInvalidEntry.set("supplier_tenfile", (Object)supplierEntry.getInt("supplier_tenfile"));
                    supplierInvalidEntry.set("supplier_otherfile", (Object)supplierEntry.getInt("supplier_otherfile"));
                    supplierInvalidEntry.set("supplier_tenderprice", (Object)supplierEntry.getBigDecimal("supplier_tenderprice"));
                    supplierInvalidEntry.set("supplier_taxrate", (Object)supplierEntry.getBigDecimal("supplier_taxrate"));
                    supplierInvalidEntry.set("supplier_pricevat", (Object)supplierEntry.getBigDecimal("supplier_pricevat"));
                    supplierInvalidEntry.set("supplier_exceptvat", (Object)supplierEntry.getBigDecimal("supplier_exceptvat"));
                    supplierInvalidEntry.set("supplier_illustration", (Object)supplierEntry.getString("supplier_illustration"));
                    supplierInvalidEntry.set("purdetail", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidEvaluationOperationServicePlugIn_30", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            }
            if (existInvalid) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplierInvalid});
            }
            if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)evalType)) {
                bidOpen.set("techweight", dataEntity.get("techweight"));
                bidOpen.set("comweight", dataEntity.get("commweight"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidOpen});
        }
    }

    public DynamicObject getBidOpen(DynamicObject bidProject, String appId) {
        DynamicObject bidOpen = null;
        QFilter qFilter = new QFilter("bidproject.id", "=", bidProject.getPkValue());
        String bidOpenSelectType = bidProject.getString("bidopentype");
        if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.UNIONOPEN.getValue(), (CharSequence)bidOpenSelectType)) {
            qFilter.and(new QFilter("billstatus", "!=", (Object)"XX"));
        } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenSelectType)) {
            qFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS)).and(new QFilter("billstatus", "!=", (Object)"XX"));
        } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenSelectType)) {
            qFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL)).and(new QFilter("billstatus", "!=", (Object)"XX"));
        }
        bidOpen = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidopen"), (String)"id,billstatus,opentype,bidproject,ismaterialpur,isratebidding,techweight,comweight,bidsection, bidsection.sectionname, bidsection.supplierentry, supplier, name, supplier_isinvalid, evalsupplierinvalid, contactphone, supplier_deposittype, supplier_deposit,supplier_istender, supplier_tenderdate, supplier_manager, supplier_workday, supplier_techfile,supplier_comfile,supplier_tenfile, supplier_otherfile,supplier_tenderprice,supplier_taxrate,supplier_pricevat, supplier_exceptvat,supplier_rate,purdetail,supplier_illustration, supplier_invalidreason,supplier_comment,supplier_isfrombackbid,bidsection.supplierdetail,pursupplier,purentrycontent,purentryproject,materialid,qty,inclutaxprice,inclutaxamount,taxrate,taxamount,excepttaxamount,costrate", (QFilter[])new QFilter[]{qFilter});
        return bidOpen;
    }

    public void unAuditUpdateBidOpenSupplierInvalidStatus(DynamicObject dataEntity, String appId) {
        String evaluatedMethod = dataEntity.getString("evaluatedmethod");
        if (BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod) || BidEvalMethodEnum.DX.getCode().equals(evaluatedMethod)) {
            DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
            ArrayList<String> supplierInvalidKeyList = new ArrayList<String>();
            DynamicObject supplierInvalid = BusinessDataServiceHelper.loadSingle((String)(appId + "_supplierinvalid"), (String)"bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier", (QFilter[])new QFilter[]{new QFilter("evaluationid", "=", dataEntity.getPkValue())});
            if (supplierInvalid != null) {
                DynamicObjectCollection supplierInvalidSectionCol = supplierInvalid.getDynamicObjectCollection("bidsection");
                for (DynamicObject supplierInvalidSection : supplierInvalidSectionCol) {
                    String sectionName = supplierInvalidSection.getString("sectionname");
                    DynamicObjectCollection supplierEntryCol = supplierInvalidSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        String supplierId = supplierEntry.getDynamicObject("supplier").getString("id");
                        supplierInvalidKeyList.add(sectionName + "_" + supplierId);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(supplierInvalidKeyList)) {
                DynamicObject bidOpen = this.getBidOpen(bidProject, appId);
                if (bidOpen != null) {
                    DynamicObjectCollection bidSectionCol = bidOpen.getDynamicObjectCollection("bidsection");
                    for (DynamicObject bidSection : bidSectionCol) {
                        String bidSectionName = bidSection.getString("sectionname");
                        DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierEntry : supplierEntryCol) {
                            String supplierId = supplierEntry.getDynamicObject("supplier").getString("id");
                            String key = bidSectionName + "_" + supplierId;
                            if (!supplierInvalidKeyList.contains(key)) continue;
                            supplierEntry.set("supplier_isinvalid", (Object)Boolean.FALSE);
                            supplierEntry.set("supplier_invalidreason", null);
                            supplierEntry.set("evalsupplierinvalid", (Object)Boolean.FALSE);
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidOpen});
                }
                DeleteServiceHelper.delete((String)"bid_supplierinvalid", (QFilter[])new QFilter[]{new QFilter("id", "=", supplierInvalid.getPkValue())});
            }
        }
    }

    private static class Validator4BidEvaluation
    extends AbstractValidator {
        private Validator4BidEvaluation() {
        }

        public void validate() {
            DynamicObject data;
            DynamicObject bidProject;
            String key = this.getOperateKey();
            List<String> operations = Arrays.asList("audit", "submit", "unaudit", "unsubmit");
            if (operations.contains(key)) {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String appId = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
                    DynamicObject ids = (DynamicObject)dataEntity.getValue("bidproject");
                    QFilter qFilter = new QFilter("bidproject.id", "=", (Object)ids.getLong("id"));
                    String supplierInvitationId = dataEntity.getDataEntity().getString("supplierinvitationid");
                    if (!"0".equals(supplierInvitationId) && StringUtils.isNotBlank((CharSequence)supplierInvitationId) && SupplierInvitationUtil.existAgainSupplierInvitation((Object)supplierInvitationId)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4fee\u8ba2\u4e2d\u72b6\u6001\u7684\u589e\u8865\u5165\u56f4\u5355\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u540e\u7eed\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"BidEvaluationOperationServicePlugIn_9", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject[] bidpublish = BusinessDataServiceHelper.load((String)(appId + "_bidpublish"), (String)"billstatus", (QFilter[])qFilter.toArray());
                    for (int i = 0; i < bidpublish.length; ++i) {
                        String billstatus = bidpublish[i].getString("billstatus");
                        if (billstatus.equals("C") || billstatus.equals("X") || billstatus.equals("P") || billstatus.equals("J")) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4fee\u8ba2\u4e2d\u72b6\u6001\u7684\u53d1\u6807\u5355\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u540e\u7eed\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"BidEvaluationOperationServicePlugIn_10", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }
            if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String type;
                    bidProject = dataEntity.getDataEntity().getDynamicObject("bidproject");
                    String bidOpenType = bidProject.getString("bidopentype");
                    Object bidProjectId = bidProject.getPkValue();
                    String appId = ((Object)((Object)this)).getClass().getName().split("\\.")[2];
                    boolean backBidFinished = new ReBackBidUtil(appId).checkBackBidFinished(bidProjectId, type = dataEntity.getDataEntity().getString("evaltype"));
                    if (backBidFinished) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"BidEvaluationOperationServicePlugIn_32", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenType)) {
                        boolean flag = bidEvaluationService.checkNextStepUnStarted(bidProject, BidStepEnum.BidEvaluation);
                        if (flag) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"BidEvaluationOperationServicePlugIn_11", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    QFilter qFilter = new QFilter("bidproject.id", "=", bidProjectId);
                    DynamicObject[] bidOpenArr = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"billstatus,opentype", (QFilter[])new QFilter[]{qFilter});
                    if (bidOpenArr == null) continue;
                    int openCount = 0;
                    int disBeginCount = 0;
                    for (DynamicObject bidOpen : bidOpenArr) {
                        if (BillStatusEnum.OPEN.getVal().equals(bidOpen.getString("billstatus"))) {
                            ++openCount;
                            continue;
                        }
                        if (!BillStatusEnum.DISBEGIN.getVal().equals(bidOpen.getString("billstatus")) && !BillStatusEnum.SAVE.getVal().equals(bidOpen.getString("billstatus"))) continue;
                        ++disBeginCount;
                    }
                    if (openCount == 2) {
                        boolean flag = bidEvaluationService.checkNextStepUnStarted(bidProject, BidStepEnum.BidEvaluation);
                        if (!flag) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"BidEvaluationOperationServicePlugIn_11", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (StringUtils.equals((CharSequence)bidOpenType, (CharSequence)"TECHBUSINESS")) {
                            if (!StringUtils.equals((CharSequence)type, (CharSequence)"TECHNICAL")) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5546\u52a1\u6807\u5f00\u6807\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidEvaluationOperationServicePlugIn_12", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (!StringUtils.equals((CharSequence)bidOpenType, (CharSequence)"BUSSINESSTECH") || !StringUtils.equals((CharSequence)type, (CharSequence)"BUSSINESS")) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6280\u672f\u6807\u5f00\u6807\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"BidEvaluationOperationServicePlugIn_13", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (disBeginCount != 0) continue;
                    if (StringUtils.equals((CharSequence)bidOpenType, (CharSequence)"TECHBUSINESS")) {
                        if (!StringUtils.equals((CharSequence)type, (CharSequence)"TECHNICAL")) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5546\u52a1\u6807\u5f00\u6807\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidEvaluationOperationServicePlugIn_12", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)bidOpenType, (CharSequence)"BUSSINESSTECH") || !StringUtils.equals((CharSequence)type, (CharSequence)"BUSSINESS")) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6280\u672f\u6807\u5f00\u6807\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"BidEvaluationOperationServicePlugIn_13", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
                return;
            }
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    long bidOpenId;
                    boolean existFlag;
                    data = dataEntity.getDataEntity();
                    BigDecimal one = data.getBigDecimal("techweight");
                    BigDecimal two = data.getBigDecimal("commweight");
                    if (one.doubleValue() < 0.0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u201c\u6280\u672f\u6807\u6743\u91cd\u201d<0\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidEvaluationOperationServicePlugIn_14", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    } else if (one.doubleValue() > 1.0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u201c\u6280\u672f\u6807\u6743\u91cd\u201d>100\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidEvaluationOperationServicePlugIn_15", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                    if (two.doubleValue() < 0.0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u201c\u5546\u52a1\u6807\u6743\u91cd\u201d<0\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidEvaluationOperationServicePlugIn_16", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    } else if (two.doubleValue() > 1.0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u201c\u5546\u52a1\u6807\u6743\u91cd\u201d>100\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidEvaluationOperationServicePlugIn_17", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                    DynamicObject bidProject2 = dataEntity.getDataEntity().getDynamicObject("bidproject");
                    boolean flag = bidEvaluationService.checkIsExistUnAuidtedOnlineBidEval(bidProject2);
                    if (flag) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5728\u7ebf\u8bc4\u6807\u7ed3\u679c\uff0c\u8bf7\u5ba1\u6838\u5b8c\u540e\u518d\u63d0\u4ea4\u3002", (String)"BidEvaluationOperationServicePlugIn_18", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                    Long bidevaluationId = data.getLong("id");
                    DynamicObject bidevaluation = bidEvaluationService.getBidEvaluation(bidevaluationId);
                    DynamicObject bidproject = bidevaluation.getDynamicObject("bidproject");
                    DynamicObjectCollection clarifysupplierColl = bidEvaluationService.listBidEvaluationEntrys(bidevaluationId, "id");
                    for (DynamicObject clarifysupplier : clarifysupplierColl) {
                        boolean supplierInvalid;
                        if (clarifysupplier == null || !(supplierInvalid = BidEvaluationOperationServicePlugIn.isInvalid(bidproject, clarifysupplier))) continue;
                        String supplierName = clarifysupplier.getString("name");
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5df2\u5728\u5f00\u6807\u51c6\u5907\u65f6\u88ab\u6dd8\u6c70\uff0c\u8bf7\u64a4\u9500\u6d41\u7a0b\u3002", (String)"BidEvaluationOperationServicePlugIn_33", (String)"scm-bid-opplugin", (Object[])new Object[0]), supplierName));
                        return;
                    }
                    String tipMessage = questionClarifyService.checkQueryIsProcess(data);
                    if (StringUtils.isNotBlank((CharSequence)tipMessage)) {
                        this.addErrorMessage(dataEntity, tipMessage);
                        return;
                    }
                    String evaluatedMethod = data.getString("evaluatedmethod");
                    if (!BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod) && !BidEvalMethodEnum.DX.getCode().equals(evaluatedMethod) || !(existFlag = QueryServiceHelper.exists((String)"bid_supplierinvalid", (QFilter[])new QFilter[]{new QFilter("bidopenid", "=", (Object)(bidOpenId = data.getLong("bidopenid"))), new QFilter("billstatus", "!=", (Object)"C")}))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u4f9b\u5e94\u5546\u6dd8\u6c70\u4e1a\u52a1\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BidEvaluationOperationServicePlugIn_20", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    bidProject = dataEntity.getDataEntity().getDynamicObject("bidproject");
                    boolean flag = bidEvaluationService.checkIsExistUnAuidtedOnlineBidEval(bidProject);
                    if (!flag) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5728\u7ebf\u8bc4\u6807\u7ed3\u679c\uff0c\u8bf7\u5ba1\u6838\u5b8c\u540e\u518d\u4fdd\u5b58\u3002", (String)"BidEvaluationOperationServicePlugIn_21", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            } else if ("audit".equals(key)) {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    data = dataEntity.getDataEntity();
                    Long bidEvaluationId = data.getLong("id");
                    DynamicObject bidProject3 = data.getDynamicObject("bidproject");
                    DynamicObjectCollection clarifySupplierColl = bidEvaluationService.listBidEvaluationEntrys(bidEvaluationId, "id");
                    for (DynamicObject clarifySupplier : clarifySupplierColl) {
                        boolean supplierInvalid;
                        if (clarifySupplier == null || !(supplierInvalid = BidEvaluationOperationServicePlugIn.isInvalid(bidProject3, clarifySupplier))) continue;
                        String supplierName = clarifySupplier.getString("name");
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5df2\u5728\u5f00\u6807\u51c6\u5907\u65f6\u88ab\u6dd8\u6c70\uff0c\u8bf7\u64a4\u9500\u6d41\u7a0b\u3002", (String)"BidEvaluationOperationServicePlugIn_33", (String)"scm-bid-opplugin", (Object[])new Object[0]), supplierName));
                        return;
                    }
                }
            }
            if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    data = dataEntity.getDataEntity();
                    DynamicObject bidProject4 = data.getDynamicObject("bidproject");
                    boolean exsit = new ReBackBidUtil(((Object)((Object)this)).getClass().getName().split("\\.")[2]).checkBackBidFinished(bidProject4.getPkValue());
                    if (!exsit) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidEvaluationOperationServicePlugIn_34", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }
}

