/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.bid.business.basedata.IProficientService;
import kd.scm.bid.business.basedata.serviceImpl.ProficientServiceImpl;
import kd.scm.bid.business.bill.IBidEvaluationService;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.helper.BidStepInteractiveHelper;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidOpenProficientOperationServicePlugin
extends AbstractOperationServicePlugIn {
    private IBidOpenService bidOpenService = new BidOpenServiceImpl();
    private IBidProjectService projectService = new BidProjectServiceImpl();
    private IBidEvaluationService evaluationService = new BidEvaluationServiceImpl();
    private IProficientService proficientService = new ProficientServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bidopen_proficient");
        e.getFieldKeys().add("bidopen");
        e.getFieldKeys().add("proficient_technical");
        e.getFieldKeys().add("proficient_commercial");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject now = null;
        Long id = null;
        MainEntityType type = null;
        if (StringUtils.equals((CharSequence)"savebidopen", (CharSequence)key)) {
            MainEntityType evaluationType = EntityMetadataCache.getDataEntityType((String)"bid_bidevaluation");
            DynamicObject project = null;
            for (DynamicObject obj : dataEntities) {
                DynamicObject evaluation;
                type = EntityMetadataCache.getDataEntityType((String)"bid_bidopen");
                id = obj.getLong("bidopen");
                now = this.bidOpenService.getBidOpenById(id);
                Long projectId = now.getLong("bidproject.id");
                project = this.projectService.getBidProjectAllById(projectId);
                String billstatus = now.getString("billstatus");
                DynamicObjectCollection beforeColls = now.getDynamicObjectCollection("bidopen_proficient");
                if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.OPEN.getVal())) {
                    for (DynamicObject beforeColl : beforeColls) {
                        DynamicObject tempProficient = beforeColl.getDynamicObject("proficient");
                        Long tempProfiId = tempProficient.getLong("id");
                        this.proficientService.deleteProficientProByField(tempProfiId, project);
                    }
                }
                EntityType proType = (EntityType)type.getAllEntities().get("bidopen_proficient");
                DynamicObjectCollection coll = obj.getDynamicObjectCollection("bidopen_proficient");
                now.set("bidopen_proficient", null);
                DynamicObjectCollection newColl = new DynamicObjectCollection((DynamicObjectType)proType, (Object)now);
                for (DynamicObject col : coll) {
                    DynamicObject temp = new DynamicObject((DynamicObjectType)proType);
                    temp.set("proficient", col.get("proficient"));
                    temp.set("proficient_technical", col.get("proficient_technical"));
                    temp.set("proficient_commercial", col.get("proficient_commercial"));
                    temp.set("proficient_comment", col.get("proficient_comment"));
                    temp.set("seq", col.get("seq"));
                    temp.set("selectionmethod", col.get("selectionmethod"));
                    DynamicObject proficient = col.getDynamicObject("proficient");
                    if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.OPEN.getVal())) {
                        this.proficientService.insertProficientProByIds(Long.valueOf(proficient.getLong("id")), project);
                    }
                    newColl.add((Object)temp);
                }
                now.set("bidopen_proficient", (Object)newColl);
                BusinessDataServiceHelper.save((IDataEntityType)type, (Object[])new Object[]{now});
                if (!BidStepInteractiveHelper.checkContainStep((Long)now.getLong("bidproject.id"), (BidStepEnum)BidStepEnum.BidEvaluation) || (evaluation = this.evaluationService.getEvaluationByProjectId(projectId, "id")) == null) continue;
                DeleteServiceHelper.delete((IDataEntityType)evaluationType, (Object[])new Object[]{evaluation.get("id")});
                this.bidOpenService.createNextStep(project, BidStepEnum.BidOpen);
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ValidatorForBidOpenProficient());
    }

    private class ValidatorForBidOpenProficient
    extends AbstractValidator {
        private ValidatorForBidOpenProficient() {
        }

        public void validate() {
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (StringUtils.equals((CharSequence)"savebidopen", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    String confirmMessage;
                    DynamicObjectCollection proficients = (DynamicObjectCollection)dataEntity.getValue("bidopen_proficient");
                    String bidOpen = (String)dataEntity.getValue("bidopen");
                    DynamicObject openObj = BidOpenProficientOperationServicePlugin.this.bidOpenService.getBidOpenById(Long.valueOf(Long.parseLong(bidOpen)));
                    DynamicObject bidProject = openObj.getDynamicObject("bidproject");
                    Boolean isEva = bidProject.getBoolean("bidevaluation");
                    if (!isEva.booleanValue()) continue;
                    if (proficients == null || proficients.size() == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u8bc4\u6807\u4e13\u5bb6\u201d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BidOpenProficientOperationServicePlugin_2", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    Boolean isProNull = Boolean.FALSE;
                    boolean hasTechnical = false;
                    if ("BUSSINESS".equals(bidProject.getString("doctype"))) {
                        hasTechnical = true;
                    }
                    boolean hasCommercial = false;
                    for (DynamicObject proficient : proficients) {
                        Boolean isTech = proficient.getBoolean("proficient_technical");
                        Boolean isCom = proficient.getBoolean("proficient_commercial");
                        if (!isTech.booleanValue() && !isCom.booleanValue()) {
                            isProNull = Boolean.TRUE;
                        }
                        if (hasCommercial && hasTechnical) break;
                        if (!hasTechnical) {
                            hasTechnical = proficient.getBoolean("proficient_technical");
                        }
                        if (hasCommercial) continue;
                        hasCommercial = proficient.getBoolean("proficient_commercial");
                    }
                    if (isProNull.booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u8bbe\u7f6e\u201c\u8bc4\u6807\u5185\u5bb9\u201d\u7684\u4e13\u5bb6\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenProficientOperationServicePlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!hasTechnical && !hasCommercial) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u8bbe\u7f6e\u201c\u8bc4\u6807\u5185\u5bb9\u201d\u7684\u4e13\u5bb6\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenProficientOperationServicePlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!hasTechnical) {
                        confirmMessage = ResManager.loadKDString((String)"\u6280\u672f\u6807\u8bc4\u6807\u4e13\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (String)"BidOpenProficientOperationServicePlugin_4", (String)"scm-bid-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, confirmMessage);
                        continue;
                    }
                    if (hasCommercial) continue;
                    confirmMessage = ResManager.loadKDString((String)"\u5546\u52a1\u6807\u8bc4\u6807\u4e13\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (String)"BidOpenProficientOperationServicePlugin_5", (String)"scm-bid-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, confirmMessage);
                }
            }
        }
    }
}

