/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidAnswerQuestionRecoService;
import kd.scm.bid.business.bill.IBidAnswerQuestionService;
import kd.scm.bid.business.bill.IBidBottomMakeService;
import kd.scm.bid.business.bill.IBidDecisionService;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.IBidPayService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.IBidPublishService;
import kd.scm.bid.business.bill.IMyTenderService;
import kd.scm.bid.business.bill.IOnlineBidEvalService;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidAnswerQuestionRecoServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidAnswerQuestionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidBottomMakeServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDecisionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidPayServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidPublishServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.MyTenderServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.OnlineBidEvalServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.business.helper.BidStepInteractiveHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BidTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.EvalItemType;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.bid.common.enums.PurchaseModel;
import kd.scm.bid.common.enums.RespBusiness;
import kd.scm.bid.common.enums.ScoreMode;
import kd.scm.bid.common.enums.ScoreType;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;
import kd.scm.bid.opplugin.bill.util.NextStepSendMessage;

public class BidProjectOperationServicePlugin
extends AbstractOperationServicePlugIn {
    private IBidProjectService projectService = new BidProjectServiceImpl();
    private IBidPublishService publishService = new BidPublishServiceImpl();
    private IBidAnswerQuestionService answerQuestionService = new BidAnswerQuestionServiceImpl();
    private IBidAnswerQuestionRecoService recoService = new BidAnswerQuestionRecoServiceImpl();
    private ISupplierInvitationService supplierInvitationService = new SupplierInvitationServiceImpl();
    private IBidDecisionService bidDecisionService = new BidDecisionServiceImpl();
    private IBidOpenService bidOpenService = new BidOpenServiceImpl();
    private IOnlineBidEvalService onlineBidEvalService = new OnlineBidEvalServiceImpl();
    private IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();
    private IMyTenderService myTenderService = new MyTenderServiceImpl();
    private IBidPayService bidPayService = new BidPayServiceImpl();
    private IBidBottomMakeService bidBottomMakeService = new BidBottomMakeServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("isseparatedoc");
        e.getFieldKeys().add("enablemultisection");
        e.getFieldKeys().add("memberentity");
        e.getFieldKeys().add("bidsection");
        e.getFieldKeys().add("memberentity.respbusiness");
        e.getFieldKeys().add("memberentity.user");
        e.getFieldKeys().add("memberentity.isdirector");
        e.getFieldKeys().add("entrustmentway");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("supplierinvitation");
        e.getFieldKeys().add("biddocument");
        e.getFieldKeys().add("bidpublish");
        e.getFieldKeys().add("bidopen");
        e.getFieldKeys().add("bidevaluation");
        e.getFieldKeys().add("bidbustalk");
        e.getFieldKeys().add("biddecision");
        e.getFieldKeys().add("purmodel");
        e.getFieldKeys().add("bidanswerquestion");
        e.getFieldKeys().add("answerquestiontime");
        e.getFieldKeys().add("bidsection.projectentry");
        e.getFieldKeys().add("entrustmentorgunit");
        e.getFieldKeys().add("ismaterialpur");
        e.getFieldKeys().add("bidmode");
        e.getFieldKeys().add("bidopentype");
        e.getFieldKeys().add("deposit");
        e.getFieldKeys().add("tenderfee");
        e.getFieldKeys().add("isdeposit");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("secdeposit");
        e.getFieldKeys().add("doctype");
        e.getFieldKeys().add("evaluatedecideway");
        e.getFieldKeys().add("techweight");
        e.getFieldKeys().add("comweight");
        e.getFieldKeys().add("isonlineeval");
        e.getFieldKeys().add("bidevaltemplate");
        e.getFieldKeys().add("scoremode");
        e.getFieldKeys().add("scoretype");
        e.getFieldKeys().add("bid_proficiententry");
        e.getFieldKeys().add("proficient");
        e.getFieldKeys().add("proficient_technical");
        e.getFieldKeys().add("proficient_commercial");
        e.getFieldKeys().add("bid_opentypeentry");
        e.getFieldKeys().add("evalparenttype");
        e.getFieldKeys().add("bid_openevalentry");
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("item");
        e.getFieldKeys().add("standard");
        e.getFieldKeys().add("score");
        e.getFieldKeys().add("weight");
        e.getFieldKeys().add("bidrollsection");
        e.getFieldKeys().add("supplierentry");
        e.getFieldKeys().add("invitationstatus");
        e.getFieldKeys().add("entitytypeid");
        e.getFieldKeys().add("clarificaiton");
        e.getFieldKeys().add("bidbottommake");
        e.getFieldKeys().add("clarificaitondate");
        e.getFieldKeys().add("bidbottommakedate");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("evaluatedmethod");
        e.getFieldKeys().add("bidtype");
        e.getFieldKeys().add("purentrycontent");
        e.getFieldKeys().add("materialid");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("respbusinessleader");
        e.getFieldKeys().add("busbackbidtime");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new Validator4BidProject());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if ("submit".equals(key)) {
            for (DynamicObject proObj : datas) {
                DynamicObjectCollection bidRollSection;
                if (!BidModeHelper.isPublicBidding((DynamicObject)proObj) || (bidRollSection = proObj.getDynamicObjectCollection("bidrollsection")) == null || bidRollSection.size() <= 0) continue;
                for (int i = 0; i < bidRollSection.size(); ++i) {
                    DynamicObjectCollection supplierColl = ((DynamicObject)bidRollSection.get(i)).getDynamicObjectCollection("supplierentry");
                    supplierColl.clear();
                }
            }
        } else if ("undoinvitation".equals(key)) {
            this.undoInvitation(datas);
        }
    }

    public void undoInvitation(DynamicObject[] bidProjectArray) {
        DynamicObject[] supplierInvitationArray;
        if (bidProjectArray == null || bidProjectArray.length == 0) {
            return;
        }
        ArrayList<Long> bidSupplierIdList = new ArrayList<Long>();
        ArrayList<Long> bidProjectIdList = new ArrayList<Long>(bidProjectArray.length);
        String appId = null;
        for (DynamicObject bidProject : bidProjectArray) {
            appId = bidProject.getString("entitytypeid").split("_")[0];
            bidProjectIdList.add(bidProject.getLong("id"));
            DynamicObjectCollection bidSectionCol = bidProject.getDynamicObjectCollection("bidrollsection");
            for (DynamicObject bidSection : bidSectionCol) {
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                    if (supplier != null) {
                        bidSupplierIdList.add(supplier.getLong("id"));
                    }
                    supplierEntry.set("invitationstatus", (Object)"UNSEND");
                }
            }
        }
        for (DynamicObject supplierInvitation : supplierInvitationArray = BusinessDataServiceHelper.load((String)(appId + "_supplierinvitation"), (String)"supplier, invitationstatus, supplierentry.isrecommend", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIdList)})) {
            DynamicObjectCollection bidSectionCol = supplierInvitation.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidSection : bidSectionCol) {
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                    if (supplier == null || CollectionUtils.isEmpty(bidSupplierIdList) || !bidSupplierIdList.contains(supplier.getLong("id"))) continue;
                    supplierEntry.set("invitationstatus", (Object)"UNSEND");
                    supplierEntry.set("isrecommend", (Object)Boolean.TRUE);
                }
            }
        }
        DeleteServiceHelper.delete((String)(appId + "_invitation"), (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIdList).and(new QFilter("supplierentry.supplier.id", "in", bidSupplierIdList))});
        SaveServiceHelper.update((DynamicObject[])bidProjectArray);
        SaveServiceHelper.update((DynamicObject[])supplierInvitationArray);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if ("audit".equals(key)) {
            NextStepSendMessage nextStepSendMessage = null;
            for (DynamicObject proObj : datas) {
                nextStepSendMessage = new NextStepSendMessage();
                nextStepSendMessage.nextStepSendMessage(proObj, BidStepEnum.BidProject);
                if (!proObj.getBoolean("bidbottommake")) continue;
                this.bidBottomMakeService.sendMessageToMember(proObj);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if ("audit".equals(key)) {
            for (DynamicObject proObj : datas) {
                BidStepEnum[] nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)proObj, (BidStepEnum)BidStepEnum.BidProject);
                boolean bidBottomMake = proObj.getBoolean("bidbottommake");
                if (bidBottomMake) {
                    BidBottomMakeServiceImpl bidBottomMakeService = new BidBottomMakeServiceImpl();
                    String appId = proObj.getString("entitytypeid").split("_")[0];
                    bidBottomMakeService.createBottomMakeByBidProject(Long.valueOf(proObj.getLong("id")), appId);
                }
                if (nextStep != null && BidStepEnum.BidAnswerQuestion == nextStep[0]) {
                    this.answerQuestionService.createNextStep(proObj, BidStepEnum.BidAnswerQuestion);
                }
                String id = proObj.getString("id");
                this.projectService.generatorNextStepBill((Object)id);
            }
            return;
        }
        if ("unaudit".equals(key)) {
            for (DynamicObject proObj : datas) {
                String id = proObj.getString("id");
                this.projectService.deleteNextStepUnStarted(proObj, BidStepEnum.BidProject);
                BidStepEnum[] nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)proObj, (BidStepEnum)BidStepEnum.BidProject);
                if (nextStep != null && BidStepEnum.BidAnswerQuestion == nextStep[0] && proObj.getBoolean("bidopen")) {
                    this.bidOpenService.deleteUnStarted(proObj.getPkValue());
                }
                boolean bidBottomMake = proObj.getBoolean("bidbottommake");
                String appId = proObj.getString("entitytypeid").split("_")[0];
                if (bidBottomMake) {
                    this.bidBottomMakeService.deleteUnStartedBottomMakeByBidProjectId(Long.valueOf(Long.parseLong(id)), appId);
                }
                if (nextStep == null || BidStepEnum.BidAnswerQuestion != nextStep[0] || proObj.getBoolean("bidopen")) continue;
                this.answerQuestionService.deleteNextStepUnStarted(proObj, BidStepEnum.BidAnswerQuestion);
                this.projectService.saveCurrentBidStep(proObj.getPkValue(), new BidStepEnum[]{BidStepEnum.BidProject});
            }
            return;
        }
        if ("save".equals(key) || "submit".equals(key)) {
            StringBuilder temp = null;
            for (DynamicObject proObj : datas) {
                String id = proObj.getString("id");
                this.projectService.savePurProjectSet(id);
                this.publishService.saveAnswerDeadline((Object)id, proObj.getDate("answerquestiontime"), "answerquestiondeadline");
                this.answerQuestionService.saveAnswerDeadline((Object)id, proObj.getDate("answerquestiontime"), "answerquestiondeadline");
                this.myTenderService.refreshMyTenderBiddingStatus(proObj.getPkValue());
                DynamicObjectCollection memberEntry = proObj.getDynamicObjectCollection("memberentity");
                RespBusiness rb = RespBusiness.valueOf((String)"BidPay");
                temp = new StringBuilder();
                for (int i = 0; i < memberEntry.size(); ++i) {
                    DynamicObject member = (DynamicObject)memberEntry.get(i);
                    DynamicObject user = member.getDynamicObject("user");
                    String respbusiness = member.getString("respbusiness");
                    if (null == respbusiness || respbusiness.indexOf(rb.getVal()) < 0) continue;
                    temp.append(user.getPkValue()).append(',');
                }
                this.bidPayService.updateAllPayRespbusiness(Long.valueOf(proObj.getLong("id")), temp.length() > 0 ? temp.substring(0, temp.length() - 1) : "");
                DynamicObject mainObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_project", (String)"id,currentstep,billstatus");
                if (!"A".equals(mainObj) && !"B".equals(mainObj)) continue;
                mainObj.set("currentstep", (Object)",BidProject,");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObj});
            }
            return;
        }
        if ("invalid".equals(key)) {
            DynamicObject[] invitationColl;
            DynamicObject[] announcementColl;
            DynamicObject[] myTenderArr;
            HashSet<Long> bidProjectIDSet = new HashSet<Long>();
            ArrayList<String> bidProjectIdStrList = new ArrayList<String>(16);
            for (DynamicObject proObj : datas) {
                DynamicObject[] bidassInviteArr;
                DynamicObject[] bidassInviteSumArr;
                DynamicObject[] invitationDataArray;
                String id = proObj.getString("id");
                Long projectId = Long.parseLong(id);
                DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
                String appid = bidProject.getString("entitytypeid").split("_")[0];
                Boolean isInvitation = proObj.getBoolean("supplierinvitation");
                String appId = this.billEntityType.getAppId();
                if (isInvitation.booleanValue()) {
                    this.supplierInvitationService.invalidInvitation(projectId, appId + "_supplierstatistic");
                }
                for (DynamicObject invitationData : invitationDataArray = BusinessDataServiceHelper.load((String)(appid + "_invitation"), (String)"id, status", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("status", "!=", (Object)"X")})) {
                    invitationData.set("status", (Object)"X");
                }
                SaveServiceHelper.save((DynamicObject[])invitationDataArray);
                for (DynamicObject bidassInviteSum : bidassInviteSumArr = BusinessDataServiceHelper.load((String)(appid + "_bidassinvitesum"), (String)"id, billstatus", (QFilter[])new QFilter[]{new QFilter("linkexpertextract.bidprojectname", "=", (Object)projectId), new QFilter("billstatus", "!=", (Object)"X")})) {
                    bidassInviteSum.set("billstatus", (Object)"X");
                }
                SaveServiceHelper.save((DynamicObject[])bidassInviteSumArr);
                for (DynamicObject bidassInvite : bidassInviteArr = BusinessDataServiceHelper.load((String)(appid + "_bidassinvite"), (String)"id, billstatus", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)projectId), new QFilter("billstatus", "!=", (Object)"X")})) {
                    bidassInvite.set("billstatus", (Object)"X");
                }
                SaveServiceHelper.save((DynamicObject[])bidassInviteArr);
                this.bidBottomMakeService.saveBidBottomMakeInvalidStatus(projectId, appId);
                Boolean isBidOpen = proObj.getBoolean("bidopen");
                if (isBidOpen.booleanValue()) {
                    this.bidOpenService.invalidProficients(projectId);
                }
                this.bidDecisionService.invalidBidDecision(projectId, appId + "_supplierstatistic");
                this.projectService.saveProjectInvalidStatus(id);
                this.recoService.saveRecoInvalidStatus((Object)projectId);
                this.onlineBidEvalService.saveOnlineBidEvalInvalidStatus(projectId);
                bidProjectIDSet.add(projectId);
                bidProjectIdStrList.add(projectId.toString());
                this.questionClarifyService.setProjectClarifyDataInvalid((Object)projectId);
                this.sendMessage(key, projectId, appid);
                this.sendMessageToMember(key, projectId, appid, proObj);
            }
            for (DynamicObject myTender : myTenderArr = BusinessDataServiceHelper.load((String)"ten_mytender", (String)"tenderstatus,statusbeforefailure", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIDSet)})) {
                myTender.set("statusbeforefailure", myTender.get("tenderstatus"));
                myTender.set("tenderstatus", (Object)MyTenderStatus.FAILURE);
            }
            SaveServiceHelper.update((DynamicObject[])myTenderArr);
            for (DynamicObject announcement : announcementColl = BusinessDataServiceHelper.load((String)"bid_announcement", (String)"status", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIdStrList)})) {
                announcement.set("status", (Object)"C");
            }
            SaveServiceHelper.save((DynamicObject[])announcementColl);
            for (DynamicObject invitation : invitationColl = BusinessDataServiceHelper.load((String)"bid_invitation", (String)"enable", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIDSet)})) {
                invitation.set("enable", (Object)"2");
            }
            SaveServiceHelper.save((DynamicObject[])invitationColl);
            return;
        }
    }

    private void sendMessageToMember(String key, Long projectId, String appId, DynamicObject proObj) {
        HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        String name = proObj.getString("name");
        msgParam.put("appId", appId);
        msgParam.put("operation", key);
        msgParam.put("title", null);
        msgParam.put("pkId", projectId);
        msgParam.put("formId", FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        msgParam.put("msgentity", "bid_project");
        msgParam.put("id", projectId);
        msgParam.put("content", null);
        msgParam.put("tplScene", "bid_invalid_mem");
        DynamicObjectCollection memberColl = proObj.getDynamicObjectCollection("memberentity");
        for (DynamicObject member : memberColl) {
            memberSet.add(member.getDynamicObject("user"));
            if (!member.getBoolean("isdirector")) continue;
            memberSet.add(member.getDynamicObject("user"));
        }
        if (!memberSet.isEmpty()) {
            for (DynamicObject set : memberSet) {
                receiveUserIds.add(set.getLong("id"));
            }
        }
        String notifyTypes = MessageChannelUtil.getNotifyType((String)"bid_invalid_mem", (String)"bid_project");
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)false, receiveUserIds, (String)notifyTypes);
    }

    private void sendMessage(String key, Long projectId, String appId) {
        DynamicObject[] supplierInvation = null;
        supplierInvation = "bid".equals(appId) ? BusinessDataServiceHelper.load((String)"bid_supplierinvitation", (String)"id,bidproject,bidproject.bidmode,bidsection,bidsection.supplierentry,bidenrollsection,supplierentry.supplier,supplierentry.invitationstatus,supplierentry.invitationuser,,bidenrollsection.supplierenrollentry,supplierenrollentry.enrollsupplier,supplierenrollentry.applyuser", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", (Object)projectId)}) : BusinessDataServiceHelper.load((String)"rebm_supplierinvitation", (String)"id,bidproject,bidproject.bidmode,bidsection,bidsection.supplierentry,bidenrollsection,supplierentry.supplier,supplierentry.invitationstatus,supplierentry.invitationuser,,bidenrollsection.supplierenrollentry,supplierenrollentry.enrollsupplier,supplierenrollentry.applyuser", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", (Object)projectId)});
        if (supplierInvation != null && supplierInvation.length > 0) {
            DynamicObject supplierInvate = supplierInvation[0];
            DynamicObject bidProject = supplierInvate.getDynamicObject("bidproject");
            DynamicObject bidMode = bidProject.getDynamicObject("bidmode");
            String name = bidProject.getString("name");
            if (bidMode != null) {
                String notifyTypes = MessageChannelUtil.getNotifyType((String)"bid_invalid", (String)"bid_project");
                if (bidMode.getString("name").contains(ResManager.loadKDString((String)"\u516c\u5f00\u62db\u6807", (String)"BidProjectOperationServicePlugin_82", (String)"scm-bid-opplugin", (Object[])new Object[0]))) {
                    DynamicObjectCollection bidSectionColl = supplierInvate.getDynamicObjectCollection("bidsection");
                    DynamicObjectCollection bidEnrollSectionColl = supplierInvate.getDynamicObjectCollection("bidenrollsection");
                    HashMap<Long, Long> supplierBizUsers = new HashMap<Long, Long>();
                    if (!bidEnrollSectionColl.isEmpty()) {
                        for (int i = 0; i < bidEnrollSectionColl.size(); ++i) {
                            DynamicObject bidSection = (DynamicObject)bidEnrollSectionColl.get(i);
                            for (DynamicObject item : bidSection.getDynamicObjectCollection("supplierenrollentry")) {
                                long supplierId = item.getLong("enrollsupplier.id");
                                long applyUserId = item.getLong("applyuser.id");
                                supplierBizUsers.put(supplierId, applyUserId);
                            }
                        }
                    }
                    HashSet<Long> selectedSuplierIdSet = new HashSet<Long>();
                    if (!bidSectionColl.isEmpty()) {
                        for (int i = 0; i < bidSectionColl.size(); ++i) {
                            for (DynamicObject item : ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry")) {
                                selectedSuplierIdSet.add(item.getLong("supplier.id"));
                            }
                        }
                    }
                    HashMap<String, Object> msgParam = new HashMap<String, Object>();
                    msgParam.put("appId", appId);
                    msgParam.put("operation", key);
                    msgParam.put("title", null);
                    msgParam.put("pkId", projectId);
                    msgParam.put("formId", FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
                    msgParam.put("msgentity", "bid_project");
                    msgParam.put("id", projectId);
                    msgParam.put("content", null);
                    msgParam.put("tplScene", "bid_invalid");
                    Set<Long> receiveUserIds = this.getReceiveUserIds(selectedSuplierIdSet, supplierBizUsers);
                    MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)false, new ArrayList<Long>(receiveUserIds), (String)notifyTypes);
                } else {
                    HashMap<String, Object> msgParam = new HashMap<String, Object>();
                    msgParam.put("appId", appId);
                    msgParam.put("operation", key);
                    msgParam.put("title", null);
                    msgParam.put("pkId", projectId);
                    msgParam.put("formId", FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
                    msgParam.put("msgentity", "bid_project");
                    msgParam.put("id", projectId);
                    msgParam.put("content", null);
                    msgParam.put("tplScene", "bid_invalid");
                    DynamicObjectCollection bidSectionColl = supplierInvate.getDynamicObjectCollection("bidsection");
                    HashSet<Long> receiveUserIds = new HashSet<Long>();
                    if (!bidSectionColl.isEmpty()) {
                        for (int i = 0; i < bidSectionColl.size(); ++i) {
                            DynamicObjectCollection supplierEntryColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                            for (DynamicObject supplierEntry : supplierEntryColl) {
                                if (supplierEntry.getLong("id") == 0L || supplierEntry.getDynamicObject("supplier") == null || !"ACCEPTED".equals(supplierEntry.getString("invitationstatus"))) continue;
                                receiveUserIds.add(supplierEntry.getLong("invitationuser.id"));
                            }
                        }
                    }
                    if (!receiveUserIds.isEmpty()) {
                        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)false, new ArrayList(receiveUserIds), (String)notifyTypes);
                    }
                }
            }
        }
    }

    protected Set<Long> getReceiveUserIds(Set<Long> supplierIds, Map<Long, Long> supplierBizUsers) {
        HashSet<Long> receiveUserIds = new HashSet<Long>(20);
        if (CollectionUtils.isEmpty(supplierBizUsers)) {
            return receiveUserIds;
        }
        for (Long supplierId : supplierIds) {
            if (!supplierBizUsers.containsKey(supplierId)) continue;
            receiveUserIds.add(supplierBizUsers.get(supplierId));
        }
        return receiveUserIds;
    }

    private class Validator4BidProject
    extends AbstractValidator {
        private Validator4BidProject() {
        }

        public void validate() {
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    Object name = dataEntity.getValue("name");
                    if (StringUtils.isBlank((Object)name)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u62db\u6807\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_38", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    String billno = (String)dataEntity.getValue("billno");
                    CodeRuleInfo xCodeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)BidProjectOperationServicePlugin.this.billEntityType.getName(), (DynamicObject)dataEntity.getDataEntity(), (String)String.valueOf(RequestContext.get().getOrgId()));
                    boolean isNonBreak = false;
                    if (xCodeRuleInfo != null) {
                        isNonBreak = xCodeRuleInfo.getIsNonBreak();
                    }
                    if (StringUtils.isBlank((CharSequence)billno) && !isNonBreak) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u62db\u6807\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_39", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObjectCollection members = (DynamicObjectCollection)dataEntity.getValue("memberentity");
                    if (members == null || members.size() == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u62db\u6807\u5c0f\u7ec4\u6210\u5458\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_40", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    this.validateRespBusiness4Save(dataEntity);
                    ILocaleString nameLocal = (ILocaleString)dataEntity.getValue("name");
                    Long id = (Long)dataEntity.getValue("id");
                    boolean isUnique = BidProjectOperationServicePlugin.this.projectService.checkUniqueName(this.entityKey, id, nameLocal.getLocaleValue());
                    if (isUnique) continue;
                    this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u62db\u6807\u540d\u79f0\u201d\u552f\u4e00\u6027\u6821\u9a8c\uff1a\u201c\u62db\u6807\u540d\u79f0\u201d\u5b57\u6bb5\u503c\u201c%s\u201d\u91cd\u590d\u3002", (String)"BidProjectOperationServicePlugin_41", (String)"scm-bid-opplugin", (Object[])new Object[0]), nameLocal.getLocaleValue()));
                }
                return;
            }
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObjectCollection members;
                    Object eou;
                    String entrustmentway = (String)dataEntity.getValue("entrustmentway");
                    if ("03".equals(entrustmentway) && (eou = dataEntity.getValue("entrustmentorgunit")) == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u59d4\u6258\u91c7\u8d2d\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_42", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    ILocaleString nameLocal = (ILocaleString)dataEntity.getValue("name");
                    Long id = (Long)dataEntity.getValue("id");
                    boolean isUnique = BidProjectOperationServicePlugin.this.projectService.checkUniqueName(this.entityKey, id, nameLocal.getLocaleValue());
                    if (!isUnique) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u62db\u6807\u540d\u79f0\u201d\u552f\u4e00\u6027\u6821\u9a8c\uff1a\u201c\u62db\u6807\u540d\u79f0\u201d\u5b57\u6bb5\u503c\u201c%s\u201d\u91cd\u590d\u3002", (String)"BidProjectOperationServicePlugin_41", (String)"scm-bid-opplugin", (Object[])new Object[0]), nameLocal.getLocaleValue()));
                    }
                    String purModel = (String)dataEntity.getValue("purmodel");
                    if (PurchaseModel.ProjectProcurement.getVal().equals(purModel) || PurchaseModel.ConsortiumPurchasing.getVal().equals(purModel) || PurchaseModel.StrategySourcing.getVal().equals(purModel)) {
                        DynamicObjectCollection sections = (DynamicObjectCollection)dataEntity.getValue("bidsection");
                        boolean enableMultiSection = (Boolean)dataEntity.getValue("enablemultisection");
                        String flag = "true";
                        if (dataEntity.getValue("bidType").toString().equals(BidTypeEnum.PROJECT.getValue())) {
                            flag = "false";
                        }
                        if (sections == null || sections.size() == 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6807\u6bb5\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_44", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        DynamicObjectType entryType = ((DynamicObject)sections.get(0)).getDynamicObjectCollection("projectentry").getDynamicObjectType();
                        if (entryType.getProperty("purentryproject") == null) {
                            DynamicObject dObj = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getBillPkId(), (String)"bid_project");
                            sections = dObj.getDynamicObjectCollection("bidsection");
                        }
                        for (int i = 0; i < sections.size(); ++i) {
                            DynamicObject section = (DynamicObject)sections.get(i);
                            String name = section.getString("sectionname");
                            DynamicObjectCollection purDetails = section.getDynamicObjectCollection("projectentry");
                            if (enableMultiSection) {
                                if (purDetails == null || purDetails.size() == 0) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6807\u6bb5\u201c%s\u201d\u5bf9\u5e94\u7684\u201c\u91c7\u8d2d\u660e\u7ec6\u201d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_45", (String)"scm-bid-opplugin", (Object[])new Object[0]), name));
                                    continue;
                                }
                                this.validateContent4MultiSection(dataEntity, name, purDetails, flag);
                                continue;
                            }
                            if (purDetails == null || purDetails.size() == 0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u91c7\u8d2d\u660e\u7ec6\u201d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_46", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            this.validateContent4SingleSection(dataEntity, purDetails, flag);
                        }
                    }
                    if ((members = (DynamicObjectCollection)dataEntity.getValue("memberentity")) == null || members.size() == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u62db\u6807\u5c0f\u7ec4\u6210\u5458\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_40", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    this.validateRespBusiness(dataEntity);
                    this.validateOpenEvalPlanEntity(dataEntity);
                }
                return;
            }
            if (StringUtils.equals((CharSequence)"invalid", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    String billStatus = (String)dataEntity.getValue("billstatus");
                    if (!BillStatusEnum.AUDITED.getVal().equals(billStatus)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6279\u7684\u6570\u636e\u624d\u5141\u8bb8\u4f5c\u5e9f\u3002", (String)"BidProjectOperationServicePlugin_48", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject decision = BusinessDataServiceHelper.loadSingle((String)"bid_decision", (String)"id,billstatus,synxkflag", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", dataEntity.getBillPkId())});
                    if (decision == null) continue;
                    boolean synxkflag = decision.getBoolean("synxkflag");
                    if (synxkflag) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5df2\u751f\u6210\u661f\u7a7a\u91c7\u8d2d\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c\u3002", (String)"BidProjectOperationServicePlugin_49", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    String billstatus = decision.getString("billstatus");
                    if (!BillStatusEnum.PARTSIGNED.getVal().equals(billstatus) && !BillStatusEnum.SIGNED.getVal().equals(billstatus)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u5b58\u5728\u5df2\u7b7e\u7ea6\u6216\u90e8\u5206\u7b7e\u7ea6\u7684\u5b9a\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f\u3002", (String)"BidProjectOperationServicePlugin_50", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
                return;
            }
            if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    boolean unStarted;
                    String billStatus = (String)dataEntity.getValue("billstatus");
                    if (!BillStatusEnum.AUDITED.getVal().equals(billStatus)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"BidProjectOperationServicePlugin_51", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    Object pk = dataEntity.getValue("id");
                    DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bid_project");
                    boolean flag = BidProjectOperationServicePlugin.this.projectService.checkNextStepUnStarted(bidProject, BidStepEnum.BidProject);
                    if (!flag) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"BidProjectOperationServicePlugin_52", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObjectCollection recos = BidProjectOperationServicePlugin.this.recoService.getRecordByProjectId(Long.valueOf(bidProject.getLong("id")));
                    if (recos.size() > 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5b58\u5728\u7b54\u7591\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidProjectOperationServicePlugin_53", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    BidStepEnum[] nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)bidProject, (BidStepEnum)BidStepEnum.BidProject);
                    if (nextStep != null && BidStepEnum.BidAnswerQuestion == nextStep[0] && !BidProjectOperationServicePlugin.this.answerQuestionService.checkNextStepUnStarted(bidProject, BidStepEnum.BidAnswerQuestion)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"BidProjectOperationServicePlugin_52", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                    boolean bidBottomMake = dataEntity.getDataEntity().getBoolean("bidbottommake");
                    String appId = dataEntity.getDataEntity().getString("entitytypeid").split("_")[0];
                    if (bidBottomMake && !(unStarted = BidProjectOperationServicePlugin.this.bidBottomMakeService.checkBottomMakeUnStartedByBidProjectId(Long.valueOf(Long.parseLong(pk.toString())), appId))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"BidProjectOperationServicePlugin_52", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                    this.validInvitationSend(dataEntity);
                }
                return;
            }
        }

        private void validateOpenEvalPlanEntity(ExtendedDataEntity dataEntity) {
            DynamicObject bidProjectData = dataEntity.getDataEntity();
            DynamicObject bidMode = bidProjectData.getDynamicObject("bidmode");
            if (bidMode == null) {
                return;
            }
            Boolean isEvaluation = bidMode.getBoolean("bidevaluation");
            String docType = bidProjectData.getString("doctype");
            BigDecimal oneHundredNumber = new BigDecimal("100");
            BigDecimal oneNumber = new BigDecimal("1");
            if (isEvaluation.booleanValue()) {
                String method;
                DynamicObjectCollection proficients = bidProjectData.getDynamicObjectCollection("bid_proficiententry");
                if (proficients != null && proficients.size() > 0) {
                    Boolean isProNull = Boolean.FALSE;
                    for (DynamicObject proficient : proficients) {
                        Boolean isTech = proficient.getBoolean("proficient_technical");
                        Boolean isCom = proficient.getBoolean("proficient_commercial");
                        if (isTech.booleanValue() || isCom.booleanValue()) continue;
                        isProNull = Boolean.TRUE;
                    }
                    if (isProNull.booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u8bbe\u7f6e\u8bc4\u6807\u5185\u5bb9\u7684\u4e13\u5bb6\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidProjectOperationServicePlugin_54", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                }
                if ("1".equals(method = bidProjectData.getString("evaluatedmethod"))) {
                    return;
                }
                DynamicObjectCollection entryentity = bidProjectData.getDynamicObjectCollection("bid_opentypeentry");
                boolean isonlineeval = bidProjectData.getBoolean("isonlineeval");
                if (isonlineeval) {
                    if (entryentity == null || entryentity.isEmpty()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidProjectOperationServicePlugin_85", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    String scoremode = bidProjectData.getString("scoremode");
                    String scoretype = bidProjectData.getString("scoretype");
                    for (DynamicObject entry : entryentity) {
                        String type = entry.getString("evalparenttype");
                        DynamicObjectCollection templateColl = entry.getDynamicObjectCollection("bid_openevalentry");
                        String typeAlias = "";
                        if (EvalItemType.TECHNICAL.getVal().equals(type)) {
                            typeAlias = EvalItemType.TECHNICAL.getAlias();
                        } else if (EvalItemType.COMMERCIAL.getVal().equals(type)) {
                            typeAlias = EvalItemType.COMMERCIAL.getAlias();
                        }
                        if (templateColl == null || templateColl.size() == 0) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u8bc4\u6807\u9879\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidProjectOperationServicePlugin_55", (String)"scm-bid-opplugin", (Object[])new Object[0]), typeAlias));
                            continue;
                        }
                        if (scoretype == null) continue;
                        BigDecimal technicalSum = BigDecimal.ZERO;
                        BigDecimal commercialSum = BigDecimal.ZERO;
                        boolean iscorrect = true;
                        for (int i = 0; i < templateColl.size(); ++i) {
                            DynamicObject coll = (DynamicObject)templateColl.get(i);
                            String tempType = coll.getString("type");
                            if (StringUtils.isBlank((CharSequence)tempType)) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u6807\u9879\u533a\u57df\u7684\u7b2c%s\u884c\u201c\u7c7b\u522b\u201d\u5b57\u6bb5\u3002", (String)"BidProjectOperationServicePlugin_56", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
                                iscorrect = false;
                            }
                            if (StringUtils.isBlank((CharSequence)coll.getString("item"))) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u6807\u9879\u533a\u57df\u7684\u7b2c%s\u884c\u201c\u8bc4\u5206\u9879\u201d\u5b57\u6bb5\u3002", (String)"BidProjectOperationServicePlugin_57", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
                                iscorrect = false;
                            }
                            if (ScoreMode.STANDARD.getVal().equals(scoremode)) {
                                BigDecimal detailEntryScore = coll.getBigDecimal("score");
                                if (detailEntryScore.compareTo(BigDecimal.ZERO) <= 0) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u6807\u9879\u533a\u57df\u7684\u7b2c%s\u884c\u201c\u6807\u51c6\u5206\u201d\u5b57\u6bb5\u3002", (String)"BidProjectOperationServicePlugin_58", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
                                    iscorrect = false;
                                }
                                if (EvalItemType.TECHNICAL.getVal().equals(tempType)) {
                                    technicalSum = technicalSum.add(detailEntryScore);
                                    continue;
                                }
                                if (!EvalItemType.COMMERCIAL.getVal().equals(tempType)) continue;
                                commercialSum = commercialSum.add(detailEntryScore);
                                continue;
                            }
                            if (!ScoreMode.WEIGHT.getVal().equals(scoremode)) continue;
                            BigDecimal detailEntryWeight = coll.getBigDecimal("weight");
                            if (detailEntryWeight.compareTo(BigDecimal.ZERO) <= 0) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u6807\u9879\u533a\u57df\u7684\u7b2c%s\u884c\u201c\u6240\u5360\u6743\u91cd\u201d\u5b57\u6bb5\u3002", (String)"BidProjectOperationServicePlugin_59", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
                                iscorrect = false;
                            }
                            if (EvalItemType.TECHNICAL.getVal().equals(tempType)) {
                                technicalSum = technicalSum.add(detailEntryWeight);
                                continue;
                            }
                            if (!EvalItemType.COMMERCIAL.getVal().equals(tempType)) continue;
                            commercialSum = commercialSum.add(detailEntryWeight);
                        }
                        if (!iscorrect) continue;
                        if (ScoreType.SUM.getVal().equals(scoretype)) {
                            if (ScoreMode.STANDARD.getVal().equals(scoremode)) {
                                if (oneHundredNumber.compareTo(technicalSum.add(commercialSum)) != 0) {
                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u603b\u5206\u4e0d\u7b49\u4e8e100\u5206\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BidProjectOperationServicePlugin_60", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                    continue;
                                }
                                if (!BidOpenTypeEnum.MULTI.getValue().equals(docType)) continue;
                                if (technicalSum.compareTo(BigDecimal.ZERO) == 0) {
                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5fc5\u987b\u5b58\u5728\u6280\u672f\u6807\u90e8\u5206", (String)"BidProjectOperationServicePlugin_61", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                }
                                if (commercialSum.compareTo(BigDecimal.ZERO) != 0) continue;
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5fc5\u987b\u5b58\u5728\u5546\u52a1\u6807\u90e8\u5206", (String)"BidProjectOperationServicePlugin_62", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            if (oneNumber.compareTo(technicalSum.add(commercialSum)) != 0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6743\u91cd\u5408\u8ba1\u4e0d\u7b49\u4e8e100%\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BidProjectOperationServicePlugin_63", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            if (!BidOpenTypeEnum.MULTI.getValue().equals(docType)) continue;
                            if (technicalSum.compareTo(BigDecimal.ZERO) == 0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5fc5\u987b\u5b58\u5728\u6280\u672f\u6807\u90e8\u5206", (String)"BidProjectOperationServicePlugin_61", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                            if (commercialSum.compareTo(BigDecimal.ZERO) != 0) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5fc5\u987b\u5b58\u5728\u5546\u52a1\u6807\u90e8\u5206", (String)"BidProjectOperationServicePlugin_62", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (!ScoreType.PART.getVal().equals(scoretype)) continue;
                        if (ScoreMode.STANDARD.getVal().equals(scoremode)) {
                            if (EvalItemType.TECHNICAL.getVal().equals(type)) {
                                if (technicalSum.compareTo(oneHundredNumber) == 0) continue;
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u6280\u672f\u6807\u90e8\u5206\u603b\u5206\u4e0d\u7b49\u4e8e100\u5206\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BidProjectOperationServicePlugin_64", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            if (!EvalItemType.COMMERCIAL.getVal().equals(type) || commercialSum.compareTo(oneHundredNumber) == 0) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5546\u52a1\u6807\u90e8\u5206\u603b\u5206\u4e0d\u7b49\u4e8e100\u5206\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BidProjectOperationServicePlugin_65", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (EvalItemType.TECHNICAL.getVal().equals(type)) {
                            if (technicalSum.compareTo(oneNumber) == 0) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u6280\u672f\u6807\u90e8\u5206\u6743\u91cd\u5408\u8ba1\u4e0d\u7b49\u4e8e100%\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BidProjectOperationServicePlugin_66", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (!EvalItemType.COMMERCIAL.getVal().equals(type) || commercialSum.compareTo(oneNumber) == 0) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5546\u52a1\u6807\u90e8\u5206\u6743\u91cd\u5408\u8ba1\u4e0d\u7b49\u4e8e100%\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BidProjectOperationServicePlugin_67", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                } else {
                    BigDecimal comWeight;
                    BigDecimal techWeight = bidProjectData.getBigDecimal("techweight");
                    BigDecimal sumWeight = techWeight.add(comWeight = bidProjectData.getBigDecimal("comweight"));
                    if (sumWeight.compareTo(new BigDecimal("1")) != 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6280\u672f\u6807\u6743\u91cd\u4e0e\u5546\u52a1\u6807\u6743\u91cd\u4e4b\u548c\u4e0d\u7b49\u4e8e1\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidProjectOperationServicePlugin_68", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        }

        private void validateContent4SingleSection(ExtendedDataEntity dataEntity, DynamicObjectCollection purDetails, String flag) {
            for (int j = 0; j < purDetails.size(); ++j) {
                BigDecimal actualQty;
                String content;
                DynamicObject purDetail = (DynamicObject)purDetails.get(j);
                if (purDetail == null) continue;
                if (flag != null && !flag.equals("true") && StringUtils.isBlank((CharSequence)(content = purDetail.getString("purentrycontent")))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u660e\u7ec6\u4fe1\u606f\u4e2d\u7b2c%s\u884c\u201c\u62db\u6807\u5185\u5bb9\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_69", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(j + 1)));
                    continue;
                }
                if (flag == null || !flag.equals("true")) continue;
                String materialid = purDetail.getString("materialid");
                String bidType = dataEntity.getDataEntity().getString("bidtype");
                if (!BidTypeEnum.RESOURCE.getValue().equalsIgnoreCase(bidType) && StringUtils.isBlank((CharSequence)materialid)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u660e\u7ec6\u4fe1\u606f\u4e2d\u7b2c%s\u884c\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_70", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(j + 1)));
                    continue;
                }
                String qty = purDetail.getString("qty");
                if (StringUtils.isBlank((CharSequence)qty)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u660e\u7ec6\u4fe1\u606f\u4e2d\u7b2c%s\u884c\u201c\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_71", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(j + 1)));
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)qty) || (actualQty = new BigDecimal(qty)).compareTo(BigDecimal.ZERO) != 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u660e\u7ec6\u4fe1\u606f\u4e2d\u7b2c%s\u884c\u201c\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_71", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(j + 1)));
            }
        }

        private void validateContent4MultiSection(ExtendedDataEntity dataEntity, String name, DynamicObjectCollection purDetails, String flag) {
            for (int j = 0; j < purDetails.size(); ++j) {
                BigDecimal actualQty;
                String content;
                DynamicObject purDetail = (DynamicObject)purDetails.get(j);
                if (purDetail == null) continue;
                if (flag != null && !flag.equals("true") && StringUtils.isBlank((CharSequence)(content = purDetail.getString("purentrycontent")))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6807\u6bb5[%1$s]\u5bf9\u5e94\u7684\u91c7\u8d2d\u660e\u7ec6\u4fe1\u606f\u4e2d\u7b2c%2$s\u884c\u201c\u62db\u6807\u5185\u5bb9\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_72", (String)"scm-bid-opplugin", (Object[])new Object[0]), name, String.valueOf(j + 1)));
                    continue;
                }
                if (flag == null || !flag.equals("true")) continue;
                String materialid = purDetail.getString("materialid");
                String bidType = dataEntity.getDataEntity().getString("bidtype");
                if (!BidTypeEnum.RESOURCE.getValue().equalsIgnoreCase(bidType) && StringUtils.isBlank((CharSequence)materialid)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6807\u6bb5\u201c%s\u201d\u5bf9\u5e94\u7684\u91c7\u8d2d\u660e\u7ec6\u4fe1\u606f\u4e2d\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_73", (String)"scm-bid-opplugin", (Object[])new Object[0]), name));
                    continue;
                }
                String qty = purDetail.getString("qty");
                if (StringUtils.isBlank((CharSequence)qty)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6807\u6bb5\u201c%s\u201d\u5bf9\u5e94\u7684\u91c7\u8d2d\u660e\u7ec6\u4fe1\u606f\u4e2d\u201c\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_74", (String)"scm-bid-opplugin", (Object[])new Object[0]), name));
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)qty) || (actualQty = new BigDecimal(qty)).compareTo(BigDecimal.ZERO) != 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6807\u6bb5\u201c%s\u201d\u5bf9\u5e94\u7684\u91c7\u8d2d\u660e\u7ec6\u4fe1\u606f\u4e2d\u201c\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidProjectOperationServicePlugin_74", (String)"scm-bid-opplugin", (Object[])new Object[0]), name));
            }
        }

        private void validateRespBusiness(ExtendedDataEntity dataEntity) {
            boolean flag;
            String businessMember;
            boolean isBidProject = (Boolean)dataEntity.getValue("bidproject");
            boolean isSupplierInvitation = (Boolean)dataEntity.getValue("supplierinvitation");
            boolean isBidDocument = (Boolean)dataEntity.getValue("biddocument");
            boolean isBidPublish = (Boolean)dataEntity.getValue("bidpublish");
            boolean isBidOpen = (Boolean)dataEntity.getValue("bidopen");
            boolean isBidEvaluation = (Boolean)dataEntity.getValue("bidevaluation");
            boolean isBidBustalk = (Boolean)dataEntity.getValue("bidbustalk");
            boolean isBidDecision = (Boolean)dataEntity.getValue("biddecision");
            boolean isBidAnwser = (Boolean)dataEntity.getValue("bidanswerquestion");
            boolean isClarificaiton = (Boolean)dataEntity.getValue("clarificaiton");
            boolean isBidBottomMake = (Boolean)dataEntity.getValue("bidbottommake");
            boolean isSeparateDoc = (Boolean)dataEntity.getValue("isseparatedoc");
            String appId = dataEntity.getDataEntity().getString("entitytypeid").split("_")[0];
            boolean hasBidClear = "rebm".equals(appId);
            boolean isBidClear = false;
            if (hasBidClear) {
                isBidClear = (Boolean)dataEntity.getValue("isenablelist");
            }
            String docTypeStr = (String)dataEntity.getValue("doctype");
            String bidOpenType = (String)dataEntity.getValue("bidopentype");
            LinkedHashMap<String, Boolean> mapping = new LinkedHashMap<String, Boolean>();
            mapping.put("BidProject", isBidProject);
            mapping.put("SupplierInvitation", isSupplierInvitation);
            mapping.put("BidDocument", isBidDocument);
            mapping.put("BidPublish", isBidPublish);
            mapping.put("BidOpen", isBidOpen);
            mapping.put("BidEvaluation", isBidEvaluation);
            mapping.put("BidBustalk", isBidBustalk);
            mapping.put("BidDecision", isBidDecision);
            mapping.put("BidAnswerQuestion", isBidAnwser);
            mapping.put("BidClear", isBidClear);
            mapping.put("Clarificaiton", isClarificaiton);
            mapping.put("BidBottomMake", isBidBottomMake);
            String[] rbs = mapping.entrySet().stream().filter(Map.Entry::getValue).map(entry -> {
                String rp = null;
                String k = (String)entry.getKey();
                if ("BidDocument".equals(k)) {
                    if (isSeparateDoc) {
                        if (BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr)) {
                            rp = RespBusiness.TechnicalDoc.getVal() + "," + RespBusiness.CommercialDoc.getVal();
                        } else if (BidOpenTypeEnum.TECHNICAL.getValue().equals(docTypeStr)) {
                            rp = RespBusiness.TechnicalDoc.getVal();
                        } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr)) {
                            rp = RespBusiness.CommercialDoc.getVal();
                        }
                    } else {
                        rp = RespBusiness.RespCreateDoc.getVal();
                    }
                    return rp;
                }
                if ("BidOpen".equals(k)) {
                    rp = !BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenType) ? (StringUtils.isBlank((CharSequence)bidOpenType) ? RespBusiness.BidOpen.getVal() : RespBusiness.TechnicalOpen.getVal() + "," + RespBusiness.BusinessOpen.getVal()) : RespBusiness.BidOpen.getVal();
                    return rp;
                }
                if ("BidEvaluation".equals(k)) {
                    rp = !BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenType) ? (StringUtils.isBlank((CharSequence)bidOpenType) ? RespBusiness.BidEvaluation.getVal() : RespBusiness.TechnicalEval.getVal() + "," + RespBusiness.BusinessEval.getVal()) : RespBusiness.BidEvaluation.getVal();
                    return rp;
                }
                return RespBusiness.valueOf((String)k).getVal();
            }).collect(Collectors.joining(",")).split(",");
            Set rb4Pro = Arrays.stream(rbs).distinct().collect(Collectors.toSet());
            DynamicObjectCollection members = (DynamicObjectCollection)dataEntity.getValue("memberentity");
            DynamicObjectCollection leaders = (DynamicObjectCollection)dataEntity.getValue("memberleaderentity");
            Set memberRb4Pro = Arrays.stream(members.stream().map(member -> member.getString("respbusiness")).collect(Collectors.joining(",")).split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            for (String num : rb4Pro) {
                if (memberRb4Pro.contains(num)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62db\u6807\u5c0f\u7ec4\u6210\u5458\u5361\u7247\u4e2d\u5b58\u5728\u672a\u8bbe\u7f6e\u7ecf\u529e\u4eba\u7684\u4e1a\u52a1\u6b65\u9aa4\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BidProjectOperationServicePlugin_75", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                break;
            }
            for (DynamicObject member2 : members) {
                businessMember = member2.getString("respbusiness");
                boolean isdirector = member2.getBoolean("isdirector");
                if (isdirector || businessMember != null && !businessMember.equals("")) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62db\u6807\u7ecf\u529e\u5c0f\u7ec4\u6210\u5458\u5361\u7247\u4e2d\u5b58\u5728\u672a\u8bbe\u7f6e\u4e1a\u52a1\u6b65\u9aa4\u7684\u7ecf\u529e\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BidProjectOperationServicePlugin_87", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                break;
            }
            for (DynamicObject leader : leaders) {
                businessMember = leader.getString("respbusinessleader");
                if (businessMember != null && !businessMember.equals("")) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62db\u6807\u9886\u5bfc\u5c0f\u7ec4\u6210\u5458\u5361\u7247\u4e2d\u5b58\u5728\u672a\u8bbe\u7f6e\u4e1a\u52a1\u6b65\u9aa4\u7684\u9886\u5bfc\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BidProjectOperationServicePlugin_86", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                break;
            }
            BigDecimal tenderfee = new BigDecimal(0);
            String chargingstage = "";
            if (null == dataEntity.getValue("tenderfee")) {
                DynamicObject bidproject = dataEntity.getDataEntity();
                tenderfee = bidproject.getBigDecimal("tenderfee");
                chargingstage = bidproject.getString("chargingstage");
            } else {
                tenderfee = (BigDecimal)dataEntity.getValue("tenderfee");
                chargingstage = dataEntity.getValue("chargingstage").toString();
            }
            boolean bl = flag = tenderfee.compareTo(BigDecimal.ZERO) > 0 || !"notstage".equals(chargingstage);
            if (flag) {
                boolean b = false;
                RespBusiness rb = RespBusiness.valueOf((String)"BidPay");
                for (int i = 0; i < members.size(); ++i) {
                    DynamicObject member3 = (DynamicObject)members.get(i);
                    String respbusiness = member3.getString("respbusiness");
                    if (!StringUtils.isNotEmpty((CharSequence)respbusiness) || respbusiness.indexOf(rb.getVal()) < 0) continue;
                    b = true;
                    break;
                }
                if (!b) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u4fe1\u606f\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u7f34\u8d39\u7ecf\u529e\u4eba\u3002", (String)"BidProjectOperationServicePlugin_76", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }

        private void validateRespBusiness4Save(ExtendedDataEntity dataEntity) {
            DynamicObjectCollection memberEntries = (DynamicObjectCollection)dataEntity.getValue("memberentity");
            boolean flag = false;
            for (int i = 0; i < memberEntries.size(); ++i) {
                DynamicObject entry = (DynamicObject)memberEntries.get(i);
                String respBusi = entry.getString("respbusiness");
                DynamicObject user = entry.getDynamicObject("user");
                if (respBusi != null && respBusi.contains("01")) {
                    flag = true;
                    if (user == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62db\u6807\u5c0f\u7ec4\u6210\u5458\u5361\u7247\u4e2d\u5b58\u5728\u672a\u8bbe\u7f6e\u7ecf\u529e\u4eba\u7684\u4e1a\u52a1\u6b65\u9aa4\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BidProjectOperationServicePlugin_75", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                }
                if (StringUtils.isEmpty((CharSequence)respBusi) || user != null) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62db\u6807\u5c0f\u7ec4\u6210\u5458\u5361\u7247\u4e2d\u5b58\u5728\u672a\u8bbe\u7f6e\u7ecf\u529e\u4eba\u7684\u4e1a\u52a1\u6b65\u9aa4\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BidProjectOperationServicePlugin_75", (String)"scm-bid-opplugin", (Object[])new Object[0]));
            }
            if (!flag) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62db\u6807\u5c0f\u7ec4\u6210\u5458\u5361\u7247\u4e2d\u5b58\u5728\u672a\u8bbe\u7f6e\u7ecf\u529e\u4eba\u7684\u4e1a\u52a1\u6b65\u9aa4\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BidProjectOperationServicePlugin_75", (String)"scm-bid-opplugin", (Object[])new Object[0]));
            }
        }

        private void validInvitationSend(ExtendedDataEntity dataEntity) {
            DynamicObject model = dataEntity.getDataEntity();
            DynamicObjectCollection sectionEntryColl = model.getDynamicObjectCollection("bidrollsection");
            block0: for (DynamicObject sectionEntry : sectionEntryColl) {
                DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryColl) {
                    String invitationStatus = supplierEntry.getString("invitationstatus");
                    if ("UNSEND".equals(invitationStatus)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u7acb\u9879\u5df2\u53d1\u9001\u9080\u8bf7\u51fd\u5230\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838", (String)"BidProjectOperationServicePlugin_77", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    continue block0;
                }
            }
        }
    }
}

