/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BidProjectSumOrUnsumOPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("submittor");
        e.getFieldKeys().add("submittime");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("entitytypeid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                String operateKey = this.getOperateKey();
                if (!StringUtils.equals((CharSequence)"unaudit", (CharSequence)operateKey)) {
                    return;
                }
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject entity = dataEntity.getDataEntity();
                    DynamicObject bidproject = entity.getDynamicObject("bidproject");
                    bidproject = BusinessDataServiceHelper.loadSingle((Object)bidproject.getPkValue(), (String)"bid_project");
                    String entitytypeid = bidproject.getString("entitytypeid");
                    String appId = "bid";
                    if (entitytypeid.startsWith("rebm")) {
                        appId = "rebm";
                    }
                    QFilter bidqFilter = new QFilter("bidproject", "=", bidproject.getPkValue());
                    QFilterUtil.Filter costtypeFilter = new QFilterUtil.Filter("costtype", "=", (Object)"02");
                    boolean exists = QueryServiceHelper.exists((String)(appId + "_refund_pay"), (QFilter[])new QFilter[]{bidqFilter, costtypeFilter});
                    if (!exists) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u9000\u8d39\u8bb0\u5f55\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidProjectSumOrUnsumOPlugin_0", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if ("unaudit".equals(key)) {
            datas[0].set("submittor", (Object)0);
            datas[0].set("submittime", (Object)"");
            datas[0].set("auditor", (Object)0);
            datas[0].set("auditdate", (Object)"");
        }
    }
}

