/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.IProficientService;
import kd.scm.bid.business.basedata.serviceImpl.ProficientServiceImpl;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.IBidSupplierFileService;
import kd.scm.bid.business.bill.IOnlineBidEvalService;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidSupplierFileServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.OnlineBidEvalServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.business.helper.BidStepInteractiveHelper;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.bid.common.util.BidMessageUtil;
import kd.scm.bid.opplugin.bill.util.BidProjectQueryUtil;

public class BidSupplierInvalAuditOp
extends AbstractOperationServicePlugIn {
    protected IBidOpenService bidOpenService = new BidOpenServiceImpl();
    protected IBidProjectService bidProjectService = new BidProjectServiceImpl();
    protected IBidSupplierFileService bidSupplierFileService = new BidSupplierFileServiceImpl();
    protected IProficientService proficientService = new ProficientServiceImpl();
    protected IOnlineBidEvalService onlineBidEvalService = new OnlineBidEvalServiceImpl();
    protected IBidProjectService projectService = new BidProjectServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bidopenid");
        fieldKeys.add("bidsection");
        fieldKeys.add("sectionname");
        fieldKeys.add("supplierentry");
        fieldKeys.add("supplier");
        fieldKeys.add("supplier_isinvalid");
        fieldKeys.add("supplier_invalidreason");
        fieldKeys.add("isonlineeval");
        fieldKeys.add("bidproject");
        fieldKeys.add("entitytypeid");
        fieldKeys.add("createtime");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new Validator4SaleCheck());
    }

    protected DynamicObject separateBidOpenCheck(DynamicObject project, String openType, DynamicObject dataEntity) {
        long openId = dataEntity.getLong("bidopenid");
        DynamicObject bidOpen = QueryServiceHelper.queryOne((String)(this.getAppId(dataEntity) + "bidopen"), (String)"opentype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)openId)});
        String opentype = bidOpen.getString("opentype");
        DynamicObject nextStepOpen = null;
        if ("TECHBUSINESS".equals(openType)) {
            nextStepOpen = "BUSSINESS".equals(opentype) ? null : QueryServiceHelper.queryOne((String)(this.getAppId(dataEntity) + "bidopen"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("opentype", "=", (Object)"BUSSINESS")});
        } else if ("BUSSINESSTECH".equals(openType)) {
            nextStepOpen = "TECHNICAL".equals(opentype) ? null : QueryServiceHelper.queryOne((String)(this.getAppId(dataEntity) + "bidopen"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("opentype", "=", (Object)"TECHNICAL")});
        }
        return nextStepOpen;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[i];
            this.reWriteBidOpenEntryData(dataEntity, e);
        }
    }

    protected void reWriteBidOpenEntryData(DynamicObject dataEntity, BeginOperationTransactionArgs event) {
        String operationKey = event.getOperationKey();
        long bidOpenId = dataEntity.getLong("bidopenid");
        String selectedProperties = String.join((CharSequence)",", "bidproject", "bidsection", "sectionname", "supplierentry", "supplier", "supplier_isinvalid", "supplier_invalidreason");
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)(this.getAppId(dataEntity) + "bidopen"), (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidOpenId), new QFilter("billstatus", "=", (Object)"O")});
        if (bidOpen == null) {
            return;
        }
        HashMap invalEntry = new HashMap();
        DynamicObjectCollection section = dataEntity.getDynamicObjectCollection("bidsection");
        section.forEach(e -> {
            String sectionName = e.getString("sectionname");
            DynamicObjectCollection supplierEntry = e.getDynamicObjectCollection("supplierentry");
            supplierEntry.forEach(row -> {
                Object rowId = row.getDynamicObject("supplier").getPkValue();
                invalEntry.put(sectionName + rowId, row);
            });
        });
        DynamicObjectCollection openSectionEntry = bidOpen.getDynamicObjectCollection("bidsection");
        openSectionEntry.forEach(e -> {
            String openSectionName = e.getString("sectionname");
            DynamicObjectCollection openSuppleirEntry = e.getDynamicObjectCollection("supplierentry");
            openSuppleirEntry.forEach(r -> {
                Object pkValue = r.getDynamicObject("supplier").getPkValue();
                DynamicObject supplierRow = (DynamicObject)invalEntry.get(openSectionName + pkValue);
                if (supplierRow != null) {
                    if ("audit".equals(operationKey)) {
                        r.set("supplier_isinvalid", (Object)Boolean.TRUE);
                        r.set("supplier_invalidreason", supplierRow.get("supplier_invalidreason"));
                    } else {
                        r.set("supplier_isinvalid", (Object)Boolean.FALSE);
                        r.set("supplier_invalidreason", null);
                    }
                }
            });
        });
        SaveServiceHelper.update((DynamicObject)bidOpen);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[i];
            if (!"audit".equals(operationKey) && !"unaudit".equals(operationKey)) continue;
            this.deleteNextStepBill(dataEntity);
            this.createNextStepBill(dataEntity);
        }
    }

    protected DynamicObject getBidmode(DynamicObject dataEntity) {
        DynamicObject project = dataEntity.getDynamicObject("bidproject");
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)(this.getAppId(dataEntity) + "project"), (String)"bidmode");
        return BusinessDataServiceHelper.loadSingle((Object)bidProject.getDynamicObject("bidmode").getPkValue(), (String)(this.getAppId(dataEntity) + "bidmode"));
    }

    protected void deleteNextStepBill(DynamicObject dataEntity) {
        String entityType = this.getAppId(dataEntity);
        DynamicObject bidmode = this.getBidmode(dataEntity);
        boolean hasEvaluation = bidmode.getBoolean("bidevaluation");
        boolean hasBustalk = bidmode.getBoolean("bidbustalk");
        if (hasEvaluation) {
            this.deleteEvaluation(dataEntity, entityType);
        } else {
            if (hasBustalk) {
                DeleteServiceHelper.delete((String)(entityType + "bustalk"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", dataEntity.getDynamicObject("bidproject").getPkValue()), new QFilter("billstatus", "=", (Object)"D")});
            }
            DeleteServiceHelper.delete((String)(entityType + "decision"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", dataEntity.getDynamicObject("bidproject").getPkValue()), new QFilter("billstatus", "=", (Object)"D")});
        }
    }

    protected void deleteEvaluation(DynamicObject dataEntity, String entityType) {
        QFilter[] qfilters = new QFilter[]{new QFilter("bidopenid", "=", (Object)dataEntity.getLong("bidopenid")), new QFilter("billstatus", "=", (Object)"D")};
        long evalId = 0L;
        DynamicObject bidEvaluation = QueryServiceHelper.queryOne((String)(entityType + "bidevaluation"), (String)"id", (QFilter[])qfilters);
        if (bidEvaluation == null) {
            return;
        }
        evalId = bidEvaluation.getLong("id");
        DeleteServiceHelper.delete((String)(entityType + "bidevaluationentry"), (QFilter[])new QFilter[]{new QFilter("bidevaluation", "=", (Object)evalId)});
        DeleteServiceHelper.delete((String)(entityType + "bidevalscoredetail"), (QFilter[])new QFilter[]{new QFilter("bidevaluation", "=", (Object)evalId)});
        DeleteServiceHelper.delete((String)(entityType + "bidevaluation"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)evalId)});
        boolean isOnlineEval = dataEntity.getBoolean("isonlineeval");
        if (isOnlineEval) {
            DynamicObjectCollection onlineEvalCol = QueryServiceHelper.query((String)(entityType + "onlinebideval"), (String)"id", (QFilter[])qfilters);
            if (onlineEvalCol == null || onlineEvalCol.size() <= 0) {
                return;
            }
            ArrayList<Long> evalIdList = new ArrayList<Long>();
            for (DynamicObject onlineEval : onlineEvalCol) {
                evalIdList.add(onlineEval.getLong("id"));
            }
            DeleteServiceHelper.delete((String)(entityType + "onlinesupplierdetail"), (QFilter[])new QFilter[]{new QFilter("onlinebideval", "in", evalIdList)});
            DeleteServiceHelper.delete((String)(entityType + "onlinescoredetail"), (QFilter[])new QFilter[]{new QFilter("onlinebideval", "in", evalIdList)});
            DeleteServiceHelper.delete((String)(entityType + "onlinebideval"), (QFilter[])new QFilter[]{new QFilter("id", "in", evalIdList)});
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("bidevaluationid", "=", (Object)evalId)};
        if (QueryServiceHelper.exists((String)(entityType + "multiquestclarify"), (QFilter[])qFilters)) {
            DeleteServiceHelper.delete((String)(entityType + "multiquestclarify"), (QFilter[])qFilters);
        } else if (QueryServiceHelper.exists((String)(entityType + "questionclarify"), (QFilter[])qFilters)) {
            DeleteServiceHelper.delete((String)(entityType + "questionclarify"), (QFilter[])qFilters);
        }
    }

    protected void createNextStepBill(DynamicObject dataEntity) {
        DynamicObject tempOpen;
        QFilter qFilter;
        boolean isOnlineEval;
        Long profiId;
        DynamicObject proficient;
        DynamicObjectCollection profis;
        HashSet<Long> bidProjectIDSet = new HashSet<Long>();
        Long id = dataEntity.getLong("bidopenid");
        String appId = dataEntity.getString("entitytypeid");
        DynamicObject bidopen = this.bidOpenService.getBidOpenByIdAndType(id, appId);
        String openType = bidopen.getString("opentype");
        Long projectId = bidopen.getLong("bidproject.id");
        DynamicObject project = this.bidProjectService.getBidProjectAllById(projectId);
        String bidOpenSelectType = project.getString("bidopentype");
        BidStepEnum[] steps = BidStepInteractiveHelper.getNextStep((DynamicObject)project, (BidStepEnum)BidStepEnum.BidOpen);
        boolean isNextDecision = false;
        for (BidStepEnum step : steps) {
            if (BidStepEnum.BidDecision != step) continue;
            isNextDecision = true;
        }
        if (isNextDecision) {
            if (BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenSelectType)) {
                this.bidOpenService.createNextStep(project, BidStepEnum.BidOpen);
                this.bidProjectService.saveCurrentBidStep((Object)bidopen.getLong("bidproject.id"), steps);
                profis = bidopen.getDynamicObjectCollection("bidopen_proficient");
                for (DynamicObject profi : profis) {
                    proficient = profi.getDynamicObject("proficient");
                    profiId = proficient.getLong("id");
                    this.proficientService.insertProficientProByIds(profiId, project);
                }
                isOnlineEval = bidopen.getBoolean("isonlineeval");
                if (isOnlineEval) {
                    this.onlineBidEvalService.createByLastStep(project);
                }
                bidProjectIDSet.add(projectId);
            } else if (BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidOpenSelectType) && BidOpenTypeEnum.BUSSINESS.getValue().equals(openType)) {
                this.bidOpenService.createNextStep(project, BidStepEnum.BidOpen);
                this.bidProjectService.saveCurrentBidStep((Object)bidopen.getLong("bidproject.id"), steps);
                profis = bidopen.getDynamicObjectCollection("bidopen_proficient");
                for (DynamicObject profi : profis) {
                    proficient = profi.getDynamicObject("proficient");
                    profiId = proficient.getLong("id");
                    this.proficientService.insertProficientProByIds(profiId, project);
                }
                isOnlineEval = bidopen.getBoolean("isonlineeval");
                if (isOnlineEval) {
                    this.onlineBidEvalService.createByLastStep(project);
                }
                bidProjectIDSet.add(projectId);
            } else if (BidOpenSelectTypeEnum.BUSSINESSTECH.getValue().equals(bidOpenSelectType) && BidOpenTypeEnum.TECHNICAL.getValue().equals(openType)) {
                this.bidOpenService.createNextStep(project, BidStepEnum.BidOpen);
                this.bidProjectService.saveCurrentBidStep((Object)bidopen.getLong("bidproject.id"), steps);
                profis = bidopen.getDynamicObjectCollection("bidopen_proficient");
                for (DynamicObject profi : profis) {
                    proficient = profi.getDynamicObject("proficient");
                    profiId = proficient.getLong("id");
                    this.proficientService.insertProficientProByIds(profiId, project);
                }
                isOnlineEval = bidopen.getBoolean("isonlineeval");
                if (isOnlineEval) {
                    this.onlineBidEvalService.createByLastStep(project);
                }
                bidProjectIDSet.add(projectId);
            }
        } else {
            this.bidOpenService.createNextStep(project, BidStepEnum.BidOpen);
            this.bidProjectService.saveCurrentBidStep((Object)bidopen.getLong("bidproject.id"), new BidStepEnum[]{steps[0]});
            profis = bidopen.getDynamicObjectCollection("bidopen_proficient");
            for (DynamicObject profi : profis) {
                proficient = profi.getDynamicObject("proficient");
                profiId = proficient.getLong("id");
                this.proficientService.insertProficientProByIds(profiId, project);
            }
            isOnlineEval = bidopen.getBoolean("isonlineeval");
            if (isOnlineEval) {
                this.onlineBidEvalService.createByLastStep(project);
            }
            bidProjectIDSet.add(projectId);
        }
        String openSelectType = bidopen.getString("bidproject.bidopentype");
        MainEntityType newOneType = EntityMetadataCache.getDataEntityType((String)(appId + "_bidopen"));
        MainEntityType t = EntityMetadataCache.getDataEntityType((String)"bid_supplier_file");
        if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)openSelectType)) {
            if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)openType)) {
                qFilter = new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue());
                qFilter = qFilter.and(new QFilter("bidproject", "=", project.getPkValue()));
                qFilter = qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()));
                tempOpen = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{qFilter});
                DynamicObject curOpenBill = BusinessDataServiceHelper.loadSingle((Object)bidopen.getPkValue(), (DynamicObjectType)bidopen.getDynamicObjectType());
                DynamicObject openBill = BusinessDataServiceHelper.loadSingle((Object)tempOpen.getPkValue(), (DynamicObjectType)curOpenBill.getDynamicObjectType());
                DynamicObjectCollection sectionEntry = openBill.getDynamicObjectCollection("bidsection");
                DynamicObjectCollection curSectionEntry = curOpenBill.getDynamicObjectCollection("bidsection");
                openBill.set("evaluatedmethod", (Object)bidopen.getString("evaluatedmethod"));
                for (int i = 0; i < sectionEntry.size(); ++i) {
                    DynamicObject sectionEntryRow = (DynamicObject)sectionEntry.get(i);
                    DynamicObject curSectionEntryRow = (DynamicObject)curSectionEntry.get(i);
                    DynamicObjectCollection supplierEntry = sectionEntryRow.getDynamicObjectCollection("supplierentry");
                    DynamicObjectCollection curSupplierEntry = curSectionEntryRow.getDynamicObjectCollection("supplierentry");
                    supplierEntry.clear();
                    for (DynamicObject curSupplierEntryRow : curSupplierEntry) {
                        DynamicObject supplierEntryRow = new DynamicObject((DynamicObjectType)newOneType.getAllEntities().get("supplierentry"));
                        boolean isTender = curSupplierEntryRow.getBoolean("supplier_istender");
                        boolean isInvalid = curSupplierEntryRow.getBoolean("supplier_isinvalid");
                        DynamicObject supplier = curSupplierEntryRow.getDynamicObject("supplier");
                        if (!isTender || isInvalid || supplier == null) continue;
                        Long supId = ID.genLongId();
                        supplierEntryRow.set("id", (Object)supId);
                        supplierEntryRow.set("seq", curSupplierEntryRow.get("seq"));
                        supplierEntryRow.set("supplier", (Object)curSupplierEntryRow.getDynamicObject("supplier"));
                        supplierEntryRow.set("suppliercontact", (Object)curSupplierEntryRow.getString("suppliercontact"));
                        supplierEntryRow.set("contactphone", (Object)curSupplierEntryRow.getString("contactphone"));
                        supplierEntryRow.set("supplier_deposittype", (Object)curSupplierEntryRow.getString("supplier_deposittype"));
                        supplierEntryRow.set("supplier_deposit", (Object)curSupplierEntryRow.getBigDecimal("supplier_deposit"));
                        supplierEntryRow.set("supplier_istender", (Object)curSupplierEntryRow.getBoolean("supplier_istender"));
                        supplierEntryRow.set("supplier_tenderdate", (Object)curSupplierEntryRow.getDate("supplier_tenderdate"));
                        supplierEntryRow.set("supplier_manager", (Object)curSupplierEntryRow.getString("supplier_manager"));
                        supplierEntryRow.set("supplier_workday", (Object)curSupplierEntryRow.getInt("supplier_workday"));
                        this.copyAttach(supplierEntryRow.getDynamicObjectCollection("supplier_techattach"), curSupplierEntryRow.getDynamicObjectCollection("supplier_techattach"));
                        this.copyAttach(supplierEntryRow.getDynamicObjectCollection("supplier_comattach"), curSupplierEntryRow.getDynamicObjectCollection("supplier_comattach"));
                        this.copyAttach(supplierEntryRow.getDynamicObjectCollection("supplier_tenattach"), curSupplierEntryRow.getDynamicObjectCollection("supplier_tenattach"));
                        this.copyAttach(supplierEntryRow.getDynamicObjectCollection("supplier_otherattach"), curSupplierEntryRow.getDynamicObjectCollection("supplier_otherattach"));
                        supplierEntryRow.set("supplier_tenderprice", (Object)curSupplierEntryRow.getBigDecimal("supplier_tenderprice"));
                        supplierEntryRow.set("supplier_taxrate", (Object)curSupplierEntryRow.getBigDecimal("supplier_taxrate"));
                        supplierEntryRow.set("supplier_pricevat", (Object)curSupplierEntryRow.getBigDecimal("supplier_pricevat"));
                        supplierEntryRow.set("supplier_exceptvat", (Object)curSupplierEntryRow.getBigDecimal("supplier_exceptvat"));
                        supplierEntryRow.set("supplier_rate", (Object)curSupplierEntryRow.getBigDecimal("supplier_rate"));
                        supplierEntryRow.set("supplier_revokebidnumber", (Object)curSupplierEntryRow.getInt("supplier_revokebidnumber"));
                        supplierEntryRow.set("supplier_ip", (Object)curSupplierEntryRow.getString("supplier_ip"));
                        supplierEntryRow.set("isnew", (Object)curSupplierEntryRow.getString("isnew"));
                        supplierEntryRow.set("isfromproject", (Object)curSupplierEntryRow.getString("isfromproject"));
                        supplierEntryRow.set("supplier_isfrombackbid", (Object)curSupplierEntryRow.getString("supplier_isfrombackbid"));
                        supplierEntryRow.set("supplier_illustration", (Object)curSupplierEntryRow.getString("supplier_illustration"));
                        supplierEntryRow.set("supplier_isinvalid", (Object)curSupplierEntryRow.getBoolean("supplier_isinvalid"));
                        supplierEntryRow.set("supplier_invalidreason", (Object)curSupplierEntryRow.getString("supplier_invalidreason"));
                        supplierEntryRow.set("supplier_comment", (Object)curSupplierEntryRow.getString("supplier_comment"));
                        DynamicObject file4Tech = this.bidSupplierFileService.getOneFileRecordByIds((Long)curSupplierEntryRow.getDynamicObject("supplier").getPkValue(), (Long)curSectionEntryRow.getPkValue(), "techFile", "id,status");
                        DynamicObject file = new DynamicObject((DynamicObjectType)t);
                        file.set("sectionid", sectionEntryRow.getPkValue());
                        file.set("supplierid", curSupplierEntryRow.getDynamicObject("supplier").getPkValue());
                        file.set("type", (Object)"techFile");
                        long fid = ID.genLongId();
                        file.set("id", (Object)fid);
                        if (file4Tech != null) {
                            try (TXHandle h = TX.requiresNew();){
                                try {
                                    BidFileHelper.copyFileFromAToB((String)(appId + "_supplier_file"), (Object)file4Tech.get("id"), (String)"attachmentpanelap", (String)(appId + "_supplier_file"), (Object)fid, (String)"attachmentpanelap");
                                }
                                catch (Throwable ex) {
                                    h.markRollback();
                                    throw ex;
                                }
                            }
                        }
                        BusinessDataServiceHelper.save((IDataEntityType)t, (Object[])new DynamicObject[]{file});
                        supplierEntry.add((Object)supplierEntryRow);
                    }
                    DynamicObjectCollection curSupplierDetail = curSectionEntryRow.getDynamicObjectCollection("supplierdetail");
                    DynamicObjectCollection supplierDetail = sectionEntryRow.getDynamicObjectCollection("supplierdetail");
                    supplierDetail.clear();
                    for (DynamicObject curSupplierDetailRow : curSupplierDetail) {
                        DynamicObject supplierDetailRow = new DynamicObject((DynamicObjectType)newOneType.getAllEntities().get("supplierdetail"));
                        supplierDetailRow.set("seq", curSupplierDetailRow.get("seq"));
                        supplierDetailRow.set("pursupplier", (Object)curSupplierDetailRow.getDynamicObject("pursupplier"));
                        supplierDetailRow.set("purentrycontent", (Object)curSupplierDetailRow.getString("purentrycontent"));
                        supplierDetailRow.set("purentryproject", (Object)curSupplierDetailRow.getDynamicObject("purentryproject"));
                        supplierDetailRow.set("materialid", (Object)curSupplierDetailRow.getDynamicObject("materialid"));
                        supplierDetailRow.set("materialdes", (Object)curSupplierDetailRow.getString("materialdes"));
                        supplierDetailRow.set("qty", (Object)curSupplierDetailRow.getBigDecimal("qty"));
                        supplierDetailRow.set("inclutaxprice", (Object)curSupplierDetailRow.getBigDecimal("inclutaxprice"));
                        supplierDetailRow.set("inclutaxamount", (Object)curSupplierDetailRow.getBigDecimal("inclutaxamount"));
                        supplierDetailRow.set("taxrate", (Object)curSupplierDetailRow.getBigDecimal("taxrate"));
                        supplierDetailRow.set("taxamount", (Object)curSupplierDetailRow.getBigDecimal("taxamount"));
                        supplierDetailRow.set("excepttaxamount", (Object)curSupplierDetailRow.getBigDecimal("excepttaxamount"));
                        supplierDetailRow.set("costrate", (Object)curSupplierDetailRow.getBigDecimal("costrate"));
                        supplierDetail.add((Object)supplierDetailRow);
                    }
                }
                SaveServiceHelper.save((IDataEntityType)openBill.getDataEntityType(), (Object[])new DynamicObject[]{openBill});
            }
        } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)openSelectType) && StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)openType)) {
            qFilter = new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
            qFilter = qFilter.and(new QFilter("bidproject", "=", project.getPkValue()));
            qFilter = qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()));
            tempOpen = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{qFilter});
            DynamicObject curOpenBill = BusinessDataServiceHelper.loadSingle((Object)bidopen.getPkValue(), (DynamicObjectType)bidopen.getDynamicObjectType());
            DynamicObject openBill = BusinessDataServiceHelper.loadSingle((Object)tempOpen.getPkValue(), (DynamicObjectType)curOpenBill.getDynamicObjectType());
            DynamicObjectCollection sectionEntry = openBill.getDynamicObjectCollection("bidsection");
            DynamicObjectCollection curSectionEntry = curOpenBill.getDynamicObjectCollection("bidsection");
            openBill.set("evaluatedmethod", (Object)bidopen.getString("evaluatedmethod"));
            for (int i = 0; i < sectionEntry.size(); ++i) {
                DynamicObject sectionEntryRow = (DynamicObject)sectionEntry.get(i);
                DynamicObject curSectionEntryRow = (DynamicObject)curSectionEntry.get(i);
                DynamicObjectCollection supplierEntry = sectionEntryRow.getDynamicObjectCollection("supplierentry");
                DynamicObjectCollection curSupplierEntry = curSectionEntryRow.getDynamicObjectCollection("supplierentry");
                supplierEntry.clear();
                for (DynamicObject curSupplierEntryRow : curSupplierEntry) {
                    DynamicObject supplierEntryRow = new DynamicObject((DynamicObjectType)newOneType.getAllEntities().get("supplierentry"));
                    boolean isTender = curSupplierEntryRow.getBoolean("supplier_istender");
                    boolean isInvalid = curSupplierEntryRow.getBoolean("supplier_isinvalid");
                    DynamicObject supplier = curSupplierEntryRow.getDynamicObject("supplier");
                    if (!isTender || isInvalid || supplier == null) continue;
                    Long supId = ID.genLongId();
                    supplierEntryRow.set("id", (Object)supId);
                    supplierEntryRow.set("seq", curSupplierEntryRow.get("seq"));
                    supplierEntryRow.set("supplier", (Object)curSupplierEntryRow.getDynamicObject("supplier"));
                    supplierEntryRow.set("suppliercontact", (Object)curSupplierEntryRow.getString("suppliercontact"));
                    supplierEntryRow.set("contactphone", (Object)curSupplierEntryRow.getString("contactphone"));
                    supplierEntryRow.set("supplier_deposittype", (Object)curSupplierEntryRow.getString("supplier_deposittype"));
                    supplierEntryRow.set("supplier_deposit", (Object)curSupplierEntryRow.getBigDecimal("supplier_deposit"));
                    supplierEntryRow.set("supplier_istender", (Object)curSupplierEntryRow.getBoolean("supplier_istender"));
                    supplierEntryRow.set("supplier_tenderdate", (Object)curSupplierEntryRow.getDate("supplier_tenderdate"));
                    supplierEntryRow.set("supplier_manager", (Object)curSupplierEntryRow.getString("supplier_manager"));
                    supplierEntryRow.set("supplier_workday", (Object)curSupplierEntryRow.getInt("supplier_workday"));
                    this.copyAttach(supplierEntryRow.getDynamicObjectCollection("supplier_techattach"), curSupplierEntryRow.getDynamicObjectCollection("supplier_techattach"));
                    this.copyAttach(supplierEntryRow.getDynamicObjectCollection("supplier_comattach"), curSupplierEntryRow.getDynamicObjectCollection("supplier_comattach"));
                    this.copyAttach(supplierEntryRow.getDynamicObjectCollection("supplier_tenattach"), curSupplierEntryRow.getDynamicObjectCollection("supplier_tenattach"));
                    this.copyAttach(supplierEntryRow.getDynamicObjectCollection("supplier_otherattach"), curSupplierEntryRow.getDynamicObjectCollection("supplier_otherattach"));
                    supplierEntryRow.set("supplier_tenderprice", (Object)curSupplierEntryRow.getBigDecimal("supplier_tenderprice"));
                    supplierEntryRow.set("supplier_taxrate", (Object)curSupplierEntryRow.getBigDecimal("supplier_taxrate"));
                    supplierEntryRow.set("supplier_pricevat", (Object)curSupplierEntryRow.getBigDecimal("supplier_pricevat"));
                    supplierEntryRow.set("supplier_exceptvat", (Object)curSupplierEntryRow.getBigDecimal("supplier_exceptvat"));
                    supplierEntryRow.set("supplier_rate", (Object)curSupplierEntryRow.getBigDecimal("supplier_rate"));
                    supplierEntryRow.set("supplier_revokebidnumber", (Object)curSupplierEntryRow.getInt("supplier_revokebidnumber"));
                    supplierEntryRow.set("supplier_ip", (Object)curSupplierEntryRow.getString("supplier_ip"));
                    supplierEntryRow.set("isnew", (Object)curSupplierEntryRow.getString("isnew"));
                    supplierEntryRow.set("isfromproject", (Object)curSupplierEntryRow.getString("isfromproject"));
                    supplierEntryRow.set("supplier_isfrombackbid", (Object)curSupplierEntryRow.getString("supplier_isfrombackbid"));
                    supplierEntryRow.set("supplier_illustration", (Object)curSupplierEntryRow.getString("supplier_illustration"));
                    supplierEntryRow.set("supplier_isinvalid", (Object)curSupplierEntryRow.getBoolean("supplier_isinvalid"));
                    supplierEntryRow.set("supplier_invalidreason", (Object)curSupplierEntryRow.getString("supplier_invalidreason"));
                    supplierEntryRow.set("supplier_comment", (Object)curSupplierEntryRow.getString("supplier_comment"));
                    DynamicObject file4Com = this.bidSupplierFileService.getOneFileRecordByIds((Long)curSupplierEntryRow.getDynamicObject("supplier").getPkValue(), (Long)curSectionEntryRow.getPkValue(), "comFile", "id,status");
                    DynamicObject file = new DynamicObject((DynamicObjectType)t);
                    file.set("sectionid", sectionEntryRow.getPkValue());
                    file.set("supplierid", curSupplierEntryRow.getDynamicObject("supplier").getPkValue());
                    file.set("type", (Object)"comFile");
                    long fid = ID.genLongId();
                    file.set("id", (Object)fid);
                    if (file4Com != null) {
                        try (TXHandle h = TX.requiresNew();){
                            try {
                                BidFileHelper.copyFileFromAToB((String)(appId + "_supplier_file"), (Object)file4Com.get("id"), (String)"attachmentpanelap", (String)(appId + "_supplier_file"), (Object)fid, (String)"attachmentpanelap");
                            }
                            catch (Throwable ex) {
                                h.markRollback();
                                throw ex;
                            }
                        }
                    }
                    BusinessDataServiceHelper.save((IDataEntityType)t, (Object[])new DynamicObject[]{file});
                    supplierEntry.add((Object)supplierEntryRow);
                }
                Iterator curSupplierDetail = curSectionEntryRow.getDynamicObjectCollection("supplierdetail");
                DynamicObjectCollection supplierDetail = sectionEntryRow.getDynamicObjectCollection("supplierdetail");
                supplierDetail.clear();
                Iterator iterator = curSupplierDetail.iterator();
                while (iterator.hasNext()) {
                    DynamicObject curSupplierDetailRow = (DynamicObject)iterator.next();
                    DynamicObject supplierDetailRow = new DynamicObject((DynamicObjectType)newOneType.getAllEntities().get("supplierdetail"));
                    supplierDetailRow.set("pursupplier", (Object)curSupplierDetailRow.getDynamicObject("pursupplier"));
                    supplierDetailRow.set("purentrycontent", (Object)curSupplierDetailRow.getString("purentrycontent"));
                    supplierDetailRow.set("purentryproject", (Object)curSupplierDetailRow.getDynamicObject("purentryproject"));
                    supplierDetailRow.set("materialid", (Object)curSupplierDetailRow.getDynamicObject("materialid"));
                    supplierDetailRow.set("materialdes", (Object)curSupplierDetailRow.getString("materialdes"));
                    supplierDetailRow.set("qty", (Object)curSupplierDetailRow.getBigDecimal("qty"));
                    supplierDetailRow.set("inclutaxprice", (Object)curSupplierDetailRow.getBigDecimal("inclutaxprice"));
                    supplierDetailRow.set("inclutaxamount", (Object)curSupplierDetailRow.getBigDecimal("inclutaxamount"));
                    supplierDetailRow.set("taxrate", (Object)curSupplierDetailRow.getBigDecimal("taxrate"));
                    supplierDetailRow.set("taxamount", (Object)curSupplierDetailRow.getBigDecimal("taxamount"));
                    supplierDetailRow.set("excepttaxamount", (Object)curSupplierDetailRow.getBigDecimal("excepttaxamount"));
                    supplierDetailRow.set("costrate", (Object)curSupplierDetailRow.getBigDecimal("costrate"));
                    supplierDetail.add((Object)supplierDetailRow);
                }
            }
            BusinessDataServiceHelper.save((IDataEntityType)openBill.getDataEntityType(), (Object[])new DynamicObject[]{openBill});
        }
        this.refreshMyTenderStatus(bidProjectIDSet);
        BidStepEnum[] bidStepEnums = BidProjectQueryUtil.filterClarificaitonArr(projectId);
        this.projectService.saveCurrentBidStep((Object)projectId, bidStepEnums);
    }

    protected void copyAttach(DynamicObjectCollection newAttachFiles, DynamicObjectCollection oldAttachFiles) {
        oldAttachFiles.stream().forEach(item -> {
            DynamicObject inviteAttach = newAttachFiles.addNew();
            inviteAttach.set("fbasedataid", (Object)item.getDynamicObject("fbasedataid"));
        });
    }

    public void refreshMyTenderStatus(HashSet<Long> bidProjectIDSet) {
        String selectFields = "bidproject,supplier,entry,entry.sectionname,entry.projectsection,entry.sectionstatus,ispublicbid,tenderstatus";
        DynamicObject[] myTenderArr = BusinessDataServiceHelper.load((String)"ten_mytender", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIDSet), new QFilter("tenderstatus", "=", (Object)MyTenderStatus.PRETENDERED)});
        if (myTenderArr.length > 0) {
            Long[] idArr = bidProjectIDSet.toArray(new Long[bidProjectIDSet.size()]);
            DynamicObjectCollection projectColl = this.bidProjectService.listBidProjectByIds(idArr, "bidopendeadline");
            for (int i = 0; i < projectColl.size(); ++i) {
                if (((DynamicObject)projectColl.get(i)).get("bidopendeadline") != null) continue;
                for (DynamicObject myTender : myTenderArr) {
                    myTender.set("tenderstatus", (Object)MyTenderStatus.UNTENDERED);
                    for (DynamicObject myTenderEntry : myTender.getDynamicObjectCollection("entry")) {
                        myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.UNTENDERED);
                    }
                }
            }
            SaveServiceHelper.update((DynamicObject[])myTenderArr);
        }
    }

    protected String getAppId(DynamicObject dataEntity) {
        String entityTypeId = dataEntity.getString("entitytypeid");
        return "rebm".equals(entityTypeId) ? "rebm_" : "bid_";
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if ("audit".equals(key)) {
            Arrays.stream(datas).forEach(dataEntity -> BidMessageUtil.sendMsgBySupplierInvalid((DynamicObject)dataEntity));
        }
    }

    private class Validator4SaleCheck
    extends AbstractValidator {
        private Validator4SaleCheck() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            String operateKey = this.getOperateKey();
            if ("unaudit".equals(operateKey)) {
                for (int i = 0; i < dataEntities.length; ++i) {
                    DynamicObject bidBustalk;
                    String billStatus;
                    boolean hasEvaluation;
                    DynamicObject dataEntity = dataEntities[i].getDataEntity();
                    boolean existNewBill = QueryServiceHelper.exists((String)(BidSupplierInvalAuditOp.this.getAppId(dataEntity) + "supplierinvalid"), (QFilter[])new QFilter[]{new QFilter("createtime", ">", (Object)dataEntity.getDate("createtime")), new QFilter("bidproject", "=", dataEntity.getDynamicObject("bidproject").getPkValue())});
                    if (existNewBill) {
                        this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bf9\u6700\u65b0\u7684\u4f9b\u5e94\u5546\u6dd8\u6c70\u5355\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"BidSupplierInvalAuditOp_0", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                    DynamicObject project = dataEntity.getDynamicObject("bidproject");
                    DynamicObject bidmode = null;
                    String openType = null;
                    if (project != null) {
                        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)(BidSupplierInvalAuditOp.this.getAppId(dataEntity) + "project"), (String)"bidmode,bidopentype");
                        DynamicObject mode = bidProject.getDynamicObject("bidmode");
                        bidmode = BusinessDataServiceHelper.loadSingle((Object)mode.getPkValue(), (String)(BidSupplierInvalAuditOp.this.getAppId(dataEntity) + "bidmode"));
                        openType = bidProject.getString("bidopentype");
                    }
                    if (bidmode == null) {
                        return;
                    }
                    DynamicObject nextStepOpen = BidSupplierInvalAuditOp.this.separateBidOpenCheck(project, openType, dataEntity);
                    if (nextStepOpen != null) {
                        String billStatus2;
                        hasEvaluation = bidmode.getBoolean("bidevaluation");
                        if (hasEvaluation) {
                            DynamicObjectCollection questionclarifys;
                            DynamicObjectCollection onlineBidEvals;
                            boolean isonlineEval = dataEntity.getBoolean("isonlineeval");
                            DynamicObject bidEval = QueryServiceHelper.queryOne((String)(BidSupplierInvalAuditOp.this.getAppId(dataEntity) + "bidevaluation"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("bidopenid", "=", (Object)dataEntity.getLong("bidopenid")), new QFilter("billstatus", "!=", (Object)"XX")});
                            if (bidEval != null && !"D".equals(billStatus = bidEval.getString("billstatus"))) {
                                this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"BidSupplierInvalAuditOp_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                return;
                            }
                            if (isonlineEval && (onlineBidEvals = QueryServiceHelper.query((String)(BidSupplierInvalAuditOp.this.getAppId(dataEntity) + "onlinebideval"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("bidopenid", "=", (Object)dataEntity.getLong("bidopenid")), new QFilter("billstatus", "!=", (Object)"XX")})) != null) {
                                for (int j = 0; j < onlineBidEvals.size(); ++j) {
                                    DynamicObject onlineBidEval = (DynamicObject)onlineBidEvals.get(j);
                                    String billStatus3 = onlineBidEval.getString("billstatus");
                                    if ("D".equals(billStatus3)) continue;
                                    this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"BidSupplierInvalAuditOp_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                    return;
                                }
                            }
                            if ((questionclarifys = QueryServiceHelper.query((String)(BidSupplierInvalAuditOp.this.getAppId(dataEntity) + "multiquestclarify"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("bidopenid", "=", (Object)((Long)dataEntity.getPkValue())), new QFilter("billstatus", "!=", (Object)"INVALIDXX")})) != null && questionclarifys.size() > 0) {
                                this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"BidSupplierInvalAuditOp_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                return;
                            }
                        }
                        if ("D".equals(billStatus2 = nextStepOpen.getString("billstatus"))) continue;
                        this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"BidSupplierInvalAuditOp_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    hasEvaluation = bidmode.getBoolean("bidevaluation");
                    boolean hasBustalk = bidmode.getBoolean("bidbustalk");
                    if (hasEvaluation) {
                        DynamicObjectCollection questionclarifys;
                        DynamicObjectCollection onlineBidEvals;
                        String billStatus4;
                        boolean isonlineEval = dataEntity.getBoolean("isonlineeval");
                        DynamicObject bidEval = QueryServiceHelper.queryOne((String)(BidSupplierInvalAuditOp.this.getAppId(dataEntity) + "bidevaluation"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("bidopenid", "=", (Object)dataEntity.getLong("bidopenid")), new QFilter("billstatus", "!=", (Object)"XX")});
                        if (bidEval != null && !"D".equals(billStatus4 = bidEval.getString("billstatus"))) {
                            this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"BidSupplierInvalAuditOp_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (isonlineEval && (onlineBidEvals = QueryServiceHelper.query((String)(BidSupplierInvalAuditOp.this.getAppId(dataEntity) + "onlinebideval"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("bidopenid", "=", (Object)dataEntity.getLong("bidopenid")), new QFilter("billstatus", "!=", (Object)"XX")})) != null) {
                            for (int j = 0; j < onlineBidEvals.size(); ++j) {
                                DynamicObject onlineBidEval = (DynamicObject)onlineBidEvals.get(j);
                                String billStatus5 = onlineBidEval.getString("billstatus");
                                if ("D".equals(billStatus5)) continue;
                                this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"BidSupplierInvalAuditOp_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                return;
                            }
                        }
                        if ((questionclarifys = QueryServiceHelper.query((String)(BidSupplierInvalAuditOp.this.getAppId(dataEntity) + "multiquestclarify"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("bidopenid", "=", (Object)((Long)dataEntity.getPkValue())), new QFilter("billstatus", "!=", (Object)"INVALIDXX")})) == null || questionclarifys.size() <= 0) continue;
                        this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"BidSupplierInvalAuditOp_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (hasBustalk && (bidBustalk = QueryServiceHelper.queryOne((String)(BidSupplierInvalAuditOp.this.getAppId(dataEntity) + "bustalk"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue())})) != null && !"D".equals(billStatus = bidBustalk.getString("billstatus"))) {
                        this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"BidSupplierInvalAuditOp_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject bidDecision = QueryServiceHelper.queryOne((String)(BidSupplierInvalAuditOp.this.getAppId(dataEntity) + "decision"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("billstatus", "!=", (Object)"XX")});
                    if (bidDecision == null || "D".equals(billStatus = bidDecision.getString("billstatus"))) continue;
                    this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"BidSupplierInvalAuditOp_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }
}

