/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidTemplateManageOp
extends AbstractOperationServicePlugIn {
    private static final String SUBMIT_AUDIT = "submitaudit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("number");
        fieldKeys.add("name");
        fieldKeys.add("type");
        fieldKeys.add("org");
        fieldKeys.add("createorg");
        fieldKeys.add("enable");
        fieldKeys.add("default");
        fieldKeys.add("status");
        fieldKeys.add("auditor");
        fieldKeys.add("auditdate");
        fieldKeys.add("entitytypeid");
        fieldKeys.add("useorg");
        fieldKeys.add("ctrlstrategy");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        String appId = this.billEntityType.getAppId();
        String entityTypeId = String.join((CharSequence)"_", appId, "templatemanage");
        switch (operationKey) {
            case "save": 
            case "submit": {
                for (DynamicObject data : datas) {
                    DynamicObject org = data.getDynamicObject("org");
                    data.set("org", (Object)org);
                    data.set("createorg", (Object)org);
                    data.set("useorg", (Object)org);
                    data.set("ctrlstrategy", (Object)"7");
                    data.set("enable", (Object)"");
                    data.set("default", (Object)"0");
                    data.set("entitytypeid", (Object)entityTypeId);
                }
                break;
            }
            case "audit": 
            case "submitaudit": {
                for (DynamicObject data : datas) {
                    DynamicObject org = data.getDynamicObject("org");
                    data.set("org", (Object)org);
                    data.set("createorg", (Object)org);
                    data.set("useorg", (Object)org);
                    data.set("ctrlstrategy", (Object)"7");
                    data.set("status", (Object)BillStatusEnum.AUDITED.getVal());
                    data.set("enable", (Object)"1");
                    data.set("entitytypeid", (Object)entityTypeId);
                    RequestContext requestContext = RequestContext.get();
                    data.set("auditor", (Object)requestContext.getUserId());
                    data.set("auditdate", (Object)new Date());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
                }
                break;
            }
            case "unsubmit": 
            case "unaudit": {
                for (DynamicObject data : datas) {
                    data.set("enable", (Object)"");
                    data.set("auditor", (Object)0L);
                    data.set("auditdate", null);
                    SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{data});
                }
                break;
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String key = this.getOperateKey();
                if ("save".equals(key) || "submit".equals(key) || BidTemplateManageOp.SUBMIT_AUDIT.equals(key)) {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        DynamicObject templateManage = dataEntity.getDataEntity();
                        String number = templateManage.getString("number");
                        String name = templateManage.getString("name");
                        String entityTypeID = templateManage.getDataEntityType().getName();
                        QFilter noFilter = new QFilter("number", "=", (Object)number);
                        QFilter nameFilter = new QFilter("name", "=", (Object)name);
                        QFilter typeFilter = new QFilter("entitytypeid", "=", (Object)entityTypeID);
                        QFilter idFilter = new QFilter("id", "!=", templateManage.getPkValue());
                        boolean noExists = QueryServiceHelper.exists((String)entityTypeID, (QFilter[])noFilter.and(typeFilter).and(idFilter).toArray());
                        boolean nameExists = QueryServiceHelper.exists((String)entityTypeID, (QFilter[])nameFilter.and(typeFilter).and(idFilter).toArray());
                        if (noExists) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6a21\u677f\u7f16\u7801\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"BidTemplateManageOp_0", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (!nameExists) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6a21\u677f\u540d\u79f0\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"BidTemplateManageOp_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }
}

