/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.bid.business.bill.IOnlineBidEvalService;
import kd.scm.bid.business.bill.serviceImpl.OnlineBidEvalServiceImpl;
import kd.scm.bid.common.enums.BidEvalMethodEnum;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.formplugin.bill.util.SupplierInvitationUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class OnlineBidEvalOperationServicePlugIn
extends AbstractOperationServicePlugIn {
    protected IOnlineBidEvalService onlineBidEvalService = new OnlineBidEvalServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("bidevaluationdate");
        e.getFieldKeys().add("evaltype");
        e.getFieldKeys().add("bidproject.bidopentype");
        e.getFieldKeys().add("bidproject.doctype");
        e.getFieldKeys().add("bidproject.entitytypeid");
        e.getFieldKeys().add("supplierinvitationid");
        e.getFieldKeys().add("evaluatedmethod");
        e.getFieldKeys().add("bidopenid");
        e.getFieldKeys().add("bidevaluator");
        e.getFieldKeys().add("bidopenid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new Validator4OnlineBidEval());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block3: {
            String key;
            block4: {
                block2: {
                    super.beginOperationTransaction(e);
                    key = e.getOperationKey();
                    if (!"save".equals(key)) break block2;
                    DynamicObject[] dynamicObjectArray = e.getDataEntities();
                    break block3;
                }
                if (!"submit".equals(key)) break block4;
                DynamicObject[] dataEntities = e.getDataEntities();
                for (int i = 0; i < dataEntities.length; ++i) {
                    DynamicObject dataEntitie = dataEntities[i];
                    dataEntitie.set("bidevaluationdate", (Object)new Date());
                }
                break block3;
            }
            if (!"delete".equals(key)) break block3;
            for (DynamicObject dataEntity : e.getDataEntities()) {
                long bidOpenId = dataEntity.getLong("bidopenid");
                long onlineBidEvalId = dataEntity.getLong("id");
                DeleteServiceHelper.delete((String)"bid_onlinescoredetail", (QFilter[])new QFilter("onlinebideval", "=", (Object)onlineBidEvalId).toArray());
                DeleteServiceHelper.delete((String)"bid_onlinesupplierdetail", (QFilter[])new QFilter("onlinebideval", "=", (Object)onlineBidEvalId).toArray());
                DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
                DynamicObject bidProjectLoad = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)bidProject.getDynamicObjectType().getName(), (String)"id,org");
                DynamicObject bidEvaluator = dataEntity.getDynamicObject("bidevaluator");
                this.onlineBidEvalService.createByLastStepWhenDelete(bidProjectLoad, bidEvaluator.getLong("id"), bidOpenId, "delete");
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block3: {
            DynamicObject[] dataEntities;
            String key;
            block2: {
                super.endOperationTransaction(e);
                key = e.getOperationKey();
                dataEntities = e.getDataEntities();
                if (!"audit".equals(key)) break block2;
                for (int i = 0; i < dataEntities.length; ++i) {
                    DynamicObject dataEntitie = dataEntities[i];
                    DynamicObject bidProject = dataEntitie.getDynamicObject("bidproject");
                    String docType = bidProject.getString("doctype");
                    String evalType = dataEntitie.getString("evaltype");
                    String bidOpenSelectType = bidProject.getString("bidopentype");
                    evalType = BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenSelectType) ? (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType) ? BidOpenTypeEnum.BUSSINESS.getValue() : BidOpenTypeEnum.MULTI.getValue()) : dataEntitie.getString("evaltype");
                    this.onlineBidEvalService.updateBidEvaluationSupplierScore(bidProject, Long.valueOf(dataEntitie.getLong("id")), evalType);
                }
                break block3;
            }
            if (!"unaudit".equals(key)) break block3;
            for (DynamicObject dataEntity : dataEntities) {
                DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
                Long onlineBidEvalId = dataEntity.getLong("id");
                String evalType = dataEntity.getString("evaltype");
                this.onlineBidEvalService.deleteBidEvaluationSupplierScore(bidProject, onlineBidEvalId, evalType);
            }
        }
    }

    private class Validator4OnlineBidEval
    extends AbstractValidator {
        private Validator4OnlineBidEval() {
        }

        public void validate() {
            block12: {
                DynamicObject bidProject;
                DynamicObject onlineBidEval;
                Long onlineBidEvalId;
                String key;
                block13: {
                    block11: {
                        key = this.getOperateKey();
                        if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                                long bidOpenId;
                                boolean existFlag;
                                DynamicObject data = dataEntity.getDataEntity();
                                String evaluatedMethod = data.getString("evaluatedmethod");
                                if (!BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod) && !BidEvalMethodEnum.DX.getCode().equals(evaluatedMethod) || !(existFlag = QueryServiceHelper.exists((String)"bid_supplierinvalid", (QFilter[])new QFilter[]{new QFilter("bidopenid", "=", (Object)(bidOpenId = data.getLong("bidopenid"))), new QFilter("billstatus", "!=", (Object)"C")}))) continue;
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u4f9b\u5e94\u5546\u6dd8\u6c70\u4e1a\u52a1\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"OnlineBidEvalOperationServicePlugIn_4", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                return;
                            }
                        }
                        if (StringUtils.equals((CharSequence)key, (CharSequence)"save") || StringUtils.equals((CharSequence)key, (CharSequence)"audit") || StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
                            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                                String appId = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
                                DynamicObject ids = (DynamicObject)dataEntity.getValue("bidproject");
                                QFilter qFilter = new QFilter("bidproject.id", "=", (Object)ids.getLong("id"));
                                String supplierInvitationId = dataEntity.getDataEntity().getString("supplierinvitationid");
                                if (!"0".equals(supplierInvitationId) && SupplierInvitationUtil.existAgainSupplierInvitation((Object)supplierInvitationId)) {
                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4fee\u8ba2\u4e2d\u72b6\u6001\u7684\u589e\u8865\u5165\u56f4\u5355\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u540e\u7eed\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"OnlineBidEvalOperationServicePlugIn_5", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                }
                                DynamicObject[] bidpublish = BusinessDataServiceHelper.load((String)(appId + "_bidpublish"), (String)"billstatus", (QFilter[])qFilter.toArray());
                                for (int i = 0; i < bidpublish.length; ++i) {
                                    String billstatus = bidpublish[i].getString("billstatus");
                                    if (billstatus.equals("C") || billstatus.equals("X") || billstatus.equals("P") || billstatus.equals("J")) continue;
                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4fee\u8ba2\u4e2d\u72b6\u6001\u7684\u53d1\u6807\u5355\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u540e\u7eed\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"OnlineBidEvalOperationServicePlugIn_6", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                    return;
                                }
                            }
                        }
                        if (!StringUtils.equals((CharSequence)"audit", (CharSequence)key)) break block11;
                        for (ExtendedDataEntity dataEntity : this.dataEntities) {
                            onlineBidEvalId = (Long)dataEntity.getBillPkId();
                            onlineBidEval = OnlineBidEvalOperationServicePlugIn.this.onlineBidEvalService.getOnlineBidEval(onlineBidEvalId);
                            String billstatus = onlineBidEval.getString("billstatus");
                            if (BillStatusEnum.SUBMIT.getVal().equals(billstatus) || BillStatusEnum.AUDITING.getVal().equals(billstatus)) continue;
                            bidProject = onlineBidEval.getDynamicObject("bidproject");
                            dataEntity.setBillNo(bidProject.getString("billno"));
                            this.addMessage(dataEntity, ResManager.loadKDString((String)" \u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", (String)"OnlineBidEvalOperationServicePlugIn_7", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                        break block12;
                    }
                    if (!StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) break block13;
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        String type;
                        DynamicObject bidProject2 = dataEntity.getDataEntity().getDynamicObject("bidproject");
                        Object bidProjectId = bidProject2.getPkValue();
                        String appId = ((Object)((Object)this)).getClass().getName().split("\\.")[2];
                        boolean backBidFinished = new ReBackBidUtil(appId).checkBackBidFinished(bidProjectId, type = dataEntity.getDataEntity().getString("evaltype"));
                        if (backBidFinished) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"OnlineBidEvalOperationServicePlugIn_11", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        boolean flag = OnlineBidEvalOperationServicePlugIn.this.onlineBidEvalService.checkBidEvaluationUnStarted(bidProject2, dataEntity.getDataEntity().getString("evaltype"));
                        if (!flag) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"OnlineBidEvalOperationServicePlugIn_8", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        Long onlineBidEvalId2 = (Long)dataEntity.getBillPkId();
                        DynamicObject onlineBidEval2 = OnlineBidEvalOperationServicePlugIn.this.onlineBidEvalService.getOnlineBidEval(onlineBidEvalId2);
                        String billstatus = onlineBidEval2.getString("billstatus");
                        if (BillStatusEnum.AUDITED.getVal().equals(billstatus)) continue;
                        DynamicObject project = onlineBidEval2.getDynamicObject("bidproject");
                        dataEntity.setBillNo(project.getString("billno"));
                        this.addMessage(dataEntity, ResManager.loadKDString((String)" \u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"OnlineBidEvalOperationServicePlugIn_9", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                    break block12;
                }
                if (!StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key)) break block12;
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    onlineBidEvalId = (Long)dataEntity.getBillPkId();
                    onlineBidEval = OnlineBidEvalOperationServicePlugIn.this.onlineBidEvalService.getOnlineBidEval(onlineBidEvalId);
                    String billstatus = onlineBidEval.getString("billstatus");
                    if (BillStatusEnum.SUBMIT.getVal().equals(billstatus) || BillStatusEnum.AUDITING.getVal().equals(billstatus)) continue;
                    bidProject = onlineBidEval.getDynamicObject("bidproject");
                    dataEntity.setBillNo(bidProject.getString("billno"));
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u63d0\u4ea4\u624d\u80fd\u64a4\u9500\u3002", (String)"OnlineBidEvalOperationServicePlugIn_10", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

