/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.bid.business.bill.IBidEvaluationService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;

public class PriceClarifyOperateServicePlugIn
extends AbstractOperationServicePlugIn {
    protected IBidProjectService bidProjectService = new BidProjectServiceImpl();
    protected IBidEvaluationService bidEvaluationService = new BidEvaluationServiceImpl();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new Validator4PriceClarify());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String key = e.getOperationKey();
        if ("save".equals(key)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            for (int i = 0; i < dataEntities.length; ++i) {
                DynamicObject dataEntitie = dataEntities[i];
                DynamicObject bidevaluation = dataEntitie.getDynamicObject("bidevaluation");
                DynamicObject bidProject = bidevaluation.getDynamicObject("bidproject");
                String billstatus = bidevaluation.getString("billstatus");
                boolean flag = this.bidEvaluationService.checkNextStepUnStarted(bidProject, BidStepEnum.BidEvaluation);
                if (!flag || !BillStatusEnum.AUDITED.getVal().equals(billstatus)) continue;
                this.bidEvaluationService.deleteNextStepUnStarted(bidProject, BidStepEnum.BidEvaluation);
                this.bidEvaluationService.createNextStep(bidProject, BidStepEnum.BidEvaluation);
            }
        }
    }

    private class Validator4PriceClarify
    extends AbstractValidator {
        private Validator4PriceClarify() {
        }

        public void validate() {
            String key = this.getOperateKey();
            if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject bidevaluation = dataEntity.getDataEntity().getDynamicObject("bidevaluation");
                    DynamicObject bidProject = bidevaluation.getDynamicObject("bidproject");
                    bidProject = PriceClarifyOperateServicePlugIn.this.bidProjectService.getBidProjectById(Long.valueOf(bidProject.getLong("id")), "id, enablemultisection, isratebidding");
                    boolean enableMultiSection = bidProject.getBoolean("enablemultisection");
                    boolean isratebidding = bidProject.getBoolean("isratebidding");
                    DynamicObjectCollection sectionColl = dataEntity.getDataEntity().getDynamicObjectCollection("bidsection");
                    for (int i = 0; i < sectionColl.size(); ++i) {
                        DynamicObject section = (DynamicObject)sectionColl.get(i);
                        String sectionName = section.getString("sectionname");
                        DynamicObjectCollection supplierColl = section.getDynamicObjectCollection("bid_pricclarsuppdetail");
                        for (int j = 0; j < supplierColl.size(); ++j) {
                            DynamicObject supplier = (DynamicObject)supplierColl.get(j);
                            boolean isClarify = supplier.getBoolean("isclarify");
                            if (!isClarify) continue;
                            if (isratebidding) {
                                BigDecimal rate = supplier.getBigDecimal("rate");
                                if (rate != null && BigDecimal.ZERO.compareTo(rate) != 0) continue;
                                if (enableMultiSection) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6807\u6bb5\u201c%1$s\u201d\u7b2c%2$s\u884c\u5bf9\u5e94\u7684\u201c\u8d39\u7387\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PriceClarifyOperateServicePlugIn_18", (String)"scm-bid-opplugin", (Object[])new Object[0]), sectionName, String.valueOf(j + 1)));
                                    continue;
                                }
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u4e2d\u7b2c%s\u884c\u5bf9\u5e94\u7684\u201c\u8d39\u7387\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PriceClarifyOperateServicePlugIn_19", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(j + 1)));
                                continue;
                            }
                            BigDecimal clarifyPrice = supplier.getBigDecimal("clarifyprice");
                            BigDecimal clarifyPriceVat = supplier.getBigDecimal("clarifypricevat");
                            BigDecimal excTaxClarifyPrice = supplier.getBigDecimal("exctaxclarifyprice");
                            if (clarifyPrice == null || BigDecimal.ZERO.compareTo(clarifyPrice) == 0) {
                                if (enableMultiSection) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6807\u6bb5\u201c%1$s\u201d\u7b2c%2$s\u884c\u5bf9\u5e94\u7684\u201c\u6f84\u6e05\u62a5\u4ef7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PriceClarifyOperateServicePlugIn_20", (String)"scm-bid-opplugin", (Object[])new Object[0]), sectionName, String.valueOf(j + 1)));
                                    continue;
                                }
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u4e2d\u7b2c%s\u884c\u5bf9\u5e94\u7684\u201c\u6f84\u6e05\u62a5\u4ef7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PriceClarifyOperateServicePlugIn_21", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(j + 1)));
                                continue;
                            }
                            if (excTaxClarifyPrice == null || BigDecimal.ZERO.compareTo(excTaxClarifyPrice) <= 0) continue;
                            if (enableMultiSection) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6807\u6bb5\u201c%1$s\u201d\u7b2c%2$s\u884c\u5bf9\u5e94\u7684\u201c\u6f84\u6e05\u62a5\u4ef7\uff08\u4e0d\u542b\u7a0e\uff09\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"PriceClarifyOperateServicePlugIn_22", (String)"scm-bid-opplugin", (Object[])new Object[0]), sectionName, String.valueOf(j + 1)));
                                continue;
                            }
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u4e2d\u7b2c%s\u884c\u5bf9\u5e94\u7684\u201c\u6f84\u6e05\u62a5\u4ef7\uff08\u4e0d\u542b\u7a0e\uff09\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"PriceClarifyOperateServicePlugIn_23", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(j + 1)));
                        }
                    }
                }
            }
        }
    }
}

