/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.IProficientService;
import kd.scm.bid.business.basedata.serviceImpl.ProficientServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;

public class ProficientOperateServicePlugIn
extends AbstractOperationServicePlugIn {
    protected IProficientService proficientService = new ProficientServiceImpl();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new Validator4Proficient());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("telephone");
        e.getFieldKeys().add("org.id");
        e.getFieldKeys().add("userdstatus");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block3: {
            String operationKey;
            block2: {
                super.endOperationTransaction(e);
                operationKey = e.getOperationKey();
                if (!StringUtils.equals((CharSequence)"audit", (CharSequence)operationKey)) break block2;
                for (DynamicObject objectInfo : e.getDataEntities()) {
                    DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)objectInfo.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"proficient", ((Object)((Object)this)).getClass()));
                    info.set("userdstatus", (Object)"Enable");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
                }
                break block3;
            }
            if (!StringUtils.equals((CharSequence)"unaudit", (CharSequence)operationKey)) break block3;
            for (DynamicObject objectInfo : e.getDataEntities()) {
                DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)objectInfo.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"proficient", ((Object)((Object)this)).getClass()));
                info.set("userdstatus", null);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
            }
        }
    }

    private class Validator4Proficient
    extends AbstractValidator {
        private Validator4Proficient() {
        }

        public void validate() {
            block6: {
                String key;
                block8: {
                    block7: {
                        block5: {
                            key = this.getOperateKey();
                            if (!StringUtils.equals((CharSequence)"save", (CharSequence)key)) break block5;
                            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                                ILocaleString name = (ILocaleString)dataEntity.getValue("name");
                                String number = (String)dataEntity.getValue("billno");
                                String telephone = (String)dataEntity.getValue("telephone");
                                Long id = (Long)dataEntity.getValue("id");
                                CodeRuleInfo xCodeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"bid_proficient", (DynamicObject)dataEntity.getDataEntity(), (String)String.valueOf(RequestContext.get().getOrgId()));
                                boolean isNonBreak = false;
                                if (xCodeRuleInfo != null) {
                                    isNonBreak = xCodeRuleInfo.getIsNonBreak();
                                }
                                DynamicObject org = (DynamicObject)dataEntity.getValue("org");
                                Long orgId = org.getLong("id");
                                boolean isUnique = ProficientOperateServicePlugIn.this.proficientService.checkUniqueNameAndTelephone(this.entityKey, id, name.getLocaleValue(), telephone, orgId);
                                if (isUnique) continue;
                                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u624b\u673a\u53f7\u201d+\u201c\u4e13\u5bb6\u59d3\u540d\u201d\u552f\u4e00\u6027\u6821\u9a8c\uff1a\u201c\u624b\u673a\u53f7+\u4e13\u5bb6\u59d3\u540d\u201d\u5b57\u6bb5\u503c\u201c%1$s+%2$s\u201d\u91cd\u590d\u3002", (String)"ProficientOperateServicePlugIn_4", (String)"scm-bid-opplugin", (Object[])new Object[0]), telephone, name.getLocaleValue()));
                            }
                            break block6;
                        }
                        if (!StringUtils.equals((CharSequence)"delete", (CharSequence)key)) break block7;
                        for (ExtendedDataEntity dataEntity : this.dataEntities) {
                            Long proficientId = (Long)dataEntity.getValue("id");
                            boolean isRefByBill = ProficientOperateServicePlugIn.this.proficientService.checkRefByBill(proficientId);
                            if (!isRefByBill) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u88ab\u5176\u4ed6\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ProficientOperateServicePlugIn_5", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                        break block6;
                    }
                    if (!StringUtils.equals((CharSequence)"submit", (CharSequence)key)) break block8;
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        ILocaleString name = (ILocaleString)dataEntity.getValue("name");
                        String telephone = (String)dataEntity.getValue("telephone");
                        Long id = (Long)dataEntity.getValue("id");
                        DynamicObject org = (DynamicObject)dataEntity.getValue("org");
                        Long orgId = org.getLong("id");
                        boolean isUnique = ProficientOperateServicePlugIn.this.proficientService.checkUniqueNameAndTelephone(this.entityKey, id, name.getLocaleValue(), telephone, orgId);
                        if (isUnique) continue;
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u624b\u673a\u53f7\u201d+\u201c\u4e13\u5bb6\u59d3\u540d\u201d\u552f\u4e00\u6027\u6821\u9a8c\uff1a\u201c\u624b\u673a\u53f7+\u4e13\u5bb6\u59d3\u540d\u201d\u5b57\u6bb5\u503c\u201c%1$s+%2$s\u201d\u91cd\u590d\u3002", (String)"ProficientOperateServicePlugIn_4", (String)"scm-bid-opplugin", (Object[])new Object[0]), telephone, name.getLocaleValue()));
                    }
                    break block6;
                }
                if (!StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) break block6;
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String userdstatus = (String)dataEntity.getValue("userdstatus");
                    if (!StringUtils.equals((CharSequence)"Enable", (CharSequence)userdstatus)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ProficientOperateServicePlugIn_6", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

