/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.basedata.IProficientService;
import kd.scm.bid.business.basedata.IProficientTypeService;
import kd.scm.bid.business.basedata.serviceImpl.ProficientServiceImpl;
import kd.scm.bid.business.basedata.serviceImpl.ProficientTypeServiceImpl;
import kd.scm.bid.common.enums.Enable;

public class ProficientTypeOperationServicePlugin
extends AbstractOperationServicePlugIn {
    private IProficientTypeService service = new ProficientTypeServiceImpl();
    private IProficientService proficientService = new ProficientServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("parent");
        e.getFieldKeys().add("parent.name");
        e.getFieldKeys().add("enable");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.getOption().setVariableValue("ignorerefentityids", "bid_proficient_f7,bid_proficient,rebm_proficient_f7,rebm_proficient");
        e.addValidator((AbstractValidator)new Validator4ProficientType());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if ("enable".equals(key)) {
            for (DynamicObject dObj : datas) {
                this.service.saveEnable(dObj.getPkValue());
            }
            return;
        }
        if ("disable".equals(key)) {
            for (DynamicObject dObj : datas) {
                this.service.saveDisable(dObj.getPkValue());
            }
            return;
        }
        if ("save".equals(key)) {
            for (DynamicObject dObj : datas) {
                DynamicObject parent = dObj.getDynamicObject("parent");
                if (parent != null) {
                    this.service.saveParentIsLeafStatus(parent.getPkValue());
                }
                this.proficientService.updateProficientMajorTypeNames(Long.valueOf(dObj.getLong("id")));
            }
            return;
        }
    }

    private class Validator4ProficientType
    extends AbstractValidator {
        private Validator4ProficientType() {
        }

        public void validate() {
            block11: {
                ExtendedDataEntity[] dataEntities;
                String key;
                block13: {
                    block12: {
                        block10: {
                            key = this.getOperateKey();
                            dataEntities = this.getDataEntities();
                            if (!StringUtils.equals((CharSequence)"enable", (CharSequence)key)) break block10;
                            for (ExtendedDataEntity de : dataEntities) {
                                if (!Enable.ENABLE.getVal().equals(de.getValue("enable").toString())) continue;
                                this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8282\u70b9\u542f\u7528\u72b6\u6001\u4e3a\u5df2\u542f\u7528 \uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u542f\u7528\u3002", (String)"ProficientTypeOperationServicePlugin_14", (String)"scm-bid-opplugin", (Object[])new Object[0]), de.getBillNo()));
                            }
                            break block11;
                        }
                        if (!StringUtils.equals((CharSequence)"disable", (CharSequence)key)) break block12;
                        for (ExtendedDataEntity de : dataEntities) {
                            if (!Enable.DISABLE.getVal().equals(de.getValue("enable").toString())) continue;
                            this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8282\u70b9\u542f\u7528\u72b6\u6001\u4e3a\u5df2\u7981\u7528 \uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u7981\u7528\u3002", (String)"ProficientTypeOperationServicePlugin_15", (String)"scm-bid-opplugin", (Object[])new Object[0]), de.getBillNo()));
                        }
                        break block11;
                    }
                    if (!StringUtils.equals((CharSequence)"delete", (CharSequence)key)) break block13;
                    for (ExtendedDataEntity de : dataEntities) {
                        if (Enable.ENABLE.getVal().equals(de.getValue("enable").toString())) {
                            this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8282\u70b9\u542f\u7528\u72b6\u6001\u4e3a\u5df2\u542f\u7528 \uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ProficientTypeOperationServicePlugin_16", (String)"scm-bid-opplugin", (Object[])new Object[0]), de.getBillNo()));
                        }
                        if (this.isExistChildNode(de.getBillPkId())) {
                            this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u8282\u70b9%s\u5b58\u5728\u4e0b\u7ea7\u4e13\u4e1a\u5206\u7c7b\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7\u201c\u4e13\u4e1a\u5206\u7c7b\u201d\u3002", (String)"ProficientTypeOperationServicePlugin_17", (String)"scm-bid-opplugin", (Object[])new Object[0]), de.getValue("name")));
                        }
                        QFilter filter = new QFilter("basedata", "=", de.getBillPkId());
                        DynamicObject objs = BusinessDataServiceHelper.loadSingle((String)"bid_profmajorentry", (String)"", (QFilter[])new QFilter[]{filter});
                        if (objs == null) continue;
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff1a[\u8bc4\u6807\u4e13\u5bb6\u5e93]\u7684\u5b57\u6bb5\u201c\u4e13\u4e1a\u5206\u7c7b\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"ProficientTypeOperationServicePlugin_18", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    break block11;
                }
                if (!StringUtils.equals((CharSequence)"save", (CharSequence)key)) break block11;
                for (ExtendedDataEntity de : dataEntities) {
                    String billName;
                    DynamicObject parent = (DynamicObject)de.getValue("parent");
                    Long parentId = null;
                    if (parent != null) {
                        Object pid = parent.getPkValue();
                        boolean isRefrenced = ProficientTypeOperationServicePlugin.this.service.checkRefrenced(pid);
                        if (isRefrenced) {
                            this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u8282\u70b9%s\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u65b0\u589e\u4e0b\u7ea7\u8282\u70b9\u3002", (String)"ProficientTypeOperationServicePlugin_19", (String)"scm-bid-opplugin", (Object[])new Object[0]), parent.getString("name")));
                        }
                        parentId = parent.getLong("id");
                    } else {
                        parentId = 0L;
                    }
                    ILocaleString nameLocale = (ILocaleString)de.getValue("name");
                    Long id = (Long)de.getValue("id");
                    if (ProficientTypeOperationServicePlugin.this.service.checkSameNameLevel(nameLocale.getLocaleValue(), parentId, id, this.entityKey)) {
                        this.addFatalErrorMessage(de, String.format(ResManager.loadKDString((String)"\u7ec4\u5408\u5b57\u6bb5\u552f\u4e00\u6027\u6821\u9a8c\uff1a\u201c\u4e13\u4e1a\u5206\u7c7b\u540d\u79f0\u201d\u5b57\u6bb5\u503c\u201c%s\u201d\u91cd\u590d\u3002", (String)"ProficientTypeOperationServicePlugin_20", (String)"scm-bid-opplugin", (Object[])new Object[0]), nameLocale.getLocaleValue()));
                    }
                    LocaleString numberName = ((IDataEntityProperty)de.getDataEntity().getDataEntityType().getProperties().get((Object)"number")).getDisplayName();
                    String number = de.getBillNo();
                    if (!this.validateNumberUnique(number, billName = this.entityKey, id)) continue;
                    this.addFatalErrorMessage(de, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b57\u6bb5\u503c\u201c%2$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProficientTypeOperationServicePlugin_21", (String)"scm-bid-opplugin", (Object[])new Object[0]), numberName.getLocaleValue(), number));
                }
            }
        }

        protected boolean validateNumberUnique(String number, String billName, Long id) {
            QFilter qFilter = new QFilter("number", "=", (Object)number);
            qFilter.and(new QFilter("id", "!=", (Object)id));
            return QueryServiceHelper.exists((String)billName, (QFilter[])qFilter.toArray());
        }

        private boolean isExistChildNode(Object billPkId) {
            return ProficientTypeOperationServicePlugin.this.service.checkExistChildren(billPkId);
        }
    }
}

