/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.bid.business.basedata.IPurTypeService;
import kd.scm.bid.business.basedata.serviceImpl.PurTypeServiceImpl;
import kd.scm.bid.common.enums.Enable;

public class PurTypeOperationServicePlugin
extends AbstractOperationServicePlugIn {
    private IPurTypeService service = new PurTypeServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("parent");
        e.getFieldKeys().add("enable");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ValidatorForPurType());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if ("enable".equals(key)) {
            for (DynamicObject dObj : datas) {
                this.service.saveEnable(dObj.getPkValue());
            }
            return;
        }
        if ("disable".equals(key)) {
            for (DynamicObject dObj : datas) {
                this.service.saveDisable(dObj.getPkValue());
            }
            return;
        }
        if ("save".equals(key)) {
            for (DynamicObject dObj : datas) {
                DynamicObject parent = dObj.getDynamicObject("parent");
                if (parent == null) continue;
                this.service.saveParentIsLeafStatus(parent.getPkValue());
            }
            return;
        }
    }

    private class ValidatorForPurType
    extends AbstractValidator {
        private ValidatorForPurType() {
        }

        public void validate() {
            block5: {
                ExtendedDataEntity[] dataEntities;
                String key;
                block6: {
                    block4: {
                        key = this.getOperateKey();
                        dataEntities = this.getDataEntities();
                        if (!StringUtils.equals((CharSequence)"enable", (CharSequence)key)) break block4;
                        for (ExtendedDataEntity de : dataEntities) {
                            if (!Enable.ENABLE.getVal().equals(de.getValue("enable").toString())) continue;
                            this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8282\u70b9\u4f7f\u7528\u72b6\u6001\u4e3a\u5df2\u542f\u7528 \uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u542f\u7528\u3002", (String)"PurTypeOperationServicePlugin_8", (String)"scm-bid-opplugin", (Object[])new Object[0]), de.getBillNo()));
                        }
                        break block5;
                    }
                    if (!StringUtils.equals((CharSequence)"disable", (CharSequence)key)) break block6;
                    for (ExtendedDataEntity de : dataEntities) {
                        if (!Enable.DISABLE.getVal().equals(de.getValue("enable").toString())) continue;
                        this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8282\u70b9\u4f7f\u7528\u72b6\u6001\u4e3a\u5df2\u7981\u7528 \uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u7981\u7528\u3002", (String)"PurTypeOperationServicePlugin_9", (String)"scm-bid-opplugin", (Object[])new Object[0]), de.getBillNo()));
                    }
                    break block5;
                }
                if (!StringUtils.equals((CharSequence)"delete", (CharSequence)key)) break block5;
                for (ExtendedDataEntity de : dataEntities) {
                    if (Enable.ENABLE.getVal().equals(de.getValue("enable").toString())) {
                        this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8282\u70b9\u542f\u7528\u72b6\u6001\u4e3a\u5df2\u542f\u7528 \uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PurTypeOperationServicePlugin_10", (String)"scm-bid-opplugin", (Object[])new Object[0]), de.getBillNo()));
                    }
                    if (!this.isExistChildNode(de.getBillPkId())) continue;
                    this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u8282\u70b9%s\u5b58\u5728\u4e0b\u7ea7\u91c7\u8d2d\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7\u91c7\u8d2d\u7c7b\u578b\u3002", (String)"PurTypeOperationServicePlugin_4", (String)"scm-bid-opplugin", (Object[])new Object[0]), de.getValue("name")));
                }
            }
        }

        private boolean isExistChildNode(Object billPkId) {
            return PurTypeOperationServicePlugin.this.service.checkExistChildren(billPkId);
        }
    }
}

