/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.SupplierStatisticServiceImpl;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.common.enums.BillStatusEnum;

public class SupplierEnrollOperateServicePlugIn
extends AbstractOperationServicePlugIn {
    protected ISupplierInvitationService service = new SupplierInvitationServiceImpl();
    private static String SAVE_BUTTON = "savesupplierenroll";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String key = this.getOperateKey();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (SAVE_BUTTON.equals(key)) {
                    this.checkSupplierEmptyValidator(dataEntities);
                }
            }

            protected void checkSupplierEmptyValidator(ExtendedDataEntity[] dataEntities) {
                HashSet<Object> isinvitationSet = null;
                block0: for (ExtendedDataEntity dataEntity : dataEntities) {
                    Long supplierInvitationId = Long.parseLong(dataEntity.getValue("supplierinvitationid").toString());
                    DynamicObject supplierInvitation = SupplierEnrollOperateServicePlugIn.this.service.getSupplierInvitationById(supplierInvitationId);
                    if (BillStatusEnum.DISBEGIN.getVal().equals(supplierInvitation.getString("billstatus")) || BillStatusEnum.SAVE.getVal().equals(supplierInvitation.getString("billstatus"))) {
                        return;
                    }
                    DynamicObjectCollection sections = (DynamicObjectCollection)dataEntity.getValue("entryentity");
                    if (sections == null || sections.size() == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u81f3\u5c11\u63a8\u8350\u5165\u56f4\u4e00\u4e2a\u4f9b\u5e94\u5546\u3002", (String)"SupplierEnrollOperateServicePlugIn_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    isinvitationSet = new HashSet<Object>();
                    for (DynamicObject section : sections) {
                        DynamicObjectCollection suppliers = section.getDynamicObjectCollection("subentryentity");
                        for (int i = 0; i < suppliers.size(); ++i) {
                            boolean isinvitation = ((DynamicObject)suppliers.get(i)).getBoolean("isinvitation");
                            if (!isinvitation) continue;
                            isinvitationSet.add(suppliers.get(i));
                        }
                        if (!isinvitationSet.isEmpty()) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u81f3\u5c11\u63a8\u8350\u5165\u56f4\u4e00\u4e2a\u4f9b\u5e94\u5546\u3002", (String)"SupplierEnrollOperateServicePlugIn_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue block0;
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginoperationtransactionargs) {
        super.beginOperationTransaction(beginoperationtransactionargs);
        String key = beginoperationtransactionargs.getOperationKey();
        DynamicObject[] datas = beginoperationtransactionargs.getDataEntities();
        if (StringUtils.isNotBlank((CharSequence)key) && SAVE_BUTTON.toLowerCase(Locale.getDefault()).equals(key.toLowerCase(Locale.getDefault()))) {
            DynamicObject supplierEnroll = datas[0];
            DynamicObjectCollection dataEntryColl = supplierEnroll.getDynamicObjectCollection("entryentity");
            HashMap<String, Set<Long>> addSectionMap = new HashMap<String, Set<Long>>();
            HashMap<String, Set<Long>> deleteSectionMap = new HashMap<String, Set<Long>>();
            HashMap addMap = new HashMap();
            HashMap<Long, ILocaleString> commentMap = new HashMap<Long, ILocaleString>();
            HashMap<String, Long> announcementMap = new HashMap<String, Long>();
            SupplierStatisticServiceImpl suppStatService = new SupplierStatisticServiceImpl();
            String appId = this.billEntityType.getAppId();
            if (!dataEntryColl.isEmpty()) {
                for (int i = 0; i < dataEntryColl.size(); ++i) {
                    DynamicObject supplierEnrollEntry = (DynamicObject)dataEntryColl.get(i);
                    DynamicObjectCollection detailColl = supplierEnrollEntry.getDynamicObjectCollection("subentryentity");
                    if (detailColl.isEmpty()) continue;
                    String sectionName = supplierEnrollEntry.getString("entrysectionname");
                    ArrayList<DynamicObject> sectionList = new ArrayList<DynamicObject>();
                    HashSet<Long> addIdSet = new HashSet<Long>();
                    HashSet<Long> deleteSupplierIdSet = new HashSet<Long>();
                    for (int j = 0; j < detailColl.size(); ++j) {
                        DynamicObject supplierEnrollDetail = (DynamicObject)detailColl.get(j);
                        DynamicObject supplier = supplierEnrollDetail.getDynamicObject("enrollsupplier");
                        if (supplierEnrollDetail.getBoolean("isinvitation")) {
                            addIdSet.add(supplierEnrollDetail.getLong("enrollid"));
                            sectionList.add(supplierEnrollDetail);
                        } else {
                            deleteSupplierIdSet.add(supplier.getLong("id"));
                        }
                        commentMap.put(supplierEnrollDetail.getLong("enrollid"), supplierEnrollDetail.getLocaleString("enrollsuppliercomment"));
                        String fileKey = sectionName + "_" + supplier.getPkValue();
                        announcementMap.put(fileKey, supplierEnrollDetail.getLong("announcement"));
                    }
                    addSectionMap.put(sectionName, addIdSet);
                    deleteSectionMap.put(sectionName, deleteSupplierIdSet);
                    addMap.put(sectionName, sectionList);
                }
            }
            Long supplierInvitationid = supplierEnroll.getLong("supplierinvitationid");
            DynamicObject supplierInvitation = this.service.getSupplierInvitationById(supplierInvitationid);
            this.setSupplierEnrollDetail(supplierInvitation, addSectionMap, deleteSectionMap, commentMap);
            DynamicObjectCollection entryColl = supplierInvitation.getDynamicObjectCollection("bidsection");
            HashSet<Long> supplierIdSet = new HashSet<Long>();
            if (!entryColl.isEmpty()) {
                for (int i = 0; i < entryColl.size(); ++i) {
                    DynamicObject supplier;
                    DynamicObject supplierEntry;
                    int j;
                    DynamicObject supplierEntryObject = (DynamicObject)entryColl.get(i);
                    String sectionName = supplierEntryObject.getString("sectionname");
                    List supplierList = (List)addMap.get(sectionName);
                    if (supplierList == null) continue;
                    Set deleteSupplierIdSet = (Set)deleteSectionMap.get(sectionName);
                    DynamicObjectCollection detailColl = supplierEntryObject.getDynamicObjectCollection("supplierentry");
                    if (supplierList.isEmpty()) {
                        for (j = detailColl.size() - 1; j >= 0; --j) {
                            detailColl.remove(j);
                        }
                        continue;
                    }
                    if (!addMap.containsKey(sectionName)) continue;
                    for (j = detailColl.size() - 1; j >= 0; --j) {
                        DynamicObject detailSupplierEnroll = (DynamicObject)detailColl.get(j);
                        DynamicObject detailSupplier = detailSupplierEnroll.getDynamicObject("supplier");
                        if (!deleteSupplierIdSet.contains(detailSupplier.getLong("id"))) continue;
                        detailColl.remove(j);
                    }
                    for (j = supplierList.size() - 1; j >= 0; --j) {
                        supplierEntry = (DynamicObject)supplierList.get(j);
                        supplier = supplierEntry.getDynamicObject("enrollsupplier");
                        for (int k = 0; k < detailColl.size(); ++k) {
                            DynamicObject detailSupplierEntry = (DynamicObject)detailColl.get(k);
                            DynamicObject detailSupplier = detailSupplierEntry.getDynamicObject("supplier");
                            if (supplier.getLong("id") != detailSupplier.getLong("id")) continue;
                            detailSupplierEntry.set("suppliercomment", commentMap.get(supplierEntry.getLong("enrollid")));
                            supplierList.remove(j);
                        }
                    }
                    for (j = 0; j < supplierList.size(); ++j) {
                        DynamicObject supplier2 = (DynamicObject)supplierList.get(j);
                        DynamicObject enrollsupplier = supplier2.getDynamicObject("enrollsupplier");
                        DynamicObject supplierStatistic = suppStatService.getSupplierStatistic(Long.valueOf(enrollsupplier.getLong("id")), appId + "_supplierstatistic");
                        DynamicObject supplierEntry2 = this.getNewSupplierEntry(sectionName, detailColl, supplier2, supplierStatistic, announcementMap);
                        detailColl.add((Object)supplierEntry2);
                    }
                    for (j = 0; j < detailColl.size(); ++j) {
                        supplierEntry = (DynamicObject)detailColl.get(j);
                        supplier = supplierEntry.getDynamicObject("supplier");
                        supplierIdSet.add(supplier.getLong("id"));
                    }
                }
            }
            if (BillStatusEnum.DISBEGIN.getVal().equals(supplierInvitation.getString("billstatus"))) {
                supplierInvitation.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            }
            supplierInvitation.set("supplierqty", (Object)supplierIdSet.size());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplierInvitation});
        }
    }

    private void setSupplierEnrollDetail(DynamicObject supplierInvitation, Map<String, Set<Long>> addIdMap, Map<String, Set<Long>> deleteSupplierIdMap, Map<Long, ILocaleString> commentMap) {
        DynamicObjectCollection enrollEntryColl = supplierInvitation.getDynamicObjectCollection("bidenrollsection");
        if (!enrollEntryColl.isEmpty()) {
            for (int i = 0; i < enrollEntryColl.size(); ++i) {
                DynamicObject supplierEnrollEntry = (DynamicObject)enrollEntryColl.get(i);
                String sectionName = supplierEnrollEntry.getString("entrysectionname");
                DynamicObjectCollection detailColl = supplierEnrollEntry.getDynamicObjectCollection("supplierenrollentry");
                Set<Long> addIdSet = addIdMap.get(sectionName);
                Set<Long> deleteSupplierIdSet = deleteSupplierIdMap.get(sectionName);
                for (int j = 0; j < detailColl.size(); ++j) {
                    Long id;
                    DynamicObject supplier;
                    DynamicObject supplierEnrollDetail = (DynamicObject)detailColl.get(j);
                    if (addIdSet.contains(supplierEnrollDetail.getLong("id"))) {
                        supplierEnrollDetail.set("isinvitation", (Object)Boolean.TRUE);
                    }
                    if (deleteSupplierIdSet.contains((supplier = supplierEnrollDetail.getDynamicObject("enrollsupplier")).getLong("id"))) {
                        supplierEnrollDetail.set("isinvitation", (Object)Boolean.FALSE);
                    }
                    if (commentMap.get(id = Long.valueOf(supplierEnrollDetail.getLong("id"))) == null) continue;
                    supplierEnrollDetail.set("enrollsuppliercomment", (Object)commentMap.get(id));
                }
            }
        }
    }

    private DynamicObject getNewSupplierEntry(String sectionName, DynamicObjectCollection detailColl, DynamicObject supplier, DynamicObject supplierStatistic, Map<String, Long> announcementMap) {
        DynamicObject supplierEntry = new DynamicObject(detailColl.getDynamicObjectType());
        DynamicObject enrollsupplier = supplier.getDynamicObject("enrollsupplier");
        supplierEntry.set("seq", supplier.get("seq"));
        supplierEntry.set("supplier", (Object)enrollsupplier);
        supplierEntry.set("suppliercontact", supplier.get("enrollsuppliercontact"));
        supplierEntry.set("contactphone", supplier.get("enrollcontactphone"));
        supplierEntry.set("suppliercomment", supplier.get("enrollsuppliercomment"));
        supplierEntry.set("email", supplier.get("enrollemail"));
        supplierEntry.set("address", supplier.get("enrolladdress"));
        supplierEntry.set("fax", supplier.get("enrollfax"));
        supplierEntry.set("invitationstatus", (Object)"UNSEND");
        supplierEntry.set("supplierstatistic", supplierStatistic.get("id"));
        String key = sectionName + "_" + enrollsupplier.getPkValue();
        DynamicObjectCollection inviteAttachFiles = supplierEntry.getDynamicObjectCollection("inviteattachfile");
        DynamicObjectCollection registerAttachFiles = supplier.getDynamicObjectCollection("registerattachfile");
        registerAttachFiles.stream().forEach(item -> {
            DynamicObject inviteAttach = inviteAttachFiles.addNew();
            inviteAttach.set("fbasedataid", (Object)item.getDynamicObject("fbasedataid"));
        });
        supplierEntry.set("announcementid", (Object)announcementMap.get(key));
        supplierEntry.set("isregister", (Object)Boolean.TRUE);
        supplierEntry.set("isrecommend", (Object)Boolean.TRUE);
        return supplierEntry;
    }
}

