/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidAnswerQuestionRecoService;
import kd.scm.bid.business.bill.IBidAnswerQuestionService;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidAnswerQuestionRecoServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidAnswerQuestionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.business.helper.BidStepInteractiveHelper;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SupplierServiceOrgUtil;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;
import kd.scm.bid.formplugin.bill.util.InvalidBillUtil;
import kd.scm.bid.formplugin.bill.util.SendMessageUtil;
import kd.scm.bid.formplugin.bill.util.SupplierInvitationUtil;
import kd.scm.bid.opplugin.bill.BidPublishOperationServicePlugin;
import kd.scm.bid.opplugin.bill.util.BidProjectQueryUtil;
import kd.scm.bid.opplugin.bill.util.NextStepSendMessage;

public class SupplierInvitationOperateServicePlugIn
extends AbstractOperationServicePlugIn {
    protected ISupplierInvitationService service = new SupplierInvitationServiceImpl();
    protected IBidOpenService openService = new BidOpenServiceImpl();
    protected IBidAnswerQuestionService bidAnswerQuestionService = new BidAnswerQuestionServiceImpl();
    protected IBidAnswerQuestionRecoService recoService = new BidAnswerQuestionRecoServiceImpl();
    protected IQuestionClarifyService clarifyService = new QuestionClarifyServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("bidproject");
        keys.add("bidsection");
        keys.add("bidsection.supplierentry");
        keys.add("bidsection.sectionname");
        keys.add("bidenrollsection.supplierenrollentry");
        keys.add("bidproject.id");
        keys.add("entitytypeid");
        keys.add("supplierentry.supplier");
        keys.add("supplierentry.invitationstatus");
        keys.add("supplierentry.isrecommend");
        keys.add("bidenrollsection.enrollsupplier");
        keys.add("bidenrollsection");
        keys.add("bidenrollsection.entrysectionname");
        keys.add("bidenrollsection.supplierenrollentry");
        keys.add("enrollsupplier");
        keys.add("applyuser");
        keys.add("sectionname");
        keys.add("invitationstatus");
        keys.add("isrecommend");
        keys.add("invitationuser");
        keys.add("projectpartner");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        final String appId = this.billEntityType.getAppId();
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String key = this.getOperateKey();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if ("submit".equals(key)) {
                    this.checkSupplierEmptyValidator(dataEntities);
                    this.checkInvitationStatus(dataEntities);
                    this.checkQueryStepIsProcess(dataEntities, appId);
                } else if ("unaudit".equals(key)) {
                    this.checkNextStepUnStart(dataEntities);
                } else if ("undoinvitation".equals(key)) {
                    this.checkUndoInvitation(dataEntities);
                } else if ("newdelete".equals(key)) {
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        DynamicObject dataSupplierEntity = dataEntity.getDataEntity();
                        String appId2 = dataSupplierEntity.getString("entitytypeid").split("_")[0];
                        DynamicObject[] invitationDataArray = BusinessDataServiceHelper.load((String)(appId2 + "_invitation"), (String)"status", (QFilter[])new QFilter[]{new QFilter("supplierinvitation", "=", dataSupplierEntity.getPkValue()), new QFilter("status", "not in", (Object)new String[]{"XX", "X"})});
                        if (invitationDataArray == null || invitationDataArray.length <= 0) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u9080\u8bf7\u51fd\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"SupplierInvitationOperateServicePlugIn_6", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                }
            }

            public void checkUndoInvitation(ExtendedDataEntity[] dataEntities) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    String invitationStatus;
                    DynamicObjectCollection supplierEntryColl;
                    String appId2 = dataEntity.getDataEntity().getString("entitytypeid").split("_")[0];
                    DynamicObject bidSupplierInvitation = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getBillPkId(), (String)(appId2 + "_supplierinvitation"));
                    boolean undoSendFlag = false;
                    boolean unSendFlag = true;
                    DynamicObjectCollection sectionEntryColl = bidSupplierInvitation.getDynamicObjectCollection("bidsection");
                    block1: for (DynamicObject sectionEntry : sectionEntryColl) {
                        supplierEntryColl = sectionEntry.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierEntry : supplierEntryColl) {
                            invitationStatus = supplierEntry.getString("invitationstatus");
                            if (!"ACCEPTED".equals(invitationStatus) && !"REJECTED".equals(invitationStatus)) continue;
                            undoSendFlag = true;
                            continue block1;
                        }
                    }
                    block3: for (DynamicObject sectionEntry : sectionEntryColl) {
                        supplierEntryColl = sectionEntry.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierEntry : supplierEntryColl) {
                            invitationStatus = supplierEntry.getString("invitationstatus");
                            if ("UNSEND".equals(invitationStatus)) {
                                unSendFlag = true;
                                continue;
                            }
                            unSendFlag = false;
                            continue block3;
                        }
                    }
                    if (unSendFlag) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u9080\u8bf7\u51fd\uff0c\u65e0\u9700\u64a4\u9500", (String)"SupplierInvitationOperateServicePlugIn_7", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (!undoSendFlag) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6709\u4f9b\u5e94\u5546\u63a5\u53d7\u6216\u62d2\u7edd\u9080\u8bf7\u51fd\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500", (String)"SupplierInvitationOperateServicePlugIn_8", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            }

            protected void checkInvitationStatus(ExtendedDataEntity[] dataEntities) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject bidProject = (DynamicObject)dataEntity.getValue("bidProject");
                    if (bidProject == null) continue;
                    QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidProject.getLong("id"));
                    QFilter statusFilter = new QFilter("status", "not in", (Object)new String[]{"XX", "X"});
                    DynamicObjectCollection invitationColl = QueryServiceHelper.query((String)"bid_invitation", (String)"id,status,releasestatus", (QFilter[])new QFilter[]{qFilter, statusFilter});
                    for (DynamicObject invitation : invitationColl) {
                        boolean flag = "P".equals(invitation.getString("releasestatus")) && "C".equals(invitation.getString("status"));
                        if (flag) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u9080\u8bf7\u51fd\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c", (String)"SupplierInvitationOperateServicePlugIn_9", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                }
            }

            protected void checkSupplierEmptyValidator(ExtendedDataEntity[] dataEntities) {
                Boolean enableObj = Boolean.TRUE;
                boolean enable = enableObj != null ? enableObj : false;
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject bidMode;
                    DynamicObject bidProject;
                    DynamicObjectCollection sections = (DynamicObjectCollection)dataEntity.getValue("bidsection");
                    if (sections == null || sections.size() == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8f93\u5165\u4e00\u6761\u4f9b\u5e94\u5546\u4fe1\u606f\u3002", (String)"SupplierInvitationOperateServicePlugIn_10", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    for (DynamicObject section : sections) {
                        DynamicObjectCollection suppliers = section.getDynamicObjectCollection("supplierentry");
                        if (suppliers != null && suppliers.size() != 0) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8f93\u5165\u4e00\u6761\u4f9b\u5e94\u5546\u4fe1\u606f\u3002", (String)"SupplierInvitationOperateServicePlugIn_10", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    if ((bidProject = (DynamicObject)dataEntity.getValue("bidProject")) == null || !SupplierInvitationOperateServicePlugIn.this.isOpenBid(bidMode = (DynamicObject)bidProject.get("bidmode"))) continue;
                    Date enrollDeadLine = bidProject.getDate("enrolldeadline");
                    if (!enable || enrollDeadLine == null || enrollDeadLine.compareTo(new Date()) <= 0) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c\u6295\u6807\u62a5\u540d\u65f6\u95f4\u201d\u5c1a\u672a\u622a\u6b62,\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"SupplierInvitationOperateServicePlugIn_11", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    break;
                }
            }

            private void checkQueryStepIsProcess(ExtendedDataEntity[] dataEntities, String appId2) {
                String s = "";
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    Long id = (Long)dataEntity.getValue("id");
                    DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_supplierinvitation");
                    String bidproject = supplierInvitation.getDynamicObject("bidproject").getPkValue().toString();
                    s = SupplierInvitationOperateServicePlugIn.this.clarifyService.checkQueryIsProcess(Long.valueOf(Long.parseLong(bidproject)), appId2);
                    if (StringUtils.isEmpty((Object)s)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)s, (String)"SupplierInvitationOperateServicePlugIn_4", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            }

            protected void checkNextStepUnStart(ExtendedDataEntity[] dataEntities) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    Long id = (Long)dataEntity.getValue("id");
                    DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_supplierinvitation");
                    if (SupplierInvitationUtil.isAgainSupplierInvitation((DynamicObject)supplierInvitation)) continue;
                    DynamicObject bidProject = dataEntity.getDataEntity().getDynamicObject("bidproject");
                    if (!SupplierInvitationOperateServicePlugIn.this.service.checkNextStepUnStarted(bidProject, BidStepEnum.SupplierInvitation)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"SupplierInvitationOperateServicePlugIn_13", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObjectCollection recos = SupplierInvitationOperateServicePlugIn.this.recoService.getRecordByProjectId(Long.valueOf(bidProject.getLong("id")));
                    if (recos.size() > 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5b58\u5728\u7b54\u7591\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SupplierInvitationOperateServicePlugIn_14", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    BidStepEnum[] nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)bidProject, (BidStepEnum)BidStepEnum.SupplierInvitation);
                    if (nextStep == null || BidStepEnum.BidAnswerQuestion != nextStep[0] || SupplierInvitationOperateServicePlugIn.this.bidAnswerQuestionService.checkNextStepUnStarted(bidProject, BidStepEnum.BidAnswerQuestion)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"SupplierInvitationOperateServicePlugIn_13", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    protected boolean isOpenBid(DynamicObject bidMode) {
        return BidModeHelper.isPublicBiddingByModel((DynamicObject)bidMode);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if ("audit".equals(key) || "unaudit".equals(key)) {
            this.handleBeforeAuditOrUnAudit(key, datas);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if ("audit".equals(key)) {
            NextStepSendMessage nextStepSendMessage = null;
            for (DynamicObject proObj : datas) {
                DynamicObject bidProject = proObj.getDynamicObject("bidproject");
                bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
                nextStepSendMessage = new NextStepSendMessage();
                nextStepSendMessage.nextStepSendMessage(bidProject, BidStepEnum.SupplierInvitation);
            }
            String appId = this.billEntityType.getAppId();
            boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
            if (!enable) {
                return;
            }
            new SendMessageUtil().sendSupplierInvitationSeletedMsg(datas, appId);
        }
    }

    public void handleBeforeAuditOrUnAudit(String key, DynamicObject[] datas) {
        if (datas != null && datas.length > 0) {
            Object[] pks = new Object[datas.length];
            Long[] suppInviIds = new Long[datas.length];
            int i = 0;
            for (DynamicObject supplierInvitationObj : datas) {
                suppInviIds[i] = (Long)supplierInvitationObj.get("id");
                pks[i] = supplierInvitationObj.getPkValue();
                ++i;
            }
            String appId = this.billEntityType.getAppId();
            String tender = "bid".equals(appId) ? "ten" : "resp";
            datas = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)this.billEntityType);
            BidProjectServiceImpl bidProService = new BidProjectServiceImpl();
            LinkedList<Object> stepEnumList = null;
            for (DynamicObject supplierInvitationObj : datas) {
                DynamicObject myTender;
                int n;
                DynamicObject[] myTenderArr;
                List<String> tenderStatusList;
                String selectFields;
                BidStepEnum[] nextStep;
                String sourceBillId;
                DynamicObject bidProject = supplierInvitationObj.getDynamicObject("bidproject");
                HashMap<String, String> stepMap = BidProjectQueryUtil.queryStep(bidProject.getPkValue());
                if ("audit".equals(key)) {
                    this.updateSuppllier(supplierInvitationObj);
                    if (SupplierInvitationUtil.isAgainSupplierInvitation((DynamicObject)supplierInvitationObj)) {
                        if (BidStepInteractiveHelper.checkStepComplete((Long)((Long)bidProject.getPkValue()), (BidStepEnum)BidStepEnum.BidDocument)) {
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("isAgain", "1");
                            String sourceBillId2 = supplierInvitationObj.getString("sourcebillid");
                            DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"id,billstatus,rounds,bidstep,isnewbill", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("isnewbill", "=", (Object)Boolean.TRUE)});
                            if (bidPublish != null) {
                                bidPublish.set("bidstep", (Object)supplierInvitationObj.getString("bidstep"));
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidPublish});
                                DynamicObject[] bidOpenArray = BusinessDataServiceHelper.load((String)(appId + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidpublishid", "=", bidPublish.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{BillStatusEnum.INVALIDXX.getVal(), BillStatusEnum.INVALID.getVal()})});
                                if (bidOpenArray != null && bidOpenArray.length > 0) {
                                    for (DynamicObject bidOpen : bidOpenArray) {
                                        InvalidBillUtil.invalidBidAssinviteBill((String)appId, (Long)bidOpen.getLong("id"));
                                    }
                                }
                            }
                            InvalidBillUtil.invalidLaterBillByCurrentStep((DynamicObject)bidProject, (Object)sourceBillId2, (Object)supplierInvitationObj.getPkValue(), null, (BidStepEnum)BidStepEnum.SupplierInvitation);
                            BidStepEnum[] steps = BidStepInteractiveHelper.getNextStep((DynamicObject)bidProject, (BidStepEnum)BidStepEnum.SupplierInvitation);
                            if (steps != null && BidStepEnum.BidPublish == steps[0]) {
                                this.service.createNextStep(bidProject, params, BidStepEnum.SupplierInvitation);
                            } else {
                                this.service.createNextStep(bidProject, BidStepEnum.SupplierInvitation);
                            }
                            if (stepMap.get(BidStepEnum.Clarificaiton.name()) == null) continue;
                            BidStepEnum[] stepEnumArr = BidPublishOperationServicePlugin.getCurrentSteps(bidProject, BidStepEnum.BidPublish);
                            bidProService.saveCurrentBidStep(bidProject.getPkValue(), stepEnumArr);
                            continue;
                        }
                        sourceBillId = supplierInvitationObj.getString("sourcebillid");
                        InvalidBillUtil.invalidLaterBillByCurrentStep((DynamicObject)bidProject, (Object)sourceBillId, (Object)supplierInvitationObj.getPkValue(), null, (BidStepEnum)BidStepEnum.SupplierInvitation);
                        if (stepMap.get(BidStepEnum.Clarificaiton.name()) != null) {
                            bidProService.saveCurrentBidStep(bidProject.getPkValue(), new BidStepEnum[]{BidStepEnum.BidDocument, BidStepEnum.Clarificaiton});
                            continue;
                        }
                        bidProService.saveCurrentBidStep(bidProject.getPkValue(), new BidStepEnum[]{BidStepEnum.BidDocument});
                        continue;
                    }
                    this.service.handleInvitedQty(suppInviIds, "audit".equals(key), appId + "_supplierstatistic");
                    nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)bidProject, (BidStepEnum)BidStepEnum.SupplierInvitation);
                    if (nextStep != null && BidStepEnum.BidAnswerQuestion == nextStep[0]) {
                        BidAnswerQuestionServiceImpl service = new BidAnswerQuestionServiceImpl();
                        service.createNextStep(bidProject, BidStepEnum.BidAnswerQuestion);
                    }
                    if (BidStepInteractiveHelper.checkStepComplete((Long)((Long)bidProject.getPkValue()), (BidStepEnum)BidStepEnum.BidDocument)) {
                        BidStepEnum[] steps = BidStepInteractiveHelper.getNextStep((DynamicObject)bidProject, (BidStepEnum)BidStepEnum.SupplierInvitation);
                        if (steps != null && BidStepEnum.BidPublish == steps[0]) {
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("isAgain", "1");
                            this.service.createNextStep(bidProject, params, BidStepEnum.SupplierInvitation);
                        } else {
                            this.service.createNextStep(bidProject, BidStepEnum.SupplierInvitation);
                        }
                        if (stepMap.get(BidStepEnum.Clarificaiton.name()) != null) {
                            bidProService.saveCurrentBidStep(bidProject.getPkValue(), new BidStepEnum[]{BidStepEnum.Clarificaiton, BidStepEnum.BidPublish});
                        }
                    } else if (stepMap.get(BidStepEnum.Clarificaiton.name()) != null) {
                        bidProService.saveCurrentBidStep(bidProject.getPkValue(), new BidStepEnum[]{BidStepEnum.BidDocument, BidStepEnum.Clarificaiton});
                    } else {
                        bidProService.saveCurrentBidStep(bidProject.getPkValue(), new BidStepEnum[]{BidStepEnum.BidDocument});
                    }
                    selectFields = "bidproject,supplier,entry,entry.sectionname,entry.projectsection,entry.sectionstatus,ispublicbid,tenderstatus";
                    tenderStatusList = Arrays.asList(MyTenderStatus.ACCEPT_INVITED.getValue(), MyTenderStatus.APPLIED.getValue());
                    myTenderArr = BusinessDataServiceHelper.load((String)(tender + "_mytender"), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("tenderstatus", "in", tenderStatusList)});
                    List<Map<Object, String>> supplierIdMapList = this.queryRecommendSupplierId(supplierInvitationObj);
                    ArrayList<Object> recommendSupplierIds = new ArrayList<Object>(16);
                    if (!CollectionUtils.isEmpty(supplierIdMapList)) {
                        for (Map<Object, String> map : supplierIdMapList) {
                            Set<Object> supplierIdList = map.keySet();
                            recommendSupplierIds.addAll(supplierIdList);
                        }
                    }
                    DynamicObject[] dynamicObjectArray = myTenderArr;
                    int n2 = dynamicObjectArray.length;
                    for (n = 0; n < n2; ++n) {
                        myTender = dynamicObjectArray[n];
                        DynamicObject supplier = myTender.getDynamicObject("supplier");
                        if (supplier == null) continue;
                        if (!recommendSupplierIds.isEmpty() && recommendSupplierIds.contains(supplier.getPkValue())) {
                            myTender.set("tenderstatus", (Object)MyTenderStatus.INVITED.getValue());
                        } else {
                            myTender.set("tenderstatus", (Object)MyTenderStatus.UNINVITED.getValue());
                        }
                        for (DynamicObject myTenderEntry : myTender.getDynamicObjectCollection("entry")) {
                            if (MyTenderStatus.UNINVITED.getValue().equals(myTenderEntry.getString("sectionstatus"))) continue;
                            String sectionName = myTenderEntry.getString("sectionname");
                            boolean isInvited = false;
                            for (Map<Object, String> map : supplierIdMapList) {
                                String sectionname = map.get(supplier.getPkValue());
                                if (!sectionName.equals(sectionname)) continue;
                                isInvited = true;
                                break;
                            }
                            if (isInvited && !recommendSupplierIds.isEmpty() && recommendSupplierIds.contains(supplier.getPkValue())) {
                                myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.INVITED.getValue());
                                continue;
                            }
                            myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.UNINVITED.getValue());
                        }
                    }
                    SaveServiceHelper.update((DynamicObject[])myTenderArr);
                    continue;
                }
                if (SupplierInvitationUtil.isAgainSupplierInvitation((DynamicObject)supplierInvitationObj)) {
                    sourceBillId = supplierInvitationObj.getString("sourcebillid");
                    DeleteServiceHelper.delete((String)"bid_bidpublish", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.DISBEGIN.getVal())});
                    QFilter[] qFilters = new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("supplierinvitationid", "=", (Object)Long.valueOf(sourceBillId)), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALID.getVal())};
                    DynamicObject[] bidPublishColl = BusinessDataServiceHelper.load((String)"bid_bidpublish", (String)"id,billstatus,rounds,bidstep,isnewbill", (QFilter[])qFilters, (String)"rounds desc");
                    DynamicObject bidPublish = null;
                    if (bidPublishColl != null && bidPublishColl.length > 0) {
                        bidPublish = bidPublishColl[0];
                        bidPublish.set("isnewbill", (Object)Boolean.TRUE);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidPublish});
                    }
                    bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(appId + "_project"));
                    if (bidPublish != null) {
                        String bidOpenType = bidProject.getString("bidopentype");
                        if ("TECHBUSINESS".equals(bidOpenType)) {
                            DynamicObject[] openBillBussArrays;
                            DynamicObject[] openBillTechArrays = BusinessDataServiceHelper.load((String)(appId + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidpublishid", "=", bidPublish.getPkValue()), new QFilter("opentype", "=", (Object)"TECHNICAL")}, (String)"createtime desc");
                            if (openBillTechArrays != null && openBillTechArrays.length > 0) {
                                InvalidBillUtil.validBidAssinviteBill((String)appId, (Long)openBillTechArrays[0].getLong("id"));
                            }
                            if ((openBillBussArrays = BusinessDataServiceHelper.load((String)(appId + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidpublishid", "=", bidPublish.getPkValue()), new QFilter("opentype", "=", (Object)"BUSSINESS")}, (String)"createtime desc")) != null && openBillBussArrays.length > 0) {
                                InvalidBillUtil.validBidAssinviteBill((String)appId, (Long)openBillTechArrays[0].getLong("id"));
                            }
                        } else {
                            DynamicObject[] bidOpenArray = BusinessDataServiceHelper.load((String)(appId + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidpublishid", "=", bidPublish.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal())}, (String)"createtime desc");
                            if (bidOpenArray != null && bidOpenArray.length > 0) {
                                InvalidBillUtil.validBidAssinviteBill((String)appId, (Long)bidOpenArray[0].getLong("id"));
                            }
                        }
                        InvalidBillUtil.validLaterBillByCurrentStep((DynamicObject)bidProject, (Object)sourceBillId, (Object)supplierInvitationObj.getPkValue(), (BidStepEnum)BidStepEnum.SupplierInvitation, (Object)bidPublish.getPkValue());
                    } else {
                        InvalidBillUtil.validLaterBillByCurrentStep((DynamicObject)bidProject, (Object)sourceBillId, (Object)supplierInvitationObj.getPkValue(), (BidStepEnum)BidStepEnum.SupplierInvitation, null);
                    }
                } else {
                    this.service.handleInvitedQty(suppInviIds, "audit".equals(key), appId + "_supplierstatistic");
                    this.service.deleteNextStepUnStarted(bidProject, BidStepEnum.SupplierInvitation);
                    nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)bidProject, (BidStepEnum)BidStepEnum.SupplierInvitation);
                    if (nextStep != null && BidStepEnum.BidAnswerQuestion == nextStep[0] && bidProject.getBoolean("bidopen")) {
                        this.openService.deleteUnStarted(bidProject.getPkValue());
                    }
                    if (nextStep != null && BidStepEnum.BidAnswerQuestion == nextStep[0]) {
                        BidAnswerQuestionServiceImpl answerQuestionService = new BidAnswerQuestionServiceImpl();
                        answerQuestionService.deleteNextStepUnStarted(bidProject, BidStepEnum.BidAnswerQuestion);
                        if (stepMap.get(BidStepEnum.Clarificaiton.name()) != null) {
                            bidProService.saveCurrentBidStep(bidProject.getPkValue(), new BidStepEnum[]{BidStepEnum.SupplierInvitation, BidStepEnum.Clarificaiton});
                        } else {
                            bidProService.saveCurrentBidStep(bidProject.getPkValue(), new BidStepEnum[]{BidStepEnum.SupplierInvitation});
                        }
                    }
                    selectFields = "bidproject,supplier,entry,entry.sectionname,entry.projectsection,entry.sectionstatus,ispublicbid,tenderstatus";
                    tenderStatusList = Arrays.asList(MyTenderStatus.INVITED.getValue(), MyTenderStatus.UNINVITED.getValue());
                    myTenderArr = BusinessDataServiceHelper.load((String)(tender + "_mytender"), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("tenderstatus", "in", tenderStatusList)});
                    DynamicObject bidMode = (DynamicObject)bidProject.get("bidmode");
                    boolean openBid = this.isOpenBid(bidMode);
                    DynamicObject[] dynamicObjectArray = myTenderArr;
                    int n3 = dynamicObjectArray.length;
                    for (n = 0; n < n3; ++n) {
                        myTender = dynamicObjectArray[n];
                        String tenderStatus = openBid ? MyTenderStatus.APPLIED.getValue() : MyTenderStatus.ACCEPT_INVITED.getValue();
                        myTender.set("tenderstatus", (Object)tenderStatus);
                        for (DynamicObject myTenderEntry : myTender.getDynamicObjectCollection("entry")) {
                            myTenderEntry.set("sectionstatus", (Object)tenderStatus);
                        }
                    }
                    SaveServiceHelper.update((DynamicObject[])myTenderArr);
                }
                if (stepMap.get(BidStepEnum.Clarificaiton.name()) == null) continue;
                HashMap<String, Object> bidStepEnumHashMap = BidProjectQueryUtil.queryStepEnum(bidProject.getPkValue());
                if (bidStepEnumHashMap == null) {
                    bidStepEnumHashMap = new HashMap(16);
                }
                bidStepEnumHashMap.put("Clarificaiton", BidStepEnum.Clarificaiton);
                stepEnumList = new LinkedList<Object>();
                if (bidStepEnumHashMap != null && !bidStepEnumHashMap.isEmpty()) {
                    stepEnumList.addAll(bidStepEnumHashMap.values());
                }
                bidProService.saveCurrentBidStep(bidProject.getPkValue(), stepEnumList.toArray(new BidStepEnum[stepEnumList.size()]));
            }
        }
    }

    protected List<Map<Object, String>> queryRecommendSupplierId(DynamicObject supplierInvitationObj) {
        ArrayList<Map<Object, String>> bidSupplierIdList = new ArrayList<Map<Object, String>>();
        DynamicObjectCollection bidSectionCol = supplierInvitationObj.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidSection : bidSectionCol) {
            String sectionname = bidSection.getString("sectionname");
            DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryCol) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                boolean isRecommend = supplierEntry.getBoolean("isrecommend");
                if (supplier == null || !isRecommend) continue;
                HashMap<Object, String> supplierIdSectionMap = new HashMap<Object, String>();
                supplierIdSectionMap.put(supplier.getPkValue(), sectionname);
                bidSupplierIdList.add(supplierIdSectionMap);
            }
        }
        return bidSupplierIdList;
    }

    protected void updateSuppllier(DynamicObject supplierInvitationObj) {
        DynamicObject supplier;
        DynamicObjectCollection bidSectionCol = supplierInvitationObj.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection bidEnrollSectionCol = supplierInvitationObj.getDynamicObjectCollection("bidenrollsection");
        ArrayList<Object> bidSupplierIdList = new ArrayList<Object>();
        for (DynamicObject bidSection : bidSectionCol) {
            DynamicObjectCollection dynamicObjectCollection = bidSection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : dynamicObjectCollection) {
                supplier = supplierEntry.getDynamicObject("supplier");
                if (supplier == null) continue;
                bidSupplierIdList.add(supplier.getPkValue());
            }
        }
        for (DynamicObject bidEnrollSection : bidEnrollSectionCol) {
            DynamicObjectCollection dynamicObjectCollection = bidEnrollSection.getDynamicObjectCollection("supplierenrollentry");
            for (DynamicObject supplierEntry : dynamicObjectCollection) {
                supplier = supplierEntry.getDynamicObject("enrollsupplier");
                if (supplier == null) continue;
                bidSupplierIdList.add(supplier.getPkValue());
            }
        }
        String appId = this.billEntityType.getAppId();
        if (!"bid".equals(appId) && !bidSupplierIdList.isEmpty()) {
            for (Object e : bidSupplierIdList) {
                SupplierServiceOrgUtil.updateServiceOrg((Object)supplierInvitationObj.getDynamicObject("org").getPkValue(), e, (String)"resm_official_supplier");
            }
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeoperationargs) {
        super.beforeExecuteOperationTransaction(beforeoperationargs);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginoperationtransactionargs) {
        block20: {
            DynamicObject[] datas;
            String key;
            block22: {
                block21: {
                    block19: {
                        super.beginOperationTransaction(beginoperationtransactionargs);
                        key = beginoperationtransactionargs.getOperationKey();
                        datas = beginoperationtransactionargs.getDataEntities();
                        if (!"save".equals(key)) break block19;
                        for (DynamicObject supplierInvitationObj : datas) {
                            String billstatus = supplierInvitationObj.getString("billstatus");
                            if (!"D".equals(billstatus) && !"A".equals(billstatus)) continue;
                            supplierInvitationObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                        }
                        break block20;
                    }
                    if (!"newdelete".equals(key)) break block21;
                    for (DynamicObject supplierInvitationObj : datas) {
                        DynamicObject supplierInvitation = this.service.getSupplierInvitationById(Long.valueOf(supplierInvitationObj.getLong("id")));
                        DynamicObject bidProject = supplierInvitationObj.getDynamicObject("bidproject");
                        if (bidProject == null) continue;
                        if (!SupplierInvitationUtil.isAgainSupplierInvitation((DynamicObject)supplierInvitation)) {
                            MainEntityType mainType;
                            DynamicObject bidProjects = BusinessDataServiceHelper.loadSingle((Object)supplierInvitationObj.get("bidproject.id"), (String)"bid_project");
                            String entityTypePre = bidProjects.getString("entitytypeid").split("_")[0];
                            DynamicObject project = null;
                            EntityType supplierDetailType = null;
                            EntityType sectionEntryType = null;
                            if ("bid".equals(entityTypePre)) {
                                project = BusinessDataServiceHelper.loadSingle((Object)bidProjects.get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bid_project"));
                                mainType = EntityMetadataCache.getDataEntityType((String)"bid_supplierinvitation");
                                supplierDetailType = (EntityType)mainType.getAllEntities().get("supplierentry");
                                sectionEntryType = (EntityType)mainType.getAllEntities().get("bidsection");
                            } else if ("rebm".equals(entityTypePre)) {
                                project = BusinessDataServiceHelper.loadSingle((Object)bidProjects.get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rebm_project"));
                                mainType = EntityMetadataCache.getDataEntityType((String)"rebm_supplierinvitation");
                                supplierDetailType = (EntityType)mainType.getAllEntities().get("supplierentry");
                                sectionEntryType = (EntityType)mainType.getAllEntities().get("bidsection");
                            }
                            supplierInvitation.set("billstatus", (Object)"D");
                            supplierInvitation.set("supplierqty", (Object)0);
                            DynamicObjectCollection bidsection = supplierInvitation.getDynamicObjectCollection("bidsection");
                            bidsection.clear();
                            DynamicObjectCollection suppInviSections = new DynamicObjectCollection((DynamicObjectType)sectionEntryType, (Object)supplierInvitation);
                            HashSet<Object> supplierPks = new HashSet<Object>();
                            if (project != null) {
                                DynamicObjectCollection bidRollSections = project.getDynamicObjectCollection("bidrollsection");
                                for (DynamicObject section : bidRollSections) {
                                    DynamicObject supplierSection = new DynamicObject((DynamicObjectType)sectionEntryType);
                                    supplierSection.set("seq", section.get("seq"));
                                    supplierSection.set("sectionname", section.get("rollsectionname"));
                                    DynamicObjectCollection projSuppliers = section.getDynamicObjectCollection("supplierentry");
                                    DynamicObjectCollection suppInviSuppliers = new DynamicObjectCollection((DynamicObjectType)supplierDetailType, (Object)supplierSection);
                                    supplierSection.set("supplierentry", (Object)suppInviSuppliers);
                                    for (DynamicObject supplier : projSuppliers) {
                                        DynamicObject supplierEntry = new DynamicObject((DynamicObjectType)supplierDetailType);
                                        DynamicObject bdSupplier = supplier.getDynamicObject("supplier");
                                        if (bdSupplier != null) {
                                            supplierPks.add(bdSupplier.getPkValue());
                                        }
                                        supplierEntry.set("seq", supplier.get("seq"));
                                        supplierEntry.set("supplier", (Object)bdSupplier);
                                        supplierEntry.set("suppliercontact", supplier.get("suppliercontact"));
                                        supplierEntry.set("contactphone", supplier.get("contactphone"));
                                        supplierEntry.set("suppliercomment", supplier.get("suppliercomment"));
                                        supplierEntry.set("supplierstatistic", supplier.get("supplierstatistic"));
                                        supplierEntry.set("email", supplier.get("email"));
                                        supplierEntry.set("address", supplier.get("address"));
                                        supplierEntry.set("fax", supplier.get("fax"));
                                        supplierEntry.set("invitationstatus", (Object)"UNSEND");
                                        supplierEntry.set("isfromproject", (Object)"true");
                                        suppInviSuppliers.add((Object)supplierEntry);
                                    }
                                    suppInviSections.add((Object)supplierSection);
                                }
                            }
                            DynamicObjectCollection bidenrollsection = supplierInvitation.getDynamicObjectCollection("bidenrollsection");
                            for (int i = 0; i < bidenrollsection.size(); ++i) {
                                DynamicObjectCollection supplierenrollentryColl = ((DynamicObject)bidenrollsection.get(i)).getDynamicObjectCollection("supplierenrollentry");
                                if (supplierenrollentryColl.isEmpty()) continue;
                                for (int j = 0; j < supplierenrollentryColl.size(); ++j) {
                                    DynamicObject entry = (DynamicObject)supplierenrollentryColl.get(j);
                                    entry.set("isinvitation", (Object)Boolean.FALSE);
                                }
                            }
                            supplierInvitation.set("bidsection", (Object)suppInviSections);
                            supplierInvitation.set("supplierqty", (Object)supplierPks.size());
                            supplierInvitation.set("createtime", (Object)new Date());
                            supplierInvitation.set("creator", (Object)RequestContext.get().getUserId());
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplierInvitation});
                            continue;
                        }
                        String sourceBillId = supplierInvitation.getString("sourcebillid");
                        DynamicObject sourceSupplierInvitation = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"bid_supplierinvitation");
                        sourceSupplierInvitation.set("listprojectname", (Object)bidProject.getString("name"));
                        SaveServiceHelper.update((DynamicObject)sourceSupplierInvitation);
                        DeleteServiceHelper.delete((String)"bid_supplierinvitation", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierInvitationObj.getLong("id"))});
                    }
                    break block20;
                }
                if (!"auditing".equals(key)) break block22;
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    DynamicObject dataEntitie = this.dataEntities[i];
                    Object id = dataEntitie.getPkValue();
                    DynamicObject test_audit = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_supplierinvitation");
                    test_audit.set("billstatus", (Object)BillStatusEnum.AUDITING.getVal());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{test_audit});
                }
                break block20;
            }
            if (!"undoinvitation".equals(key)) break block20;
            for (DynamicObject dataEntity : datas) {
                DynamicObjectCollection bidSectionCol = dataEntity.getDynamicObjectCollection("bidsection");
                ArrayList<Long> bidSupplierIdList = new ArrayList<Long>();
                for (DynamicObject bidSection : bidSectionCol) {
                    DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier != null) {
                            bidSupplierIdList.add(Long.parseLong(supplier.getString("id")));
                        }
                        supplierEntry.set("invitationstatus", (Object)"UNSEND");
                        supplierEntry.set("isrecommend", (Object)Boolean.TRUE);
                    }
                }
                DynamicObject bidProject = dataEntity.getDynamicObject("bidProject");
                DynamicObject realBidProject = null;
                if (bidProject == null) continue;
                realBidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
                String appId = realBidProject.getString("entitytypeid").split("_")[0];
                DynamicObjectCollection bidRollSectionCol = realBidProject.getDynamicObjectCollection("bidrollsection");
                for (DynamicObject bidSection : bidRollSectionCol) {
                    DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier == null || CollectionUtils.isEmpty(bidSupplierIdList) || !bidSupplierIdList.contains(supplier.getLong("id"))) continue;
                        supplierEntry.set("invitationstatus", (Object)"UNSEND");
                    }
                }
                DeleteServiceHelper.delete((String)(appId + "_invitation"), (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProject.getPkValue()).and(new QFilter("supplierentry.supplier.id", "in", bidSupplierIdList))});
                SaveServiceHelper.update((DynamicObject)dataEntity);
                SaveServiceHelper.update((DynamicObject)realBidProject);
            }
        }
    }
}

