/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill.cancel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidAnswerQuestionRecoService;
import kd.scm.bid.business.bill.IBidBottomMakeService;
import kd.scm.bid.business.bill.IBidDecisionService;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.IOnlineBidEvalService;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidAnswerQuestionRecoServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidBottomMakeServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDecisionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.OnlineBidEvalServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SupplierHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.common.util.bidabordrepair.BidAbortiveUtil;
import kd.scm.bid.opplugin.bill.cancel.ValidatorBidProject;

public class BidCancelOp
extends AbstractOperationServicePlugIn {
    private ISupplierInvitationService supplierInvitationService = new SupplierInvitationServiceImpl();
    private IBidBottomMakeService bidBottomMakeService = new BidBottomMakeServiceImpl();
    private IBidOpenService bidOpenService = new BidOpenServiceImpl();
    private IBidDecisionService bidDecisionService = new BidDecisionServiceImpl();
    private IBidProjectService projectService = new BidProjectServiceImpl();
    private IBidAnswerQuestionRecoService recoService = new BidAnswerQuestionRecoServiceImpl();
    private IOnlineBidEvalService onlineBidEvalService = new OnlineBidEvalServiceImpl();
    private IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("bidproject");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String appId = this.billEntityType.getAppId();
        ValidatorBidProject validatorBidProject = new ValidatorBidProject();
        validatorBidProject.setAppIDD(appId);
        e.addValidator((AbstractValidator)validatorBidProject);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bidassinvites;
        DynamicObject[] extracts;
        DynamicObject[] multiquestclarifys;
        DynamicObject[] invitationColl;
        DynamicObject[] announcementColl;
        DynamicObject[] myTenderArr;
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if (!"audit".equals(key) && !"submitandauti".equals(key)) {
            return;
        }
        String appId = this.billEntityType.getAppId();
        HashSet<Long> bidProjectIDSet = new HashSet<Long>();
        ArrayList<String> bidProjectIdStrList = new ArrayList<String>(50);
        ArrayList<DynamicObject> abortList = new ArrayList<DynamicObject>(50);
        for (DynamicObject proObj : datas) {
            DynamicObject[] negotiates;
            DynamicObject[] invitationDataArray;
            DynamicObject cancel = BusinessDataServiceHelper.loadSingle((Object)proObj.getPkValue(), (String)(this.billEntityType.getAppId() + "_projectcancel"));
            cancel.set("auditdate", (Object)new Date());
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
            cancel.set("auditor", (Object)user);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{cancel});
            Long projectId = Long.parseLong(proObj.getDynamicObject("bidproject").getPkValue().toString());
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)(appId + "_project"));
            String appid = bidProject.getString("entitytypeid").split("_")[0];
            abortList.add(this.syncDataToAbort(projectId, appid));
            this.sendMessage(key, projectId, appid);
            this.sendMessageToMember(key, projectId, appid, bidProject);
            bidProject.set("billstatus", (Object)"X");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidProject});
            Boolean isInvitation = bidProject.getBoolean("supplierinvitation");
            if (isInvitation.booleanValue()) {
                this.supplierInvitationService.invalidInvitation(projectId, appId + "_supplierstatistic");
            }
            for (DynamicObject invitationData : invitationDataArray = BusinessDataServiceHelper.load((String)(appid + "_invitation"), (String)"id, status, releasestatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("status", "!=", (Object)"X")})) {
                invitationData.set("status", (Object)"X");
                invitationData.set("releasestatus", null);
            }
            SaveServiceHelper.save((DynamicObject[])invitationDataArray);
            this.bidBottomMakeService.saveBidBottomMakeInvalidStatus(projectId, appId);
            Boolean isBidOpen = bidProject.getBoolean("bidopen");
            if (isBidOpen.booleanValue()) {
                this.bidOpenService.invalidProficients(projectId);
            }
            this.bidDecisionService.invalidBidDecision(projectId, appId + "_supplierstatistic");
            this.projectService.saveProjectInvalidStatus(projectId.toString());
            this.recoService.saveRecoInvalidStatus((Object)projectId);
            this.onlineBidEvalService.saveOnlineBidEvalInvalidStatus(projectId);
            bidProjectIDSet.add(projectId);
            bidProjectIdStrList.add(projectId.toString());
            this.questionClarifyService.setProjectClarifyDataInvalid((Object)projectId);
            DynamicObject[] rebackbid = BusinessDataServiceHelper.load((String)(appid + "_rebackbid"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
            if (rebackbid != null && rebackbid.length > 0) {
                for (DynamicObject reback : rebackbid) {
                    reback.set("billstatus", (Object)"X");
                }
                SaveServiceHelper.save((DynamicObject[])rebackbid);
            }
            if ((negotiates = BusinessDataServiceHelper.load((String)(appid + "_negotiate_invite"), (String)"status", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)})) == null || negotiates.length <= 0) continue;
            for (DynamicObject negotiate : negotiates) {
                negotiate.set("status", (Object)"X");
            }
            SaveServiceHelper.save((DynamicObject[])negotiates);
        }
        if (abortList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])abortList.toArray(new DynamicObject[0]));
        }
        for (DynamicObject myTender : myTenderArr = BusinessDataServiceHelper.load((String)"ten_mytender", (String)"tenderstatus,statusbeforefailure", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIDSet)})) {
            myTender.set("statusbeforefailure", myTender.get("tenderstatus"));
            myTender.set("tenderstatus", (Object)MyTenderStatus.FAILURE);
        }
        SaveServiceHelper.update((DynamicObject[])myTenderArr);
        for (DynamicObject announcement : announcementColl = BusinessDataServiceHelper.load((String)"bid_project_announcement", (String)"status,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIdStrList)})) {
            announcement.set("status", (Object)"C");
            announcement.set("billstatus", (Object)"X");
        }
        SaveServiceHelper.save((DynamicObject[])announcementColl);
        for (DynamicObject invitation : invitationColl = BusinessDataServiceHelper.load((String)"bid_invitation", (String)"enable,supplierentry,supplierentry.invitationstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIDSet)})) {
            invitation.set("enable", (Object)"2");
            DynamicObjectCollection supplierentry = invitation.getDynamicObjectCollection("supplierentry");
            for (DynamicObject next : supplierentry) {
                next.set("invitationstatus", (Object)"NULLIFY");
            }
        }
        SaveServiceHelper.save((DynamicObject[])invitationColl);
        for (DynamicObject multiquestclarify : multiquestclarifys = BusinessDataServiceHelper.load((String)(appId + "_multiquestclarify"), (String)"id,billstatus,publicstatis", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIDSet)})) {
            multiquestclarify.set("billstatus", (Object)"INVALID");
        }
        SaveServiceHelper.update((DynamicObject[])multiquestclarifys);
        String table = "";
        table = appId.equals("rebm") ? "rebm_query_letters_inh" : "bid_query_letters";
        DynamicObject[] letters = BusinessDataServiceHelper.load((String)table, (String)"id,status", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIDSet)});
        if (letters != null && letters.length > 0) {
            for (DynamicObject letter : letters) {
                letter.set("status", (Object)"X");
            }
            SaveServiceHelper.update((DynamicObject[])letters);
        }
        if ((extracts = BusinessDataServiceHelper.load((String)(appId + "_proficient_extract"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidprojectname", "in", bidProjectIDSet)})) != null && extracts.length > 0) {
            Set extractIds = Arrays.stream(extracts).map(d -> Long.parseLong(d.getPkValue().toString())).collect(Collectors.toSet());
            DynamicObject[] bidassinvitesums = BusinessDataServiceHelper.load((String)(appId + "_bidassinvitesum"), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("linkexpertextract", "in", extractIds), new QFilter("billstatus", "!=", (Object)"XX")});
            if (bidassinvitesums != null && bidassinvitesums.length > 0) {
                for (DynamicObject bidassinvitesumData : bidassinvitesums) {
                    bidassinvitesumData.set("billstatus", (Object)"X");
                }
                SaveServiceHelper.update((DynamicObject[])bidassinvitesums);
            }
        }
        if ((bidassinvites = BusinessDataServiceHelper.load((String)(appId + "_bidassinvite"), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("name", "in", bidProjectIDSet), new QFilter("billstatus", "!=", (Object)"XX")})) != null && bidassinvites.length > 0) {
            for (DynamicObject bidassinviteData : bidassinvites) {
                bidassinviteData.set("billstatus", (Object)"X");
            }
            SaveServiceHelper.update((DynamicObject[])bidassinvites);
        }
    }

    protected DynamicObject syncDataToAbort(Long projectId, String appid) {
        DynamicObject abort = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)(appid + "_" + "abored_repair")));
        abort.set("bidproject", (Object)projectId);
        abort.set("displayflag", (Object)Boolean.FALSE);
        abort.set("deletedataflag", (Object)Boolean.FALSE);
        abort.set("recoverflag", (Object)Boolean.FALSE);
        abort.set("creator", (Object)RequestContext.get().getCurrUserId());
        abort.set("billstatus", (Object)"B");
        abort.set("isfromcancle", (Object)Boolean.TRUE);
        BidAbortiveUtil.fillEntryDownLoadBillsData((Object)projectId, (String)appid, (DynamicObject)abort);
        return abort;
    }

    private void sendMessage(String key, Long projectId, String appId) {
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable) {
            return;
        }
        DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidpublish"), (String)"bidsection,sectionname,supplier,projectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", (Object)projectId), new QFilter("billstatus", "=", (Object)"P")});
        HashSet<Long> receiveUserIds = new HashSet<Long>();
        HashSet<Long> supplierIds = new HashSet<Long>();
        if (bidPublish != null) {
            DynamicObjectCollection bidSection = bidPublish.getDynamicObjectCollection("bidsection");
            for (DynamicObject sectionEntry : bidSection) {
                DynamicObjectCollection supplierentry = sectionEntry.getDynamicObjectCollection("supplierentry");
                for (DynamicObject entry : supplierentry) {
                    long supplierId = (Long)entry.getDynamicObject("supplier").getPkValue();
                    supplierIds.add(supplierId);
                    DynamicObject projectPartner = entry.getDynamicObject("projectpartner");
                    if (projectPartner == null) continue;
                    receiveUserIds.add((Long)projectPartner.getPkValue());
                }
            }
        } else {
            DynamicObject[] supplierInvation = BusinessDataServiceHelper.load((String)(appId + "_supplierinvitation"), (String)"id,bidproject,bidproject.bidmode,bidsection,bidsection.supplierentry,bidenrollsection,supplierentry.supplier,supplierentry.isrecommend,supplierentry.projectpartner,,bidenrollsection.supplierenrollentry,supplierenrollentry.enrollsupplier,supplierenrollentry.baoprojectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", (Object)projectId)});
            if (supplierInvation != null && supplierInvation.length > 0) {
                int i;
                DynamicObject supplierInvate = supplierInvation[0];
                DynamicObjectCollection bidSectionColl = supplierInvate.getDynamicObjectCollection("bidsection");
                DynamicObjectCollection bidEnrollSectionColl = supplierInvate.getDynamicObjectCollection("bidenrollsection");
                if (!bidEnrollSectionColl.isEmpty()) {
                    for (i = 0; i < bidEnrollSectionColl.size(); ++i) {
                        DynamicObject bidSection = (DynamicObject)bidEnrollSectionColl.get(i);
                        for (DynamicObject item : bidSection.getDynamicObjectCollection("supplierenrollentry")) {
                            DynamicObject supplier = item.getDynamicObject("enrollsupplier");
                            if (supplier == null) continue;
                            supplierIds.add(supplier.getLong("id"));
                            DynamicObject projectPartner = item.getDynamicObject("baoprojectpartner");
                            if (projectPartner == null) continue;
                            receiveUserIds.add((Long)projectPartner.getPkValue());
                        }
                    }
                }
                if (!bidSectionColl.isEmpty()) {
                    for (i = 0; i < bidSectionColl.size(); ++i) {
                        for (DynamicObject item : ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry")) {
                            DynamicObject supplier = item.getDynamicObject("supplier");
                            if (item.getDynamicObject("supplier") == null) continue;
                            supplierIds.add(supplier.getLong("id"));
                            DynamicObject projectPartner = item.getDynamicObject("projectpartner");
                            if (projectPartner == null) continue;
                            receiveUserIds.add((Long)projectPartner.getPkValue());
                        }
                    }
                }
            }
        }
        Set<Long> supplierAdminIds = this.getReceiveUserIds(supplierIds, appId);
        receiveUserIds.addAll(supplierAdminIds);
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        msgParam.put("appId", appId);
        msgParam.put("operation", key);
        msgParam.put("title", null);
        msgParam.put("pkId", projectId);
        msgParam.put("formId", FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        msgParam.put("msgentity", "bid_project");
        msgParam.put("id", projectId);
        msgParam.put("content", null);
        msgParam.put("tplScene", "bid_invalid");
        String notifyTypes = MessageChannelUtil.getNotifyType((String)"bid_invalid", (String)"bid_project");
        if (!receiveUserIds.isEmpty()) {
            MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)false, new ArrayList(receiveUserIds), (String)notifyTypes);
        }
    }

    private void sendMessageToMember(String key, Long projectId, String appId, DynamicObject proObj) {
        HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        msgParam.put("appId", appId);
        msgParam.put("operation", key);
        msgParam.put("title", null);
        msgParam.put("pkId", projectId);
        msgParam.put("formId", FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        msgParam.put("msgentity", "bid_project");
        msgParam.put("id", projectId);
        msgParam.put("content", null);
        msgParam.put("tplScene", "bid_invalid_mem");
        DynamicObjectCollection memberColl = proObj.getDynamicObjectCollection("memberentity");
        for (DynamicObject member : memberColl) {
            memberSet.add(member.getDynamicObject("user"));
            if (!member.getBoolean("isdirector")) continue;
            memberSet.add(member.getDynamicObject("user"));
        }
        if (!memberSet.isEmpty()) {
            for (DynamicObject set : memberSet) {
                receiveUserIds.add(set.getLong("id"));
            }
        }
        String notifyTypes = MessageChannelUtil.getNotifyType((String)"bid_invalid_mem", (String)"bid_project");
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)false, receiveUserIds, (String)notifyTypes);
    }

    protected Set<Long> getReceiveUserIds(Set<Long> supplierIds, String appId) {
        HashSet<Long> receiveUserIds = new HashSet<Long>(20);
        for (Long supplierId : supplierIds) {
            Long adminUserId = null;
            if ("rebm".equals(appId)) {
                adminUserId = SupplierHelper.listAdminUserIdByResmSupplier((Long)supplierId);
                receiveUserIds.add(adminUserId);
                continue;
            }
            adminUserId = SupplierHelper.listAdminUserIdBySupplier((Long)supplierId);
            receiveUserIds.add(adminUserId);
        }
        return receiveUserIds;
    }
}

