/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.common.util;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.bid.business.bill.serviceImpl.MyTenderServiceImpl;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;

public class BidMessageUtil {
    private static MyTenderServiceImpl myTenderService = new MyTenderServiceImpl();

    public static void sendMsgByQuestionClarify(DynamicObject questionClarify, DynamicObject bidProject, Long supplierId, String appId) {
        boolean enable = SystemParamHelper.getSystemParameter(appId, OrgUnitServiceHelper.getRootOrgId(), "enable");
        if (!enable) {
            return;
        }
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        if ("rebm".equals(appId)) {
            msgParam.put("formId", "resp_mytender");
            msgParam.put("appId", "rebm");
        } else {
            msgParam.put("formId", "ten_mytender");
            msgParam.put("appId", "bid");
        }
        msgParam.put("msgentity", "bid_questionclarify");
        msgParam.put("tplScene", "query");
        msgParam.put("operation", "send");
        msgParam.put("title", null);
        msgParam.put("content", null);
        DynamicObject myTender = myTenderService.getMyTenderByBidProjectAndSupplier((Long)bidProject.getPkValue(), supplierId);
        if (myTender != null) {
            msgParam.put("pkId", myTender.getPkValue());
            msgParam.put("id", questionClarify.getPkValue());
            msgParam.put("targetButtonId", "button_clarify_info");
            msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId", "targetButtonId"));
        }
        Table<Object, Object, List<Long>> publishMap = MessageCenterHelper.getPublishMap(appId, bidProject.getPkValue());
        HashSet allUserIdSet = new HashSet();
        publishMap.rowKeySet().forEach(key -> {
            List userIdList = (List)publishMap.get(key, (Object)supplierId);
            if (userIdList != null) {
                allUserIdSet.addAll(userIdList);
            }
        });
        String notifyType = MessageChannelUtil.getNotifyType("query", "bid_questionclarify");
        MessageCenterHelper.sendMessagesToOpetator(msgParam, myTender != null, new ArrayList<Long>(allUserIdSet), notifyType);
    }

    public static void sendMsgByBidOpen(String appId, DynamicObject bidOpen) {
        boolean enable = SystemParamHelper.getSystemParameter(appId, OrgUnitServiceHelper.getRootOrgId(), "enable");
        if (!enable) {
            return;
        }
        DynamicObject bidProject = bidOpen.getDynamicObject("bidproject");
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(appId + "_" + "project"));
        Table<Object, Object, List<Long>> publishMap = MessageCenterHelper.getPublishMap(appId, project.getPkValue());
        if (publishMap.isEmpty()) {
            return;
        }
        HashMap<Object, Object> myTenderMap = new HashMap<Object, Object>();
        HashMap<Object, List<Long>> isInvalidIdMap = new HashMap<Object, List<Long>>();
        HashMap<Object, List<Long>> isNotInvalidIdMap = new HashMap<Object, List<Long>>();
        DynamicObjectCollection bidSectionColl = bidOpen.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidSectionColl.size(); ++i) {
            String sectionName = ((DynamicObject)bidSectionColl.get(i)).getString("sectionname");
            DynamicObjectCollection supplierEntryColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
            for (int j = 0; j < supplierEntryColl.size(); ++j) {
                DynamicObject myTender;
                DynamicObject supplier = ((DynamicObject)supplierEntryColl.get(j)).getDynamicObject("supplier");
                Long supplierId = (Long)supplier.getPkValue();
                if (((DynamicObject)supplierEntryColl.get(j)).getBoolean("supplier_istender")) {
                    if (((DynamicObject)supplierEntryColl.get(j)).getBoolean("supplier_isinvalid")) {
                        isInvalidIdMap.computeIfAbsent(supplierId, key -> new ArrayList()).addAll((Collection)publishMap.get((Object)sectionName, (Object)supplierId));
                    } else {
                        isNotInvalidIdMap.computeIfAbsent(supplierId, key -> new ArrayList()).addAll((Collection)publishMap.get((Object)sectionName, (Object)supplierId));
                    }
                }
                if (myTenderMap.containsKey(supplierId) || (myTender = myTenderService.getMyTenderByBidProjectAndSupplier(Long.valueOf(bidProject.getLong("id")), supplierId)) == null) continue;
                myTenderMap.put(supplierId, myTender.getPkValue());
            }
        }
        if (!isNotInvalidIdMap.isEmpty()) {
            BidMessageUtil.sendMsgToSupplier(appId, bidOpen.getLong("id"), isNotInvalidIdMap, myTenderMap, "bidopen_split");
        }
        if (!isInvalidIdMap.isEmpty()) {
            BidMessageUtil.sendMsgToSupplier(appId, bidOpen.getLong("id"), isInvalidIdMap, myTenderMap, "bidopen_split_out");
        }
    }

    public static void sendMsgBySupplierInvalid(DynamicObject invalid) {
        String appId = invalid.getString("entitytypeid");
        boolean enable = SystemParamHelper.getSystemParameter(appId, OrgUnitHelper.ROOT_ORG_ID, "enable");
        if (!enable) {
            return;
        }
        Long bidopenId = invalid.getLong("bidopenid");
        DynamicObject bidProject = invalid.getDynamicObject("bidproject");
        if ((bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(appId + "_" + "project"))).getDynamicObject("bidmode") != null) {
            Table<Object, Object, List<Long>> publishMap = MessageCenterHelper.getPublishMap(appId, bidProject.getPkValue());
            HashMap<Object, Object> myTenderMap = new HashMap<Object, Object>();
            HashMap<Object, List<Long>> isInvalidIdMap = new HashMap<Object, List<Long>>();
            DynamicObjectCollection bidSectionColl = invalid.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < bidSectionColl.size(); ++i) {
                String sectionName = ((DynamicObject)bidSectionColl.get(i)).getString("sectionname");
                DynamicObjectCollection supplierEntryColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supplierEntryColl.size(); ++j) {
                    DynamicObject supplier = ((DynamicObject)supplierEntryColl.get(j)).getDynamicObject("supplier");
                    Long supplierId = (Long)supplier.getPkValue();
                    isInvalidIdMap.computeIfAbsent(supplierId, key -> new ArrayList()).addAll((Collection)publishMap.get((Object)sectionName, (Object)supplierId));
                    if (myTenderMap.containsKey(supplierId)) continue;
                    DynamicObject myTender = myTenderService.getMyTenderByBidProjectAndSupplier(Long.valueOf(bidProject.getLong("id")), supplierId);
                    myTenderMap.put(supplierId, myTender.getPkValue());
                }
            }
            BidMessageUtil.sendMsgToSupplier(appId, bidopenId, isInvalidIdMap, myTenderMap, "bidopen_split_out");
        }
    }

    public static void sendMsgToSupplier(String appId, Long bidopenId, Map<Object, List<Long>> isInvalidIdMap, Map<Object, Object> myTenderMap, String tplScene) {
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        if ("bid".equals(appId)) {
            msgParam.put("formId", "ten_mytender");
            msgParam.put("appId", "bid");
        } else {
            msgParam.put("formId", "resp_mytender");
            msgParam.put("appId", "rebm");
        }
        msgParam.put("tplScene", tplScene);
        msgParam.put("msgentity", "bid_bidopen");
        msgParam.put("operation", "confirmopen");
        msgParam.put("notifyType", MessageChannelUtil.getNotifyType(tplScene, "bid_bidopen"));
        msgParam.put("id", bidopenId);
        if (!isInvalidIdMap.isEmpty()) {
            isInvalidIdMap.forEach((supplierId, userIdList) -> {
                msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
                msgParam.put("pkId", myTenderMap.get(supplierId));
                MessageCenterHelper.sendMessages(msgParam, true, userIdList);
            });
        }
    }
}

