/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.common.enums.EvaluationBasePriceEnum;
import kd.scm.bid.common.enums.QuoteLimitBaseEnum;
import kd.scm.bid.common.enums.QuoteSourceEnum;
import kd.scm.bid.common.util.BigDecimalUtil;
import kd.scm.bid.common.util.GetEntityIdUtil;

public class QuotationScoreSchUtil {
    private static final String N = "n";

    public static Map<String, List> getSupplierCalScoreItem(String appId, Object currBidOpenId, Object quotationScoreSchId) {
        if (quotationScoreSchId == null) {
            return new HashMap<String, List>();
        }
        QFilter filter = new QFilter("id", "=", currBidOpenId);
        String bidOpenEntityName = GetEntityIdUtil.getEntityIdByAppId(appId, "bid_bidopen");
        DynamicObject currBidOpen = QueryServiceHelper.queryOne((String)bidOpenEntityName, (String)"id,bidproject.id,opentype", (QFilter[])filter.toArray());
        if (currBidOpen == null) {
            return new HashMap<String, List>();
        }
        Object projectId = currBidOpen.get("bidproject.id");
        String opentype = currBidOpen.getString("opentype");
        DynamicObject quotationScoreSch = BusinessDataServiceHelper.loadSingle((Object)quotationScoreSchId, (String)GetEntityIdUtil.getEntityIdByAppId(appId, "bid_quotationscoresch"));
        if (quotationScoreSch == null) {
            return new HashMap<String, List>();
        }
        String quotesource = quotationScoreSch.getString("quotationsource");
        Map<String, BigDecimal> bottomMakeAmountMap = QuotationScoreSchUtil.getBottomMakeAmountMap(appId, currBidOpenId, bidOpenEntityName);
        Map<String, List> supplierBiddingData = QuotationScoreSchUtil.getSupplierBiddingData(appId, currBidOpenId, opentype, quotesource);
        QuotationScoreSchUtil.setSort(supplierBiddingData);
        QuotationScoreSchUtil.removeOutLimitData(bottomMakeAmountMap, supplierBiddingData, quotationScoreSch);
        QuotationScoreSchUtil.calSupplierBaseScoreRations(bottomMakeAmountMap, supplierBiddingData, quotationScoreSch);
        return supplierBiddingData;
    }

    public static void calSupplierBaseScoreRations(Map<String, BigDecimal> bottomMakeAmountMap, Map<String, List> supplierBiddingData, DynamicObject quotationScoreSch) {
        Set<Map.Entry<String, List>> entrySet = supplierBiddingData.entrySet();
        for (Map.Entry<String, List> entry : entrySet) {
            String key = entry.getKey();
            List list = entry.getValue();
            String[] strs2 = key.split("_");
            String sectionname = strs2[1];
            BigDecimal evaluationasePrice = QuotationScoreSchUtil.calEvaluationasePriceByScoreSch(list, bottomMakeAmountMap, sectionname, quotationScoreSch);
            for (int i = 0; i < list.size(); ++i) {
                Map supplierData = (Map)list.get(i);
                BigDecimal price = (BigDecimal)supplierData.get("price");
                BigDecimal priceDiffRatios = evaluationasePrice.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : BigDecimalUtil.subtractBigDecimal(price, evaluationasePrice).divide(evaluationasePrice, 8, 4);
                BigDecimal priceDiffRatios_abs = priceDiffRatios.abs();
                BigDecimal priceDiffCoef = QuotationScoreSchUtil.getPriceDiffCoef(priceDiffRatios, quotationScoreSch);
                BigDecimal baseScoreRations = priceDiffCoef == null ? BigDecimal.ZERO : BigDecimalUtil.subtractBigDecimal(BigDecimal.ONE, BigDecimalUtil.multiplyBigDecimal(priceDiffRatios_abs, priceDiffCoef));
                supplierData.put("priceDiffRatios", priceDiffRatios);
                supplierData.put("priceDiffRatios_abs", priceDiffRatios_abs);
                supplierData.put("priceDiffCoef", priceDiffCoef);
                supplierData.put("baseScoreRations", baseScoreRations);
            }
        }
    }

    public static BigDecimal getPriceDiffCoef(BigDecimal priceDiffRatios, DynamicObject quotationScoreSch) {
        BigDecimal priceDiffCoef = null;
        DynamicObjectCollection scoringruleentryCol = quotationScoreSch.getDynamicObjectCollection("scoringruleentry");
        for (DynamicObject scoringruleentry : scoringruleentryCol) {
            BigDecimal pricediffratiostart = scoringruleentry.getBigDecimal("pricediffratiostart");
            BigDecimal pricediffratioend = scoringruleentry.getBigDecimal("pricediffratioend");
            if (priceDiffRatios.compareTo(pricediffratiostart) < 0 || priceDiffRatios.compareTo(pricediffratioend) >= 0) continue;
            priceDiffCoef = scoringruleentry.getBigDecimal("pricediffcoef") == null ? BigDecimal.ZERO : scoringruleentry.getBigDecimal("pricediffcoef");
            break;
        }
        return priceDiffCoef;
    }

    private static BigDecimal calEvaluationasePriceByScoreSch(List<Map> list, Map<String, BigDecimal> bottomMakeAmountMap, String sectionname, DynamicObject quotationScoreSch) {
        BigDecimal priceSum;
        int rangeEnd_int;
        int rangeStart_int;
        BigDecimal evaluationasePrice = BigDecimal.ZERO;
        String range = quotationScoreSch.getString("range");
        String evaluationbaseprice = quotationScoreSch.getString("evaluationbaseprice");
        if (EvaluationBasePriceEnum.RANGEAVG.getValue().equals(evaluationbaseprice)) {
            range = range.replaceFirst("\\[", "");
            range = range.substring(0, range.length() - 1);
            String[] strs = range.split(",");
            String rangeStart = strs[0];
            String rangeEnd = strs[1];
            rangeStart_int = 0;
            rangeEnd_int = 0;
            if (!rangeStart.contains(N)) {
                rangeStart_int = Integer.parseInt(rangeStart) - 1;
            } else {
                int n = rangeStart_int = N.equals(rangeStart) ? list.size() - 1 : list.size() + Integer.parseInt(rangeStart.replace(N, "")) - 1;
            }
            if (!rangeEnd.contains(N)) {
                rangeEnd_int = Integer.parseInt(rangeEnd) - 1;
            } else {
                int n = rangeEnd_int = N.equals(rangeEnd) ? list.size() - 1 : list.size() + Integer.parseInt(rangeEnd.replace(N, "")) - 1;
            }
            if (rangeStart_int > rangeEnd_int) {
                return evaluationasePrice;
            }
            if (rangeStart_int < 0) {
                return evaluationasePrice;
            }
            if (rangeEnd_int > list.size() - 1) {
                return evaluationasePrice;
            }
            priceSum = BigDecimal.ZERO;
            for (int i = rangeStart_int; i <= rangeEnd_int; ++i) {
                if (i >= list.size()) continue;
                Map supplierData = list.get(i);
                priceSum = BigDecimalUtil.addBigDecimal(priceSum, (BigDecimal)supplierData.get("price"));
            }
        } else {
            evaluationasePrice = bottomMakeAmountMap.get(sectionname) == null ? BigDecimal.ZERO : bottomMakeAmountMap.get(sectionname);
            return evaluationasePrice;
        }
        int count = rangeEnd_int - rangeStart_int + 1;
        evaluationasePrice = count == 0 ? BigDecimal.ZERO : BigDecimalUtil.divideObject(priceSum, count);
        return evaluationasePrice;
    }

    public static void removeOutLimitData(Map<String, BigDecimal> bottomMakeAmountMap, Map<String, List> supplierBiddingData, DynamicObject quotationScoreSch) {
        String quoteupperlimitbase = quotationScoreSch.getString("quoteupperlimitbase");
        BigDecimal quoteupperlimitcoef = quotationScoreSch.getBigDecimal("quoteupperlimitcoef");
        String quotelowerlimitbase = quotationScoreSch.getString("quotelowerlimitbase");
        BigDecimal quotelowerlimitcoef = quotationScoreSch.getBigDecimal("quotelowerlimitcoef");
        if (!(quoteupperlimitbase != null && quoteupperlimitbase.trim().length() != 0 || quotelowerlimitbase != null && quotelowerlimitbase.trim().length() != 0)) {
            return;
        }
        Set<Map.Entry<String, List>> entrySet = supplierBiddingData.entrySet();
        for (Map.Entry<String, List> entry : entrySet) {
            String key = entry.getKey();
            List list = entry.getValue();
            String[] strs = key.split("_");
            String sectionname = strs[1];
            BigDecimal upperBaseAmount = QuotationScoreSchUtil.getLimitBaseAmount(bottomMakeAmountMap, quoteupperlimitbase, list, sectionname);
            BigDecimal lowerBaseAmount = QuotationScoreSchUtil.getLimitBaseAmount(bottomMakeAmountMap, quotelowerlimitbase, list, sectionname);
            BigDecimal upperLimit = BigDecimalUtil.multiplyBigDecimal(upperBaseAmount, quoteupperlimitcoef);
            BigDecimal lowerLimit = BigDecimalUtil.multiplyBigDecimal(lowerBaseAmount, quotelowerlimitcoef);
            for (int i = list.size() - 1; i >= 0; --i) {
                BigDecimal price;
                Map map = (Map)list.get(i);
                BigDecimal bigDecimal = price = map.get("price") == null ? BigDecimal.ZERO : (BigDecimal)map.get("price");
                if (quoteupperlimitbase == null || quoteupperlimitbase.trim().length() == 0) {
                    if (price.compareTo(lowerLimit) >= 0) continue;
                    list.remove(i);
                    continue;
                }
                if (quotelowerlimitbase == null || quotelowerlimitbase.trim().length() == 0) {
                    if (price.compareTo(upperLimit) <= 0) continue;
                    list.remove(i);
                    continue;
                }
                if (price.compareTo(lowerLimit) >= 0 && price.compareTo(upperLimit) <= 0) continue;
                list.remove(i);
            }
        }
    }

    public static BigDecimal getLimitBaseAmount(Map<String, BigDecimal> bottomMakeAmountMap, String limitbase, List<Map> list, String sectionname) {
        BigDecimal baseAmount = BigDecimal.ZERO;
        if (QuoteLimitBaseEnum.BidBottomAmt.getValue().equals(limitbase)) {
            baseAmount = bottomMakeAmountMap.get(sectionname);
        } else if (QuoteLimitBaseEnum.HIGHESTQUOTATION.getValue().equals(limitbase)) {
            baseAmount = QuotationScoreSchUtil.getHighestQuotation(list);
        } else if (QuoteLimitBaseEnum.LowestQuotation.getValue().equals(limitbase)) {
            baseAmount = QuotationScoreSchUtil.getLowestQuotation(list);
        } else if (QuoteLimitBaseEnum.TrimmedMean.getValue().equals(limitbase)) {
            baseAmount = QuotationScoreSchUtil.getTrimmedMean(list);
        } else if (QuoteLimitBaseEnum.AVG.getValue().equals(limitbase)) {
            baseAmount = QuotationScoreSchUtil.getAVG(list);
        }
        return baseAmount;
    }

    private static BigDecimal getAVG(List<Map> list) {
        if (list == null || list.size() == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal priceSum = BigDecimal.ZERO;
        for (int i = 0; i < list.size(); ++i) {
            Map map = list.get(i);
            priceSum = BigDecimalUtil.addBigDecimal(priceSum, (BigDecimal)map.get("price"));
        }
        int count = list.size();
        return BigDecimalUtil.divideObject(priceSum, count);
    }

    public static BigDecimal getTrimmedMean(List<Map> list) {
        if (list == null || list.size() <= 2) {
            return BigDecimal.ZERO;
        }
        BigDecimal priceSum = BigDecimal.ZERO;
        for (int i = 0; i < list.size(); ++i) {
            Map map = list.get(i);
            if (i == 0 || i == list.size() - 1) continue;
            priceSum = BigDecimalUtil.addBigDecimal(priceSum, (BigDecimal)map.get("price"));
        }
        int count = list.size() - 2;
        return count == 0 ? BigDecimal.ZERO : BigDecimalUtil.divideObject(priceSum, count);
    }

    public static BigDecimal getLowestQuotation(List<Map> list) {
        if (list == null || list.size() == 0) {
            return BigDecimal.ZERO;
        }
        Map map = list.get(0);
        return (BigDecimal)map.get("price");
    }

    public static BigDecimal getHighestQuotation(List<Map> list) {
        if (list == null || list.size() == 0) {
            return BigDecimal.ZERO;
        }
        Map map = list.get(list.size() - 1);
        return (BigDecimal)map.get("price");
    }

    public static void setSort(Map<String, List> supplierBiddingData) {
        Set<Map.Entry<String, List>> entrySet = supplierBiddingData.entrySet();
        for (Map.Entry<String, List> entry : entrySet) {
            String key = entry.getKey();
            List list = entry.getValue();
            Collections.sort(list, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    BigDecimal val1 = o1.get("price") == null ? BigDecimal.ZERO : (BigDecimal)o1.get("price");
                    BigDecimal val2 = o2.get("price") == null ? BigDecimal.ZERO : (BigDecimal)o2.get("price");
                    return val1.compareTo(val2);
                }
            });
        }
    }

    public static Map<String, List> getSupplierBiddingData(String appId, Object currBidOpenId, String opentype, String quotesource) {
        QFilter filter;
        HashMap<String, List> dataMap = new HashMap<String, List>();
        String bidOpenEntityName = GetEntityIdUtil.getEntityIdByAppId(appId, "bid_bidopen");
        DynamicObjectCollection bidOpenCol = QueryServiceHelper.query((String)bidOpenEntityName, (String)"id,bidproject.id,opentype,bidpublishid", (QFilter[])(filter = new QFilter("id", "=", currBidOpenId)).toArray());
        if (bidOpenCol != null && bidOpenCol.size() != 0) {
            DynamicObject bidOpen = (DynamicObject)bidOpenCol.get(0);
            int rounds = 0;
            long bidOpenId = bidOpen.getLong("id");
            QuotationScoreSchUtil.getBiddingPriceDataFromBidOpen(dataMap, bidOpenId, bidOpenEntityName, rounds, quotesource);
            QuotationScoreSchUtil.getBiddingPriceDataFromQuestionClarify(appId, dataMap, bidOpenId, opentype, rounds, quotesource);
        }
        return dataMap;
    }

    public static Map<String, BigDecimal> getBottomMakeAmountMap(String appId, Object bidOpenId, String bidOpenEntitykey) {
        HashMap<String, BigDecimal> bottomMakeAmountMap = new HashMap<String, BigDecimal>();
        DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)bidOpenEntitykey);
        DynamicObjectCollection bottomsectionCol = info.getDynamicObjectCollection("bottomsection");
        for (DynamicObject bottomsection : bottomsectionCol) {
            String bidsectionName = bottomsection.getString("botsectionname");
            DynamicObjectCollection bottomentryCol = bottomsection.getDynamicObjectCollection("bottomentry");
            for (DynamicObject bottomentry : bottomentryCol) {
                BigDecimal bottomMakeAmount = bottomentry.getBigDecimal("finalauditamount");
                if (bottomMakeAmount == null) continue;
                if (bottomMakeAmountMap.get(bidsectionName) == null) {
                    bottomMakeAmountMap.put(bidsectionName, bottomMakeAmount);
                    continue;
                }
                bottomMakeAmountMap.put(bidsectionName, bottomMakeAmount.add((BigDecimal)bottomMakeAmountMap.get(bidsectionName)));
            }
        }
        return bottomMakeAmountMap;
    }

    public static void getBiddingPriceDataFromBidOpen(Map<String, List> allDataMap, long bidOpenId, String bidOpenEntityName, int rounds, String quotesource) {
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)bidOpenEntityName);
        DynamicObjectCollection bidOpenSectionCol = bidOpen.getDynamicObjectCollection("bidsection");
        HashMap supplierDataMap = new HashMap();
        for (DynamicObject bidOpenSection : bidOpenSectionCol) {
            DynamicObjectCollection purDetails = bidOpenSection.getDynamicObjectCollection("supplierentry");
            String key = rounds + "_" + bidOpenSection.getString("sectionname");
            ArrayList<Map<String, String>> list = allDataMap.get(key);
            if (list == null) {
                list = new ArrayList<Map<String, String>>();
                allDataMap.put(key, list);
            }
            supplierDataMap.clear();
            for (DynamicObject purDetail : purDetails) {
                DynamicObject supplier;
                boolean supplier_istender = purDetail.getBoolean("supplier_istender");
                boolean supplier_isinvalid = purDetail.getBoolean("supplier_isinvalid");
                if (!supplier_istender || supplier_isinvalid || (supplier = purDetail.getDynamicObject("supplier")) == null) continue;
                Map<String, String> map = new HashMap();
                if (supplierDataMap.get(supplier.get("id").toString()) != null) {
                    map = (Map)supplierDataMap.get(supplier.get("id").toString());
                } else {
                    supplierDataMap.put(supplier.get("id").toString(), map);
                    list.add(map);
                }
                map.put("supplierid", supplier.get("id").toString());
                map.put("suppliername", supplier.getString("name"));
                map.put("suppliernumber", supplier.getString("number"));
                if (QuoteSourceEnum.PRICEINCLTAX.getValue().equals(quotesource)) {
                    map.put("price", (String)((Object)BigDecimalUtil.addBigDecimal((BigDecimal)map.get("price"), purDetail.getBigDecimal("supplier_tenderprice"))));
                    continue;
                }
                map.put("price", (String)((Object)BigDecimalUtil.addBigDecimal((BigDecimal)map.get("price"), purDetail.getBigDecimal("supplier_exceptvat"))));
            }
            supplierDataMap.clear();
        }
    }

    public static void getBiddingPriceDataFromQuestionClarify(String appId, Map<String, List> allDataMap, long bidOpenId, String openType, int rounds, String quotesource) {
        DynamicObject[] clarifyDataArray = QuotationScoreSchUtil.getQuestionClarify(bidOpenId, appId, openType);
        if (clarifyDataArray == null || clarifyDataArray.length == 0) {
            return;
        }
        HashMap<String, Map> dataMap2 = new HashMap<String, Map>();
        for (Map.Entry<String, List> entry : allDataMap.entrySet()) {
            String key = entry.getKey();
            List list = entry.getValue();
            for (int i = 0; i < list.size(); ++i) {
                Map supplierPriceMap = (Map)list.get(i);
                String supplierId = (String)supplierPriceMap.get("supplierid");
                String key2 = key + "_" + supplierId;
                dataMap2.put(key2, supplierPriceMap);
            }
        }
        for (DynamicObject clarifyData : clarifyDataArray) {
            DynamicObjectCollection clarifyBidSectionCol = clarifyData.getDynamicObjectCollection("bidsection");
            for (DynamicObject clarifyBidSection : clarifyBidSectionCol) {
                String clarifySectionName = clarifyBidSection.getString("sectionname");
                String key = rounds + "_" + clarifySectionName;
                ArrayList<HashMap<String, String>> list = allDataMap.get(key);
                if (list == null) {
                    list = new ArrayList<HashMap<String, String>>();
                    allDataMap.put(key, list);
                }
                DynamicObjectCollection clarifySupplierDetailCol = clarifyBidSection.getDynamicObjectCollection("supplierdetail");
                for (int i = 0; i < clarifySupplierDetailCol.size(); ++i) {
                    DynamicObject supplierDetail = (DynamicObject)clarifySupplierDetailCol.get(i);
                    DynamicObject supplier = supplierDetail.getDynamicObject("pursupplier");
                    if (supplier == null) continue;
                    String key2 = key + "_" + supplier.getString("id");
                    HashMap<String, String> map = (HashMap<String, String>)dataMap2.get(key2);
                    if (map == null) {
                        map = new HashMap<String, String>();
                        list.add(map);
                    }
                    map.put("supplierid", supplier.get("id").toString());
                    map.put("suppliername", supplier.getString("name"));
                    map.put("suppliernumber", supplier.getString("number"));
                    if (i == 0) {
                        map.put("price", (String)((Object)BigDecimal.ZERO));
                    }
                    if (QuoteSourceEnum.PRICEINCLTAX.getValue().equals(quotesource)) {
                        map.put("price", (String)((Object)BigDecimalUtil.addBigDecimal((BigDecimal)map.get("price"), supplierDetail.getBigDecimal("inclutaxamount"))));
                        continue;
                    }
                    map.put("price", (String)((Object)BigDecimalUtil.addBigDecimal((BigDecimal)map.get("price"), supplierDetail.getBigDecimal("excepttaxamount"))));
                }
            }
        }
    }

    public static DynamicObject[] getQuestionClarify(Object bidOpenId, String appId, String openType) {
        QFilter clarifyTypeFilter = null;
        if (BidOpenTypeEnum.TECHNICAL.getValue().equals(openType)) {
            clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
        } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(openType)) {
            clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()).or(new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.MULTI.getValue()));
        }
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED.getValue());
        QFilter reSubMissTendersFilter = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
        QFilter bidEvaluationFilter = new QFilter("bidopenid", "=", bidOpenId);
        DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)(appId + "_questionclarify"), (String)"id,submitdate,tenderprice,pricevat,tax,notaxtenderprice,rate,bidsection,bidsection.sectionname,clarifysupplier,clarifytype,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate", (QFilter[])new QFilter[]{bidEvaluationFilter, billStatusFilter, clarifyTypeFilter, reSubMissTendersFilter}, (String)"submitdate asc");
        return dataArray;
    }
}

