/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.common.util.bidabordrepair;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.enums.BidProcessEnum;

public class BidAbortiveUtil {
    public static void fillEntryDownLoadBillsData(Object bidProjectId, String appId, DynamicObject dataEntity) {
        Map<String, String> bidMainProcessFormIdMap = BidAbortiveUtil.getBidMainProcessFormIdMap(appId);
        DynamicObjectCollection downbillentry = dataEntity.getDynamicObjectCollection("downbillentry");
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        downbillentry.clear();
        entryentity.clear();
        bidMainProcessFormIdMap.forEach((formId, name) -> {
            String billStatusName;
            String nformId = BidAbortiveUtil.getSpecialFormId(formId, appId);
            DynamicObject[] datas = BidAbortiveUtil.getDatas(bidProjectId, appId, nformId, billStatusName = BidAbortiveUtil.getBillStatusName(nformId, appId));
            if (datas.length == 0) {
                return;
            }
            Arrays.stream(datas).forEach(data -> {
                DynamicObject newEntry = downbillentry.addNew();
                newEntry.set("billname", name);
                newEntry.set("entityid", (Object)nformId);
                newEntry.set("billid", (Object)data.getLong("id"));
                newEntry.set("entrybillstatus", data.get(billStatusName));
            });
            if (nformId.equals(appId + "_" + BidProcessEnum.INVITATION.getValue())) {
                DynamicObject[] invitationColl;
                for (DynamicObject invitation : invitationColl = BusinessDataServiceHelper.load((String)nformId, (String)"supplierentry,supplierentry.invitationstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId)})) {
                    DynamicObjectCollection supplierentry = invitation.getDynamicObjectCollection("supplierentry");
                    supplierentry.forEach(entry -> {
                        DynamicObject newentry = entryentity.addNew();
                        newentry.set("srcentryid", entry.getPkValue());
                        newentry.set("invitationstatus", entry.get("invitationstatus"));
                    });
                }
            }
        });
    }

    protected static DynamicObject[] getDatas(Object bidProjectId, String appId, String nformId, String billStatusName) {
        DynamicObject[] datas = new DynamicObject[]{};
        String bidProjectName = BidAbortiveUtil.getBidProjectName(nformId);
        if (nformId.endsWith("bidassinvitesum")) {
            DynamicObjectCollection extracts = QueryServiceHelper.query((String)(appId + "_proficient_extract"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidprojectname", "=", bidProjectId)});
            if (extracts != null && extracts.size() > 0) {
                Set extractIds = extracts.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
                datas = BusinessDataServiceHelper.load((String)(appId + "_bidassinvitesum"), (String)String.join((CharSequence)",", billStatusName, "id"), (QFilter[])new QFilter[]{new QFilter("linkexpertextract", "in", extractIds), new QFilter("billstatus", "!=", (Object)"XX")});
            }
        } else {
            datas = BusinessDataServiceHelper.load((String)nformId, (String)String.join((CharSequence)",", billStatusName, "id"), (QFilter[])new QFilter[]{new QFilter(billStatusName, "!=", (Object)"XX"), new QFilter(bidProjectName, "=", nformId.endsWith(BidProcessEnum.PROJECT_ANNOUNCEMENT.getValue()) ? String.valueOf(bidProjectId) : bidProjectId)});
        }
        return datas;
    }

    public static DynamicObject getDatas(Object billid, String nformId, String appId) {
        String billStatusName = BidAbortiveUtil.getBillStatusName(nformId, appId);
        return BusinessDataServiceHelper.loadSingle((String)nformId, (String)String.join((CharSequence)",", billStatusName, "id"), (QFilter[])new QFilter[]{new QFilter("id", "=", billid)});
    }

    protected static String getBidProjectName(String nformId) {
        String bidProject = "bidproject";
        if (nformId.endsWith(BidProcessEnum.BIDPROJECT.getValue())) {
            bidProject = "id";
        } else if (nformId.endsWith(BidProcessEnum.BIDASSINVITE.getValue())) {
            bidProject = "name";
        }
        return bidProject;
    }

    protected static String getSpecialFormId(String formId, String appId) {
        if (formId.endsWith(BidProcessEnum.MYTENDER.getValue())) {
            String tenAppId = "rebm".equalsIgnoreCase(appId) ? "resp" : "ten";
            return tenAppId + "_" + BidProcessEnum.MYTENDER.getValue();
        }
        if (formId.endsWith(BidProcessEnum.QUERY_LETTERS.getValue()) && "rebm".equals(appId)) {
            return "rebm_" + BidProcessEnum.QUERY_LETTERS.getValue() + "_inh";
        }
        return formId;
    }

    public static String getBillStatusName(String formId, String appId) {
        return Arrays.asList(appId + "_" + BidProcessEnum.INVITATION.getValue(), appId + "_" + BidProcessEnum.INVITATION.getValue() + "_list", appId + "_" + BidProcessEnum.QUERY_LETTERS.getValue(), appId + "_" + BidProcessEnum.QUERY_LETTERS.getValue() + "_inh", appId + "_" + BidProcessEnum.NEGOTIATE_INVITE.getValue()).contains(formId) ? "status" : "billstatus";
    }

    public static Map<String, String> getBidMainProcessFormIdMap(String appId) {
        LinkedHashMap<String, String> bidProcessFormIdMap = new LinkedHashMap<String, String>(22);
        for (BidProcessEnum bidProcessEnum : BidAbortiveUtil.getProcessEnum()) {
            bidProcessFormIdMap.put(appId.concat("_").concat(bidProcessEnum.getValue()), bidProcessEnum.getLabel());
        }
        return bidProcessFormIdMap;
    }

    public static BidProcessEnum[] getProcessEnum() {
        return new BidProcessEnum[]{BidProcessEnum.BIDPROJECT, BidProcessEnum.PROJECT_ANNOUNCEMENT, BidProcessEnum.SUPPLIERINVITATION, BidProcessEnum.INVITATION, BidProcessEnum.BIDDOCUMENT_EDIT, BidProcessEnum.BOTTOM_MAKE, BidProcessEnum.BIDPUBLISH, BidProcessEnum.MYTENDER, BidProcessEnum.ANSWERQUESTION, BidProcessEnum.ANSWERQUESTION_RECO, BidProcessEnum.BIDOPEN, BidProcessEnum.REBACKBID, BidProcessEnum.ONLINEBIDEVAL, BidProcessEnum.BIDEVALUATION, BidProcessEnum.BIDASSINVITESUM, BidProcessEnum.BIDASSINVITE, BidProcessEnum.MULTIQUESTCLARIFY, BidProcessEnum.QUESTIONCLARIFY, BidProcessEnum.QUERY_LETTERS, BidProcessEnum.BUSTALK, BidProcessEnum.NEGOTIATE_INVITE, BidProcessEnum.DECISION};
    }
}

