/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.basedata.serviceImpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.bid.business.basedata.IPurProjectService;
import kd.scm.bid.common.util.OrgUnitHelper;

public class PurProjectServiceImpl
implements IPurProjectService {
    public static final String BID_PURPROJECT = "bid_purproject";
    public static final String REBM_PURPROJECT = "rebm_purproject";
    public static final String BD_PROJECT = "bd_project";

    @Override
    public DynamicObjectCollection listAllPurProjects(String fields) {
        DynamicObjectCollection purProjects = QueryServiceHelper.query((String)BID_PURPROJECT, (String)fields, (QFilter[])new QFilter[0]);
        return purProjects;
    }

    @Override
    public DynamicObject getPurProject(Object id, String fields) {
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(id.toString()));
        DynamicObject purProject = QueryServiceHelper.queryOne((String)BID_PURPROJECT, (String)fields, (QFilter[])new QFilter[]{qFilter});
        return purProject;
    }

    @Override
    public DynamicObjectCollection listPurProjectByOrgs(String orgId, String fields) {
        QFilter qFilter = new QFilter("org", "=", (Object)Long.valueOf(orgId));
        DynamicObjectCollection purProjectColl = QueryServiceHelper.query((String)BID_PURPROJECT, (String)fields, (QFilter[])new QFilter[]{qFilter});
        return purProjectColl;
    }

    @Override
    public Map<String, Object> importBdProjectById(Object bdProjectId, Object ecProjectId, String whereabouts, String projectSource) {
        String splitStr = ".";
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DynamicObject bDProjectQueryOne = BusinessDataServiceHelper.loadSingle((Object)bdProjectId, (String)BD_PROJECT, (String)"id,longnumber");
        String longNumber = bDProjectQueryOne.getString("longnumber");
        String rootNumber = null;
        if (longNumber.contains(splitStr)) {
            String[] split = longNumber.split("\\" + splitStr);
            rootNumber = split[0];
        } else {
            rootNumber = longNumber;
        }
        if (rootNumber != null) {
            DynamicObject[] loadArray = BusinessDataServiceHelper.load((String)BD_PROJECT, (String)"id,longnumber,level,parent", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(rootNumber + splitStr + "%")).or(new QFilter("number", "=", (Object)rootNumber))});
            HashSet<String> alreadyImportIdSet = new HashSet<String>();
            this.importBdProjectData(loadArray, whereabouts, projectSource, alreadyImportIdSet, ecProjectId);
        }
        return resultMap;
    }

    public void importBdProjectData(DynamicObject[] bDProjectArray, String whereabouts, String projectSource, Set<String> alreadyImportIdSet, Object ecProjectId) {
        HashSet<Object> bDProjectIdSet = new HashSet<Object>(200);
        for (DynamicObject bDProjectOne : bDProjectArray) {
            bDProjectIdSet.add(bDProjectOne.getPkValue());
        }
        String entityTypeId = "";
        entityTypeId = "rebm".equals(whereabouts) ? REBM_PURPROJECT : ("bid".equals(whereabouts) ? BID_PURPROJECT : BID_PURPROJECT);
        DynamicObjectCollection alreadyImportBdProjectColl = ORM.create().query(entityTypeId, "id,parent.id,parent.name,bdproject.id,bdproject.name", new QFilter[]{new QFilter("bdproject", "in", bDProjectIdSet)});
        if (alreadyImportBdProjectColl.size() != 0) {
            for (DynamicObject alreadyImportBdProject : alreadyImportBdProjectColl) {
                DynamicObject purProjectImportBdProject = alreadyImportBdProject.getDynamicObject("bdproject");
                if (purProjectImportBdProject == null) continue;
                bDProjectIdSet.removeIf(item -> item.equals(purProjectImportBdProject.getPkValue()));
            }
        }
        DynamicObjectCollection needImportBdProjectColl = ORM.create().query(BD_PROJECT, "id,number,longnumber,enable,name,fullname,level,parent.id,isleaf,createorg.id", new QFilter[]{new QFilter("id", "in", bDProjectIdSet)}, "longnumber asc");
        DynamicObjectCollection needSaveDataColl = new DynamicObjectCollection();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityTypeId);
        HashSet<String> notPurOrgs = new HashSet<String>();
        for (DynamicObject needImportBdProject : needImportBdProjectColl) {
            DynamicObject newPurProjectData = this.createNewPurProjectData(needImportBdProject, type, alreadyImportBdProjectColl, projectSource, notPurOrgs, ecProjectId);
            alreadyImportBdProjectColl.add((Object)newPurProjectData);
            needSaveDataColl.add((Object)newPurProjectData);
        }
        if (!notPurOrgs.isEmpty()) {
            Log log = LogFactory.getLog(PurProjectServiceImpl.class);
            log.info("PurProjectServiceImpl-\u7ec4\u7ec7" + notPurOrgs + "\u4e0d\u542b\u6709\u91c7\u8d2d\u7ec4\u7ec7\u804c\u80fd\u3002");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6240\u5f15\u5165\u9879\u76ee\u7684\u7ec4\u7ec7\u975e\u91c7\u8d2d\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5f15\u5165\u3002", (String)"PurProjectServiceImpl_7", (String)"scm-bid-business", (Object[])new Object[0]), new Object[0]));
        }
        for (DynamicObject needSaveData : needSaveDataColl) {
            if (needSaveData.getDynamicObject("parent") != null) continue;
            String numberStr = needSaveData.getString("number");
            boolean numberExists = QueryServiceHelper.exists((String)entityTypeId, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)numberStr)});
            String errorMessage = null;
            if (numberExists) {
                errorMessage = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u91c7\u8d2d\u9879\u76ee\uff0c\u4e0d\u80fd\u91cd\u590d\u5f15\u5165\u3002", (String)"PurProjectServiceImpl_5", (String)"scm-bid-business", (Object[])new Object[0]), numberStr);
            }
            if (errorMessage == null) continue;
            throw new KDBizException(errorMessage);
        }
        for (DynamicObject alreadyImportBdProject : alreadyImportBdProjectColl) {
            DynamicObject purProjectImportBdProject = alreadyImportBdProject.getDynamicObject("bdproject");
            if (purProjectImportBdProject == null) continue;
            alreadyImportIdSet.add(purProjectImportBdProject.getPkValue().toString());
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((IDataEntityType)type, (Object[])needSaveDataColl.toArray());
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public DynamicObject createNewPurProjectData(DynamicObject needImportBdProject, MainEntityType type, DynamicObjectCollection alreadyImportBdProjectColl, String projectSource, Set<String> notPurOrgs, Object ecProjectId) {
        DynamicObject parent;
        DynamicObject createPurProjectData = new DynamicObject((DynamicObjectType)type);
        long genLongId = ORM.create().genLongId((IDataEntityType)type);
        createPurProjectData.set("id", (Object)genLongId);
        createPurProjectData.set("masterid", (Object)genLongId);
        String entityTypeId = "";
        if ("bid".equals(type.getAppId())) {
            entityTypeId = BID_PURPROJECT;
        } else {
            entityTypeId = REBM_PURPROJECT;
            if ("ec".equals(projectSource)) {
                this.getEcProjectOtherOrg(createPurProjectData, ecProjectId);
            }
        }
        createPurProjectData.set("entitytypeid", (Object)entityTypeId);
        createPurProjectData.set("enable", (Object)needImportBdProject.getString("enable"));
        createPurProjectData.set("status", (Object)"A");
        createPurProjectData.set("creator", (Object)RequestContext.get().getUserId());
        createPurProjectData.set("createtime", (Object)new Date());
        createPurProjectData.set("bdproject", (Object)needImportBdProject);
        createPurProjectData.set("number", (Object)needImportBdProject.getString("number"));
        createPurProjectData.set("longnumber", (Object)needImportBdProject.getString("longnumber"));
        createPurProjectData.set("name", (Object)needImportBdProject.getString("name"));
        createPurProjectData.set("fullname", (Object)needImportBdProject.getString("fullname"));
        createPurProjectData.set("level", (Object)needImportBdProject.getString("level"));
        createPurProjectData.set("isleaf", (Object)needImportBdProject.getString("isleaf"));
        if (projectSource == null) {
            createPurProjectData.set("projectsource", (Object)"sys");
        } else {
            createPurProjectData.set("projectsource", (Object)projectSource);
        }
        DynamicObject createOrg = needImportBdProject.getDynamicObject("createorg");
        if (createOrg != null) {
            createPurProjectData.set("belongmanageorg", (Object)createOrg);
            boolean isPurchaseOrg = OrgUnitServiceHelper.checkOrgFunction((Long)createOrg.getLong("id"), (String)"02");
            if (isPurchaseOrg) {
                createPurProjectData.set("org", (Object)createOrg);
            } else {
                notPurOrgs.add(createOrg.getString("name"));
                createPurProjectData.set("enable", (Object)"0");
            }
        }
        if (ecProjectId != null && "ec".equals(projectSource)) {
            notPurOrgs.clear();
            createPurProjectData.set("enable", (Object)"1");
            DynamicObject ecProject = BusinessDataServiceHelper.loadSingle((String)"ec_project", (String)"fiaccountorg,departmentcu,unitproject,responsibleorg,projectorg", (QFilter[])new QFilter[]{new QFilter("id", "=", ecProjectId)});
            DynamicObject projectorg = ecProject.getDynamicObject("projectorg");
            boolean isPurchaseorg = OrgUnitServiceHelper.checkOrgFunction((Long)projectorg.getLong("id"), (String)"02");
            if (isPurchaseorg) {
                createPurProjectData.set("org", (Object)projectorg);
            }
        }
        if ((parent = needImportBdProject.getDynamicObject("parent")) != null) {
            for (DynamicObject alreadyImportBdProject : alreadyImportBdProjectColl) {
                DynamicObject alreadyImportBdProjectData = alreadyImportBdProject.getDynamicObject("bdproject");
                if (alreadyImportBdProjectData == null || alreadyImportBdProjectData.getLong("id") != parent.getLong("id")) continue;
                createPurProjectData.set("parent", (Object)alreadyImportBdProject);
                break;
            }
        }
        return createPurProjectData;
    }

    protected void getEcProjectOtherOrg(DynamicObject createPurProjectData, Object ecProjectId) {
        if (ecProjectId == null) {
            return;
        }
        DynamicObject ecProject = BusinessDataServiceHelper.loadSingle((String)"ec_project", (String)"fiaccountorg,departmentcu,unitproject,responsibleorg", (QFilter[])new QFilter[]{new QFilter("id", "=", ecProjectId)});
        if (ecProject != null) {
            createPurProjectData.set("fiaccountorg", (Object)ecProject.getDynamicObject("fiaccountorg"));
            createPurProjectData.set("departmentcu", (Object)ecProject.getDynamicObject("departmentcu"));
            DynamicObjectCollection unitproject = ecProject.getDynamicObjectCollection("unitproject");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < unitproject.size(); ++i) {
                DynamicObject project = (DynamicObject)unitproject.get(i);
                Object responsibleOrg = project.getDynamicObject("responsibleorg").getPkValue();
                String temp = responsibleOrg + ",";
                sb.append(temp);
            }
            createPurProjectData.set("responsibleorg", (Object)sb.toString());
        }
    }

    @Override
    public DynamicObject exportPurProjectToSysProject(DynamicObject dataEntity, String source) {
        DynamicObject dataEntityBdProject = dataEntity.getDynamicObject("bdproject");
        if (dataEntityBdProject != null) {
            return null;
        }
        DynamicObject sysProjectFromCreate = null;
        try (TXHandle h = TX.requiresNew();){
            try {
                DynamicObject parent = dataEntity.getDynamicObject("parent");
                DynamicObject belongManageOrg = dataEntity.getDynamicObject("belongmanageorg");
                if (parent == null) {
                    sysProjectFromCreate = this.createBdProjectByPurProject(null, dataEntity.getString("number"), dataEntity.getLocaleString("name").getLocaleValue(), belongManageOrg.getPkValue(), null, null, null, null, source);
                } else {
                    DynamicObject parentBdProject = parent.getDynamicObject("bdproject");
                    if (parentBdProject != null) {
                        sysProjectFromCreate = this.createBdProjectByPurProject(null, dataEntity.getString("number"), dataEntity.getLocaleString("name").getLocaleValue(), belongManageOrg.getPkValue(), parentBdProject.getPkValue(), null, null, null, source);
                    }
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        if (sysProjectFromCreate != null) {
            DynamicObject purProject = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)BID_PURPROJECT, (String)"bdproject");
            purProject.set("bdproject", (Object)sysProjectFromCreate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{purProject});
        }
        return sysProjectFromCreate;
    }

    @Override
    public List<Long> getAllPurProjectTree(DynamicObject purProject) {
        DynamicObject parent = purProject.getDynamicObject("parent");
        String numberQfilter = "";
        String splitStr = ".";
        numberQfilter = parent == null ? purProject.getString("number") : purProject.getString("longnumber").split("\\" + splitStr)[0];
        DynamicObjectCollection purProjectColl = QueryServiceHelper.query((String)BID_PURPROJECT, (String)"id,bdproject.id,parent.id", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(numberQfilter + splitStr + "%")).or(new QFilter("number", "=", (Object)numberQfilter))});
        return purProjectColl.stream().map(pp -> pp.getLong("id")).collect(Collectors.toList());
    }

    @Override
    public DynamicObject createBdProjectByPurProject(Object groupId, String projectNumber, Object projectName, Object createOrgId, Object parentId, Date planbegindate, Date planenddate, String address, String source) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)BD_PROJECT);
        DynamicObject project = new DynamicObject((DynamicObjectType)dt, (Object)ORM.create().genLongId((IDataEntityType)dt));
        project.set("number", (Object)projectNumber);
        project.set("name", projectName);
        project.set("planbegindate", (Object)planbegindate);
        project.set("planenddate", (Object)planenddate);
        project.set("proaddress", (Object)address);
        if (groupId != null && !groupId.toString().equals("0")) {
            DynamicObject group = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"bd_projectkind");
            project.set("group", (Object)group);
        }
        if (createOrgId != null && !createOrgId.toString().equals("0")) {
            DynamicObject createOrg = BusinessDataServiceHelper.loadSingle((Object)createOrgId, (String)"bos_org");
            project.set("createorg", (Object)createOrg);
        }
        DynamicObject parent = null;
        if (parentId != null && !parentId.toString().equals("0")) {
            parent = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)BD_PROJECT);
            project.set("parent", (Object)parent);
        }
        project.set("isleaf", (Object)1);
        if (parent == null) {
            project.set("level", (Object)1);
            project.set("longnumber", (Object)projectNumber);
            project.set("fullname", projectName);
        } else {
            project.set("level", (Object)(parent.getInt("level") + 1));
            project.set("longnumber", (Object)(parent.get("number") + "." + projectNumber));
            project.set("fullname", (Object)(parent.get("name") + "." + projectName));
        }
        project.set("status", (Object)"C");
        project.set("enable", (Object)1);
        project.set("systemtype", (Object)source);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)BD_PROJECT, (DynamicObject[])new DynamicObject[]{project}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            throw new KDBizException(((OperateErrorInfo)((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
        }
        if (parent != null) {
            parent.set("isleaf", (Object)0);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parent});
        }
        return project;
    }

    @Override
    public void deleteBdProjectByPurProject(DynamicObject purProject) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)BD_PROJECT);
        if (purProject == null) {
            return;
        }
        DynamicObject bdProject = purProject.getDynamicObject("bdproject");
        if (bdProject == null) {
            return;
        }
        try {
            DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])new Object[]{bdProject.getPkValue()});
        }
        catch (Exception e) {
            Log log = LogFactory.getLog(PurProjectServiceImpl.class);
            log.error("delete BdProject error", (Throwable)e);
        }
    }

    @Override
    public void updateBdProjectByPurProject(DynamicObject purProject) {
        DynamicObject bdProject = purProject.getDynamicObject("bdproject");
        if (bdProject != null) {
            DynamicObject bdProjectLoadSingle = BusinessDataServiceHelper.loadSingle((Object)bdProject.getPkValue(), (String)BD_PROJECT, (String)"name,number,fullname,longnumber");
            String purProjectName = purProject.getLocaleString("name").getLocaleValue();
            String purProjectNumber = purProject.getString("number");
            String purProjectFullName = purProject.getLocaleString("fullname").getLocaleValue();
            String purProjectLongNumber = purProject.getString("longnumber");
            String bdProjectName = bdProjectLoadSingle.getLocaleString("name").getLocaleValue();
            String bdProjectNumber = bdProjectLoadSingle.getString("number");
            String bdProjectFullName = bdProjectLoadSingle.getLocaleString("fullname").getLocaleValue();
            String bdProjectLongNumber = bdProjectLoadSingle.getString("longnumber");
            boolean needSave = false;
            if (!StringUtils.equals((CharSequence)purProjectName, (CharSequence)bdProjectName)) {
                bdProjectLoadSingle.set("name", (Object)purProjectName);
                needSave = true;
            }
            if (!StringUtils.equals((CharSequence)purProjectNumber, (CharSequence)bdProjectNumber)) {
                bdProjectLoadSingle.set("number", (Object)purProjectNumber);
                needSave = true;
            }
            if (!StringUtils.equals((CharSequence)purProjectFullName, (CharSequence)bdProjectFullName)) {
                bdProjectLoadSingle.set("fullname", (Object)purProjectFullName);
                needSave = true;
            }
            if (!StringUtils.equals((CharSequence)purProjectLongNumber, (CharSequence)bdProjectLongNumber)) {
                bdProjectLoadSingle.set("longnumber", (Object)purProjectLongNumber);
                needSave = true;
            }
            if (needSave) {
                try (TXHandle h = TX.requiresNew();){
                    SaveServiceHelper.update((DynamicObject)bdProjectLoadSingle);
                }
            }
        }
    }

    @Override
    public boolean checkPurProjectRefrence(String entityNumber, Object purProjectId, Set<String> ignoreRefEntityNumbers) {
        BaseDataCheckRefrence checkRefrence = new BaseDataCheckRefrence();
        Set ignoreRefEntityIds = checkRefrence.getIgnoreRefEntityIds();
        for (String ignoreRefEntityNumber : ignoreRefEntityNumbers) {
            ignoreRefEntityIds.add(ignoreRefEntityNumber);
        }
        checkRefrence.setDraftValidReference(true);
        BaseDataCheckRefrenceResult result = checkRefrence.checkRef((BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber), purProjectId);
        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u5f15\u7528\u6821\u9a8c\u7ed3\u679c\uff1a%s\u3002", (String)"PurProjectServiceImpl_3", (String)"scm-bid-business", (Object[])new Object[0]), result));
        return result.isRefence();
    }

    @Override
    public void bidPurProjectHistoricalDataUpgrade() {
        DynamicObject[] purProjectArray = BusinessDataServiceHelper.load((String)BID_PURPROJECT, (String)String.join((CharSequence)",", "id", "number", "name", "longnumber", "fullname", "level", "isleaf", "belongmanageorg", "projectsource", "entitytypeid", "org", "bdproject"), null);
        if (purProjectArray == null) {
            return;
        }
        if (purProjectArray.length == 0) {
            return;
        }
        ArrayList<String> existsBdProjectList = new ArrayList<String>(purProjectArray.length);
        ArrayList<String> addNewBdProjectList = new ArrayList<String>(purProjectArray.length);
        ArrayList<String> upgradePurProIdList = new ArrayList<String>(purProjectArray.length);
        ArrayList<String> rebmUpgradePurProIdList = new ArrayList<String>(purProjectArray.length);
        for (DynamicObject purProject : purProjectArray) {
            this.updateHistorgPurProjectData(existsBdProjectList, addNewBdProjectList, rebmUpgradePurProIdList, purProject);
            upgradePurProIdList.add(purProject.getPkValue().toString());
        }
        Log log = LogFactory.getLog(PurProjectServiceImpl.class);
        log.error("[ERROR]\u56e0\u4e3a\u540d\u79f0\u6216\u7f16\u7801\u91cd\u590d\u672a\u80fd\u540c\u6b65\u81f3\u7cfb\u7edf\u4e91\u9879\u76ee\u7684\u91c7\u8d2d\u9879\u76eeid\uff1a" + existsBdProjectList);
        log.error("[ERROR]\u672c\u6b21\u65b0\u589e\u81f3\u7cfb\u7edf\u4e91\u9879\u76eeid\uff1a" + addNewBdProjectList);
        log.error("[ERROR]\u672c\u6b21\u5347\u7ea7\u7684\u91c7\u8d2d\u9879\u76eeid:" + upgradePurProIdList);
        log.info("[INFO]\u56e0\u4e3a\u540d\u79f0\u6216\u7f16\u7801\u91cd\u590d\u672a\u80fd\u540c\u6b65\u81f3\u7cfb\u7edf\u4e91\u9879\u76ee\u7684\u91c7\u8d2d\u9879\u76eeid\uff1a" + existsBdProjectList);
        log.info("[INFO]\u672c\u6b21\u5347\u7ea7\u7684\u91c7\u8d2d\u9879\u76eeid:" + upgradePurProIdList);
        log.info("[INFO]\u672c\u6b21\u65b0\u589e\u81f3\u7cfb\u7edf\u4e91\u9879\u76eeid\uff1a" + addNewBdProjectList);
        log.info("[INFO]\u672c\u6b21\u4e0d\u662frebmproject\u9879\u76eeid\uff1a" + rebmUpgradePurProIdList);
        SaveServiceHelper.update((DynamicObject[])purProjectArray);
    }

    public void updateHistorgPurProjectData(List<String> existsBdProjectList, List<String> addNewBdProjectList, List<String> rebmUpgradePurProIdList, DynamicObject purProject) {
        String entityTypeId = purProject.getString("entitytypeid");
        purProject.set("level", (Object)1);
        String purProjectNumber = purProject.getString("number");
        purProject.set("longnumber", (Object)purProjectNumber);
        String purProjetcName = purProject.getLocaleString("name").getLocaleValue();
        purProject.set("fullname", purProject.get("name"));
        purProject.set("isleaf", (Object)Boolean.TRUE);
        if (StringUtils.equals((CharSequence)BID_PURPROJECT, (CharSequence)entityTypeId)) {
            purProject.set("projectsource", (Object)"addnew");
            this.updateBelongOrgAndBdProject(existsBdProjectList, addNewBdProjectList, purProject, purProjectNumber, purProjetcName);
        } else if (StringUtils.equals((CharSequence)REBM_PURPROJECT, (CharSequence)entityTypeId)) {
            MainEntityType type = null;
            try {
                type = EntityMetadataCache.getDataEntityType((String)REBM_PURPROJECT);
            }
            catch (Exception e) {
                rebmUpgradePurProIdList.add(purProject.getPkValue().toString());
            }
            if (type != null) {
                DynamicObject queryOne = QueryServiceHelper.queryOne((String)REBM_PURPROJECT, (String)"eascurproject", (QFilter[])new QFilter[]{new QFilter("id", "=", purProject.getPkValue())});
                long easCurProject = queryOne.getLong("eascurproject");
                String projectSource = "eas";
                if (easCurProject != 0L) {
                    projectSource = "eas";
                } else {
                    projectSource = "addnew";
                    this.updateBelongOrgAndBdProject(existsBdProjectList, addNewBdProjectList, purProject, purProjectNumber, purProjetcName);
                }
                purProject.set("projectsource", (Object)projectSource);
            } else {
                rebmUpgradePurProIdList.add(purProject.getPkValue().toString());
            }
        }
    }

    protected void updateBelongOrgAndBdProject(List<String> existsBdProjectList, List<String> addNewBdProjectList, DynamicObject purProject, String purProjectNumber, String purProjetcName) {
        DynamicObject purchaseOrg = purProject.getDynamicObject("org");
        Long orgHasCuByOrgId = 0L;
        if (purchaseOrg != null) {
            orgHasCuByOrgId = OrgUnitHelper.getOrgHasCuByOrgId((long)purchaseOrg.getLong("id"));
            purProject.set("belongmanageorg", (Object)orgHasCuByOrgId);
        }
        if (orgHasCuByOrgId != 0L) {
            boolean exists = QueryServiceHelper.exists((String)BD_PROJECT, (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)purProjetcName).or(new QFilter("number", "=", (Object)purProjectNumber))});
            if (!exists) {
                DynamicObject bDProjectFromCreate = this.createBdProjectByPurProject(null, purProjectNumber, purProjetcName, orgHasCuByOrgId, null, null, null, null, "SCM");
                if (bDProjectFromCreate != null) {
                    purProject.set("bdproject", bDProjectFromCreate.getPkValue());
                    addNewBdProjectList.add(bDProjectFromCreate.getPkValue().toString());
                }
            } else {
                existsBdProjectList.add(purProject.getPkValue().toString());
            }
        }
    }
}

