/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.basedata.serviceImpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.IPurTypeService;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;

public class PurTypeServiceImpl
extends BidServiceImpl
implements IPurTypeService {
    @Override
    public void updateEnableStatus(Set<String> idSets, boolean enable) {
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bid_purtype", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idSets.toArray(new String[0]))});
        int flag = 0;
        if (enable) {
            flag = 1;
        }
        for (DynamicObject obj : objs) {
            obj.set("enable", (Object)flag);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    public boolean checkTypeIsExistDisableChild(String id) {
        QFilter filter = new QFilter("parent", "=", (Object)Long.valueOf(id)).and(new QFilter("enable", "=", (Object)"0"));
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bid_purtype", (String)"id,enable", (QFilter[])new QFilter[]{filter});
        return objs != null && objs.length == 1;
    }

    @Override
    public DynamicObject getPurType(Object id, String selectors) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_purtype", (String)selectors);
    }

    @Override
    public void saveEnable(Object id) {
        DynamicObject ptObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_purtype", (String)"id,longnumber,parent");
        if (ptObj == null) {
            return;
        }
        String longNumber = ptObj.getString("longnumber");
        QFilter[] filters4Child = new QFilter[]{new QFilter("longnumber", "like", (Object)(longNumber + ".%"))};
        QFilter[] filters4Parent = new QFilter[]{new QFilter("number", "in", (Object)longNumber.split("\\."))};
        DynamicObject[] childPT = BusinessDataServiceHelper.load((String)"bid_purtype", (String)"id,enable", (QFilter[])filters4Child);
        DynamicObject[] parentPT = BusinessDataServiceHelper.load((String)"bid_purtype", (String)"id,enable", (QFilter[])filters4Parent);
        List<DynamicObject> do4PtCols = Stream.concat(Arrays.stream(childPT), Arrays.stream(parentPT)).map(do4Pt -> {
            do4Pt.set("enable", (Object)1);
            return do4Pt;
        }).collect(Collectors.toList());
        SaveServiceHelper.save((DynamicObject[])do4PtCols.toArray(new DynamicObject[0]));
    }

    @Override
    public void saveDisable(Object id) {
        DynamicObject ptObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_purtype", (String)"id,enable,longnumber,parent");
        if (ptObj == null) {
            return;
        }
        String longNumber = ptObj.getString("longnumber");
        QFilter[] filters4Child = new QFilter[]{new QFilter("longnumber", "like", (Object)(longNumber + ".%"))};
        QFilter[] filters4Parent = new QFilter[]{new QFilter("number", "in", (Object)longNumber.split("\\."))};
        DynamicObject[] childPT = BusinessDataServiceHelper.load((String)"bid_purtype", (String)"id,enable,parent", (QFilter[])filters4Child);
        DynamicObject[] parentPT = BusinessDataServiceHelper.load((String)"bid_purtype", (String)"id,enable,parent", (QFilter[])filters4Parent);
        Map<String, DynamicObject> m = Arrays.stream(parentPT).collect(Collectors.toMap(ppt1 -> ppt1.getPkValue().toString(), ppt -> ppt));
        ArrayList<DynamicObject> allPts = new ArrayList<DynamicObject>(100);
        LinkedList<DynamicObject> queue = new LinkedList<DynamicObject>();
        queue.offer(ptObj);
        while (queue.size() > 0) {
            DynamicObject dObj;
            DynamicObject pt = (DynamicObject)queue.poll();
            allPts.add(pt);
            String id4Cur = pt.getPkValue().toString();
            if (pt.getDynamicObject("parent") == null) continue;
            String id4Par = pt.getDynamicObject("parent").getPkValue().toString();
            QFilter[] filters = new QFilter[]{new QFilter("parent", "=", (Object)Long.valueOf(id4Par)).and(new QFilter("id", "!=", (Object)Long.valueOf(id4Cur))).and(new QFilter("enable", "=", (Object)"1"))};
            DynamicObject[] pts = BusinessDataServiceHelper.load((String)"bid_purtype", (String)"id,enable,parent", (QFilter[])filters);
            if (pts != null && pts.length != 0 || (dObj = m.get(id4Par)) == null) continue;
            queue.offer(dObj);
        }
        List<DynamicObject> do4PtCols = Stream.concat(Arrays.stream(childPT), allPts.stream()).map(do4Pt -> {
            do4Pt.set("enable", (Object)0);
            return do4Pt;
        }).collect(Collectors.toList());
        SaveServiceHelper.save((DynamicObject[])do4PtCols.toArray(new DynamicObject[0]));
    }

    @Override
    public boolean checkExistChildren(Object id) {
        QFilter filter = new QFilter("parent", "=", id);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bid_purtype", (String)"id,enable", (QFilter[])new QFilter[]{filter});
        return objs != null && objs.length > 0;
    }

    @Override
    public void saveParentIsLeafStatus(Object id) {
        DynamicObject pt = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_purtype", (String)"id,isleaf");
        if (pt != null && pt.getBoolean("isleaf")) {
            pt.set("isleaf", (Object)0);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pt});
        }
    }

    @Override
    public boolean checkReferened(Object id) {
        boolean projectRef;
        if (id == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3anull", (String)"PurTypeServiceImpl_0", (String)"scm-bid-business", (Object[])new Object[0]));
        }
        boolean isExist = QueryServiceHelper.exists((String)"bid_purtype", (Object)id);
        if (!isExist) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728id\u4e3a%s\u7684\u91c7\u8d2d\u7c7b\u578b\u6570\u636e", (String)"PurTypeServiceImpl_1", (String)"scm-bid-business", (Object[])new Object[0]), id));
        }
        return isExist && (projectRef = QueryServiceHelper.exists((String)"bid_project", (QFilter[])new QFilter[]{new QFilter("purtype", "=", (Object)Long.valueOf(id.toString()))}));
    }
}

