/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.helper.BidStepInteractiveHelper;
import kd.scm.bid.business.helper.BidStepInteractiveServiceHelper;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;

public interface IBidStepInteractiveService {
    default public void createByLastStep(DynamicObject bidProject, BidStepEnum lastStep) {
    }

    default public void createNextStep(DynamicObject bidProject, BidStepEnum currentStep) {
        BidStepInteractiveServiceHelper[] nextStepServices;
        for (BidStepInteractiveServiceHelper nextStepService : nextStepServices = BidStepInteractiveHelper.getNextStepService(bidProject, currentStep)) {
            if (nextStepService.hasUnstarted(bidProject)) continue;
            nextStepService.createByLastStep(bidProject, currentStep);
        }
        BidProjectServiceImpl bidProService = new BidProjectServiceImpl();
        BidStepEnum[] steps = BidStepInteractiveHelper.getNextStep(bidProject, currentStep);
        if (steps != null && steps.length > 0) {
            bidProService.saveCurrentBidStep(bidProject.getPkValue(), steps);
        }
    }

    default public boolean hasUnstarted(DynamicObject bidProject) {
        Object bidProjectPK = bidProject.getPkValue();
        QFilter qFilter = new QFilter("bidproject.id", "=", bidProjectPK);
        qFilter.and(new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.DISBEGIN.getVal(), BillStatusEnum.QUESTIONING.getVal(), BillStatusEnum.ENDED.getVal()}));
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)this.getFormId(), (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter});
        return object != null;
    }

    default public boolean deleteNextStepUnStarted(DynamicObject bidProject, BidStepEnum currentStep) {
        if (bidProject == null || bidProject.get("id") == null) {
            return false;
        }
        BidStepInteractiveServiceHelper[] nextStepServices = BidStepInteractiveHelper.getNextStepService(bidProject, currentStep);
        Object bidProjectPk = bidProject.getPkValue();
        for (BidStepInteractiveServiceHelper nextStepService : nextStepServices) {
            if (nextStepService.deleteUnStarted(bidProjectPk)) continue;
            return false;
        }
        BidProjectServiceImpl bidProService = new BidProjectServiceImpl();
        bidProService.saveCurrentBidStep(bidProject.getPkValue(), currentStep);
        return true;
    }

    default public boolean deleteUnStarted(Object bidProjectPK) {
        QFilter[] qFilters = this.getFilters(bidProjectPK);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getFormId());
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)this.getFormId(), (String)"id,billstatus", (QFilter[])qFilters);
        if (!(object == null || BillStatusEnum.DISBEGIN.getVal().equals(object.get("billstatus")) || BillStatusEnum.QUESTIONING.getVal().equals(object.get("billstatus")) || BillStatusEnum.ENDED.getVal().equals(object.get("billstatus")))) {
            return false;
        }
        if (object != null) {
            BusinessDataServiceHelper.delete((IDataEntityType)type, (Object[])new Object[]{object});
        }
        return true;
    }

    default public boolean checkNextStepUnStarted(DynamicObject bidProject, BidStepEnum currentStep) {
        if (bidProject == null || bidProject.get("id") == null) {
            return false;
        }
        BidStepInteractiveServiceHelper[] nextStepServices = BidStepInteractiveHelper.getNextStepService(bidProject, currentStep);
        Object bidProjectPk = bidProject.getPkValue();
        for (BidStepInteractiveServiceHelper nextStepService : nextStepServices) {
            if (nextStepService.checkUnStarted(bidProjectPk)) continue;
            return false;
        }
        return true;
    }

    default public boolean checkUnStarted(Object bidProjectPK) {
        QFilter[] qFilters = this.getFilters(bidProjectPK);
        DynamicObject object = QueryServiceHelper.queryOne((String)this.getFormId(), (String)"billstatus", (QFilter[])qFilters);
        return object == null || BillStatusEnum.DISBEGIN.getVal().equals(object.get("billstatus")) || BillStatusEnum.QUESTIONING.getVal().equals(object.get("billstatus")) || BillStatusEnum.ENDED.getVal().equals(object.get("billstatus"));
    }

    default public boolean checkUnStarted(Object bidProjectPK, String formId) {
        QFilter[] qFilters = this.getFilters(bidProjectPK);
        DynamicObject object = QueryServiceHelper.queryOne((String)formId, (String)"billstatus", (QFilter[])qFilters);
        return object == null || BillStatusEnum.DISBEGIN.getVal().equals(object.get("billstatus")) || BillStatusEnum.QUESTIONING.getVal().equals(object.get("billstatus")) || BillStatusEnum.ENDED.getVal().equals(object.get("billstatus"));
    }

    default public boolean checkBillIsStatus(Object bidProjectPK, String formId, BillStatusEnum status) {
        QFilter[] qFilters = this.getFilters(bidProjectPK);
        DynamicObject object = QueryServiceHelper.queryOne((String)formId, (String)"billstatus", (QFilter[])qFilters);
        if (object != null && !status.getVal().equals(object.get("billstatus"))) {
            return false;
        }
        return object != null && status.getVal().equals(object.get("billstatus"));
    }

    public String getFormId();

    default public QFilter[] getFilters(Object bidProjectPK) {
        QFilter qFilter = new QFilter("bidproject.id", "=", bidProjectPK);
        qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal()));
        QFilter[] qFilters = new QFilter[]{qFilter};
        return qFilters;
    }
}

