/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidAnswerQuestionService;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.helper.EntityTypeHelper;
import kd.scm.bid.business.util.BidProjectChgCreatorUtils;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidAnswerQuestionServiceImpl
implements IBidAnswerQuestionService {
    @Override
    public boolean checkBidOpenStarted(DynamicObject bidProject) {
        QFilter billStatusFilter;
        DynamicObject[] bidOpenArr;
        boolean isBidOpen = bidProject.getBoolean("bidopen");
        return !isBidOpen || (bidOpenArr = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.OPEN.getVal())})) == null || bidOpenArr.length <= 0;
    }

    @Override
    public void updateAnswerCount(DynamicObject bidProject, String flag, boolean isOld) {
        Long bidProjectId = bidProject.getLong("id");
        QFilter bidProjectIdFilter = new QFilter("bidproject", "=", (Object)bidProjectId);
        DynamicObject bidAnswerQuestion = BusinessDataServiceHelper.loadSingle((String)"bid_answerquestion", (String)"id,answerquestioncount,askstatus", (QFilter[])new QFilter[]{bidProjectIdFilter});
        if (!isOld) {
            int answerquestioncount = bidAnswerQuestion.getInt("answerquestioncount");
            if ("addone".equals(flag)) {
                ++answerquestioncount;
            } else if ("delone".equals(flag)) {
                bidAnswerQuestion.set("answerquestioncount", (Object)(answerquestioncount - 1));
                --answerquestioncount;
            }
            bidAnswerQuestion.set("answerquestioncount", (Object)answerquestioncount);
        }
        DynamicObject[] questionRecoArr = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bid_answerquestion_reco"), (QFilter[])new QFilter[]{bidProjectIdFilter}).values().toArray(new DynamicObject[0]);
        String askstatus = "ASKED";
        StringBuilder status = new StringBuilder();
        DynamicObject bidproject = questionRecoArr[0].getDynamicObject("bidproject");
        boolean privateRelyAnswer = bidproject.getBoolean("privatizationreplyflag");
        if (privateRelyAnswer) {
            for (DynamicObject questionReco : questionRecoArr) {
                String billstatus = questionReco.getString("billstatus");
                status.append(billstatus);
            }
            askstatus = status.toString().contains("A") ? "ASKING" : "ASKED";
        } else {
            Lang lang = RequestContext.get().getLang();
            block1: for (DynamicObject questionReco : questionRecoArr) {
                for (DynamicObject entry : questionReco.getDynamicObjectCollection("bid_answerquestions_list")) {
                    String answer = entry.getString("questionanswer");
                    if (null != answer && !answer.equals("")) continue;
                    if (!Lang.zh_CN.equals((Object)lang)) {
                        if (!Lang.zh_TW.equals((Object)lang)) {
                            askstatus = "PENDING";
                            continue block1;
                        }
                    }
                    askstatus = "ASKING";
                    continue block1;
                }
            }
        }
        bidAnswerQuestion.set("askstatus", (Object)askstatus);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidAnswerQuestion});
    }

    private MainEntityType createBidAnswerQuestionType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_answerquestion");
        return mainType;
    }

    @Override
    public DynamicObject getAnswerByProjectId(Long id, String selectedFields) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bid_answerquestion", (String)selectedFields, (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public void updateAnswerStatus() {
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.QUESTIONING.getVal());
        Date now = new Date();
        DynamicObject[] answeringResultArr = BusinessDataServiceHelper.load((String)"bid_answerquestion", (String)"id,billstatus,answerquestiondeadline,bidproject,bidproject.bidopen", (QFilter[])new QFilter[]{billstatusFilter});
        HashSet<Long> hasOpenPorjectId = new HashSet<Long>(20);
        for (int i = 0; i < answeringResultArr.length; ++i) {
            if (answeringResultArr[i].getDate("answerquestiondeadline") == null || answeringResultArr[i].getDate("answerquestiondeadline").compareTo(now) > 0) continue;
            answeringResultArr[i].set("billstatus", (Object)BillStatusEnum.ENDED.getVal());
            DynamicObject project = answeringResultArr[i].getDynamicObject("bidproject");
            if (!project.getBoolean("bidopen")) continue;
            hasOpenPorjectId.add(project.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])answeringResultArr);
        if (!hasOpenPorjectId.isEmpty()) {
            QFilter idFilter = new QFilter("id", "in", hasOpenPorjectId);
            DynamicObject[] projectArr = BusinessDataServiceHelper.load((String)"bid_project", (String)"id,billstatus,currentstep,bidopen", (QFilter[])new QFilter[]{idFilter});
            for (int i = 0; i < projectArr.length; ++i) {
                DynamicObject project = projectArr[i];
                String currentStep = project.getString("currentstep");
                if (!StringUtils.isNotEmpty((CharSequence)currentStep) || !",BidAnswerQuestion,".equals(currentStep)) continue;
                project.set("currentstep", (Object)",BidOpen,");
            }
            SaveServiceHelper.update((DynamicObject[])projectArr);
        }
    }

    @Override
    public void saveAnswerDeadline(Object bidProjectId, Date date, String field) {
        QFilter bidProjectFilter = new QFilter("bidproject", "=", (Object)Long.parseLong(bidProjectId.toString()));
        DynamicObject bidAnswer = BusinessDataServiceHelper.loadSingle((String)"bid_answerquestion", (String)("id,billstatus," + field), (QFilter[])new QFilter[]{bidProjectFilter});
        if (bidAnswer != null) {
            bidAnswer.set(field, (Object)date);
            if (date != null) {
                if (field.equals("answerquestiondeadline") && !bidAnswer.getString("billstatus").equals(BillStatusEnum.COMPLETE.getVal())) {
                    if (date.compareTo(new Date()) <= 0) {
                        bidAnswer.set("billstatus", (Object)BillStatusEnum.ENDED.getVal());
                    } else {
                        bidAnswer.set("billstatus", (Object)BillStatusEnum.QUESTIONING.getVal());
                    }
                }
            } else if (date == null && field.equals("answerquestiondeadline") && !bidAnswer.getString("billstatus").equals(BillStatusEnum.COMPLETE.getVal())) {
                bidAnswer.set("billstatus", (Object)BillStatusEnum.QUESTIONING.getVal());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidAnswer});
        }
    }

    @Override
    public void createByLastStep(DynamicObject bidProject, BidStepEnum lastStep) {
        QFilter bidProjectFilter1;
        DynamicObject[] ansewerCol;
        BidOpenServiceImpl bidOpenServiceImpl = new BidOpenServiceImpl();
        boolean isTenNew = false;
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue())});
        if (bidOpen == null && bidProject.getBoolean("bidopen")) {
            bidOpenServiceImpl.saveBidOpen(bidProject.getLong("id"), isTenNew);
        }
        if ((ansewerCol = BusinessDataServiceHelper.load((String)"bid_answerquestion", (String)"id", (QFilter[])new QFilter[]{bidProjectFilter1 = new QFilter("bidproject", "=", bidProject.getPkValue())})) != null && ansewerCol.length != 0) {
            return;
        }
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project", (String)"id,billno,org,billno,answerquestiontime,bidpublish,bidopen");
        MainEntityType dynObjT = this.createBidAnswerQuestionType();
        DynamicObject bidAnswerQuestion = new DynamicObject((DynamicObjectType)dynObjT);
        bidAnswerQuestion.set("billstatus", (Object)"Q");
        bidAnswerQuestion.set("billno", bidProject.get("billno"));
        boolean isBidPublish = bidProject.getBoolean("bidpublish");
        if (isBidPublish) {
            QFilter billstatusFilter;
            QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
            DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"id,answerquestiondeadline,plananswerquestiontime", (QFilter[])new QFilter[]{bidProjectFilter, billstatusFilter = new QFilter("billstatus", "not in", Arrays.asList(BillStatusEnum.INVALID.getVal(), BillStatusEnum.ADJUSTING.getVal()))});
            if (bidPublish != null) {
                bidAnswerQuestion.set("answerquestiondeadline", bidPublish.get("plananswerquestiontime"));
            } else {
                bidAnswerQuestion.set("answerquestiondeadline", bidProject.get("answerquestiontime"));
            }
        } else {
            bidAnswerQuestion.set("answerquestiondeadline", bidProject.get("answerquestiontime"));
        }
        bidAnswerQuestion.set("bidproject", bidProject.getPkValue());
        HashMap<String, DynamicObject> creatorMap = BidProjectChgCreatorUtils.getCreator(bidProject);
        DynamicObject creator = creatorMap.get("10");
        bidAnswerQuestion.set("creator", (Object)creator);
        bidAnswerQuestion.set("createtime", (Object)new Date());
        bidAnswerQuestion.set("org", bidProject.get("org"));
        EntityTypeHelper.setEntityType(bidAnswerQuestion, "bid_answerquestion", "bidproject");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidAnswerQuestion});
    }

    @Override
    public String getFormId() {
        return "bid_answerquestion";
    }
}

