/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;
import kd.scm.bid.business.bill.IBidBottomMakeService;
import kd.scm.bid.business.util.BidProjectChgCreatorUtils;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;

public class BidBottomMakeServiceImpl
extends BidServiceImpl
implements IBidBottomMakeService {
    @Override
    public void createBottomMakeByBidProject(Long bidProjectId, String appId) {
        if (bidProjectId == null) {
            return;
        }
        String entityNumber = appId + "_project";
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)entityNumber);
        String formId = appId + "_bottom_make";
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)formId);
        object.set("billstatus", (Object)BillStatusEnum.DISBEGIN.getVal());
        object.set("billno", bidProject.get("billno"));
        object.set("currency", bidProject.get("currency"));
        object.set("bidproject", (Object)bidProject);
        object.set("bidmode", bidProject.get("bidmode"));
        object.set("doctype", bidProject.get("doctype"));
        object.set("evaluatedecideway", bidProject.get("evaluatedecideway"));
        object.set("bidbottommakedate", bidProject.get("bidbottommakedate"));
        object.set("setupdate", bidProject.get("setupdate"));
        object.set("org", bidProject.get("org"));
        HashMap<String, DynamicObject> creatorMap = BidProjectChgCreatorUtils.getCreator(bidProject);
        DynamicObject creator = creatorMap.get("19");
        object.set("creator", (Object)creator);
        object.set("createtime", (Object)new Date());
        object.set("comment", null);
        object.set("entitytypeid", (Object)formId);
        DynamicObjectCollection bidProjSectionList = bidProject.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection sectionList = object.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidProjSection : bidProjSectionList) {
            DynamicObject section = sectionList.addNew();
            section.set("seq", bidProjSection.get("seq"));
            section.set("sectionname", bidProjSection.get("sectionname"));
            section.set("workload", bidProjSection.get("workload"));
            section.set("secdeposit", bidProjSection.get("secdeposit"));
            DynamicObjectCollection projentrys = bidProjSection.getDynamicObjectCollection("projectentry");
            DynamicObjectCollection docPurDetails = section.getDynamicObjectCollection("projectentry");
            for (DynamicObject projentry : projentrys) {
                DynamicObject purDetail = docPurDetails.addNew();
                purDetail.set("seq", projentry.get("seq"));
                purDetail.set("purentrycontent", projentry.get("purentrycontent"));
                purDetail.set("purentryproject", projentry.get("purentryproject"));
                purDetail.set("materialid", projentry.get("materialid"));
                purDetail.set("baseunit", projentry.get("baseunit"));
                purDetail.set("materialdes", (Object)projentry.getString("materialdes"));
                purDetail.set("qty", (Object)projentry.getString("qty"));
                purDetail.set("controlamount", (Object)projentry.getString("controlamount"));
                purDetail.set("controlvat", (Object)projentry.getString("controlvat"));
                purDetail.set("ctrlamtexceptvat", (Object)projentry.getString("ctrlamtexceptvat"));
                purDetail.set("purentryworkload", (Object)projentry.getString("purentryworkload"));
                purDetail.set("purentrycomment", (Object)projentry.getString("purentrycomment"));
                purDetail.set("planamount", projentry.get("planamount"));
                purDetail.set("nottaxplanamount", projentry.get("nottaxplanamount"));
                if (!StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) continue;
                purDetail.set("listnumber", projentry.get("listnumber"));
                purDetail.set("listname", projentry.get("listname"));
                purDetail.set("resourceitem", projentry.get("resourceitem"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    @Override
    public void deleteBottomMakeByBidProjectId(Long bidProjectId, String appId) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
        String entityName = appId + "_bottom_make";
        DeleteServiceHelper.delete((String)entityName, (QFilter[])qFilter.toArray());
    }

    @Override
    public DynamicObject getBidBottomMakeById(Long bottomId, String selectedFields) {
        QFilter qFilter = new QFilter("id", "=", (Object)bottomId);
        return QueryServiceHelper.queryOne((String)"bid_bottom_make", (String)selectedFields, (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public String getFormId() {
        return "bid_bottom_make";
    }

    @Override
    public void deleteUnStartedBottomMakeByBidProjectId(Long bidProjectId, String appId) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.DISBEGIN.getVal()));
        String entityName = appId + "_bottom_make";
        DeleteServiceHelper.delete((String)entityName, (QFilter[])qFilter.toArray());
    }

    @Override
    public boolean checkBottomMakeUnStartedByBidProjectId(Long bidProjectId, String appId) {
        QFilter qFilter;
        String entityName = appId + "_bottom_make";
        if (QueryServiceHelper.exists((String)entityName, (QFilter[])(qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId)).toArray())) {
            qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.DISBEGIN.getVal()));
            return QueryServiceHelper.exists((String)entityName, (QFilter[])qFilter.toArray());
        }
        return true;
    }

    @Override
    public void saveBidBottomMakeInvalidStatus(Long bidProjectId, String appId) {
        String entityName = appId + "_bottom_make";
        DynamicObject[] bottomMakeArray = BusinessDataServiceHelper.load((String)entityName, (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProjectId)});
        if (bottomMakeArray != null && bottomMakeArray.length > 0) {
            for (DynamicObject bottomMake : bottomMakeArray) {
                bottomMake.set("billstatus", (Object)BillStatusEnum.INVALID.getVal());
            }
            SaveServiceHelper.save((DynamicObject[])bottomMakeArray);
        }
    }

    @Override
    public void sendMessageToMember(DynamicObject bidProject) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("X");
        list.add("XX");
        DynamicObject bottomMake = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bottom_make", this.getClass()), (String)"id,entitytypeid", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", list)});
        String appid = bottomMake.getString("entitytypeid").split("_")[0];
        String title = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u6761<%s>\u4e1a\u52a1\u5f85\u529e\u6d88\u606f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidBottomMakeServiceImpl_4", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        msgParam.put("tplScene", "createbidbottommake");
        if ("bid".equals(appid)) {
            msgParam.put("formId", "bid_bottom_make");
        } else {
            msgParam.put("formId", "rebm_bottom_make");
        }
        msgParam.put("appId", appid);
        msgParam.put("id", bottomMake.getPkValue());
        msgParam.put("pkId", bottomMake.getPkValue());
        msgParam.put("title", null);
        msgParam.put("operation", "save");
        msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
        DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
        HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        for (DynamicObject member : memberColl) {
            String[] values;
            if (member.getString("respbusiness") == null || (values = member.getString("respbusiness").split(",")) == null || values.length <= 0) continue;
            for (int m = 0; m < values.length; ++m) {
                if (!"19".equals(values[m])) continue;
                memberSet.add(member.getDynamicObject("user"));
            }
        }
        if (!memberSet.isEmpty()) {
            for (DynamicObject set : memberSet) {
                receiveUserIds.add(set.getLong("id"));
            }
        }
        msgParam.put("msgentity", "bid_bottom_make");
        String content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u53c2\u4e0e\u7684<%s>\u9879\u76ee\u5df2\u8fdb\u5165\u6807\u5e95\u7f16\u5236\u4e1a\u52a1\u529e\u7406\u73af\u8282\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidBottomMakeServiceImpl_5", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
        msgParam.put("content", null);
        String notifyType = MessageChannelUtil.getNotifyType((String)"createbidbottommake", (String)"bid_bottom_make");
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyType);
    }
}

